/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;
import com.googlecode.eyesfree.utils.ContrastUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class TextContrastViewCheck
extends AccessibilityViewCheck {
    @Override
    public List<AccessibilityViewCheckResult> runCheckOnView(View view) {
        ArrayList<AccessibilityViewCheckResult> results = new ArrayList<AccessibilityViewCheckResult>();
        if (view instanceof TextView && !TextUtils.isEmpty((CharSequence)((TextView)view).getText())) {
            TextView textView = (TextView)view;
            int textColor = textView.getCurrentTextColor();
            Drawable background = textView.getBackground();
            if (background instanceof ColorDrawable) {
                if (Build.VERSION.SDK_INT >= 11) {
                    double requiredContrast;
                    int backgroundColor = ((ColorDrawable)background).getColor();
                    double contrast = ContrastUtils.calculateContrastRatio(ContrastUtils.calculateLuminance(textColor), ContrastUtils.calculateLuminance(backgroundColor));
                    double backgroundAlpha = Color.alpha((int)backgroundColor);
                    double d = requiredContrast = TextContrastViewCheck.isLargeText(textView) ? 3.0 : 4.5;
                    if (contrast < requiredContrast) {
                        if (backgroundAlpha < 255.0) {
                            String message = "View's background color must be opaque";
                            results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, message, view));
                        } else {
                            String message = String.format(Locale.US, "TextView does not have required contrast of %f. Actual contrast is %f", requiredContrast, contrast);
                            results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, message, view));
                        }
                    }
                } else {
                    String message = "Cannot be run on API levels lower than 11";
                    results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, message, view));
                }
            } else {
                results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "TextView does not have a solid background color", view));
            }
        } else {
            results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "View must be a non-empty TextView", view));
        }
        return results;
    }

    private static boolean isLargeText(TextView textView) {
        float textSize = textView.getTextSize();
        return textSize >= 18.0f || textSize >= 14.0f && textView.getTypeface().isBold();
    }
}

