/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.view.accessibility.AccessibilityNodeInfo;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityInfoCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityInfoCheckResult;
import com.googlecode.eyesfree.utils.AccessibilityNodeInfoUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class TouchTargetSizeInfoCheck
extends AccessibilityInfoCheck {
    private static final int TOUCH_TARGET_MIN_HEIGHT = 48;
    private static final int TOUCH_TARGET_MIN_WIDTH = 48;

    @Override
    public List<AccessibilityInfoCheckResult> runCheckOnInfo(AccessibilityNodeInfo info, Context context, Bundle metadata) {
        ArrayList<AccessibilityInfoCheckResult> results = new ArrayList<AccessibilityInfoCheckResult>();
        AccessibilityNodeInfoCompat infoCompat = new AccessibilityNodeInfoCompat((Object)info);
        if (!AccessibilityNodeInfoUtils.isClickable(infoCompat) && !AccessibilityNodeInfoUtils.isLongClickable(infoCompat)) {
            results.add(new AccessibilityInfoCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "View is not clickable", info));
            return results;
        }
        if (context == null) {
            results.add(new AccessibilityInfoCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "This check needs a context", info));
            return results;
        }
        float density = context.getResources().getDisplayMetrics().density;
        Rect bounds = new Rect();
        info.getBoundsInScreen(bounds);
        float targetHeight = (float)bounds.height() / density;
        float targetWidth = (float)bounds.width() / density;
        if (targetHeight < 48.0f || targetWidth < 48.0f) {
            String message = String.format(Locale.US, "View is too small of a touch target. Minimum touch target size is %dx%ddp. Actual size is %.1fx%.1fdp (screen density is %.1f).", 48, 48, Float.valueOf(targetWidth), Float.valueOf(targetHeight), Float.valueOf(density));
            results.add(new AccessibilityInfoCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, message, info));
        }
        return results;
    }
}

