/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.view.View;
import android.view.ViewParent;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.ViewAccessibilityUtils;
import java.util.ArrayList;
import java.util.List;

public class TouchTargetSizeViewCheck
extends AccessibilityViewCheck {
    private static final int TOUCH_TARGET_MIN_HEIGHT = 48;
    private static final int TOUCH_TARGET_MIN_WIDTH = 48;

    @Override
    public List<AccessibilityViewCheckResult> runCheckOnView(View view) {
        ArrayList<AccessibilityViewCheckResult> results = new ArrayList<AccessibilityViewCheckResult>();
        if (!view.isClickable() && !view.isLongClickable()) {
            results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "View is not clickable", view));
            return results;
        }
        if (!ViewAccessibilityUtils.isVisibleToUser(view)) {
            results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "View is not visible", view));
            return results;
        }
        float density = view.getContext().getResources().getDisplayMetrics().density;
        float targetHeight = (float)view.getHeight() / density;
        float targetWidth = (float)view.getWidth() / density;
        if (targetHeight < 48.0f || targetWidth < 48.0f) {
            boolean hasDelegate = TouchTargetSizeViewCheck.hasAncestorWithTouchDelegate(view);
            AccessibilityCheckResult.AccessibilityCheckResultType resultType = hasDelegate ? AccessibilityCheckResult.AccessibilityCheckResultType.WARNING : AccessibilityCheckResult.AccessibilityCheckResultType.ERROR;
            StringBuilder messageBuilder = new StringBuilder(String.format("View falls below the minimum recommended size for touch targets. Minimum touch target size is %dx%ddp. Actual size is %.1fx%.1fdp (screen density is %.1f).", 48, 48, Float.valueOf(targetWidth), Float.valueOf(targetHeight), Float.valueOf(density)));
            if (hasDelegate) {
                messageBuilder.append(" A TouchDelegate has been detected on one of this view's ancestors. If the delegate is of sufficient size and handles touches for this view, this warning may be ignored.");
            }
            results.add(new AccessibilityViewCheckResult(this.getClass(), resultType, messageBuilder, view));
        }
        return results;
    }

    private static boolean hasAncestorWithTouchDelegate(View view) {
        if (view == null) {
            return false;
        }
        View evalView = null;
        ViewParent parent = view.getParent();
        if (parent instanceof View && (evalView = (View)parent).getTouchDelegate() != null) {
            return true;
        }
        return TouchTargetSizeViewCheck.hasAncestorWithTouchDelegate(evalView);
    }
}

