/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.annotation.TargetApi;
import android.graphics.Rect;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AdapterView;
import android.widget.CompoundButton;
import android.widget.HorizontalScrollView;
import android.widget.ScrollView;
import android.widget.Spinner;
import android.widget.TextView;
import java.util.HashSet;
import java.util.Set;

@TargetApi(value=16)
final class ViewAccessibilityUtils {
    private ViewAccessibilityUtils() {
    }

    public static Set<View> getAllViewsInHierarchy(View rootView) {
        HashSet<View> allViews = new HashSet<View>();
        allViews.add(rootView);
        ViewAccessibilityUtils.addAllChildrenToSet(rootView, allViews);
        return allViews;
    }

    public static boolean isImportantForAccessibility(View view) {
        if (view == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return view.isImportantForAccessibility();
        }
        int mode = view.getImportantForAccessibility();
        if (mode == 2 || mode == 4) {
            return false;
        }
        ViewParent parent = view.getParent();
        while (parent instanceof View) {
            if (((View)parent).getImportantForAccessibility() == 4) {
                return false;
            }
            parent = parent.getParent();
        }
        return mode == 1 || ViewAccessibilityUtils.isActionableForAccessibility(view) || ViewAccessibilityUtils.hasListenersForAccessibility(view) || view.getAccessibilityNodeProvider() != null || ViewCompat.getAccessibilityLiveRegion((View)view) != 0;
    }

    public static boolean isActionableForAccessibility(View view) {
        if (view == null) {
            return false;
        }
        return view.isClickable() || view.isLongClickable() || view.isFocusable();
    }

    public static boolean isVisibleToUser(View view) {
        if (view == null) {
            return false;
        }
        View current = view;
        while (current instanceof View) {
            View currentView = current;
            if (ViewCompat.getAlpha((View)currentView) <= 0.0f || currentView.getVisibility() != 0) {
                return false;
            }
            current = currentView.getParent();
        }
        return view.getGlobalVisibleRect(new Rect());
    }

    public static boolean shouldFocusView(View view) {
        if (view == null) {
            return false;
        }
        if (!ViewAccessibilityUtils.isVisibleToUser(view)) {
            return false;
        }
        if (ViewAccessibilityUtils.isAccessibilityFocusable(view)) {
            if (!(view instanceof ViewGroup) || view instanceof ViewGroup && ((ViewGroup)view).getChildCount() == 0) {
                return true;
            }
            return ViewAccessibilityUtils.isSpeakingView(view);
        }
        return ViewAccessibilityUtils.hasText(view) && !ViewAccessibilityUtils.hasFocusableAncestor(view);
    }

    public static View getLabelForView(View view) {
        if (Build.VERSION.SDK_INT < 17) {
            return null;
        }
        int idToFind = view.getId();
        if (idToFind == -1) {
            return null;
        }
        View childToSkip = null;
        View labelingView;
        while ((labelingView = ViewAccessibilityUtils.lookForLabelForViewInViewAndChildren(view, childToSkip, idToFind)) == null) {
            ViewParent parent = view.getParent();
            childToSkip = view;
            if (!(parent instanceof View)) {
                return null;
            }
            view = (View)parent;
        }
        return labelingView;
    }

    private static View lookForLabelForViewInViewAndChildren(View view, View childToSkip, int idToFind) {
        if (view.getLabelFor() == idToFind) {
            return view;
        }
        if (!(view instanceof ViewGroup)) {
            return null;
        }
        ViewGroup viewGroup = (ViewGroup)view;
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View labelingView;
            View child = viewGroup.getChildAt(i);
            if (child.equals(childToSkip) || (labelingView = ViewAccessibilityUtils.lookForLabelForViewInViewAndChildren(child, null, idToFind)) == null) continue;
            return labelingView;
        }
        return null;
    }

    private static void addAllChildrenToSet(View rootView, Set<View> theSet) {
        if (!(rootView instanceof ViewGroup)) {
            return;
        }
        ViewGroup rootViewGroup = (ViewGroup)rootView;
        for (int i = 0; i < rootViewGroup.getChildCount(); ++i) {
            View nextView = rootViewGroup.getChildAt(i);
            theSet.add(nextView);
            ViewAccessibilityUtils.addAllChildrenToSet(nextView, theSet);
        }
    }

    private static boolean hasListenersForAccessibility(View view) {
        if (view == null) {
            return false;
        }
        boolean result = false;
        return result |= view.getTouchDelegate() != null;
    }

    private static boolean hasFocusableAncestor(View view) {
        if (view == null) {
            return false;
        }
        ViewParent parent = view.getParentForAccessibility();
        if (!(parent instanceof View)) {
            return false;
        }
        if (ViewAccessibilityUtils.isAccessibilityFocusable((View)parent)) {
            return true;
        }
        return ViewAccessibilityUtils.hasFocusableAncestor((View)parent);
    }

    private static boolean isAccessibilityFocusable(View view) {
        if (view == null) {
            return false;
        }
        if (view.getVisibility() != 0) {
            return false;
        }
        if (ViewAccessibilityUtils.isActionableForAccessibility(view)) {
            return true;
        }
        return ViewAccessibilityUtils.isChildOfScrollableContainer(view) && ViewAccessibilityUtils.isSpeakingView(view);
    }

    private static boolean isChildOfScrollableContainer(View view) {
        if (view == null) {
            return false;
        }
        ViewParent viewParent = view.getParentForAccessibility();
        if (viewParent == null || !(viewParent instanceof View)) {
            return false;
        }
        View parent = (View)viewParent;
        if (parent.isScrollContainer()) {
            return true;
        }
        return (parent instanceof AdapterView || parent instanceof ScrollView || parent instanceof HorizontalScrollView) && !(parent instanceof Spinner);
    }

    private static boolean isSpeakingView(View view) {
        if (ViewAccessibilityUtils.hasText(view)) {
            return true;
        }
        if (view instanceof CompoundButton) {
            return true;
        }
        return ViewAccessibilityUtils.hasNonActionableSpeakingChildren(view);
    }

    private static boolean hasNonActionableSpeakingChildren(View view) {
        if (view == null || !(view instanceof ViewGroup)) {
            return false;
        }
        ViewGroup group = (ViewGroup)view;
        for (int i = 0; i < group.getChildCount(); ++i) {
            View child = group.getChildAt(i);
            if (child == null || child.getVisibility() != 0 || ViewAccessibilityUtils.isAccessibilityFocusable(child) || !ViewAccessibilityUtils.isImportantForAccessibility(child) || !ViewAccessibilityUtils.isSpeakingView(child)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasText(View view) {
        if (!TextUtils.isEmpty((CharSequence)view.getContentDescription())) {
            return true;
        }
        if (view instanceof TextView) {
            return !TextUtils.isEmpty((CharSequence)((TextView)view).getText());
        }
        return false;
    }
}

