/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.integrations;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;
import java.util.List;
import java.util.Locale;

public class AccessibilityViewCheckException
extends RuntimeException {
    private List<AccessibilityViewCheckResult> results;
    private AccessibilityCheckResult.AccessibilityCheckResultDescriptor resultDescriptor = new AccessibilityCheckResult.AccessibilityCheckResultDescriptor();

    public AccessibilityViewCheckException(List<AccessibilityViewCheckResult> results) {
        if (results == null || results.size() == 0) {
            throw new RuntimeException("AccessibilityViewCheckException requires at least 1 AccessibilityViewCheckResult");
        }
        this.results = results;
    }

    @Override
    public String getMessage() {
        StringBuilder exceptionMessage = new StringBuilder();
        String errorCountMessage = this.results.size() == 1 ? "There was 1 accessibility error:\n" : String.format(Locale.US, "There were %d accessibility errors:\n", this.results.size());
        exceptionMessage.append(errorCountMessage);
        for (int i = 0; i < this.results.size(); ++i) {
            if (i > 0) {
                exceptionMessage.append(",\n");
            }
            AccessibilityViewCheckResult result = this.results.get(i);
            exceptionMessage.append(this.resultDescriptor.describeResult(result));
        }
        return exceptionMessage.toString();
    }

    public AccessibilityViewCheckException setResultDescriptor(AccessibilityCheckResult.AccessibilityCheckResultDescriptor resultDescriptor) {
        this.resultDescriptor = resultDescriptor;
        return this;
    }

    public List<AccessibilityViewCheckResult> getResults() {
        return this.results;
    }
}

