/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.integrations.espresso;

import android.util.Log;
import android.view.View;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckPreset;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResultUtils;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.integrations.AccessibilityViewCheckException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;

public class AccessibilityValidator {
    private static final String TAG = "AccessibilityValidator";
    private boolean runChecksFromRootView = false;
    private boolean throwExceptionForErrors = true;
    private AccessibilityCheckResult.AccessibilityCheckResultDescriptor resultDescriptor = new AccessibilityCheckResult.AccessibilityCheckResultDescriptor();
    private List<AccessibilityViewHierarchyCheck> viewHierarchyChecks = new LinkedList<AccessibilityViewHierarchyCheck>();
    private Matcher<? super AccessibilityViewCheckResult> suppressingMatcher = null;

    public AccessibilityValidator() {
        this.viewHierarchyChecks.addAll(AccessibilityCheckPreset.getViewChecksForPreset(AccessibilityCheckPreset.LATEST));
    }

    public final List<AccessibilityViewCheckResult> checkAndReturnResults(View view) {
        if (view != null) {
            View viewToCheck = this.runChecksFromRootView ? view.getRootView() : view;
            return this.runAccessibilityChecks(viewToCheck);
        }
        return Collections.emptyList();
    }

    public AccessibilityValidator setRunChecksFromRootView(boolean runChecksFromRootView) {
        this.runChecksFromRootView = runChecksFromRootView;
        return this;
    }

    public AccessibilityValidator setSuppressingResultMatcher(Matcher<? super AccessibilityViewCheckResult> resultMatcher) {
        this.suppressingMatcher = resultMatcher;
        return this;
    }

    public AccessibilityValidator setThrowExceptionForErrors(boolean throwExceptionForErrors) {
        this.throwExceptionForErrors = throwExceptionForErrors;
        return this;
    }

    public AccessibilityValidator setResultDescriptor(AccessibilityCheckResult.AccessibilityCheckResultDescriptor resultDescriptor) {
        this.resultDescriptor = resultDescriptor;
        return this;
    }

    private List<AccessibilityViewCheckResult> runAccessibilityChecks(View root) {
        LinkedList<AccessibilityViewCheckResult> results = new LinkedList<AccessibilityViewCheckResult>();
        for (AccessibilityViewHierarchyCheck check : this.viewHierarchyChecks) {
            results.addAll(check.runCheckOnViewHierarchy(root));
        }
        AccessibilityCheckResultUtils.suppressMatchingResults(results, this.suppressingMatcher);
        this.processResults(results);
        return results;
    }

    private void processResults(Iterable<AccessibilityViewCheckResult> results) {
        if (results == null) {
            return;
        }
        List<AccessibilityViewCheckResult> infos = AccessibilityCheckResultUtils.getResultsForType(results, AccessibilityCheckResult.AccessibilityCheckResultType.INFO);
        List<AccessibilityViewCheckResult> warnings = AccessibilityCheckResultUtils.getResultsForType(results, AccessibilityCheckResult.AccessibilityCheckResultType.WARNING);
        List<AccessibilityViewCheckResult> errors = AccessibilityCheckResultUtils.getResultsForType(results, AccessibilityCheckResult.AccessibilityCheckResultType.ERROR);
        for (AccessibilityViewCheckResult result : infos) {
            Log.i((String)TAG, (String)this.resultDescriptor.describeResult(result));
        }
        for (AccessibilityViewCheckResult result : warnings) {
            Log.w((String)TAG, (String)this.resultDescriptor.describeResult(result));
        }
        if (!errors.isEmpty() && this.throwExceptionForErrors) {
            throw new AccessibilityViewCheckException(errors).setResultDescriptor(this.resultDescriptor);
        }
        for (AccessibilityViewCheckResult result : errors) {
            Log.e((String)TAG, (String)this.resultDescriptor.describeResult(result));
        }
    }
}

