/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.eyesfree.compat;

import android.text.TextUtils;
import android.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class CompatUtils {
    private static final String TAG = CompatUtils.class.getSimpleName();
    public static boolean DEBUG = false;

    public static Class<?> getClass(String className) {
        if (TextUtils.isEmpty((CharSequence)className)) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static Method getMethod(Class<?> targetClass, String name, Class<?> ... parameterTypes) {
        if (targetClass == null || TextUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        try {
            return targetClass.getDeclaredMethod(name, parameterTypes);
        }
        catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static Field getField(Class<?> targetClass, String name) {
        if (targetClass == null || TextUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        try {
            return targetClass.getDeclaredField(name);
        }
        catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static Constructor<?> getConstructor(Class<?> targetClass, Class<?> ... types) {
        if (targetClass == null || types == null) {
            return null;
        }
        try {
            return targetClass.getConstructor(types);
        }
        catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static Object newInstance(Constructor<?> constructor, Object ... args) {
        if (constructor == null) {
            return null;
        }
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            String string = String.valueOf(e.getClass().getSimpleName());
            Log.e((String)TAG, (String)(string.length() != 0 ? "Exception in newInstance: ".concat(string) : new String("Exception in newInstance: ")));
            if (DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static Object invoke(Object receiver, Object defaultValue, Method method, Object ... args) {
        if (method == null) {
            return defaultValue;
        }
        try {
            return method.invoke(receiver, args);
        }
        catch (Exception e) {
            String string = String.valueOf(e.getClass().getSimpleName());
            Log.e((String)TAG, (String)(string.length() != 0 ? "Exception in invoke: ".concat(string) : new String("Exception in invoke: ")));
            if (DEBUG) {
                e.printStackTrace();
            }
            return defaultValue;
        }
    }

    public static Object getFieldValue(Object receiver, Object defaultValue, Field field) {
        if (field == null) {
            return defaultValue;
        }
        try {
            return field.get(receiver);
        }
        catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return defaultValue;
        }
    }

    public static void setFieldValue(Object receiver, Field field, Object value) {
        block3: {
            if (field == null) {
                return;
            }
            try {
                field.set(receiver, value);
            }
            catch (Exception e) {
                if (!DEBUG) break block3;
                e.printStackTrace();
            }
        }
    }

    private CompatUtils() {
    }
}

