/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.eyesfree.utils;

import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import com.googlecode.eyesfree.utils.AccessibilityNodeInfoUtils;

public class AccessibilityNodeInfoRef {
    private AccessibilityNodeInfoCompat mNode;
    private boolean mOwned;

    public AccessibilityNodeInfoCompat get() {
        return this.mNode;
    }

    public void recycle() {
        this.clear();
    }

    public void clear() {
        this.reset((AccessibilityNodeInfoCompat)null);
    }

    public void reset(AccessibilityNodeInfoCompat newNode) {
        if (this.mNode != newNode && this.mNode != null && this.mOwned) {
            this.mNode.recycle();
        }
        this.mNode = newNode;
        this.mOwned = true;
    }

    public void reset(AccessibilityNodeInfoRef newNode) {
        this.reset(newNode.get());
        this.mOwned = newNode.mOwned;
        newNode.mOwned = false;
    }

    public static AccessibilityNodeInfoRef obtain(AccessibilityNodeInfoCompat node) {
        return new AccessibilityNodeInfoRef(AccessibilityNodeInfoCompat.obtain((AccessibilityNodeInfoCompat)node), true);
    }

    public static AccessibilityNodeInfoRef unOwned(AccessibilityNodeInfoCompat node) {
        return node != null ? new AccessibilityNodeInfoRef(node, false) : null;
    }

    public static AccessibilityNodeInfoRef owned(AccessibilityNodeInfoCompat node) {
        return node != null ? new AccessibilityNodeInfoRef(node, true) : null;
    }

    public static AccessibilityNodeInfoRef refreshed(AccessibilityNodeInfoCompat node) {
        return AccessibilityNodeInfoRef.owned(AccessibilityNodeInfoUtils.refreshNode(node));
    }

    public AccessibilityNodeInfoRef makeOwned() {
        if (this.mNode != null && !this.mOwned) {
            this.reset(AccessibilityNodeInfoCompat.obtain((AccessibilityNodeInfoCompat)this.mNode));
        }
        return this;
    }

    public AccessibilityNodeInfoRef() {
    }

    public static boolean isNull(AccessibilityNodeInfoRef ref) {
        return ref == null || ref.get() == null;
    }

    private AccessibilityNodeInfoRef(AccessibilityNodeInfoCompat node, boolean owned) {
        this.mNode = node;
        this.mOwned = owned;
    }

    public AccessibilityNodeInfoCompat release() {
        this.mOwned = false;
        return this.mNode;
    }

    public boolean lastChild() {
        if (this.mNode == null || this.mNode.getChildCount() < 1) {
            return false;
        }
        for (int i = this.mNode.getChildCount() - 1; i >= 0; --i) {
            AccessibilityNodeInfoCompat newNode = this.mNode.getChild(i);
            if (newNode == null) {
                return false;
            }
            if (AccessibilityNodeInfoUtils.isVisibleOrLegacy(newNode)) {
                this.reset(newNode);
                return true;
            }
            newNode.recycle();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previousSibling() {
        if (this.mNode == null) {
            return false;
        }
        AccessibilityNodeInfoCompat parent = this.mNode.getParent();
        if (parent == null) {
            return false;
        }
        try {
            int childNumber = this.getChildNumber(parent);
            for (int i = childNumber - 1; i >= 0; --i) {
                AccessibilityNodeInfoCompat newNode = parent.getChild(i);
                if (newNode == null) {
                    boolean bl = false;
                    return bl;
                }
                if (AccessibilityNodeInfoUtils.isVisibleOrLegacy(newNode)) {
                    this.reset(newNode);
                    boolean bl = true;
                    return bl;
                }
                newNode.recycle();
            }
        }
        finally {
            parent.recycle();
        }
        return false;
    }

    public boolean firstChild() {
        if (this.mNode == null) {
            return false;
        }
        int childCount = this.mNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            AccessibilityNodeInfoCompat newNode = this.mNode.getChild(i);
            if (newNode == null) {
                return false;
            }
            if (AccessibilityNodeInfoUtils.isVisibleOrLegacy(newNode)) {
                this.reset(newNode);
                return true;
            }
            newNode.recycle();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nextSibling() {
        if (this.mNode == null) {
            return false;
        }
        AccessibilityNodeInfoCompat parent = this.mNode.getParent();
        if (parent == null) {
            return false;
        }
        try {
            int childCount = parent.getChildCount();
            int childNumber = this.getChildNumber(parent);
            if (childNumber < 0) {
                boolean bl = false;
                return bl;
            }
            for (int i = childNumber + 1; i < childCount; ++i) {
                AccessibilityNodeInfoCompat newNode = parent.getChild(i);
                if (newNode == null) {
                    boolean bl = false;
                    return bl;
                }
                if (AccessibilityNodeInfoUtils.isVisibleOrLegacy(newNode)) {
                    this.reset(newNode);
                    boolean bl = true;
                    return bl;
                }
                newNode.recycle();
            }
        }
        finally {
            parent.recycle();
        }
        return false;
    }

    public boolean parent() {
        if (this.mNode == null) {
            return false;
        }
        AccessibilityNodeInfoCompat parentNode = this.mNode.getParent();
        while (parentNode != null) {
            if (AccessibilityNodeInfoUtils.isVisibleOrLegacy(parentNode)) {
                this.reset(parentNode);
                return true;
            }
            AccessibilityNodeInfoCompat tmp = parentNode.getParent();
            parentNode.recycle();
            parentNode = tmp;
        }
        return false;
    }

    private int getChildNumber(AccessibilityNodeInfoCompat parent) {
        int ret = -1;
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount && ret < 0; ++i) {
            AccessibilityNodeInfoCompat child = parent.getChild(i);
            if (this.mNode.equals((Object)child)) {
                ret = i;
            }
            if (child == null) continue;
            child.recycle();
        }
        return ret;
    }

    public boolean nextInOrder() {
        if (this.mNode == null) {
            return false;
        }
        if (this.firstChild()) {
            return true;
        }
        if (this.nextSibling()) {
            return true;
        }
        AccessibilityNodeInfoRef tmp = AccessibilityNodeInfoRef.unOwned(this.mNode);
        while (tmp.parent()) {
            if (!tmp.nextSibling()) continue;
            this.reset(tmp);
            return true;
        }
        tmp.clear();
        return false;
    }

    public boolean previousInOrder() {
        if (this.mNode == null) {
            return false;
        }
        if (this.previousSibling()) {
            this.lastDescendant();
            return true;
        }
        return this.parent();
    }

    public boolean lastDescendant() {
        if (!this.lastChild()) {
            return false;
        }
        while (this.lastChild()) {
        }
        return true;
    }
}

