/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.eyesfree.utils;

import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.text.TextUtils;
import android.widget.AbsListView;
import android.widget.AbsSpinner;
import android.widget.AdapterView;
import android.widget.HorizontalScrollView;
import android.widget.ScrollView;
import android.widget.Spinner;
import com.googlecode.eyesfree.compat.CompatUtils;
import com.googlecode.eyesfree.utils.ClassLoadingManager;
import com.googlecode.eyesfree.utils.LogUtils;
import com.googlecode.eyesfree.utils.NodeFilter;
import com.googlecode.eyesfree.utils.NodeFocusFinder;
import com.googlecode.eyesfree.utils.WebInterfaceUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class AccessibilityNodeInfoUtils {
    private static final boolean SUPPORTS_VISIBILITY = Build.VERSION.SDK_INT >= 16;
    private static final Class<?> CLASS_TOUCHWIZ_TWADAPTERVIEW = CompatUtils.getClass("com.sec.android.touchwiz.widget.TwAdapterView");
    private static final Class<?> CLASS_TOUCHWIZ_TWABSLISTVIEW = CompatUtils.getClass("com.sec.android.touchwiz.widget.TwAbsListView");
    public static final NodeFilter FILTER_SCROLLABLE = new NodeFilter(){

        @Override
        public boolean accept(Context context, AccessibilityNodeInfoCompat node) {
            return AccessibilityNodeInfoUtils.isScrollable(node);
        }
    };
    private static final NodeFilter FILTER_ACCESSIBILITY_FOCUSABLE = new NodeFilter(){

        @Override
        public boolean accept(Context context, AccessibilityNodeInfoCompat node) {
            return AccessibilityNodeInfoUtils.isAccessibilityFocusable(context, node);
        }
    };
    public static final NodeFilter FILTER_SHOULD_FOCUS = new NodeFilter(){

        @Override
        public boolean accept(Context context, AccessibilityNodeInfoCompat node) {
            return AccessibilityNodeInfoUtils.shouldFocusNode(context, node);
        }
    };
    private static final NodeFilter FILTER_AUTO_SCROLL = new NodeFilter(){

        @Override
        public boolean accept(Context context, AccessibilityNodeInfoCompat node) {
            return AccessibilityNodeInfoUtils.nodeMatchesAnyClassByType(context, node, AbsListView.class, AbsSpinner.class, ScrollView.class, HorizontalScrollView.class, CLASS_TOUCHWIZ_TWABSLISTVIEW);
        }
    };
    private static final NodeActionFilter FILTER_SCROLL_FORWARD = new NodeActionFilter(4096);
    private static final NodeActionFilter FILTER_SCROLL_BACKWARD = new NodeActionFilter(8192);

    private AccessibilityNodeInfoUtils() {
    }

    public static CharSequence getNodeText(AccessibilityNodeInfoCompat node) {
        if (node == null) {
            return null;
        }
        CharSequence contentDescription = node.getContentDescription();
        if (!TextUtils.isEmpty((CharSequence)contentDescription) && TextUtils.getTrimmedLength((CharSequence)contentDescription) > 0) {
            return contentDescription;
        }
        CharSequence text = node.getText();
        if (!TextUtils.isEmpty((CharSequence)text) && TextUtils.getTrimmedLength((CharSequence)text) > 0) {
            return text;
        }
        return null;
    }

    public static AccessibilityNodeInfoCompat getRoot(AccessibilityNodeInfoCompat node) {
        if (node == null) {
            return null;
        }
        AccessibilityNodeInfoCompat current = null;
        AccessibilityNodeInfoCompat parent = AccessibilityNodeInfoCompat.obtain((AccessibilityNodeInfoCompat)node);
        while ((parent = (current = parent).getParent()) != null) {
        }
        return current;
    }

    public static boolean isAccessibilityFocusable(Context context, AccessibilityNodeInfoCompat node) {
        if (node == null) {
            return false;
        }
        if (!AccessibilityNodeInfoUtils.isVisibleOrLegacy(node)) {
            return false;
        }
        if (AccessibilityNodeInfoUtils.isActionableForAccessibility(node)) {
            return true;
        }
        return Build.VERSION.SDK_INT < 16 ? AccessibilityNodeInfoUtils.isTopLevelScrollItem(context, node) : AccessibilityNodeInfoUtils.isTopLevelScrollItem(context, node) && (AccessibilityNodeInfoUtils.isSpeakingNode(context, node) || AccessibilityNodeInfoUtils.hasNonActionableSpeakingChildren(context, node));
    }

    public static boolean shouldFocusNode(Context context, AccessibilityNodeInfoCompat node) {
        if (node == null) {
            return false;
        }
        if (!AccessibilityNodeInfoUtils.isVisibleOrLegacy(node)) {
            LogUtils.log(AccessibilityNodeInfoUtils.class, 2, "Don't focus, node is not visible", new Object[0]);
            return false;
        }
        if (FILTER_ACCESSIBILITY_FOCUSABLE.accept(context, node)) {
            if (node.getChildCount() <= 0) {
                LogUtils.log(AccessibilityNodeInfoUtils.class, 2, "Focus, node is focusable and has no children", new Object[0]);
                return true;
            }
            if (AccessibilityNodeInfoUtils.isSpeakingNode(context, node)) {
                LogUtils.log(AccessibilityNodeInfoUtils.class, 2, "Focus, node is focusable and has something to speak", new Object[0]);
                return true;
            }
            LogUtils.log(AccessibilityNodeInfoUtils.class, 2, "Don't focus, node is focusable but has nothing to speak", new Object[0]);
            return false;
        }
        if (!AccessibilityNodeInfoUtils.hasMatchingAncestor(context, node, FILTER_ACCESSIBILITY_FOCUSABLE) && AccessibilityNodeInfoUtils.hasText(node)) {
            LogUtils.log(AccessibilityNodeInfoUtils.class, 2, "Focus, node has text and no focusable ancestors", new Object[0]);
            return true;
        }
        LogUtils.log(AccessibilityNodeInfoUtils.class, 2, "Don't focus, failed all focusability tests", new Object[0]);
        return false;
    }

    public static AccessibilityNodeInfoCompat findFocusFromHover(Context context, AccessibilityNodeInfoCompat touched) {
        return AccessibilityNodeInfoUtils.getSelfOrMatchingAncestor(context, touched, FILTER_SHOULD_FOCUS);
    }

    private static boolean isSpeakingNode(Context context, AccessibilityNodeInfoCompat node) {
        if (AccessibilityNodeInfoUtils.hasText(node)) {
            LogUtils.log(AccessibilityNodeInfoUtils.class, 2, "Speaking, has text", new Object[0]);
            return true;
        }
        if (node.isCheckable()) {
            LogUtils.log(AccessibilityNodeInfoUtils.class, 2, "Speaking, is checkable", new Object[0]);
            return true;
        }
        if (WebInterfaceUtils.supportsWebActions(node)) {
            LogUtils.log(AccessibilityNodeInfoUtils.class, 2, "Speaking, has web content", new Object[0]);
            return true;
        }
        if (AccessibilityNodeInfoUtils.hasNonActionableSpeakingChildren(context, node)) {
            LogUtils.log(AccessibilityNodeInfoUtils.class, 2, "Speaking, has non-actionable speaking children", new Object[0]);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasNonActionableSpeakingChildren(Context context, AccessibilityNodeInfoCompat node) {
        int childCount = node.getChildCount();
        AccessibilityNodeInfoCompat child = null;
        for (int i = 0; i < childCount; ++i) {
            block9: {
                block8: {
                    block7: {
                        block6: {
                            try {
                                child = node.getChild(i);
                                if (child != null) break block6;
                                LogUtils.log(AccessibilityNodeInfoUtils.class, 2, "Child %d is null, skipping it", i);
                            }
                            catch (Throwable throwable) {
                                AccessibilityNodeInfoUtils.recycleNodes(child);
                                throw throwable;
                            }
                            AccessibilityNodeInfoUtils.recycleNodes(child);
                            continue;
                        }
                        if (AccessibilityNodeInfoUtils.isVisibleOrLegacy(child)) break block7;
                        LogUtils.log(AccessibilityNodeInfoUtils.class, 2, "Child %d is invisible, skipping it", i);
                        AccessibilityNodeInfoUtils.recycleNodes(child);
                        continue;
                    }
                    if (!FILTER_ACCESSIBILITY_FOCUSABLE.accept(context, child)) break block8;
                    LogUtils.log(AccessibilityNodeInfoUtils.class, 2, "Child %d is focusable, skipping it", i);
                    AccessibilityNodeInfoUtils.recycleNodes(child);
                    continue;
                }
                if (!AccessibilityNodeInfoUtils.isSpeakingNode(context, child)) break block9;
                LogUtils.log(AccessibilityNodeInfoUtils.class, 2, "Does have actionable speaking children (child %d)", i);
                boolean bl = true;
                AccessibilityNodeInfoUtils.recycleNodes(child);
                return bl;
            }
            AccessibilityNodeInfoUtils.recycleNodes(child);
        }
        LogUtils.log(AccessibilityNodeInfoUtils.class, 2, "Does not have non-actionable speaking children", new Object[0]);
        return false;
    }

    public static boolean isActionableForAccessibility(AccessibilityNodeInfoCompat node) {
        if (node == null) {
            return false;
        }
        if (AccessibilityNodeInfoUtils.isClickable(node) || AccessibilityNodeInfoUtils.isLongClickable(node)) {
            return true;
        }
        if (node.isFocusable()) {
            return true;
        }
        return AccessibilityNodeInfoUtils.supportsAnyAction(node, 1, 1024, 2048);
    }

    public static boolean isSelfOrAncestorFocused(Context context, AccessibilityNodeInfoCompat node) {
        if (node == null) {
            return false;
        }
        if (node.isAccessibilityFocused()) {
            return true;
        }
        return AccessibilityNodeInfoUtils.hasMatchingAncestor(context, node, new NodeFilter(){

            @Override
            public boolean accept(Context context, AccessibilityNodeInfoCompat node) {
                return node.isAccessibilityFocused();
            }
        });
    }

    public static boolean isClickable(AccessibilityNodeInfoCompat node) {
        if (node == null) {
            return false;
        }
        if (node.isClickable()) {
            return true;
        }
        return AccessibilityNodeInfoUtils.supportsAnyAction(node, 16);
    }

    public static boolean isLongClickable(AccessibilityNodeInfoCompat node) {
        if (node == null) {
            return false;
        }
        if (node.isLongClickable()) {
            return true;
        }
        return AccessibilityNodeInfoUtils.supportsAnyAction(node, 32);
    }

    private static boolean hasMatchingAncestor(Context context, AccessibilityNodeInfoCompat node, NodeFilter filter) {
        if (node == null) {
            return false;
        }
        AccessibilityNodeInfoCompat result = AccessibilityNodeInfoUtils.getMatchingAncestor(context, node, filter);
        if (result == null) {
            return false;
        }
        result.recycle();
        return true;
    }

    public static AccessibilityNodeInfoCompat getSelfOrMatchingAncestor(Context context, AccessibilityNodeInfoCompat node, NodeFilter filter) {
        if (node == null) {
            return null;
        }
        if (filter.accept(context, node)) {
            return AccessibilityNodeInfoCompat.obtain((AccessibilityNodeInfoCompat)node);
        }
        return AccessibilityNodeInfoUtils.getMatchingAncestor(context, node, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AccessibilityNodeInfoCompat getMatchingAncestor(Context context, AccessibilityNodeInfoCompat node, NodeFilter filter) {
        if (node == null) {
            return null;
        }
        HashSet<AccessibilityNodeInfoCompat> ancestors = new HashSet<AccessibilityNodeInfoCompat>();
        try {
            ancestors.add(AccessibilityNodeInfoCompat.obtain((AccessibilityNodeInfoCompat)node));
            for (node = node.getParent(); node != null; node = node.getParent()) {
                if (!ancestors.add(node)) {
                    node.recycle();
                    AccessibilityNodeInfoCompat accessibilityNodeInfoCompat = null;
                    return accessibilityNodeInfoCompat;
                }
                if (!filter.accept(context, node)) continue;
                AccessibilityNodeInfoCompat accessibilityNodeInfoCompat = AccessibilityNodeInfoCompat.obtain((AccessibilityNodeInfoCompat)node);
                return accessibilityNodeInfoCompat;
            }
        }
        finally {
            AccessibilityNodeInfoUtils.recycleNodes(ancestors);
        }
        return null;
    }

    private static boolean isScrollable(AccessibilityNodeInfoCompat node) {
        if (node.isScrollable()) {
            return true;
        }
        return AccessibilityNodeInfoUtils.supportsAnyAction(node, 4096, 8192);
    }

    private static boolean hasText(AccessibilityNodeInfoCompat node) {
        if (node == null) {
            return false;
        }
        return !TextUtils.isEmpty((CharSequence)node.getText()) || !TextUtils.isEmpty((CharSequence)node.getContentDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTopLevelScrollItem(Context context, AccessibilityNodeInfoCompat node) {
        AccessibilityNodeInfoCompat parent;
        block8: {
            block7: {
                block6: {
                    boolean bl;
                    if (node == null) {
                        return false;
                    }
                    parent = null;
                    try {
                        parent = node.getParent();
                        if (parent != null) break block6;
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        AccessibilityNodeInfoUtils.recycleNodes(parent);
                        throw throwable;
                    }
                    AccessibilityNodeInfoUtils.recycleNodes(parent);
                    return bl;
                }
                if (!AccessibilityNodeInfoUtils.isScrollable(node)) break block7;
                boolean bl = true;
                AccessibilityNodeInfoUtils.recycleNodes(parent);
                return bl;
            }
            if (!AccessibilityNodeInfoUtils.nodeMatchesAnyClassByType(context, parent, AdapterView.class, ScrollView.class, HorizontalScrollView.class, CLASS_TOUCHWIZ_TWADAPTERVIEW) || AccessibilityNodeInfoUtils.nodeMatchesAnyClassByType(context, parent, Spinner.class)) break block8;
            boolean bl = true;
            AccessibilityNodeInfoUtils.recycleNodes(parent);
            return bl;
        }
        boolean bl = false;
        AccessibilityNodeInfoUtils.recycleNodes(parent);
        return bl;
    }

    public static boolean isEdgeListItem(Context context, AccessibilityNodeInfoCompat node) {
        return AccessibilityNodeInfoUtils.isEdgeListItem(context, node, 0, null);
    }

    public static boolean isEdgeListItem(Context context, AccessibilityNodeInfoCompat node, int direction, NodeFilter filter) {
        if (node == null) {
            return false;
        }
        if (direction <= 0 && AccessibilityNodeInfoUtils.isMatchingEdgeListItem(context, node, -1, FILTER_SCROLL_BACKWARD.and(filter))) {
            return true;
        }
        return direction >= 0 && AccessibilityNodeInfoUtils.isMatchingEdgeListItem(context, node, 1, FILTER_SCROLL_FORWARD.and(filter));
    }

    public static boolean isAutoScrollEdgeListItem(Context context, AccessibilityNodeInfoCompat node, int direction) {
        return AccessibilityNodeInfoUtils.isEdgeListItem(context, node, direction, FILTER_AUTO_SCROLL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isMatchingEdgeListItem(Context context, AccessibilityNodeInfoCompat cursor, int direction, NodeFilter filter) {
        AccessibilityNodeInfoCompat searchedAncestor;
        AccessibilityNodeInfoCompat searched;
        AccessibilityNodeInfoCompat ancestor;
        block7: {
            block6: {
                boolean bl;
                block5: {
                    ancestor = null;
                    searched = null;
                    searchedAncestor = null;
                    ancestor = AccessibilityNodeInfoUtils.getMatchingAncestor(null, cursor, filter);
                    if (ancestor != null) break block5;
                    boolean bl2 = false;
                    AccessibilityNodeInfoUtils.recycleNodes(ancestor, searched, searchedAncestor);
                    return bl2;
                }
                try {
                    searched = NodeFocusFinder.focusSearch(cursor, direction);
                    while (searched != null && !AccessibilityNodeInfoUtils.shouldFocusNode(context, searched)) {
                        AccessibilityNodeInfoCompat temp = searched;
                        searched = NodeFocusFinder.focusSearch(temp, direction);
                        temp.recycle();
                    }
                    if (searched != null && !searched.equals((Object)ancestor)) break block6;
                    bl = true;
                }
                catch (Throwable throwable) {
                    AccessibilityNodeInfoUtils.recycleNodes(ancestor, searched, searchedAncestor);
                    throw throwable;
                }
                AccessibilityNodeInfoUtils.recycleNodes(ancestor, searched, searchedAncestor);
                return bl;
            }
            searchedAncestor = AccessibilityNodeInfoUtils.getMatchingAncestor(null, searched, filter);
            if (ancestor.equals((Object)searchedAncestor)) break block7;
            boolean bl = true;
            AccessibilityNodeInfoUtils.recycleNodes(ancestor, searched, searchedAncestor);
            return bl;
        }
        AccessibilityNodeInfoUtils.recycleNodes(ancestor, searched, searchedAncestor);
        return false;
    }

    public static boolean nodeMatchesClassByType(Context context, AccessibilityNodeInfoCompat node, Class<?> referenceClass) {
        if (node == null || referenceClass == null) {
            return false;
        }
        CharSequence nodeClassName = node.getClassName();
        if (TextUtils.equals((CharSequence)nodeClassName, (CharSequence)referenceClass.getName())) {
            return true;
        }
        ClassLoadingManager loader = ClassLoadingManager.getInstance();
        CharSequence appPackage = node.getPackageName();
        return loader.checkInstanceOf(context, nodeClassName, appPackage, referenceClass);
    }

    public static boolean nodeMatchesAnyClassByType(Context context, AccessibilityNodeInfoCompat node, Class<?> ... referenceClasses) {
        for (Class<?> referenceClass : referenceClasses) {
            if (!AccessibilityNodeInfoUtils.nodeMatchesClassByType(context, node, referenceClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean nodeMatchesClassByName(Context context, AccessibilityNodeInfoCompat node, CharSequence referenceClassName) {
        if (node == null || referenceClassName == null) {
            return false;
        }
        CharSequence nodeClassName = node.getClassName();
        if (TextUtils.equals((CharSequence)nodeClassName, (CharSequence)referenceClassName)) {
            return true;
        }
        ClassLoadingManager loader = ClassLoadingManager.getInstance();
        CharSequence appPackage = node.getPackageName();
        return loader.checkInstanceOf(context, nodeClassName, appPackage, referenceClassName);
    }

    public static void recycleNodes(Collection<AccessibilityNodeInfoCompat> nodes) {
        if (nodes == null) {
            return;
        }
        for (AccessibilityNodeInfoCompat node : nodes) {
            if (node == null) continue;
            node.recycle();
        }
        nodes.clear();
    }

    public static void recycleNodes(AccessibilityNodeInfoCompat ... nodes) {
        if (nodes == null) {
            return;
        }
        for (AccessibilityNodeInfoCompat node : nodes) {
            if (node == null) continue;
            node.recycle();
        }
    }

    public static boolean supportsAnyAction(AccessibilityNodeInfoCompat node, int ... actions) {
        if (node != null) {
            int supportedActions = node.getActions();
            for (int action : actions) {
                if ((supportedActions & action) != action) continue;
                return true;
            }
        }
        return false;
    }

    public static AccessibilityNodeInfoCompat searchFromBfs(Context context, AccessibilityNodeInfoCompat node, NodeFilter filter) {
        if (node == null) {
            return null;
        }
        LinkedList<AccessibilityNodeInfoCompat> queue = new LinkedList<AccessibilityNodeInfoCompat>();
        queue.add(AccessibilityNodeInfoCompat.obtain((AccessibilityNodeInfoCompat)node));
        while (!queue.isEmpty()) {
            AccessibilityNodeInfoCompat item = (AccessibilityNodeInfoCompat)queue.removeFirst();
            if (filter.accept(context, item)) {
                return AccessibilityNodeInfoCompat.obtain((AccessibilityNodeInfoCompat)item);
            }
            int childCount = item.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                AccessibilityNodeInfoCompat child = item.getChild(i);
                if (child == null) continue;
                queue.addLast(child);
            }
        }
        return null;
    }

    public static List<AccessibilityNodeInfoCompat> searchAllFromBfs(Context context, AccessibilityNodeInfoCompat node, NodeFilter filter) {
        if (node == null) {
            return null;
        }
        ArrayList<AccessibilityNodeInfoCompat> toReturn = new ArrayList<AccessibilityNodeInfoCompat>();
        LinkedList<AccessibilityNodeInfoCompat> queue = new LinkedList<AccessibilityNodeInfoCompat>();
        queue.add(AccessibilityNodeInfoCompat.obtain((AccessibilityNodeInfoCompat)node));
        while (!queue.isEmpty()) {
            AccessibilityNodeInfoCompat item = (AccessibilityNodeInfoCompat)queue.removeFirst();
            if (filter.accept(context, item)) {
                toReturn.add(AccessibilityNodeInfoCompat.obtain((AccessibilityNodeInfoCompat)item));
            }
            int childCount = item.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                AccessibilityNodeInfoCompat child = item.getChild(i);
                if (child == null) continue;
                queue.addLast(child);
            }
        }
        return toReturn;
    }

    public static AccessibilityNodeInfoCompat searchFromInOrderTraversal(Context context, AccessibilityNodeInfoCompat root, NodeFilter filter, int direction) {
        AccessibilityNodeInfoCompat currentNode = NodeFocusFinder.focusSearch(root, direction);
        HashSet<AccessibilityNodeInfoCompat> seenNodes = new HashSet<AccessibilityNodeInfoCompat>();
        while (currentNode != null && !seenNodes.contains(currentNode) && !filter.accept(context, currentNode)) {
            seenNodes.add(currentNode);
            currentNode = NodeFocusFinder.focusSearch(currentNode, direction);
        }
        AccessibilityNodeInfoUtils.recycleNodes(seenNodes);
        return currentNode;
    }

    public static AccessibilityNodeInfoCompat refreshNode(AccessibilityNodeInfoCompat node) {
        if (node == null) {
            return null;
        }
        AccessibilityNodeInfoCompat result = AccessibilityNodeInfoUtils.refreshFromChild(node);
        if (result == null) {
            result = AccessibilityNodeInfoUtils.refreshFromParent(node);
        }
        return result;
    }

    private static AccessibilityNodeInfoCompat refreshFromChild(AccessibilityNodeInfoCompat node) {
        AccessibilityNodeInfoCompat firstChild;
        if (node.getChildCount() > 0 && (firstChild = node.getChild(0)) != null) {
            AccessibilityNodeInfoCompat parent = firstChild.getParent();
            firstChild.recycle();
            if (node.equals((Object)parent)) {
                return parent;
            }
            AccessibilityNodeInfoUtils.recycleNodes(parent);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AccessibilityNodeInfoCompat refreshFromParent(AccessibilityNodeInfoCompat node) {
        AccessibilityNodeInfoCompat parent = node.getParent();
        if (parent != null) {
            try {
                int childCount = parent.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    AccessibilityNodeInfoCompat child = parent.getChild(i);
                    if (node.equals((Object)child)) {
                        AccessibilityNodeInfoCompat accessibilityNodeInfoCompat = child;
                        return accessibilityNodeInfoCompat;
                    }
                    AccessibilityNodeInfoUtils.recycleNodes(child);
                }
            }
            finally {
                parent.recycle();
            }
        }
        return null;
    }

    public static boolean isVisibleOrLegacy(AccessibilityNodeInfoCompat node) {
        return !SUPPORTS_VISIBILITY || node.isVisibleToUser();
    }

    public static class TopToBottomLeftToRightComparator
    implements Comparator<AccessibilityNodeInfoCompat> {
        private final Rect mFirstBounds = new Rect();
        private final Rect mSecondBounds = new Rect();
        private static final int BEFORE = -1;
        private static final int AFTER = 1;

        @Override
        public int compare(AccessibilityNodeInfoCompat first, AccessibilityNodeInfoCompat second) {
            Rect firstBounds = this.mFirstBounds;
            first.getBoundsInScreen(firstBounds);
            Rect secondBounds = this.mSecondBounds;
            second.getBoundsInScreen(secondBounds);
            if (firstBounds.bottom <= secondBounds.top) {
                return -1;
            }
            if (firstBounds.top >= secondBounds.bottom) {
                return 1;
            }
            int leftDifference = firstBounds.left - secondBounds.left;
            if (leftDifference != 0) {
                return leftDifference;
            }
            int topDifference = firstBounds.top - secondBounds.top;
            if (topDifference != 0) {
                return topDifference;
            }
            int bottomDifference = firstBounds.bottom - secondBounds.bottom;
            if (bottomDifference != 0) {
                return bottomDifference;
            }
            int rightDifference = firstBounds.right - secondBounds.right;
            if (rightDifference != 0) {
                return rightDifference;
            }
            return first.hashCode() - second.hashCode();
        }
    }

    private static class NodeActionFilter
    extends NodeFilter {
        private final int mAction;

        public NodeActionFilter(int actionMask) {
            this.mAction = actionMask;
        }

        @Override
        public boolean accept(Context context, AccessibilityNodeInfoCompat node) {
            return (node.getActions() & this.mAction) == this.mAction;
        }
    }
}

