/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.eyesfree.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;

public abstract class BasePackageMonitor
extends BroadcastReceiver {
    private final IntentFilter mPackageFilter = new IntentFilter();
    private Context mRegisteredContext;

    public BasePackageMonitor() {
        this.mPackageFilter.addAction("android.intent.action.PACKAGE_ADDED");
        this.mPackageFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        this.mPackageFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        this.mPackageFilter.addDataScheme("package");
    }

    public void register(Context context) {
        if (this.mRegisteredContext != null) {
            throw new IllegalStateException("Already registered");
        }
        this.mRegisteredContext = context;
        context.registerReceiver((BroadcastReceiver)this, this.mPackageFilter);
    }

    public void unregister() {
        if (this.mRegisteredContext == null) {
            throw new IllegalStateException("Not registered");
        }
        this.mRegisteredContext.unregisterReceiver((BroadcastReceiver)this);
        this.mRegisteredContext = null;
    }

    public void onReceive(Context context, Intent intent) {
        String packageName = BasePackageMonitor.getPackageName(intent);
        String action = intent.getAction();
        if ("android.intent.action.PACKAGE_ADDED".equals(action)) {
            this.onPackageAdded(packageName);
        } else if ("android.intent.action.PACKAGE_REMOVED".equals(action)) {
            this.onPackageRemoved(packageName);
        } else if ("android.intent.action.PACKAGE_CHANGED".equals(action)) {
            this.onPackageChanged(packageName);
        }
    }

    private static String getPackageName(Intent intent) {
        Uri uri = intent.getData();
        if (uri == null) {
            return null;
        }
        return uri.getSchemeSpecificPart();
    }

    protected abstract void onPackageAdded(String var1);

    protected abstract void onPackageRemoved(String var1);

    protected abstract void onPackageChanged(String var1);
}

