/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.eyesfree.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.text.TextUtils;
import com.googlecode.eyesfree.utils.BasePackageMonitor;
import com.googlecode.eyesfree.utils.LogUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ClassLoadingManager {
    private static ClassLoadingManager sInstance;
    private final HashMap<String, Class<?>> mClassNameToClassMap = new HashMap();
    private final HashMap<String, HashSet<String>> mNotFoundClassesMap = new HashMap();
    private final BasePackageMonitor mPackageMonitor = new BasePackageMonitor(){

        @Override
        protected void onPackageAdded(String packageName) {
            ClassLoadingManager.this.addInstalledPackageToCache(packageName);
        }

        @Override
        protected void onPackageRemoved(String packageName) {
        }

        @Override
        protected void onPackageChanged(String packageName) {
        }
    };

    public static ClassLoadingManager getInstance() {
        if (sInstance == null) {
            sInstance = new ClassLoadingManager();
        }
        return sInstance;
    }

    public void init(Context context) {
        if (!this.mNotFoundClassesMap.isEmpty()) {
            this.buildInstalledPackagesCache(context);
        }
        this.mPackageMonitor.register(context);
    }

    public void shutdown() {
        this.mClassNameToClassMap.clear();
        this.mPackageMonitor.unregister();
    }

    private void buildInstalledPackagesCache(Context context) {
        List installedPackages = context.getPackageManager().getInstalledPackages(0);
        for (PackageInfo installedPackage : installedPackages) {
            this.addInstalledPackageToCache(installedPackage.packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInstalledPackageToCache(String packageName) {
        HashMap<String, HashSet<String>> hashMap = this.mNotFoundClassesMap;
        synchronized (hashMap) {
            this.mNotFoundClassesMap.remove(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadOrGetCachedClass(Context context, CharSequence className, CharSequence packageName) {
        if (TextUtils.isEmpty((CharSequence)className)) {
            LogUtils.log(this, 3, "Missing class name. Failed to load class.", new Object[0]);
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            int lastDotIndex = TextUtils.lastIndexOf((CharSequence)className, (char)'.');
            if (lastDotIndex < 0) {
                LogUtils.log(this, 3, "Missing package name. Failed to load class: %s", className);
                return null;
            }
            packageName = TextUtils.substring((CharSequence)className, (int)0, (int)lastDotIndex);
        }
        String classNameStr = className.toString();
        String packageNameStr = packageName.toString();
        HashSet<String> notFoundClassesSet = null;
        HashMap<String, HashSet<String>> hashMap = this.mNotFoundClassesMap;
        synchronized (hashMap) {
            notFoundClassesSet = this.mNotFoundClassesMap.get(packageNameStr);
            if (notFoundClassesSet != null && notFoundClassesSet.contains(classNameStr)) {
                return null;
            }
        }
        Class<?> clazz = this.mClassNameToClassMap.get(classNameStr);
        if (clazz != null) {
            return clazz;
        }
        try {
            Class<?> insideClazz = this.getClass().getClassLoader().loadClass(classNameStr);
            if (insideClazz != null) {
                this.mClassNameToClassMap.put(classNameStr, insideClazz);
                return insideClazz;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (context == null) {
            return null;
        }
        try {
            int flags = 3;
            Context packageContext = context.createPackageContext(packageNameStr, 3);
            Class<?> outsideClazz = packageContext.getClassLoader().loadClass(classNameStr);
            if (outsideClazz != null) {
                this.mClassNameToClassMap.put(classNameStr, outsideClazz);
                return outsideClazz;
            }
        }
        catch (Exception e) {
            LogUtils.log(this, 6, "Error encountered. Failed to load outside class: %s", classNameStr);
        }
        if (notFoundClassesSet == null) {
            notFoundClassesSet = new HashSet();
            this.mNotFoundClassesMap.put(packageNameStr, notFoundClassesSet);
        }
        notFoundClassesSet.add(classNameStr);
        LogUtils.log(3, "Failed to load class: %s", classNameStr);
        return null;
    }

    public boolean checkInstanceOf(Context context, CharSequence targetClassName, CharSequence loaderPackage, CharSequence referenceClassName) {
        if (targetClassName == null || referenceClassName == null) {
            return false;
        }
        if (TextUtils.equals((CharSequence)targetClassName, (CharSequence)referenceClassName)) {
            return true;
        }
        Class<?> referenceClass = this.loadOrGetCachedClass(context, referenceClassName, loaderPackage);
        if (referenceClass == null) {
            return false;
        }
        return this.checkInstanceOf(context, targetClassName, loaderPackage, referenceClass);
    }

    public boolean checkInstanceOf(Context context, CharSequence targetClassName, CharSequence loaderPackage, Class<?> referenceClass) {
        if (targetClassName == null || referenceClass == null) {
            return false;
        }
        Class<?> targetClass = this.loadOrGetCachedClass(context, targetClassName, loaderPackage);
        if (targetClass == null) {
            return false;
        }
        return referenceClass.isAssignableFrom(targetClass);
    }
}

