/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.eyesfree.utils;

import android.graphics.Color;

public class ContrastUtils {
    public static final int WCAG_LARGE_TEXT_MIN_SIZE = 18;
    public static final int WCAG_LARGE_BOLD_TEXT_MIN_SIZE = 14;
    public static final double CONTRAST_RATIO_WCAG_NORMAL_TEXT = 4.5;
    public static final double CONTRAST_RATIO_WCAG_LARGE_TEXT = 3.0;

    private ContrastUtils() {
    }

    public static double calculateLuminance(int color) {
        double[] sRGB = new double[]{(double)Color.red((int)color) / 255.0, (double)Color.green((int)color) / 255.0, (double)Color.blue((int)color) / 255.0};
        double[] lumRGB = new double[3];
        for (int i = 0; i < sRGB.length; ++i) {
            lumRGB[i] = sRGB[i] <= 0.03928 ? sRGB[i] / 12.92 : Math.pow((sRGB[i] + 0.055) / 1.055, 2.4);
        }
        return 0.2126 * lumRGB[0] + 0.7152 * lumRGB[1] + 0.0722 * lumRGB[2];
    }

    public static double calculateContrastRatio(double lum1, double lum2) {
        if (lum1 < 0.0 || lum2 < 0.0) {
            throw new IllegalArgumentException("Luminance values may not be negative.");
        }
        return (Math.max(lum1, lum2) + 0.05) / (Math.min(lum1, lum2) + 0.05);
    }

    public static CharSequence colorsToHexString(Iterable<Integer> colors) {
        StringBuilder colorStr = new StringBuilder(7);
        for (int color : colors) {
            if (colorStr.length() != 0) {
                colorStr.append(", ");
            }
            colorStr.append(ContrastUtils.colorToHexString(color));
        }
        return colorStr;
    }

    public static CharSequence colorToHexString(int color) {
        return String.format("#%06X", 0xFFFFFF & color);
    }
}

