/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.eyesfree.utils;

import android.util.Log;
import java.util.IllegalFormatException;

public class LogUtils {
    public static String TAG = "LogUtils";
    public static int LOG_LEVEL = 6;

    public static void log(Object source, int priority, String format, Object ... args) {
        if (priority < LOG_LEVEL) {
            return;
        }
        String sourceClass = source == null ? TAG : (source instanceof Class ? ((Class)source).getSimpleName() : source.getClass().getSimpleName());
        try {
            Log.println((int)priority, (String)sourceClass, (String)String.format(format, args));
        }
        catch (IllegalFormatException e) {
            String string = String.valueOf(String.valueOf(format));
            Log.e((String)TAG, (String)new StringBuilder(25 + string.length()).append("Bad formatting string: \"").append(string).append("\"").toString(), (Throwable)e);
        }
    }

    public static void log(int priority, String format, Object ... args) {
        LogUtils.log(null, priority, format, args);
    }

    public static void setLogLevel(int logLevel) {
        LOG_LEVEL = logLevel;
    }
}

