/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.eyesfree.utils;

import android.content.Context;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import java.util.LinkedList;

public abstract class NodeFilter {
    public abstract boolean accept(Context var1, AccessibilityNodeInfoCompat var2);

    public NodeFilter and(NodeFilter filter) {
        if (filter == null) {
            return this;
        }
        return new NodeFilterAnd(this, filter);
    }

    public NodeFilter or(NodeFilter filter) {
        if (filter == null) {
            return this;
        }
        return new NodeFilterOr(this, filter);
    }

    private static class NodeFilterOr
    extends NodeFilter {
        private final LinkedList<NodeFilter> mFilters = new LinkedList();

        public NodeFilterOr(NodeFilter lhs, NodeFilter rhs) {
            this.mFilters.add(lhs);
            this.mFilters.add(rhs);
        }

        @Override
        public boolean accept(Context context, AccessibilityNodeInfoCompat node) {
            for (NodeFilter filter : this.mFilters) {
                if (!filter.accept(context, node)) continue;
                return true;
            }
            return false;
        }

        @Override
        public NodeFilter or(NodeFilter filter) {
            this.mFilters.add(filter);
            return this;
        }
    }

    private static class NodeFilterAnd
    extends NodeFilter {
        private final LinkedList<NodeFilter> mFilters = new LinkedList();

        public NodeFilterAnd(NodeFilter lhs, NodeFilter rhs) {
            this.mFilters.add(lhs);
            this.mFilters.add(rhs);
        }

        @Override
        public boolean accept(Context context, AccessibilityNodeInfoCompat node) {
            for (NodeFilter filter : this.mFilters) {
                if (filter.accept(context, node)) continue;
                return false;
            }
            return true;
        }

        @Override
        public NodeFilter and(NodeFilter filter) {
            this.mFilters.add(filter);
            return this;
        }
    }
}

