/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.eyesfree.utils;

import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import java.util.List;

public class StringBuilderUtils {
    public static final String DEFAULT_BREAKING_SEPARATOR = ", ";
    public static final String DEFAULT_SEPARATOR = " ";
    private static final char[] HEX_ALPHABET = "0123456789abcdef".toCharArray();

    public static CharSequence getAggregateText(List<CharSequence> textList) {
        SpannableStringBuilder aggregateText;
        if (textList == null || textList.isEmpty()) {
            aggregateText = null;
        } else {
            SpannableStringBuilder builder = new SpannableStringBuilder();
            for (CharSequence text : textList) {
                StringBuilderUtils.appendWithSeparator(builder, text);
            }
            aggregateText = builder;
        }
        return aggregateText;
    }

    public static SpannableStringBuilder appendWithSeparator(SpannableStringBuilder builder, CharSequence ... args) {
        if (builder == null) {
            builder = new SpannableStringBuilder();
        }
        for (CharSequence arg : args) {
            if (arg == null || arg.toString().length() == 0) continue;
            if (builder.length() > 0) {
                if (StringBuilderUtils.needsBreakingSeparator((CharSequence)builder)) {
                    builder.append((CharSequence)DEFAULT_BREAKING_SEPARATOR);
                } else {
                    builder.append((CharSequence)DEFAULT_SEPARATOR);
                }
            }
            builder.append(arg);
        }
        return builder;
    }

    private static boolean needsBreakingSeparator(CharSequence text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return false;
        }
        return Character.isLetterOrDigit(text.charAt(text.length() - 1));
    }

    public static String bytesToHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            int nibble1 = b >>> 4 & 0xF;
            int nibble2 = b & 0xF;
            hex.append(HEX_ALPHABET[nibble1]);
            hex.append(HEX_ALPHABET[nibble2]);
        }
        return hex.toString();
    }
}

