/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.eyesfree.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Bundle;
import android.provider.Settings;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import com.googlecode.eyesfree.utils.AccessibilityNodeInfoUtils;

public class WebInterfaceUtils {
    private static final String ACCESSIBILITY_SCRIPT_INJECTION = "accessibility_script_injection";
    public static final int DIRECTION_FORWARD = 1;
    public static final int DIRECTION_BACKWARD = -1;
    public static final int ACTION_READ_CURRENT_HTML_ELEMENT = -1;
    public static final int ACTION_READ_PAGE_TITLE_ELEMENT = -2;
    public static final int ACTION_STOP_SPEECH = -3;
    private static final int ACTION_TOGGLE_SPECIAL_CONTENT = -4;
    public static final int ACTION_TOGGLE_INCREMENTAL_SEARCH = -5;
    public static final String HTML_ELEMENT_MOVE_BY_SECTION = "SECTION";
    public static final String HTML_ELEMENT_MOVE_BY_LIST = "LIST";
    public static final String HTML_ELEMENT_MOVE_BY_CONTROL = "CONTROL";

    public static boolean performNavigationToHtmlElementAction(AccessibilityNodeInfoCompat node, int direction, String htmlElement) {
        int action = direction == 1 ? 1024 : 2048;
        Bundle args = new Bundle();
        args.putString("ACTION_ARGUMENT_HTML_ELEMENT_STRING", htmlElement);
        return node.performAction(action, args);
    }

    public static boolean performNavigationByDOMObject(AccessibilityNodeInfoCompat node, int direction) {
        int action = direction == 1 ? 1024 : 2048;
        return node.performAction(action);
    }

    public static boolean performNavigationAtGranularityAction(AccessibilityNodeInfoCompat node, int direction, int granularity) {
        int action = direction == 1 ? 256 : 512;
        Bundle args = new Bundle();
        args.putInt("ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT", granularity);
        return node.performAction(action, args);
    }

    public static boolean performSpecialAction(AccessibilityNodeInfoCompat node, int action) {
        return WebInterfaceUtils.performSpecialAction(node, action, 1);
    }

    public static boolean performSpecialAction(AccessibilityNodeInfoCompat node, int action, int direction) {
        return WebInterfaceUtils.performNavigationAtGranularityAction(node, direction, action);
    }

    public static boolean setSpecialContentModeEnabled(AccessibilityNodeInfoCompat node, boolean enabled) {
        int direction = enabled ? 1 : -1;
        return WebInterfaceUtils.performSpecialAction(node, -4, direction);
    }

    public static boolean supportsWebActions(AccessibilityNodeInfoCompat node) {
        return AccessibilityNodeInfoUtils.supportsAnyAction(node, 1024, 2048);
    }

    public static boolean hasNativeWebContent(AccessibilityNodeInfoCompat node) {
        if (node == null) {
            return false;
        }
        if (!WebInterfaceUtils.supportsWebActions(node)) {
            return false;
        }
        AccessibilityNodeInfoCompat parent = node.getParent();
        if (WebInterfaceUtils.supportsWebActions(parent)) {
            if (parent != null) {
                parent.recycle();
            }
            return true;
        }
        if (parent != null) {
            parent.recycle();
        }
        return node.getChildCount() > 0;
    }

    public static boolean hasLegacyWebContent(AccessibilityNodeInfoCompat node) {
        if (node == null) {
            return false;
        }
        if (!WebInterfaceUtils.supportsWebActions(node)) {
            return false;
        }
        AccessibilityNodeInfoCompat parent = node.getParent();
        if (WebInterfaceUtils.supportsWebActions(parent)) {
            if (parent != null) {
                parent.recycle();
            }
            return false;
        }
        if (parent != null) {
            parent.recycle();
        }
        return node.getChildCount() == 0;
    }

    public static boolean isScriptInjectionEnabled(Context context) {
        int injectionSetting = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)ACCESSIBILITY_SCRIPT_INJECTION, (int)0);
        return injectionSetting == 1;
    }

    public static boolean hasNavigableWebContent(Context context, AccessibilityNodeInfoCompat node) {
        return WebInterfaceUtils.supportsWebActions(node) && WebInterfaceUtils.isScriptInjectionEnabled(context) || WebInterfaceUtils.hasNativeWebContent(node);
    }
}

