/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.codegen;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import javax.annotation.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static AnnotationSpec generatedAnnotation() {
        return AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{"GoogleAdsCatalogAnnotationProcessor"}).build();
    }

    public static ClassName createServiceClientClassName(int version, String serviceClient) {
        return ClassName.get((String)("com.google.ads.googleads.v" + version + ".services"), (String)serviceClient, (String[])new String[0]);
    }

    public static JavaFile createJavaFile(String packageName, TypeSpec typeSpec) {
        String LICENSE = "Copyright 2020 Google LLC\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.";
        return JavaFile.builder((String)packageName, (TypeSpec)typeSpec).addFileComment("Copyright 2020 Google LLC\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.", new Object[0]).skipJavaLangImports(true).build();
    }

    public static void writeGeneratedClassToFile(JavaFile javaFile, File targetDirectory) {
        try {
            javaFile.writeTo(targetDirectory);
        }
        catch (IOException ioe) {
            throw new RuntimeException("There was an error writing the class file " + javaFile.typeSpec.name, ioe);
        }
    }
}

