/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v10.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BiddingDataExclusionName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_SEASONALITY_EVENT_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/biddingDataExclusions/{seasonality_event_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String seasonalityEventId;

    @Deprecated
    protected BiddingDataExclusionName() {
        this.customerId = null;
        this.seasonalityEventId = null;
    }

    private BiddingDataExclusionName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.seasonalityEventId = (String)Preconditions.checkNotNull((Object)builder.getSeasonalityEventId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getSeasonalityEventId() {
        return this.seasonalityEventId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BiddingDataExclusionName of(String customerId, String seasonalityEventId) {
        return BiddingDataExclusionName.newBuilder().setCustomerId(customerId).setSeasonalityEventId(seasonalityEventId).build();
    }

    public static String format(String customerId, String seasonalityEventId) {
        return BiddingDataExclusionName.newBuilder().setCustomerId(customerId).setSeasonalityEventId(seasonalityEventId).build().toString();
    }

    public static BiddingDataExclusionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_SEASONALITY_EVENT_ID.validatedMatch(formattedString, "BiddingDataExclusionName.parse: formattedString not in valid format");
        return BiddingDataExclusionName.of((String)matchMap.get("customer_id"), (String)matchMap.get("seasonality_event_id"));
    }

    public static List<BiddingDataExclusionName> parseList(List<String> formattedStrings) {
        ArrayList<BiddingDataExclusionName> list = new ArrayList<BiddingDataExclusionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BiddingDataExclusionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BiddingDataExclusionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BiddingDataExclusionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_SEASONALITY_EVENT_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BiddingDataExclusionName biddingDataExclusionName = this;
            synchronized (biddingDataExclusionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.seasonalityEventId != null) {
                        fieldMapBuilder.put((Object)"seasonality_event_id", (Object)this.seasonalityEventId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_SEASONALITY_EVENT_ID.instantiate(new String[]{"customer_id", this.customerId, "seasonality_event_id", this.seasonalityEventId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            BiddingDataExclusionName that = (BiddingDataExclusionName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.seasonalityEventId, that.seasonalityEventId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.seasonalityEventId);
    }

    public static class Builder {
        private String customerId;
        private String seasonalityEventId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getSeasonalityEventId() {
            return this.seasonalityEventId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setSeasonalityEventId(String seasonalityEventId) {
            this.seasonalityEventId = seasonalityEventId;
            return this;
        }

        private Builder(BiddingDataExclusionName biddingDataExclusionName) {
            this.customerId = biddingDataExclusionName.customerId;
            this.seasonalityEventId = biddingDataExclusionName.seasonalityEventId;
        }

        public BiddingDataExclusionName build() {
            return new BiddingDataExclusionName(this);
        }
    }
}

