/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v11.resources;

import com.google.ads.googleads.v11.enums.AdvertisingChannelTypeEnum;
import com.google.ads.googleads.v11.enums.DeviceEnum;
import com.google.ads.googleads.v11.enums.SeasonalityEventScopeEnum;
import com.google.ads.googleads.v11.enums.SeasonalityEventStatusEnum;
import com.google.ads.googleads.v11.resources.BiddingDataExclusionOrBuilder;
import com.google.ads.googleads.v11.resources.BiddingDataExclusionProto;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class BiddingDataExclusion
extends GeneratedMessageV3
implements BiddingDataExclusionOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
    private volatile Object resourceName_;
    public static final int DATA_EXCLUSION_ID_FIELD_NUMBER = 2;
    private long dataExclusionId_;
    public static final int SCOPE_FIELD_NUMBER = 3;
    private int scope_;
    public static final int STATUS_FIELD_NUMBER = 4;
    private int status_;
    public static final int START_DATE_TIME_FIELD_NUMBER = 5;
    private volatile Object startDateTime_;
    public static final int END_DATE_TIME_FIELD_NUMBER = 6;
    private volatile Object endDateTime_;
    public static final int NAME_FIELD_NUMBER = 7;
    private volatile Object name_;
    public static final int DESCRIPTION_FIELD_NUMBER = 8;
    private volatile Object description_;
    public static final int DEVICES_FIELD_NUMBER = 9;
    private List<Integer> devices_;
    private static final Internal.ListAdapter.Converter<Integer, DeviceEnum.Device> devices_converter_ = new Internal.ListAdapter.Converter<Integer, DeviceEnum.Device>(){

        public DeviceEnum.Device convert(Integer from) {
            DeviceEnum.Device result = DeviceEnum.Device.valueOf(from);
            return result == null ? DeviceEnum.Device.UNRECOGNIZED : result;
        }
    };
    private int devicesMemoizedSerializedSize;
    public static final int CAMPAIGNS_FIELD_NUMBER = 10;
    private LazyStringList campaigns_;
    public static final int ADVERTISING_CHANNEL_TYPES_FIELD_NUMBER = 11;
    private List<Integer> advertisingChannelTypes_;
    private static final Internal.ListAdapter.Converter<Integer, AdvertisingChannelTypeEnum.AdvertisingChannelType> advertisingChannelTypes_converter_ = new Internal.ListAdapter.Converter<Integer, AdvertisingChannelTypeEnum.AdvertisingChannelType>(){

        public AdvertisingChannelTypeEnum.AdvertisingChannelType convert(Integer from) {
            AdvertisingChannelTypeEnum.AdvertisingChannelType result = AdvertisingChannelTypeEnum.AdvertisingChannelType.valueOf(from);
            return result == null ? AdvertisingChannelTypeEnum.AdvertisingChannelType.UNRECOGNIZED : result;
        }
    };
    private int advertisingChannelTypesMemoizedSerializedSize;
    private byte memoizedIsInitialized = (byte)-1;
    private static final BiddingDataExclusion DEFAULT_INSTANCE = new BiddingDataExclusion();
    private static final Parser<BiddingDataExclusion> PARSER = new AbstractParser<BiddingDataExclusion>(){

        public BiddingDataExclusion parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new BiddingDataExclusion(input, extensionRegistry);
        }
    };

    private BiddingDataExclusion(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private BiddingDataExclusion() {
        this.resourceName_ = "";
        this.scope_ = 0;
        this.status_ = 0;
        this.startDateTime_ = "";
        this.endDateTime_ = "";
        this.name_ = "";
        this.description_ = "";
        this.devices_ = Collections.emptyList();
        this.campaigns_ = LazyStringArrayList.EMPTY;
        this.advertisingChannelTypes_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new BiddingDataExclusion();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private BiddingDataExclusion(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        int mutable_bitField0_ = 0;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block23: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block23;
                    }
                    case 10: {
                        String s = input.readStringRequireUtf8();
                        this.resourceName_ = s;
                        continue block23;
                    }
                    case 16: {
                        this.dataExclusionId_ = input.readInt64();
                        continue block23;
                    }
                    case 24: {
                        int rawValue;
                        this.scope_ = rawValue = input.readEnum();
                        continue block23;
                    }
                    case 32: {
                        int rawValue;
                        this.status_ = rawValue = input.readEnum();
                        continue block23;
                    }
                    case 42: {
                        String s = input.readStringRequireUtf8();
                        this.startDateTime_ = s;
                        continue block23;
                    }
                    case 50: {
                        String s = input.readStringRequireUtf8();
                        this.endDateTime_ = s;
                        continue block23;
                    }
                    case 58: {
                        String s = input.readStringRequireUtf8();
                        this.name_ = s;
                        continue block23;
                    }
                    case 66: {
                        String s = input.readStringRequireUtf8();
                        this.description_ = s;
                        continue block23;
                    }
                    case 72: {
                        int rawValue = input.readEnum();
                        if ((mutable_bitField0_ & 1) == 0) {
                            this.devices_ = new ArrayList<Integer>();
                            mutable_bitField0_ |= 1;
                        }
                        this.devices_.add(rawValue);
                        continue block23;
                    }
                    case 74: {
                        int rawValue;
                        int length = input.readRawVarint32();
                        int oldLimit = input.pushLimit(length);
                        while (input.getBytesUntilLimit() > 0) {
                            rawValue = input.readEnum();
                            if ((mutable_bitField0_ & 1) == 0) {
                                this.devices_ = new ArrayList<Integer>();
                                mutable_bitField0_ |= 1;
                            }
                            this.devices_.add(rawValue);
                        }
                        input.popLimit(oldLimit);
                        continue block23;
                    }
                    case 82: {
                        String s = input.readStringRequireUtf8();
                        if ((mutable_bitField0_ & 2) == 0) {
                            this.campaigns_ = new LazyStringArrayList();
                            mutable_bitField0_ |= 2;
                        }
                        this.campaigns_.add((Object)s);
                        continue block23;
                    }
                    case 88: {
                        int rawValue = input.readEnum();
                        if ((mutable_bitField0_ & 4) == 0) {
                            this.advertisingChannelTypes_ = new ArrayList<Integer>();
                            mutable_bitField0_ |= 4;
                        }
                        this.advertisingChannelTypes_.add(rawValue);
                        continue block23;
                    }
                    case 90: {
                        int rawValue;
                        int length = input.readRawVarint32();
                        int oldLimit = input.pushLimit(length);
                        while (input.getBytesUntilLimit() > 0) {
                            rawValue = input.readEnum();
                            if ((mutable_bitField0_ & 4) == 0) {
                                this.advertisingChannelTypes_ = new ArrayList<Integer>();
                                mutable_bitField0_ |= 4;
                            }
                            this.advertisingChannelTypes_.add(rawValue);
                        }
                        input.popLimit(oldLimit);
                        continue block23;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            if (mutable_bitField0_ & true) {
                this.devices_ = Collections.unmodifiableList(this.devices_);
            }
            if ((mutable_bitField0_ & 2) != 0) {
                this.campaigns_ = this.campaigns_.getUnmodifiableView();
            }
            if ((mutable_bitField0_ & 4) != 0) {
                this.advertisingChannelTypes_ = Collections.unmodifiableList(this.advertisingChannelTypes_);
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return BiddingDataExclusionProto.internal_static_google_ads_googleads_v11_resources_BiddingDataExclusion_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return BiddingDataExclusionProto.internal_static_google_ads_googleads_v11_resources_BiddingDataExclusion_fieldAccessorTable.ensureFieldAccessorsInitialized(BiddingDataExclusion.class, Builder.class);
    }

    @Override
    public String getResourceName() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.resourceName_ = s;
        return s;
    }

    @Override
    public ByteString getResourceNameBytes() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.resourceName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public long getDataExclusionId() {
        return this.dataExclusionId_;
    }

    @Override
    public int getScopeValue() {
        return this.scope_;
    }

    @Override
    public SeasonalityEventScopeEnum.SeasonalityEventScope getScope() {
        SeasonalityEventScopeEnum.SeasonalityEventScope result = SeasonalityEventScopeEnum.SeasonalityEventScope.valueOf(this.scope_);
        return result == null ? SeasonalityEventScopeEnum.SeasonalityEventScope.UNRECOGNIZED : result;
    }

    @Override
    public int getStatusValue() {
        return this.status_;
    }

    @Override
    public SeasonalityEventStatusEnum.SeasonalityEventStatus getStatus() {
        SeasonalityEventStatusEnum.SeasonalityEventStatus result = SeasonalityEventStatusEnum.SeasonalityEventStatus.valueOf(this.status_);
        return result == null ? SeasonalityEventStatusEnum.SeasonalityEventStatus.UNRECOGNIZED : result;
    }

    @Override
    public String getStartDateTime() {
        Object ref = this.startDateTime_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.startDateTime_ = s;
        return s;
    }

    @Override
    public ByteString getStartDateTimeBytes() {
        Object ref = this.startDateTime_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.startDateTime_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getEndDateTime() {
        Object ref = this.endDateTime_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.endDateTime_ = s;
        return s;
    }

    @Override
    public ByteString getEndDateTimeBytes() {
        Object ref = this.endDateTime_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.endDateTime_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getDescription() {
        Object ref = this.description_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.description_ = s;
        return s;
    }

    @Override
    public ByteString getDescriptionBytes() {
        Object ref = this.description_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.description_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<DeviceEnum.Device> getDevicesList() {
        return new Internal.ListAdapter(this.devices_, devices_converter_);
    }

    @Override
    public int getDevicesCount() {
        return this.devices_.size();
    }

    @Override
    public DeviceEnum.Device getDevices(int index) {
        return (DeviceEnum.Device)((Object)devices_converter_.convert((Object)this.devices_.get(index)));
    }

    @Override
    public List<Integer> getDevicesValueList() {
        return this.devices_;
    }

    @Override
    public int getDevicesValue(int index) {
        return this.devices_.get(index);
    }

    public ProtocolStringList getCampaignsList() {
        return this.campaigns_;
    }

    @Override
    public int getCampaignsCount() {
        return this.campaigns_.size();
    }

    @Override
    public String getCampaigns(int index) {
        return (String)this.campaigns_.get(index);
    }

    @Override
    public ByteString getCampaignsBytes(int index) {
        return this.campaigns_.getByteString(index);
    }

    @Override
    public List<AdvertisingChannelTypeEnum.AdvertisingChannelType> getAdvertisingChannelTypesList() {
        return new Internal.ListAdapter(this.advertisingChannelTypes_, advertisingChannelTypes_converter_);
    }

    @Override
    public int getAdvertisingChannelTypesCount() {
        return this.advertisingChannelTypes_.size();
    }

    @Override
    public AdvertisingChannelTypeEnum.AdvertisingChannelType getAdvertisingChannelTypes(int index) {
        return (AdvertisingChannelTypeEnum.AdvertisingChannelType)((Object)advertisingChannelTypes_converter_.convert((Object)this.advertisingChannelTypes_.get(index)));
    }

    @Override
    public List<Integer> getAdvertisingChannelTypesValueList() {
        return this.advertisingChannelTypes_;
    }

    @Override
    public int getAdvertisingChannelTypesValue(int index) {
        return this.advertisingChannelTypes_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.resourceName_);
        }
        if (this.dataExclusionId_ != 0L) {
            output.writeInt64(2, this.dataExclusionId_);
        }
        if (this.scope_ != SeasonalityEventScopeEnum.SeasonalityEventScope.UNSPECIFIED.getNumber()) {
            output.writeEnum(3, this.scope_);
        }
        if (this.status_ != SeasonalityEventStatusEnum.SeasonalityEventStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(4, this.status_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.startDateTime_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.startDateTime_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.endDateTime_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.endDateTime_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)7, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.description_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)8, (Object)this.description_);
        }
        if (this.getDevicesList().size() > 0) {
            output.writeUInt32NoTag(74);
            output.writeUInt32NoTag(this.devicesMemoizedSerializedSize);
        }
        for (i = 0; i < this.devices_.size(); ++i) {
            output.writeEnumNoTag(this.devices_.get(i).intValue());
        }
        for (i = 0; i < this.campaigns_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)10, (Object)this.campaigns_.getRaw(i));
        }
        if (this.getAdvertisingChannelTypesList().size() > 0) {
            output.writeUInt32NoTag(90);
            output.writeUInt32NoTag(this.advertisingChannelTypesMemoizedSerializedSize);
        }
        for (i = 0; i < this.advertisingChannelTypes_.size(); ++i) {
            output.writeEnumNoTag(this.advertisingChannelTypes_.get(i).intValue());
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.resourceName_);
        }
        if (this.dataExclusionId_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)2, (long)this.dataExclusionId_);
        }
        if (this.scope_ != SeasonalityEventScopeEnum.SeasonalityEventScope.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.scope_);
        }
        if (this.status_ != SeasonalityEventStatusEnum.SeasonalityEventStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)4, (int)this.status_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.startDateTime_)) {
            size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.startDateTime_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.endDateTime_)) {
            size += GeneratedMessageV3.computeStringSize((int)6, (Object)this.endDateTime_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)7, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.description_)) {
            size += GeneratedMessageV3.computeStringSize((int)8, (Object)this.description_);
        }
        int dataSize = 0;
        for (i = 0; i < this.devices_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.devices_.get(i));
        }
        size += dataSize;
        if (!this.getDevicesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.devicesMemoizedSerializedSize = dataSize;
        dataSize = 0;
        for (i = 0; i < this.campaigns_.size(); ++i) {
            dataSize += BiddingDataExclusion.computeStringSizeNoTag((Object)this.campaigns_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getCampaignsList().size();
        dataSize = 0;
        for (i = 0; i < this.advertisingChannelTypes_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.advertisingChannelTypes_.get(i));
        }
        size += dataSize;
        if (!this.getAdvertisingChannelTypesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.advertisingChannelTypesMemoizedSerializedSize = dataSize;
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BiddingDataExclusion)) {
            return super.equals(obj);
        }
        BiddingDataExclusion other = (BiddingDataExclusion)obj;
        if (!this.getResourceName().equals(other.getResourceName())) {
            return false;
        }
        if (this.getDataExclusionId() != other.getDataExclusionId()) {
            return false;
        }
        if (this.scope_ != other.scope_) {
            return false;
        }
        if (this.status_ != other.status_) {
            return false;
        }
        if (!this.getStartDateTime().equals(other.getStartDateTime())) {
            return false;
        }
        if (!this.getEndDateTime().equals(other.getEndDateTime())) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getDescription().equals(other.getDescription())) {
            return false;
        }
        if (!this.devices_.equals(other.devices_)) {
            return false;
        }
        if (!this.getCampaignsList().equals(other.getCampaignsList())) {
            return false;
        }
        if (!this.advertisingChannelTypes_.equals(other.advertisingChannelTypes_)) {
            return false;
        }
        return this.unknownFields.equals((Object)other.unknownFields);
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + BiddingDataExclusion.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getResourceName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + Internal.hashLong((long)this.getDataExclusionId());
        hash = 37 * hash + 3;
        hash = 53 * hash + this.scope_;
        hash = 37 * hash + 4;
        hash = 53 * hash + this.status_;
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getStartDateTime().hashCode();
        hash = 37 * hash + 6;
        hash = 53 * hash + this.getEndDateTime().hashCode();
        hash = 37 * hash + 7;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 8;
        hash = 53 * hash + this.getDescription().hashCode();
        if (this.getDevicesCount() > 0) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.devices_.hashCode();
        }
        if (this.getCampaignsCount() > 0) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getCampaignsList().hashCode();
        }
        if (this.getAdvertisingChannelTypesCount() > 0) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.advertisingChannelTypes_.hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static BiddingDataExclusion parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (BiddingDataExclusion)PARSER.parseFrom(data);
    }

    public static BiddingDataExclusion parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (BiddingDataExclusion)PARSER.parseFrom(data, extensionRegistry);
    }

    public static BiddingDataExclusion parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (BiddingDataExclusion)PARSER.parseFrom(data);
    }

    public static BiddingDataExclusion parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (BiddingDataExclusion)PARSER.parseFrom(data, extensionRegistry);
    }

    public static BiddingDataExclusion parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (BiddingDataExclusion)PARSER.parseFrom(data);
    }

    public static BiddingDataExclusion parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (BiddingDataExclusion)PARSER.parseFrom(data, extensionRegistry);
    }

    public static BiddingDataExclusion parseFrom(InputStream input) throws IOException {
        return (BiddingDataExclusion)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static BiddingDataExclusion parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (BiddingDataExclusion)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static BiddingDataExclusion parseDelimitedFrom(InputStream input) throws IOException {
        return (BiddingDataExclusion)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static BiddingDataExclusion parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (BiddingDataExclusion)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static BiddingDataExclusion parseFrom(CodedInputStream input) throws IOException {
        return (BiddingDataExclusion)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static BiddingDataExclusion parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (BiddingDataExclusion)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return BiddingDataExclusion.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(BiddingDataExclusion prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static BiddingDataExclusion getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<BiddingDataExclusion> parser() {
        return PARSER;
    }

    public Parser<BiddingDataExclusion> getParserForType() {
        return PARSER;
    }

    public BiddingDataExclusion getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements BiddingDataExclusionOrBuilder {
        private int bitField0_;
        private Object resourceName_ = "";
        private long dataExclusionId_;
        private int scope_ = 0;
        private int status_ = 0;
        private Object startDateTime_ = "";
        private Object endDateTime_ = "";
        private Object name_ = "";
        private Object description_ = "";
        private List<Integer> devices_ = Collections.emptyList();
        private LazyStringList campaigns_ = LazyStringArrayList.EMPTY;
        private List<Integer> advertisingChannelTypes_ = Collections.emptyList();

        public static final Descriptors.Descriptor getDescriptor() {
            return BiddingDataExclusionProto.internal_static_google_ads_googleads_v11_resources_BiddingDataExclusion_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return BiddingDataExclusionProto.internal_static_google_ads_googleads_v11_resources_BiddingDataExclusion_fieldAccessorTable.ensureFieldAccessorsInitialized(BiddingDataExclusion.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                // empty if block
            }
        }

        public Builder clear() {
            super.clear();
            this.resourceName_ = "";
            this.dataExclusionId_ = 0L;
            this.scope_ = 0;
            this.status_ = 0;
            this.startDateTime_ = "";
            this.endDateTime_ = "";
            this.name_ = "";
            this.description_ = "";
            this.devices_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFE;
            this.campaigns_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFD;
            this.advertisingChannelTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFB;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return BiddingDataExclusionProto.internal_static_google_ads_googleads_v11_resources_BiddingDataExclusion_descriptor;
        }

        public BiddingDataExclusion getDefaultInstanceForType() {
            return BiddingDataExclusion.getDefaultInstance();
        }

        public BiddingDataExclusion build() {
            BiddingDataExclusion result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public BiddingDataExclusion buildPartial() {
            BiddingDataExclusion result = new BiddingDataExclusion(this);
            int from_bitField0_ = this.bitField0_;
            result.resourceName_ = this.resourceName_;
            result.dataExclusionId_ = this.dataExclusionId_;
            result.scope_ = this.scope_;
            result.status_ = this.status_;
            result.startDateTime_ = this.startDateTime_;
            result.endDateTime_ = this.endDateTime_;
            result.name_ = this.name_;
            result.description_ = this.description_;
            if ((this.bitField0_ & 1) != 0) {
                this.devices_ = Collections.unmodifiableList(this.devices_);
                this.bitField0_ &= 0xFFFFFFFE;
            }
            result.devices_ = this.devices_;
            if ((this.bitField0_ & 2) != 0) {
                this.campaigns_ = this.campaigns_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFFFD;
            }
            result.campaigns_ = this.campaigns_;
            if ((this.bitField0_ & 4) != 0) {
                this.advertisingChannelTypes_ = Collections.unmodifiableList(this.advertisingChannelTypes_);
                this.bitField0_ &= 0xFFFFFFFB;
            }
            result.advertisingChannelTypes_ = this.advertisingChannelTypes_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof BiddingDataExclusion) {
                return this.mergeFrom((BiddingDataExclusion)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(BiddingDataExclusion other) {
            if (other == BiddingDataExclusion.getDefaultInstance()) {
                return this;
            }
            if (!other.getResourceName().isEmpty()) {
                this.resourceName_ = other.resourceName_;
                this.onChanged();
            }
            if (other.getDataExclusionId() != 0L) {
                this.setDataExclusionId(other.getDataExclusionId());
            }
            if (other.scope_ != 0) {
                this.setScopeValue(other.getScopeValue());
            }
            if (other.status_ != 0) {
                this.setStatusValue(other.getStatusValue());
            }
            if (!other.getStartDateTime().isEmpty()) {
                this.startDateTime_ = other.startDateTime_;
                this.onChanged();
            }
            if (!other.getEndDateTime().isEmpty()) {
                this.endDateTime_ = other.endDateTime_;
                this.onChanged();
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.onChanged();
            }
            if (!other.getDescription().isEmpty()) {
                this.description_ = other.description_;
                this.onChanged();
            }
            if (!other.devices_.isEmpty()) {
                if (this.devices_.isEmpty()) {
                    this.devices_ = other.devices_;
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.ensureDevicesIsMutable();
                    this.devices_.addAll(other.devices_);
                }
                this.onChanged();
            }
            if (!other.campaigns_.isEmpty()) {
                if (this.campaigns_.isEmpty()) {
                    this.campaigns_ = other.campaigns_;
                    this.bitField0_ &= 0xFFFFFFFD;
                } else {
                    this.ensureCampaignsIsMutable();
                    this.campaigns_.addAll((Collection)other.campaigns_);
                }
                this.onChanged();
            }
            if (!other.advertisingChannelTypes_.isEmpty()) {
                if (this.advertisingChannelTypes_.isEmpty()) {
                    this.advertisingChannelTypes_ = other.advertisingChannelTypes_;
                    this.bitField0_ &= 0xFFFFFFFB;
                } else {
                    this.ensureAdvertisingChannelTypesIsMutable();
                    this.advertisingChannelTypes_.addAll(other.advertisingChannelTypes_);
                }
                this.onChanged();
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            BiddingDataExclusion parsedMessage = null;
            try {
                parsedMessage = (BiddingDataExclusion)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (BiddingDataExclusion)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public String getResourceName() {
            Object ref = this.resourceName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.resourceName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getResourceNameBytes() {
            Object ref = this.resourceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.resourceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setResourceName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.resourceName_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearResourceName() {
            this.resourceName_ = BiddingDataExclusion.getDefaultInstance().getResourceName();
            this.onChanged();
            return this;
        }

        public Builder setResourceNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            BiddingDataExclusion.checkByteStringIsUtf8((ByteString)value);
            this.resourceName_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public long getDataExclusionId() {
            return this.dataExclusionId_;
        }

        public Builder setDataExclusionId(long value) {
            this.dataExclusionId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearDataExclusionId() {
            this.dataExclusionId_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public int getScopeValue() {
            return this.scope_;
        }

        public Builder setScopeValue(int value) {
            this.scope_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public SeasonalityEventScopeEnum.SeasonalityEventScope getScope() {
            SeasonalityEventScopeEnum.SeasonalityEventScope result = SeasonalityEventScopeEnum.SeasonalityEventScope.valueOf(this.scope_);
            return result == null ? SeasonalityEventScopeEnum.SeasonalityEventScope.UNRECOGNIZED : result;
        }

        public Builder setScope(SeasonalityEventScopeEnum.SeasonalityEventScope value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.scope_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearScope() {
            this.scope_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getStatusValue() {
            return this.status_;
        }

        public Builder setStatusValue(int value) {
            this.status_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public SeasonalityEventStatusEnum.SeasonalityEventStatus getStatus() {
            SeasonalityEventStatusEnum.SeasonalityEventStatus result = SeasonalityEventStatusEnum.SeasonalityEventStatus.valueOf(this.status_);
            return result == null ? SeasonalityEventStatusEnum.SeasonalityEventStatus.UNRECOGNIZED : result;
        }

        public Builder setStatus(SeasonalityEventStatusEnum.SeasonalityEventStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.status_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStatus() {
            this.status_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getStartDateTime() {
            Object ref = this.startDateTime_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.startDateTime_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getStartDateTimeBytes() {
            Object ref = this.startDateTime_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.startDateTime_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setStartDateTime(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.startDateTime_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearStartDateTime() {
            this.startDateTime_ = BiddingDataExclusion.getDefaultInstance().getStartDateTime();
            this.onChanged();
            return this;
        }

        public Builder setStartDateTimeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            BiddingDataExclusion.checkByteStringIsUtf8((ByteString)value);
            this.startDateTime_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getEndDateTime() {
            Object ref = this.endDateTime_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.endDateTime_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getEndDateTimeBytes() {
            Object ref = this.endDateTime_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.endDateTime_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setEndDateTime(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.endDateTime_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearEndDateTime() {
            this.endDateTime_ = BiddingDataExclusion.getDefaultInstance().getEndDateTime();
            this.onChanged();
            return this;
        }

        public Builder setEndDateTimeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            BiddingDataExclusion.checkByteStringIsUtf8((ByteString)value);
            this.endDateTime_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = BiddingDataExclusion.getDefaultInstance().getName();
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            BiddingDataExclusion.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getDescription() {
            Object ref = this.description_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.description_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDescriptionBytes() {
            Object ref = this.description_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.description_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDescription(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.description_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearDescription() {
            this.description_ = BiddingDataExclusion.getDefaultInstance().getDescription();
            this.onChanged();
            return this;
        }

        public Builder setDescriptionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            BiddingDataExclusion.checkByteStringIsUtf8((ByteString)value);
            this.description_ = value;
            this.onChanged();
            return this;
        }

        private void ensureDevicesIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.devices_ = new ArrayList<Integer>(this.devices_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<DeviceEnum.Device> getDevicesList() {
            return new Internal.ListAdapter(this.devices_, devices_converter_);
        }

        @Override
        public int getDevicesCount() {
            return this.devices_.size();
        }

        @Override
        public DeviceEnum.Device getDevices(int index) {
            return (DeviceEnum.Device)((Object)devices_converter_.convert((Object)this.devices_.get(index)));
        }

        public Builder setDevices(int index, DeviceEnum.Device value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureDevicesIsMutable();
            this.devices_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addDevices(DeviceEnum.Device value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureDevicesIsMutable();
            this.devices_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllDevices(Iterable<? extends DeviceEnum.Device> values) {
            this.ensureDevicesIsMutable();
            for (DeviceEnum.Device device : values) {
                this.devices_.add(device.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearDevices() {
            this.devices_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getDevicesValueList() {
            return Collections.unmodifiableList(this.devices_);
        }

        @Override
        public int getDevicesValue(int index) {
            return this.devices_.get(index);
        }

        public Builder setDevicesValue(int index, int value) {
            this.ensureDevicesIsMutable();
            this.devices_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addDevicesValue(int value) {
            this.ensureDevicesIsMutable();
            this.devices_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllDevicesValue(Iterable<Integer> values) {
            this.ensureDevicesIsMutable();
            for (int value : values) {
                this.devices_.add(value);
            }
            this.onChanged();
            return this;
        }

        private void ensureCampaignsIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.campaigns_ = new LazyStringArrayList(this.campaigns_);
                this.bitField0_ |= 2;
            }
        }

        public ProtocolStringList getCampaignsList() {
            return this.campaigns_.getUnmodifiableView();
        }

        @Override
        public int getCampaignsCount() {
            return this.campaigns_.size();
        }

        @Override
        public String getCampaigns(int index) {
            return (String)this.campaigns_.get(index);
        }

        @Override
        public ByteString getCampaignsBytes(int index) {
            return this.campaigns_.getByteString(index);
        }

        public Builder setCampaigns(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureCampaignsIsMutable();
            this.campaigns_.set(index, (Object)value);
            this.onChanged();
            return this;
        }

        public Builder addCampaigns(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureCampaignsIsMutable();
            this.campaigns_.add((Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAllCampaigns(Iterable<String> values) {
            this.ensureCampaignsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.campaigns_);
            this.onChanged();
            return this;
        }

        public Builder clearCampaigns() {
            this.campaigns_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder addCampaignsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            BiddingDataExclusion.checkByteStringIsUtf8((ByteString)value);
            this.ensureCampaignsIsMutable();
            this.campaigns_.add(value);
            this.onChanged();
            return this;
        }

        private void ensureAdvertisingChannelTypesIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.advertisingChannelTypes_ = new ArrayList<Integer>(this.advertisingChannelTypes_);
                this.bitField0_ |= 4;
            }
        }

        @Override
        public List<AdvertisingChannelTypeEnum.AdvertisingChannelType> getAdvertisingChannelTypesList() {
            return new Internal.ListAdapter(this.advertisingChannelTypes_, advertisingChannelTypes_converter_);
        }

        @Override
        public int getAdvertisingChannelTypesCount() {
            return this.advertisingChannelTypes_.size();
        }

        @Override
        public AdvertisingChannelTypeEnum.AdvertisingChannelType getAdvertisingChannelTypes(int index) {
            return (AdvertisingChannelTypeEnum.AdvertisingChannelType)((Object)advertisingChannelTypes_converter_.convert((Object)this.advertisingChannelTypes_.get(index)));
        }

        public Builder setAdvertisingChannelTypes(int index, AdvertisingChannelTypeEnum.AdvertisingChannelType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAdvertisingChannelTypesIsMutable();
            this.advertisingChannelTypes_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAdvertisingChannelTypes(AdvertisingChannelTypeEnum.AdvertisingChannelType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAdvertisingChannelTypesIsMutable();
            this.advertisingChannelTypes_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllAdvertisingChannelTypes(Iterable<? extends AdvertisingChannelTypeEnum.AdvertisingChannelType> values) {
            this.ensureAdvertisingChannelTypesIsMutable();
            for (AdvertisingChannelTypeEnum.AdvertisingChannelType advertisingChannelType : values) {
                this.advertisingChannelTypes_.add(advertisingChannelType.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearAdvertisingChannelTypes() {
            this.advertisingChannelTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getAdvertisingChannelTypesValueList() {
            return Collections.unmodifiableList(this.advertisingChannelTypes_);
        }

        @Override
        public int getAdvertisingChannelTypesValue(int index) {
            return this.advertisingChannelTypes_.get(index);
        }

        public Builder setAdvertisingChannelTypesValue(int index, int value) {
            this.ensureAdvertisingChannelTypesIsMutable();
            this.advertisingChannelTypes_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addAdvertisingChannelTypesValue(int value) {
            this.ensureAdvertisingChannelTypesIsMutable();
            this.advertisingChannelTypes_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllAdvertisingChannelTypesValue(Iterable<Integer> values) {
            this.ensureAdvertisingChannelTypesIsMutable();
            for (int value : values) {
                this.advertisingChannelTypes_.add(value);
            }
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

