/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v11.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CallViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CALL_DETAIL_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/callViews/{call_detail_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String callDetailId;

    @Deprecated
    protected CallViewName() {
        this.customerId = null;
        this.callDetailId = null;
    }

    private CallViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.callDetailId = (String)Preconditions.checkNotNull((Object)builder.getCallDetailId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCallDetailId() {
        return this.callDetailId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CallViewName of(String customerId, String callDetailId) {
        return CallViewName.newBuilder().setCustomerId(customerId).setCallDetailId(callDetailId).build();
    }

    public static String format(String customerId, String callDetailId) {
        return CallViewName.newBuilder().setCustomerId(customerId).setCallDetailId(callDetailId).build().toString();
    }

    public static CallViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CALL_DETAIL_ID.validatedMatch(formattedString, "CallViewName.parse: formattedString not in valid format");
        return CallViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("call_detail_id"));
    }

    public static List<CallViewName> parseList(List<String> formattedStrings) {
        ArrayList<CallViewName> list = new ArrayList<CallViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CallViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CallViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CallViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CALL_DETAIL_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CallViewName callViewName = this;
            synchronized (callViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.callDetailId != null) {
                        fieldMapBuilder.put((Object)"call_detail_id", (Object)this.callDetailId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CALL_DETAIL_ID.instantiate(new String[]{"customer_id", this.customerId, "call_detail_id", this.callDetailId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CallViewName that = (CallViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.callDetailId, that.callDetailId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.callDetailId);
    }

    public static class Builder {
        private String customerId;
        private String callDetailId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCallDetailId() {
            return this.callDetailId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCallDetailId(String callDetailId) {
            this.callDetailId = callDetailId;
            return this;
        }

        private Builder(CallViewName callViewName) {
            this.customerId = callViewName.customerId;
            this.callDetailId = callViewName.callDetailId;
        }

        public CallViewName build() {
            return new CallViewName(this);
        }
    }
}

