/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v11.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomerName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;

    @Deprecated
    protected CustomerName() {
        this.customerId = null;
    }

    private CustomerName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomerName of(String customerId) {
        return CustomerName.newBuilder().setCustomerId(customerId).build();
    }

    public static String format(String customerId) {
        return CustomerName.newBuilder().setCustomerId(customerId).build().toString();
    }

    public static CustomerName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID.validatedMatch(formattedString, "CustomerName.parse: formattedString not in valid format");
        return CustomerName.of((String)matchMap.get("customer_id"));
    }

    public static List<CustomerName> parseList(List<String> formattedStrings) {
        ArrayList<CustomerName> list = new ArrayList<CustomerName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomerName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomerName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomerName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomerName customerName = this;
            synchronized (customerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID.instantiate(new String[]{"customer_id", this.customerId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CustomerName that = (CustomerName)o;
            return Objects.equals(this.customerId, that.customerId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.customerId);
    }

    public static class Builder {
        private String customerId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        private Builder(CustomerName customerName) {
            this.customerId = customerName.customerId;
        }

        public CustomerName build() {
            return new CustomerName(this);
        }
    }
}

