/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v11.services;

import com.google.ads.googleads.v11.resources.CampaignDraftName;
import com.google.ads.googleads.v11.services.CampaignDraftOperation;
import com.google.ads.googleads.v11.services.CampaignDraftServiceSettings;
import com.google.ads.googleads.v11.services.ListCampaignDraftAsyncErrorsRequest;
import com.google.ads.googleads.v11.services.ListCampaignDraftAsyncErrorsResponse;
import com.google.ads.googleads.v11.services.MutateCampaignDraftsRequest;
import com.google.ads.googleads.v11.services.MutateCampaignDraftsResponse;
import com.google.ads.googleads.v11.services.PromoteCampaignDraftRequest;
import com.google.ads.googleads.v11.services.stub.CampaignDraftServiceStub;
import com.google.ads.googleads.v11.services.stub.CampaignDraftServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.rpc.Status;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CampaignDraftServiceClient
implements BackgroundResource {
    private final CampaignDraftServiceSettings settings;
    private final CampaignDraftServiceStub stub;
    private final OperationsClient operationsClient;

    public static final CampaignDraftServiceClient create() throws IOException {
        return CampaignDraftServiceClient.create(CampaignDraftServiceSettings.newBuilder().build());
    }

    public static final CampaignDraftServiceClient create(CampaignDraftServiceSettings settings) throws IOException {
        return new CampaignDraftServiceClient(settings);
    }

    public static final CampaignDraftServiceClient create(CampaignDraftServiceStub stub) {
        return new CampaignDraftServiceClient(stub);
    }

    protected CampaignDraftServiceClient(CampaignDraftServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CampaignDraftServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected CampaignDraftServiceClient(CampaignDraftServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final CampaignDraftServiceSettings getSettings() {
        return this.settings;
    }

    public CampaignDraftServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final MutateCampaignDraftsResponse mutateCampaignDrafts(String customerId, List<CampaignDraftOperation> operations) {
        MutateCampaignDraftsRequest request = MutateCampaignDraftsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateCampaignDrafts(request);
    }

    public final MutateCampaignDraftsResponse mutateCampaignDrafts(MutateCampaignDraftsRequest request) {
        return (MutateCampaignDraftsResponse)this.mutateCampaignDraftsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCampaignDraftsRequest, MutateCampaignDraftsResponse> mutateCampaignDraftsCallable() {
        return this.stub.mutateCampaignDraftsCallable();
    }

    public final OperationFuture<Empty, Empty> promoteCampaignDraftAsync(CampaignDraftName campaignDraft) {
        PromoteCampaignDraftRequest request = PromoteCampaignDraftRequest.newBuilder().setCampaignDraft(campaignDraft == null ? null : campaignDraft.toString()).build();
        return this.promoteCampaignDraftAsync(request);
    }

    public final OperationFuture<Empty, Empty> promoteCampaignDraftAsync(String campaignDraft) {
        PromoteCampaignDraftRequest request = PromoteCampaignDraftRequest.newBuilder().setCampaignDraft(campaignDraft).build();
        return this.promoteCampaignDraftAsync(request);
    }

    public final OperationFuture<Empty, Empty> promoteCampaignDraftAsync(PromoteCampaignDraftRequest request) {
        return this.promoteCampaignDraftOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PromoteCampaignDraftRequest, Empty, Empty> promoteCampaignDraftOperationCallable() {
        return this.stub.promoteCampaignDraftOperationCallable();
    }

    public final UnaryCallable<PromoteCampaignDraftRequest, Operation> promoteCampaignDraftCallable() {
        return this.stub.promoteCampaignDraftCallable();
    }

    public final ListCampaignDraftAsyncErrorsPagedResponse listCampaignDraftAsyncErrors(CampaignDraftName resourceName) {
        ListCampaignDraftAsyncErrorsRequest request = ListCampaignDraftAsyncErrorsRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.listCampaignDraftAsyncErrors(request);
    }

    public final ListCampaignDraftAsyncErrorsPagedResponse listCampaignDraftAsyncErrors(String resourceName) {
        ListCampaignDraftAsyncErrorsRequest request = ListCampaignDraftAsyncErrorsRequest.newBuilder().setResourceName(resourceName).build();
        return this.listCampaignDraftAsyncErrors(request);
    }

    public final ListCampaignDraftAsyncErrorsPagedResponse listCampaignDraftAsyncErrors(ListCampaignDraftAsyncErrorsRequest request) {
        return (ListCampaignDraftAsyncErrorsPagedResponse)((Object)this.listCampaignDraftAsyncErrorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCampaignDraftAsyncErrorsRequest, ListCampaignDraftAsyncErrorsPagedResponse> listCampaignDraftAsyncErrorsPagedCallable() {
        return this.stub.listCampaignDraftAsyncErrorsPagedCallable();
    }

    public final UnaryCallable<ListCampaignDraftAsyncErrorsRequest, ListCampaignDraftAsyncErrorsResponse> listCampaignDraftAsyncErrorsCallable() {
        return this.stub.listCampaignDraftAsyncErrorsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListCampaignDraftAsyncErrorsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCampaignDraftAsyncErrorsRequest, ListCampaignDraftAsyncErrorsResponse, Status, ListCampaignDraftAsyncErrorsPage, ListCampaignDraftAsyncErrorsFixedSizeCollection> {
        private ListCampaignDraftAsyncErrorsFixedSizeCollection(List<ListCampaignDraftAsyncErrorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCampaignDraftAsyncErrorsFixedSizeCollection createEmptyCollection() {
            return new ListCampaignDraftAsyncErrorsFixedSizeCollection(null, 0);
        }

        protected ListCampaignDraftAsyncErrorsFixedSizeCollection createCollection(List<ListCampaignDraftAsyncErrorsPage> pages, int collectionSize) {
            return new ListCampaignDraftAsyncErrorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCampaignDraftAsyncErrorsPage
    extends AbstractPage<ListCampaignDraftAsyncErrorsRequest, ListCampaignDraftAsyncErrorsResponse, Status, ListCampaignDraftAsyncErrorsPage> {
        private ListCampaignDraftAsyncErrorsPage(PageContext<ListCampaignDraftAsyncErrorsRequest, ListCampaignDraftAsyncErrorsResponse, Status> context, ListCampaignDraftAsyncErrorsResponse response) {
            super(context, (Object)response);
        }

        private static ListCampaignDraftAsyncErrorsPage createEmptyPage() {
            return new ListCampaignDraftAsyncErrorsPage(null, null);
        }

        protected ListCampaignDraftAsyncErrorsPage createPage(PageContext<ListCampaignDraftAsyncErrorsRequest, ListCampaignDraftAsyncErrorsResponse, Status> context, ListCampaignDraftAsyncErrorsResponse response) {
            return new ListCampaignDraftAsyncErrorsPage(context, response);
        }

        public ApiFuture<ListCampaignDraftAsyncErrorsPage> createPageAsync(PageContext<ListCampaignDraftAsyncErrorsRequest, ListCampaignDraftAsyncErrorsResponse, Status> context, ApiFuture<ListCampaignDraftAsyncErrorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCampaignDraftAsyncErrorsPagedResponse
    extends AbstractPagedListResponse<ListCampaignDraftAsyncErrorsRequest, ListCampaignDraftAsyncErrorsResponse, Status, ListCampaignDraftAsyncErrorsPage, ListCampaignDraftAsyncErrorsFixedSizeCollection> {
        public static ApiFuture<ListCampaignDraftAsyncErrorsPagedResponse> createAsync(PageContext<ListCampaignDraftAsyncErrorsRequest, ListCampaignDraftAsyncErrorsResponse, Status> context, ApiFuture<ListCampaignDraftAsyncErrorsResponse> futureResponse) {
            ApiFuture<ListCampaignDraftAsyncErrorsPage> futurePage = ListCampaignDraftAsyncErrorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCampaignDraftAsyncErrorsPagedResponse((ListCampaignDraftAsyncErrorsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCampaignDraftAsyncErrorsPagedResponse(ListCampaignDraftAsyncErrorsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCampaignDraftAsyncErrorsFixedSizeCollection.createEmptyCollection());
        }
    }
}

