/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v11.services;

import com.google.ads.googleads.v11.enums.ResponseContentTypeEnum;
import com.google.ads.googleads.v11.services.AssetSetOperation;
import com.google.ads.googleads.v11.services.AssetSetOperationOrBuilder;
import com.google.ads.googleads.v11.services.AssetSetServiceProto;
import com.google.ads.googleads.v11.services.MutateAssetSetsRequestOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MutateAssetSetsRequest
extends GeneratedMessageV3
implements MutateAssetSetsRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int CUSTOMER_ID_FIELD_NUMBER = 1;
    private volatile Object customerId_;
    public static final int OPERATIONS_FIELD_NUMBER = 2;
    private List<AssetSetOperation> operations_;
    public static final int PARTIAL_FAILURE_FIELD_NUMBER = 3;
    private boolean partialFailure_;
    public static final int VALIDATE_ONLY_FIELD_NUMBER = 4;
    private boolean validateOnly_;
    public static final int RESPONSE_CONTENT_TYPE_FIELD_NUMBER = 5;
    private int responseContentType_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final MutateAssetSetsRequest DEFAULT_INSTANCE = new MutateAssetSetsRequest();
    private static final Parser<MutateAssetSetsRequest> PARSER = new AbstractParser<MutateAssetSetsRequest>(){

        public MutateAssetSetsRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new MutateAssetSetsRequest(input, extensionRegistry);
        }
    };

    private MutateAssetSetsRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private MutateAssetSetsRequest() {
        this.customerId_ = "";
        this.operations_ = Collections.emptyList();
        this.responseContentType_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new MutateAssetSetsRequest();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private MutateAssetSetsRequest(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        boolean mutable_bitField0_ = false;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block15: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block15;
                    }
                    case 10: {
                        String s = input.readStringRequireUtf8();
                        this.customerId_ = s;
                        continue block15;
                    }
                    case 18: {
                        if (!(mutable_bitField0_ & true)) {
                            this.operations_ = new ArrayList<AssetSetOperation>();
                            mutable_bitField0_ |= true;
                        }
                        this.operations_.add((AssetSetOperation)input.readMessage(AssetSetOperation.parser(), extensionRegistry));
                        continue block15;
                    }
                    case 24: {
                        this.partialFailure_ = input.readBool();
                        continue block15;
                    }
                    case 32: {
                        this.validateOnly_ = input.readBool();
                        continue block15;
                    }
                    case 40: {
                        int rawValue;
                        this.responseContentType_ = rawValue = input.readEnum();
                        continue block15;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            if (mutable_bitField0_ & true) {
                this.operations_ = Collections.unmodifiableList(this.operations_);
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return AssetSetServiceProto.internal_static_google_ads_googleads_v11_services_MutateAssetSetsRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return AssetSetServiceProto.internal_static_google_ads_googleads_v11_services_MutateAssetSetsRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(MutateAssetSetsRequest.class, Builder.class);
    }

    @Override
    public String getCustomerId() {
        Object ref = this.customerId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.customerId_ = s;
        return s;
    }

    @Override
    public ByteString getCustomerIdBytes() {
        Object ref = this.customerId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.customerId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<AssetSetOperation> getOperationsList() {
        return this.operations_;
    }

    @Override
    public List<? extends AssetSetOperationOrBuilder> getOperationsOrBuilderList() {
        return this.operations_;
    }

    @Override
    public int getOperationsCount() {
        return this.operations_.size();
    }

    @Override
    public AssetSetOperation getOperations(int index) {
        return this.operations_.get(index);
    }

    @Override
    public AssetSetOperationOrBuilder getOperationsOrBuilder(int index) {
        return this.operations_.get(index);
    }

    @Override
    public boolean getPartialFailure() {
        return this.partialFailure_;
    }

    @Override
    public boolean getValidateOnly() {
        return this.validateOnly_;
    }

    @Override
    public int getResponseContentTypeValue() {
        return this.responseContentType_;
    }

    @Override
    public ResponseContentTypeEnum.ResponseContentType getResponseContentType() {
        ResponseContentTypeEnum.ResponseContentType result = ResponseContentTypeEnum.ResponseContentType.valueOf(this.responseContentType_);
        return result == null ? ResponseContentTypeEnum.ResponseContentType.UNRECOGNIZED : result;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.customerId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.customerId_);
        }
        for (int i = 0; i < this.operations_.size(); ++i) {
            output.writeMessage(2, (MessageLite)this.operations_.get(i));
        }
        if (this.partialFailure_) {
            output.writeBool(3, this.partialFailure_);
        }
        if (this.validateOnly_) {
            output.writeBool(4, this.validateOnly_);
        }
        if (this.responseContentType_ != ResponseContentTypeEnum.ResponseContentType.UNSPECIFIED.getNumber()) {
            output.writeEnum(5, this.responseContentType_);
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.customerId_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.customerId_);
        }
        for (int i = 0; i < this.operations_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)((MessageLite)this.operations_.get(i)));
        }
        if (this.partialFailure_) {
            size += CodedOutputStream.computeBoolSize((int)3, (boolean)this.partialFailure_);
        }
        if (this.validateOnly_) {
            size += CodedOutputStream.computeBoolSize((int)4, (boolean)this.validateOnly_);
        }
        if (this.responseContentType_ != ResponseContentTypeEnum.ResponseContentType.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.responseContentType_);
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MutateAssetSetsRequest)) {
            return super.equals(obj);
        }
        MutateAssetSetsRequest other = (MutateAssetSetsRequest)obj;
        if (!this.getCustomerId().equals(other.getCustomerId())) {
            return false;
        }
        if (!this.getOperationsList().equals(other.getOperationsList())) {
            return false;
        }
        if (this.getPartialFailure() != other.getPartialFailure()) {
            return false;
        }
        if (this.getValidateOnly() != other.getValidateOnly()) {
            return false;
        }
        if (this.responseContentType_ != other.responseContentType_) {
            return false;
        }
        return this.unknownFields.equals((Object)other.unknownFields);
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + MutateAssetSetsRequest.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getCustomerId().hashCode();
        if (this.getOperationsCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getOperationsList().hashCode();
        }
        hash = 37 * hash + 3;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getPartialFailure());
        hash = 37 * hash + 4;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getValidateOnly());
        hash = 37 * hash + 5;
        hash = 53 * hash + this.responseContentType_;
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static MutateAssetSetsRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (MutateAssetSetsRequest)PARSER.parseFrom(data);
    }

    public static MutateAssetSetsRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (MutateAssetSetsRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static MutateAssetSetsRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (MutateAssetSetsRequest)PARSER.parseFrom(data);
    }

    public static MutateAssetSetsRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (MutateAssetSetsRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static MutateAssetSetsRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (MutateAssetSetsRequest)PARSER.parseFrom(data);
    }

    public static MutateAssetSetsRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (MutateAssetSetsRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static MutateAssetSetsRequest parseFrom(InputStream input) throws IOException {
        return (MutateAssetSetsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static MutateAssetSetsRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (MutateAssetSetsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static MutateAssetSetsRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (MutateAssetSetsRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static MutateAssetSetsRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (MutateAssetSetsRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static MutateAssetSetsRequest parseFrom(CodedInputStream input) throws IOException {
        return (MutateAssetSetsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static MutateAssetSetsRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (MutateAssetSetsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return MutateAssetSetsRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(MutateAssetSetsRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static MutateAssetSetsRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<MutateAssetSetsRequest> parser() {
        return PARSER;
    }

    public Parser<MutateAssetSetsRequest> getParserForType() {
        return PARSER;
    }

    public MutateAssetSetsRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements MutateAssetSetsRequestOrBuilder {
        private int bitField0_;
        private Object customerId_ = "";
        private List<AssetSetOperation> operations_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<AssetSetOperation, AssetSetOperation.Builder, AssetSetOperationOrBuilder> operationsBuilder_;
        private boolean partialFailure_;
        private boolean validateOnly_;
        private int responseContentType_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return AssetSetServiceProto.internal_static_google_ads_googleads_v11_services_MutateAssetSetsRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AssetSetServiceProto.internal_static_google_ads_googleads_v11_services_MutateAssetSetsRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(MutateAssetSetsRequest.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getOperationsFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.customerId_ = "";
            if (this.operationsBuilder_ == null) {
                this.operations_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
            } else {
                this.operationsBuilder_.clear();
            }
            this.partialFailure_ = false;
            this.validateOnly_ = false;
            this.responseContentType_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return AssetSetServiceProto.internal_static_google_ads_googleads_v11_services_MutateAssetSetsRequest_descriptor;
        }

        public MutateAssetSetsRequest getDefaultInstanceForType() {
            return MutateAssetSetsRequest.getDefaultInstance();
        }

        public MutateAssetSetsRequest build() {
            MutateAssetSetsRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public MutateAssetSetsRequest buildPartial() {
            MutateAssetSetsRequest result = new MutateAssetSetsRequest(this);
            int from_bitField0_ = this.bitField0_;
            result.customerId_ = this.customerId_;
            if (this.operationsBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0) {
                    this.operations_ = Collections.unmodifiableList(this.operations_);
                    this.bitField0_ &= 0xFFFFFFFE;
                }
                result.operations_ = this.operations_;
            } else {
                result.operations_ = this.operationsBuilder_.build();
            }
            result.partialFailure_ = this.partialFailure_;
            result.validateOnly_ = this.validateOnly_;
            result.responseContentType_ = this.responseContentType_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof MutateAssetSetsRequest) {
                return this.mergeFrom((MutateAssetSetsRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(MutateAssetSetsRequest other) {
            if (other == MutateAssetSetsRequest.getDefaultInstance()) {
                return this;
            }
            if (!other.getCustomerId().isEmpty()) {
                this.customerId_ = other.customerId_;
                this.onChanged();
            }
            if (this.operationsBuilder_ == null) {
                if (!other.operations_.isEmpty()) {
                    if (this.operations_.isEmpty()) {
                        this.operations_ = other.operations_;
                        this.bitField0_ &= 0xFFFFFFFE;
                    } else {
                        this.ensureOperationsIsMutable();
                        this.operations_.addAll(other.operations_);
                    }
                    this.onChanged();
                }
            } else if (!other.operations_.isEmpty()) {
                if (this.operationsBuilder_.isEmpty()) {
                    this.operationsBuilder_.dispose();
                    this.operationsBuilder_ = null;
                    this.operations_ = other.operations_;
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.operationsBuilder_ = alwaysUseFieldBuilders ? this.getOperationsFieldBuilder() : null;
                } else {
                    this.operationsBuilder_.addAllMessages((Iterable)other.operations_);
                }
            }
            if (other.getPartialFailure()) {
                this.setPartialFailure(other.getPartialFailure());
            }
            if (other.getValidateOnly()) {
                this.setValidateOnly(other.getValidateOnly());
            }
            if (other.responseContentType_ != 0) {
                this.setResponseContentTypeValue(other.getResponseContentTypeValue());
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            MutateAssetSetsRequest parsedMessage = null;
            try {
                parsedMessage = (MutateAssetSetsRequest)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (MutateAssetSetsRequest)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public String getCustomerId() {
            Object ref = this.customerId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.customerId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCustomerIdBytes() {
            Object ref = this.customerId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.customerId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCustomerId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.customerId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearCustomerId() {
            this.customerId_ = MutateAssetSetsRequest.getDefaultInstance().getCustomerId();
            this.onChanged();
            return this;
        }

        public Builder setCustomerIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            MutateAssetSetsRequest.checkByteStringIsUtf8((ByteString)value);
            this.customerId_ = value;
            this.onChanged();
            return this;
        }

        private void ensureOperationsIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.operations_ = new ArrayList<AssetSetOperation>(this.operations_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<AssetSetOperation> getOperationsList() {
            if (this.operationsBuilder_ == null) {
                return Collections.unmodifiableList(this.operations_);
            }
            return this.operationsBuilder_.getMessageList();
        }

        @Override
        public int getOperationsCount() {
            if (this.operationsBuilder_ == null) {
                return this.operations_.size();
            }
            return this.operationsBuilder_.getCount();
        }

        @Override
        public AssetSetOperation getOperations(int index) {
            if (this.operationsBuilder_ == null) {
                return this.operations_.get(index);
            }
            return (AssetSetOperation)this.operationsBuilder_.getMessage(index);
        }

        public Builder setOperations(int index, AssetSetOperation value) {
            if (this.operationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureOperationsIsMutable();
                this.operations_.set(index, value);
                this.onChanged();
            } else {
                this.operationsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setOperations(int index, AssetSetOperation.Builder builderForValue) {
            if (this.operationsBuilder_ == null) {
                this.ensureOperationsIsMutable();
                this.operations_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.operationsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addOperations(AssetSetOperation value) {
            if (this.operationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureOperationsIsMutable();
                this.operations_.add(value);
                this.onChanged();
            } else {
                this.operationsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addOperations(int index, AssetSetOperation value) {
            if (this.operationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureOperationsIsMutable();
                this.operations_.add(index, value);
                this.onChanged();
            } else {
                this.operationsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addOperations(AssetSetOperation.Builder builderForValue) {
            if (this.operationsBuilder_ == null) {
                this.ensureOperationsIsMutable();
                this.operations_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.operationsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addOperations(int index, AssetSetOperation.Builder builderForValue) {
            if (this.operationsBuilder_ == null) {
                this.ensureOperationsIsMutable();
                this.operations_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.operationsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllOperations(Iterable<? extends AssetSetOperation> values) {
            if (this.operationsBuilder_ == null) {
                this.ensureOperationsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.operations_);
                this.onChanged();
            } else {
                this.operationsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearOperations() {
            if (this.operationsBuilder_ == null) {
                this.operations_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
            } else {
                this.operationsBuilder_.clear();
            }
            return this;
        }

        public Builder removeOperations(int index) {
            if (this.operationsBuilder_ == null) {
                this.ensureOperationsIsMutable();
                this.operations_.remove(index);
                this.onChanged();
            } else {
                this.operationsBuilder_.remove(index);
            }
            return this;
        }

        public AssetSetOperation.Builder getOperationsBuilder(int index) {
            return (AssetSetOperation.Builder)this.getOperationsFieldBuilder().getBuilder(index);
        }

        @Override
        public AssetSetOperationOrBuilder getOperationsOrBuilder(int index) {
            if (this.operationsBuilder_ == null) {
                return this.operations_.get(index);
            }
            return (AssetSetOperationOrBuilder)this.operationsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends AssetSetOperationOrBuilder> getOperationsOrBuilderList() {
            if (this.operationsBuilder_ != null) {
                return this.operationsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.operations_);
        }

        public AssetSetOperation.Builder addOperationsBuilder() {
            return (AssetSetOperation.Builder)this.getOperationsFieldBuilder().addBuilder((AbstractMessage)AssetSetOperation.getDefaultInstance());
        }

        public AssetSetOperation.Builder addOperationsBuilder(int index) {
            return (AssetSetOperation.Builder)this.getOperationsFieldBuilder().addBuilder(index, (AbstractMessage)AssetSetOperation.getDefaultInstance());
        }

        public List<AssetSetOperation.Builder> getOperationsBuilderList() {
            return this.getOperationsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<AssetSetOperation, AssetSetOperation.Builder, AssetSetOperationOrBuilder> getOperationsFieldBuilder() {
            if (this.operationsBuilder_ == null) {
                this.operationsBuilder_ = new RepeatedFieldBuilderV3(this.operations_, (this.bitField0_ & 1) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.operations_ = null;
            }
            return this.operationsBuilder_;
        }

        @Override
        public boolean getPartialFailure() {
            return this.partialFailure_;
        }

        public Builder setPartialFailure(boolean value) {
            this.partialFailure_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearPartialFailure() {
            this.partialFailure_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getValidateOnly() {
            return this.validateOnly_;
        }

        public Builder setValidateOnly(boolean value) {
            this.validateOnly_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearValidateOnly() {
            this.validateOnly_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public int getResponseContentTypeValue() {
            return this.responseContentType_;
        }

        public Builder setResponseContentTypeValue(int value) {
            this.responseContentType_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public ResponseContentTypeEnum.ResponseContentType getResponseContentType() {
            ResponseContentTypeEnum.ResponseContentType result = ResponseContentTypeEnum.ResponseContentType.valueOf(this.responseContentType_);
            return result == null ? ResponseContentTypeEnum.ResponseContentType.UNRECOGNIZED : result;
        }

        public Builder setResponseContentType(ResponseContentTypeEnum.ResponseContentType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.responseContentType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearResponseContentType() {
            this.responseContentType_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

