/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v11.services.stub;

import com.google.ads.googleads.v11.services.CampaignExperimentServiceClient;
import com.google.ads.googleads.v11.services.CreateCampaignExperimentMetadata;
import com.google.ads.googleads.v11.services.CreateCampaignExperimentRequest;
import com.google.ads.googleads.v11.services.EndCampaignExperimentRequest;
import com.google.ads.googleads.v11.services.GraduateCampaignExperimentRequest;
import com.google.ads.googleads.v11.services.GraduateCampaignExperimentResponse;
import com.google.ads.googleads.v11.services.ListCampaignExperimentAsyncErrorsRequest;
import com.google.ads.googleads.v11.services.ListCampaignExperimentAsyncErrorsResponse;
import com.google.ads.googleads.v11.services.MutateCampaignExperimentsRequest;
import com.google.ads.googleads.v11.services.MutateCampaignExperimentsResponse;
import com.google.ads.googleads.v11.services.PromoteCampaignExperimentRequest;
import com.google.ads.googleads.v11.services.stub.CampaignExperimentServiceStub;
import com.google.ads.googleads.v11.services.stub.CampaignExperimentServiceStubSettings;
import com.google.ads.googleads.v11.services.stub.GrpcCampaignExperimentServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcCampaignExperimentServiceStub
extends CampaignExperimentServiceStub {
    private static final MethodDescriptor<CreateCampaignExperimentRequest, Operation> createCampaignExperimentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v11.services.CampaignExperimentService/CreateCampaignExperiment").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateCampaignExperimentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateCampaignExperimentsRequest, MutateCampaignExperimentsResponse> mutateCampaignExperimentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v11.services.CampaignExperimentService/MutateCampaignExperiments").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateCampaignExperimentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateCampaignExperimentsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GraduateCampaignExperimentRequest, GraduateCampaignExperimentResponse> graduateCampaignExperimentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v11.services.CampaignExperimentService/GraduateCampaignExperiment").setRequestMarshaller(ProtoUtils.marshaller((Message)GraduateCampaignExperimentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GraduateCampaignExperimentResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<PromoteCampaignExperimentRequest, Operation> promoteCampaignExperimentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v11.services.CampaignExperimentService/PromoteCampaignExperiment").setRequestMarshaller(ProtoUtils.marshaller((Message)PromoteCampaignExperimentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<EndCampaignExperimentRequest, Empty> endCampaignExperimentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v11.services.CampaignExperimentService/EndCampaignExperiment").setRequestMarshaller(ProtoUtils.marshaller((Message)EndCampaignExperimentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListCampaignExperimentAsyncErrorsRequest, ListCampaignExperimentAsyncErrorsResponse> listCampaignExperimentAsyncErrorsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v11.services.CampaignExperimentService/ListCampaignExperimentAsyncErrors").setRequestMarshaller(ProtoUtils.marshaller((Message)ListCampaignExperimentAsyncErrorsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListCampaignExperimentAsyncErrorsResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateCampaignExperimentRequest, Operation> createCampaignExperimentCallable;
    private final OperationCallable<CreateCampaignExperimentRequest, Empty, CreateCampaignExperimentMetadata> createCampaignExperimentOperationCallable;
    private final UnaryCallable<MutateCampaignExperimentsRequest, MutateCampaignExperimentsResponse> mutateCampaignExperimentsCallable;
    private final UnaryCallable<GraduateCampaignExperimentRequest, GraduateCampaignExperimentResponse> graduateCampaignExperimentCallable;
    private final UnaryCallable<PromoteCampaignExperimentRequest, Operation> promoteCampaignExperimentCallable;
    private final OperationCallable<PromoteCampaignExperimentRequest, Empty, Empty> promoteCampaignExperimentOperationCallable;
    private final UnaryCallable<EndCampaignExperimentRequest, Empty> endCampaignExperimentCallable;
    private final UnaryCallable<ListCampaignExperimentAsyncErrorsRequest, ListCampaignExperimentAsyncErrorsResponse> listCampaignExperimentAsyncErrorsCallable;
    private final UnaryCallable<ListCampaignExperimentAsyncErrorsRequest, CampaignExperimentServiceClient.ListCampaignExperimentAsyncErrorsPagedResponse> listCampaignExperimentAsyncErrorsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCampaignExperimentServiceStub create(CampaignExperimentServiceStubSettings settings) throws IOException {
        return new GrpcCampaignExperimentServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCampaignExperimentServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcCampaignExperimentServiceStub(CampaignExperimentServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCampaignExperimentServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCampaignExperimentServiceStub(CampaignExperimentServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCampaignExperimentServiceStub(CampaignExperimentServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, (GrpcStubCallableFactory)new GrpcCampaignExperimentServiceCallableFactory());
    }

    protected GrpcCampaignExperimentServiceStub(CampaignExperimentServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createCampaignExperimentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createCampaignExperimentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
            return params.build();
        }).build();
        GrpcCallSettings mutateCampaignExperimentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateCampaignExperimentsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
            return params.build();
        }).build();
        GrpcCallSettings graduateCampaignExperimentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(graduateCampaignExperimentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"campaign_experiment", (Object)String.valueOf(request.getCampaignExperiment()));
            return params.build();
        }).build();
        GrpcCallSettings promoteCampaignExperimentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(promoteCampaignExperimentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"campaign_experiment", (Object)String.valueOf(request.getCampaignExperiment()));
            return params.build();
        }).build();
        GrpcCallSettings endCampaignExperimentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(endCampaignExperimentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"campaign_experiment", (Object)String.valueOf(request.getCampaignExperiment()));
            return params.build();
        }).build();
        GrpcCallSettings listCampaignExperimentAsyncErrorsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listCampaignExperimentAsyncErrorsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
            return params.build();
        }).build();
        this.createCampaignExperimentCallable = callableFactory.createUnaryCallable(createCampaignExperimentTransportSettings, settings.createCampaignExperimentSettings(), clientContext);
        this.createCampaignExperimentOperationCallable = callableFactory.createOperationCallable(createCampaignExperimentTransportSettings, settings.createCampaignExperimentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.mutateCampaignExperimentsCallable = callableFactory.createUnaryCallable(mutateCampaignExperimentsTransportSettings, settings.mutateCampaignExperimentsSettings(), clientContext);
        this.graduateCampaignExperimentCallable = callableFactory.createUnaryCallable(graduateCampaignExperimentTransportSettings, settings.graduateCampaignExperimentSettings(), clientContext);
        this.promoteCampaignExperimentCallable = callableFactory.createUnaryCallable(promoteCampaignExperimentTransportSettings, settings.promoteCampaignExperimentSettings(), clientContext);
        this.promoteCampaignExperimentOperationCallable = callableFactory.createOperationCallable(promoteCampaignExperimentTransportSettings, settings.promoteCampaignExperimentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.endCampaignExperimentCallable = callableFactory.createUnaryCallable(endCampaignExperimentTransportSettings, settings.endCampaignExperimentSettings(), clientContext);
        this.listCampaignExperimentAsyncErrorsCallable = callableFactory.createUnaryCallable(listCampaignExperimentAsyncErrorsTransportSettings, settings.listCampaignExperimentAsyncErrorsSettings(), clientContext);
        this.listCampaignExperimentAsyncErrorsPagedCallable = callableFactory.createPagedCallable(listCampaignExperimentAsyncErrorsTransportSettings, settings.listCampaignExperimentAsyncErrorsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateCampaignExperimentRequest, Operation> createCampaignExperimentCallable() {
        return this.createCampaignExperimentCallable;
    }

    @Override
    public OperationCallable<CreateCampaignExperimentRequest, Empty, CreateCampaignExperimentMetadata> createCampaignExperimentOperationCallable() {
        return this.createCampaignExperimentOperationCallable;
    }

    @Override
    public UnaryCallable<MutateCampaignExperimentsRequest, MutateCampaignExperimentsResponse> mutateCampaignExperimentsCallable() {
        return this.mutateCampaignExperimentsCallable;
    }

    @Override
    public UnaryCallable<GraduateCampaignExperimentRequest, GraduateCampaignExperimentResponse> graduateCampaignExperimentCallable() {
        return this.graduateCampaignExperimentCallable;
    }

    @Override
    public UnaryCallable<PromoteCampaignExperimentRequest, Operation> promoteCampaignExperimentCallable() {
        return this.promoteCampaignExperimentCallable;
    }

    @Override
    public OperationCallable<PromoteCampaignExperimentRequest, Empty, Empty> promoteCampaignExperimentOperationCallable() {
        return this.promoteCampaignExperimentOperationCallable;
    }

    @Override
    public UnaryCallable<EndCampaignExperimentRequest, Empty> endCampaignExperimentCallable() {
        return this.endCampaignExperimentCallable;
    }

    @Override
    public UnaryCallable<ListCampaignExperimentAsyncErrorsRequest, ListCampaignExperimentAsyncErrorsResponse> listCampaignExperimentAsyncErrorsCallable() {
        return this.listCampaignExperimentAsyncErrorsCallable;
    }

    @Override
    public UnaryCallable<ListCampaignExperimentAsyncErrorsRequest, CampaignExperimentServiceClient.ListCampaignExperimentAsyncErrorsPagedResponse> listCampaignExperimentAsyncErrorsPagedCallable() {
        return this.listCampaignExperimentAsyncErrorsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

