/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v11.services.stub;

import com.google.ads.googleads.v11.services.GenerateAdGroupThemesRequest;
import com.google.ads.googleads.v11.services.GenerateAdGroupThemesResponse;
import com.google.ads.googleads.v11.services.GenerateKeywordHistoricalMetricsRequest;
import com.google.ads.googleads.v11.services.GenerateKeywordHistoricalMetricsResponse;
import com.google.ads.googleads.v11.services.GenerateKeywordIdeaResponse;
import com.google.ads.googleads.v11.services.GenerateKeywordIdeasRequest;
import com.google.ads.googleads.v11.services.KeywordPlanIdeaServiceClient;
import com.google.ads.googleads.v11.services.stub.GrpcKeywordPlanIdeaServiceCallableFactory;
import com.google.ads.googleads.v11.services.stub.KeywordPlanIdeaServiceStub;
import com.google.ads.googleads.v11.services.stub.KeywordPlanIdeaServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcKeywordPlanIdeaServiceStub
extends KeywordPlanIdeaServiceStub {
    private static final MethodDescriptor<GenerateKeywordIdeasRequest, GenerateKeywordIdeaResponse> generateKeywordIdeasMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v11.services.KeywordPlanIdeaService/GenerateKeywordIdeas").setRequestMarshaller(ProtoUtils.marshaller((Message)GenerateKeywordIdeasRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GenerateKeywordIdeaResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GenerateKeywordHistoricalMetricsRequest, GenerateKeywordHistoricalMetricsResponse> generateKeywordHistoricalMetricsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v11.services.KeywordPlanIdeaService/GenerateKeywordHistoricalMetrics").setRequestMarshaller(ProtoUtils.marshaller((Message)GenerateKeywordHistoricalMetricsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GenerateKeywordHistoricalMetricsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GenerateAdGroupThemesRequest, GenerateAdGroupThemesResponse> generateAdGroupThemesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v11.services.KeywordPlanIdeaService/GenerateAdGroupThemes").setRequestMarshaller(ProtoUtils.marshaller((Message)GenerateAdGroupThemesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GenerateAdGroupThemesResponse.getDefaultInstance())).build();
    private final UnaryCallable<GenerateKeywordIdeasRequest, GenerateKeywordIdeaResponse> generateKeywordIdeasCallable;
    private final UnaryCallable<GenerateKeywordIdeasRequest, KeywordPlanIdeaServiceClient.GenerateKeywordIdeasPagedResponse> generateKeywordIdeasPagedCallable;
    private final UnaryCallable<GenerateKeywordHistoricalMetricsRequest, GenerateKeywordHistoricalMetricsResponse> generateKeywordHistoricalMetricsCallable;
    private final UnaryCallable<GenerateAdGroupThemesRequest, GenerateAdGroupThemesResponse> generateAdGroupThemesCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcKeywordPlanIdeaServiceStub create(KeywordPlanIdeaServiceStubSettings settings) throws IOException {
        return new GrpcKeywordPlanIdeaServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcKeywordPlanIdeaServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcKeywordPlanIdeaServiceStub(KeywordPlanIdeaServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcKeywordPlanIdeaServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcKeywordPlanIdeaServiceStub(KeywordPlanIdeaServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcKeywordPlanIdeaServiceStub(KeywordPlanIdeaServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, (GrpcStubCallableFactory)new GrpcKeywordPlanIdeaServiceCallableFactory());
    }

    protected GrpcKeywordPlanIdeaServiceStub(KeywordPlanIdeaServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings generateKeywordIdeasTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(generateKeywordIdeasMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
            return params.build();
        }).build();
        GrpcCallSettings generateKeywordHistoricalMetricsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(generateKeywordHistoricalMetricsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
            return params.build();
        }).build();
        GrpcCallSettings generateAdGroupThemesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(generateAdGroupThemesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
            return params.build();
        }).build();
        this.generateKeywordIdeasCallable = callableFactory.createUnaryCallable(generateKeywordIdeasTransportSettings, settings.generateKeywordIdeasSettings(), clientContext);
        this.generateKeywordIdeasPagedCallable = callableFactory.createPagedCallable(generateKeywordIdeasTransportSettings, settings.generateKeywordIdeasSettings(), clientContext);
        this.generateKeywordHistoricalMetricsCallable = callableFactory.createUnaryCallable(generateKeywordHistoricalMetricsTransportSettings, settings.generateKeywordHistoricalMetricsSettings(), clientContext);
        this.generateAdGroupThemesCallable = callableFactory.createUnaryCallable(generateAdGroupThemesTransportSettings, settings.generateAdGroupThemesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GenerateKeywordIdeasRequest, GenerateKeywordIdeaResponse> generateKeywordIdeasCallable() {
        return this.generateKeywordIdeasCallable;
    }

    @Override
    public UnaryCallable<GenerateKeywordIdeasRequest, KeywordPlanIdeaServiceClient.GenerateKeywordIdeasPagedResponse> generateKeywordIdeasPagedCallable() {
        return this.generateKeywordIdeasPagedCallable;
    }

    @Override
    public UnaryCallable<GenerateKeywordHistoricalMetricsRequest, GenerateKeywordHistoricalMetricsResponse> generateKeywordHistoricalMetricsCallable() {
        return this.generateKeywordHistoricalMetricsCallable;
    }

    @Override
    public UnaryCallable<GenerateAdGroupThemesRequest, GenerateAdGroupThemesResponse> generateAdGroupThemesCallable() {
        return this.generateAdGroupThemesCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

