// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.google.ads.googleads.lib.catalog;

import com.google.ads.googleads.lib.GoogleAdsAllVersions;
import com.google.ads.googleads.v10.services.AccountBudgetProposalServiceClient;
import com.google.ads.googleads.v10.services.AccountBudgetProposalServiceSettings;
import com.google.ads.googleads.v10.services.AccountLinkServiceClient;
import com.google.ads.googleads.v10.services.AccountLinkServiceSettings;
import com.google.ads.googleads.v10.services.AdGroupAdLabelServiceClient;
import com.google.ads.googleads.v10.services.AdGroupAdLabelServiceSettings;
import com.google.ads.googleads.v10.services.AdGroupAdServiceClient;
import com.google.ads.googleads.v10.services.AdGroupAdServiceSettings;
import com.google.ads.googleads.v10.services.AdGroupAssetServiceClient;
import com.google.ads.googleads.v10.services.AdGroupAssetServiceSettings;
import com.google.ads.googleads.v10.services.AdGroupBidModifierServiceClient;
import com.google.ads.googleads.v10.services.AdGroupBidModifierServiceSettings;
import com.google.ads.googleads.v10.services.AdGroupCriterionCustomizerServiceClient;
import com.google.ads.googleads.v10.services.AdGroupCriterionCustomizerServiceSettings;
import com.google.ads.googleads.v10.services.AdGroupCriterionLabelServiceClient;
import com.google.ads.googleads.v10.services.AdGroupCriterionLabelServiceSettings;
import com.google.ads.googleads.v10.services.AdGroupCriterionServiceClient;
import com.google.ads.googleads.v10.services.AdGroupCriterionServiceSettings;
import com.google.ads.googleads.v10.services.AdGroupCustomizerServiceClient;
import com.google.ads.googleads.v10.services.AdGroupCustomizerServiceSettings;
import com.google.ads.googleads.v10.services.AdGroupExtensionSettingServiceClient;
import com.google.ads.googleads.v10.services.AdGroupExtensionSettingServiceSettings;
import com.google.ads.googleads.v10.services.AdGroupFeedServiceClient;
import com.google.ads.googleads.v10.services.AdGroupFeedServiceSettings;
import com.google.ads.googleads.v10.services.AdGroupLabelServiceClient;
import com.google.ads.googleads.v10.services.AdGroupLabelServiceSettings;
import com.google.ads.googleads.v10.services.AdGroupServiceClient;
import com.google.ads.googleads.v10.services.AdGroupServiceSettings;
import com.google.ads.googleads.v10.services.AdParameterServiceClient;
import com.google.ads.googleads.v10.services.AdParameterServiceSettings;
import com.google.ads.googleads.v10.services.AdServiceClient;
import com.google.ads.googleads.v10.services.AdServiceSettings;
import com.google.ads.googleads.v10.services.AssetGroupAssetServiceClient;
import com.google.ads.googleads.v10.services.AssetGroupAssetServiceSettings;
import com.google.ads.googleads.v10.services.AssetGroupListingGroupFilterServiceClient;
import com.google.ads.googleads.v10.services.AssetGroupListingGroupFilterServiceSettings;
import com.google.ads.googleads.v10.services.AssetGroupServiceClient;
import com.google.ads.googleads.v10.services.AssetGroupServiceSettings;
import com.google.ads.googleads.v10.services.AssetGroupSignalServiceClient;
import com.google.ads.googleads.v10.services.AssetGroupSignalServiceSettings;
import com.google.ads.googleads.v10.services.AssetServiceClient;
import com.google.ads.googleads.v10.services.AssetServiceSettings;
import com.google.ads.googleads.v10.services.AssetSetAssetServiceClient;
import com.google.ads.googleads.v10.services.AssetSetAssetServiceSettings;
import com.google.ads.googleads.v10.services.AssetSetServiceClient;
import com.google.ads.googleads.v10.services.AssetSetServiceSettings;
import com.google.ads.googleads.v10.services.AudienceServiceClient;
import com.google.ads.googleads.v10.services.AudienceServiceSettings;
import com.google.ads.googleads.v10.services.BatchJobServiceClient;
import com.google.ads.googleads.v10.services.BatchJobServiceSettings;
import com.google.ads.googleads.v10.services.BiddingDataExclusionServiceClient;
import com.google.ads.googleads.v10.services.BiddingDataExclusionServiceSettings;
import com.google.ads.googleads.v10.services.BiddingSeasonalityAdjustmentServiceClient;
import com.google.ads.googleads.v10.services.BiddingSeasonalityAdjustmentServiceSettings;
import com.google.ads.googleads.v10.services.BiddingStrategyServiceClient;
import com.google.ads.googleads.v10.services.BiddingStrategyServiceSettings;
import com.google.ads.googleads.v10.services.BillingSetupServiceClient;
import com.google.ads.googleads.v10.services.BillingSetupServiceSettings;
import com.google.ads.googleads.v10.services.CampaignAssetServiceClient;
import com.google.ads.googleads.v10.services.CampaignAssetServiceSettings;
import com.google.ads.googleads.v10.services.CampaignAssetSetServiceClient;
import com.google.ads.googleads.v10.services.CampaignAssetSetServiceSettings;
import com.google.ads.googleads.v10.services.CampaignBidModifierServiceClient;
import com.google.ads.googleads.v10.services.CampaignBidModifierServiceSettings;
import com.google.ads.googleads.v10.services.CampaignBudgetServiceClient;
import com.google.ads.googleads.v10.services.CampaignBudgetServiceSettings;
import com.google.ads.googleads.v10.services.CampaignConversionGoalServiceClient;
import com.google.ads.googleads.v10.services.CampaignConversionGoalServiceSettings;
import com.google.ads.googleads.v10.services.CampaignCriterionServiceClient;
import com.google.ads.googleads.v10.services.CampaignCriterionServiceSettings;
import com.google.ads.googleads.v10.services.CampaignCustomizerServiceClient;
import com.google.ads.googleads.v10.services.CampaignCustomizerServiceSettings;
import com.google.ads.googleads.v10.services.CampaignDraftServiceClient;
import com.google.ads.googleads.v10.services.CampaignDraftServiceSettings;
import com.google.ads.googleads.v10.services.CampaignExperimentServiceClient;
import com.google.ads.googleads.v10.services.CampaignExperimentServiceSettings;
import com.google.ads.googleads.v10.services.CampaignExtensionSettingServiceClient;
import com.google.ads.googleads.v10.services.CampaignExtensionSettingServiceSettings;
import com.google.ads.googleads.v10.services.CampaignFeedServiceClient;
import com.google.ads.googleads.v10.services.CampaignFeedServiceSettings;
import com.google.ads.googleads.v10.services.CampaignGroupServiceClient;
import com.google.ads.googleads.v10.services.CampaignGroupServiceSettings;
import com.google.ads.googleads.v10.services.CampaignLabelServiceClient;
import com.google.ads.googleads.v10.services.CampaignLabelServiceSettings;
import com.google.ads.googleads.v10.services.CampaignServiceClient;
import com.google.ads.googleads.v10.services.CampaignServiceSettings;
import com.google.ads.googleads.v10.services.CampaignSharedSetServiceClient;
import com.google.ads.googleads.v10.services.CampaignSharedSetServiceSettings;
import com.google.ads.googleads.v10.services.ConversionActionServiceClient;
import com.google.ads.googleads.v10.services.ConversionActionServiceSettings;
import com.google.ads.googleads.v10.services.ConversionAdjustmentUploadServiceClient;
import com.google.ads.googleads.v10.services.ConversionAdjustmentUploadServiceSettings;
import com.google.ads.googleads.v10.services.ConversionCustomVariableServiceClient;
import com.google.ads.googleads.v10.services.ConversionCustomVariableServiceSettings;
import com.google.ads.googleads.v10.services.ConversionGoalCampaignConfigServiceClient;
import com.google.ads.googleads.v10.services.ConversionGoalCampaignConfigServiceSettings;
import com.google.ads.googleads.v10.services.ConversionUploadServiceClient;
import com.google.ads.googleads.v10.services.ConversionUploadServiceSettings;
import com.google.ads.googleads.v10.services.ConversionValueRuleServiceClient;
import com.google.ads.googleads.v10.services.ConversionValueRuleServiceSettings;
import com.google.ads.googleads.v10.services.ConversionValueRuleSetServiceClient;
import com.google.ads.googleads.v10.services.ConversionValueRuleSetServiceSettings;
import com.google.ads.googleads.v10.services.CustomAudienceServiceClient;
import com.google.ads.googleads.v10.services.CustomAudienceServiceSettings;
import com.google.ads.googleads.v10.services.CustomConversionGoalServiceClient;
import com.google.ads.googleads.v10.services.CustomConversionGoalServiceSettings;
import com.google.ads.googleads.v10.services.CustomInterestServiceClient;
import com.google.ads.googleads.v10.services.CustomInterestServiceSettings;
import com.google.ads.googleads.v10.services.CustomerAssetServiceClient;
import com.google.ads.googleads.v10.services.CustomerAssetServiceSettings;
import com.google.ads.googleads.v10.services.CustomerClientLinkServiceClient;
import com.google.ads.googleads.v10.services.CustomerClientLinkServiceSettings;
import com.google.ads.googleads.v10.services.CustomerConversionGoalServiceClient;
import com.google.ads.googleads.v10.services.CustomerConversionGoalServiceSettings;
import com.google.ads.googleads.v10.services.CustomerCustomizerServiceClient;
import com.google.ads.googleads.v10.services.CustomerCustomizerServiceSettings;
import com.google.ads.googleads.v10.services.CustomerExtensionSettingServiceClient;
import com.google.ads.googleads.v10.services.CustomerExtensionSettingServiceSettings;
import com.google.ads.googleads.v10.services.CustomerFeedServiceClient;
import com.google.ads.googleads.v10.services.CustomerFeedServiceSettings;
import com.google.ads.googleads.v10.services.CustomerLabelServiceClient;
import com.google.ads.googleads.v10.services.CustomerLabelServiceSettings;
import com.google.ads.googleads.v10.services.CustomerManagerLinkServiceClient;
import com.google.ads.googleads.v10.services.CustomerManagerLinkServiceSettings;
import com.google.ads.googleads.v10.services.CustomerNegativeCriterionServiceClient;
import com.google.ads.googleads.v10.services.CustomerNegativeCriterionServiceSettings;
import com.google.ads.googleads.v10.services.CustomerServiceClient;
import com.google.ads.googleads.v10.services.CustomerServiceSettings;
import com.google.ads.googleads.v10.services.CustomerUserAccessInvitationServiceClient;
import com.google.ads.googleads.v10.services.CustomerUserAccessInvitationServiceSettings;
import com.google.ads.googleads.v10.services.CustomerUserAccessServiceClient;
import com.google.ads.googleads.v10.services.CustomerUserAccessServiceSettings;
import com.google.ads.googleads.v10.services.CustomizerAttributeServiceClient;
import com.google.ads.googleads.v10.services.CustomizerAttributeServiceSettings;
import com.google.ads.googleads.v10.services.ExperimentArmServiceClient;
import com.google.ads.googleads.v10.services.ExperimentArmServiceSettings;
import com.google.ads.googleads.v10.services.ExperimentServiceClient;
import com.google.ads.googleads.v10.services.ExperimentServiceSettings;
import com.google.ads.googleads.v10.services.ExtensionFeedItemServiceClient;
import com.google.ads.googleads.v10.services.ExtensionFeedItemServiceSettings;
import com.google.ads.googleads.v10.services.FeedItemServiceClient;
import com.google.ads.googleads.v10.services.FeedItemServiceSettings;
import com.google.ads.googleads.v10.services.FeedItemSetLinkServiceClient;
import com.google.ads.googleads.v10.services.FeedItemSetLinkServiceSettings;
import com.google.ads.googleads.v10.services.FeedItemSetServiceClient;
import com.google.ads.googleads.v10.services.FeedItemSetServiceSettings;
import com.google.ads.googleads.v10.services.FeedItemTargetServiceClient;
import com.google.ads.googleads.v10.services.FeedItemTargetServiceSettings;
import com.google.ads.googleads.v10.services.FeedMappingServiceClient;
import com.google.ads.googleads.v10.services.FeedMappingServiceSettings;
import com.google.ads.googleads.v10.services.FeedServiceClient;
import com.google.ads.googleads.v10.services.FeedServiceSettings;
import com.google.ads.googleads.v10.services.GeoTargetConstantServiceClient;
import com.google.ads.googleads.v10.services.GeoTargetConstantServiceSettings;
import com.google.ads.googleads.v10.services.GoogleAdsFieldServiceClient;
import com.google.ads.googleads.v10.services.GoogleAdsFieldServiceSettings;
import com.google.ads.googleads.v10.services.GoogleAdsServiceClient;
import com.google.ads.googleads.v10.services.GoogleAdsServiceSettings;
import com.google.ads.googleads.v10.services.GoogleAdsVersion;
import com.google.ads.googleads.v10.services.InvoiceServiceClient;
import com.google.ads.googleads.v10.services.InvoiceServiceSettings;
import com.google.ads.googleads.v10.services.KeywordPlanAdGroupKeywordServiceClient;
import com.google.ads.googleads.v10.services.KeywordPlanAdGroupKeywordServiceSettings;
import com.google.ads.googleads.v10.services.KeywordPlanAdGroupServiceClient;
import com.google.ads.googleads.v10.services.KeywordPlanAdGroupServiceSettings;
import com.google.ads.googleads.v10.services.KeywordPlanCampaignKeywordServiceClient;
import com.google.ads.googleads.v10.services.KeywordPlanCampaignKeywordServiceSettings;
import com.google.ads.googleads.v10.services.KeywordPlanCampaignServiceClient;
import com.google.ads.googleads.v10.services.KeywordPlanCampaignServiceSettings;
import com.google.ads.googleads.v10.services.KeywordPlanIdeaServiceClient;
import com.google.ads.googleads.v10.services.KeywordPlanIdeaServiceSettings;
import com.google.ads.googleads.v10.services.KeywordPlanServiceClient;
import com.google.ads.googleads.v10.services.KeywordPlanServiceSettings;
import com.google.ads.googleads.v10.services.KeywordThemeConstantServiceClient;
import com.google.ads.googleads.v10.services.KeywordThemeConstantServiceSettings;
import com.google.ads.googleads.v10.services.LabelServiceClient;
import com.google.ads.googleads.v10.services.LabelServiceSettings;
import com.google.ads.googleads.v10.services.MediaFileServiceClient;
import com.google.ads.googleads.v10.services.MediaFileServiceSettings;
import com.google.ads.googleads.v10.services.MerchantCenterLinkServiceClient;
import com.google.ads.googleads.v10.services.MerchantCenterLinkServiceSettings;
import com.google.ads.googleads.v10.services.OfflineUserDataJobServiceClient;
import com.google.ads.googleads.v10.services.OfflineUserDataJobServiceSettings;
import com.google.ads.googleads.v10.services.PaymentsAccountServiceClient;
import com.google.ads.googleads.v10.services.PaymentsAccountServiceSettings;
import com.google.ads.googleads.v10.services.ReachPlanServiceClient;
import com.google.ads.googleads.v10.services.ReachPlanServiceSettings;
import com.google.ads.googleads.v10.services.RecommendationServiceClient;
import com.google.ads.googleads.v10.services.RecommendationServiceSettings;
import com.google.ads.googleads.v10.services.RemarketingActionServiceClient;
import com.google.ads.googleads.v10.services.RemarketingActionServiceSettings;
import com.google.ads.googleads.v10.services.SharedCriterionServiceClient;
import com.google.ads.googleads.v10.services.SharedCriterionServiceSettings;
import com.google.ads.googleads.v10.services.SharedSetServiceClient;
import com.google.ads.googleads.v10.services.SharedSetServiceSettings;
import com.google.ads.googleads.v10.services.SmartCampaignSettingServiceClient;
import com.google.ads.googleads.v10.services.SmartCampaignSettingServiceSettings;
import com.google.ads.googleads.v10.services.SmartCampaignSuggestServiceClient;
import com.google.ads.googleads.v10.services.SmartCampaignSuggestServiceSettings;
import com.google.ads.googleads.v10.services.ThirdPartyAppAnalyticsLinkServiceClient;
import com.google.ads.googleads.v10.services.ThirdPartyAppAnalyticsLinkServiceSettings;
import com.google.ads.googleads.v10.services.UserDataServiceClient;
import com.google.ads.googleads.v10.services.UserDataServiceSettings;
import com.google.ads.googleads.v10.services.UserListServiceClient;
import com.google.ads.googleads.v10.services.UserListServiceSettings;
import com.google.ads.googleads.v11.services.AudienceInsightsServiceClient;
import com.google.ads.googleads.v11.services.AudienceInsightsServiceSettings;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.io.IOException;
import java.util.SortedSet;
import javax.annotation.Generated;

@Generated("GoogleAdsCatalogAnnotationProcessor")
public class GeneratedCatalog implements ApiCatalog {
  private static GeneratedCatalog instance;

  static {
    try {
      instance = new GeneratedCatalog(VersionFactory.getVersions());
    } catch (IllegalAccessException e) {
      throw new RuntimeException(e);
    } catch (InstantiationException e) {
      throw new RuntimeException(e);
    }
  }

  private final ImmutableSortedSet<Version> supportedVersions;

  /**
   * Creates a new constant catalog from a known collection of versions. */
  public GeneratedCatalog(ImmutableSet<Version> versions) {
    supportedVersions = ImmutableSortedSet.copyOf(versions);
  }

  public static GeneratedCatalog getDefault() {
    return instance;
  }

  public SortedSet<Version> getSupportedVersions() {
    return supportedVersions;
  }

  public Version getLatestVersion() {
    return getSupportedVersions().first();
  }

  public GoogleAdsAllVersions createAllVersionsClient(TransportChannelProvider provider,
      Credentials credentials) {
    return new GoogleAdsAllVersions() {
      @Override
      public GoogleAdsVersion getVersion10() {
        return new V10Client(provider, credentials);
      }

      @Override
      public com.google.ads.googleads.v11.services.GoogleAdsVersion getVersion11() {
        return new V11Client(provider, credentials);
      }

      @Override
      public com.google.ads.googleads.v11.services.GoogleAdsVersion getLatestVersion() {
        return getVersion11();
      }
    };
  }

  private static class V10Client implements GoogleAdsVersion {
    private final TransportChannelProvider provider;

    private final Credentials credentials;

    public V10Client(TransportChannelProvider provider, Credentials credentials) {
      this.provider = provider;
      this.credentials = credentials;
    }

    @Override
    public AccountBudgetProposalServiceClient createAccountBudgetProposalServiceClient() {
      try {
        AccountBudgetProposalServiceSettings settings =
          AccountBudgetProposalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AccountBudgetProposalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AccountLinkServiceClient createAccountLinkServiceClient() {
      try {
        AccountLinkServiceSettings settings =
          AccountLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AccountLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAdLabelServiceClient createAdGroupAdLabelServiceClient() {
      try {
        AdGroupAdLabelServiceSettings settings =
          AdGroupAdLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAdLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAdServiceClient createAdGroupAdServiceClient() {
      try {
        AdGroupAdServiceSettings settings =
          AdGroupAdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAssetServiceClient createAdGroupAssetServiceClient() {
      try {
        AdGroupAssetServiceSettings settings =
          AdGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupBidModifierServiceClient createAdGroupBidModifierServiceClient() {
      try {
        AdGroupBidModifierServiceSettings settings =
          AdGroupBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCriterionCustomizerServiceClient createAdGroupCriterionCustomizerServiceClient() {
      try {
        AdGroupCriterionCustomizerServiceSettings settings =
          AdGroupCriterionCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCriterionCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCriterionLabelServiceClient createAdGroupCriterionLabelServiceClient() {
      try {
        AdGroupCriterionLabelServiceSettings settings =
          AdGroupCriterionLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCriterionLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCriterionServiceClient createAdGroupCriterionServiceClient() {
      try {
        AdGroupCriterionServiceSettings settings =
          AdGroupCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCustomizerServiceClient createAdGroupCustomizerServiceClient() {
      try {
        AdGroupCustomizerServiceSettings settings =
          AdGroupCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupExtensionSettingServiceClient createAdGroupExtensionSettingServiceClient() {
      try {
        AdGroupExtensionSettingServiceSettings settings =
          AdGroupExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupFeedServiceClient createAdGroupFeedServiceClient() {
      try {
        AdGroupFeedServiceSettings settings =
          AdGroupFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupLabelServiceClient createAdGroupLabelServiceClient() {
      try {
        AdGroupLabelServiceSettings settings =
          AdGroupLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupServiceClient createAdGroupServiceClient() {
      try {
        AdGroupServiceSettings settings =
          AdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdParameterServiceClient createAdParameterServiceClient() {
      try {
        AdParameterServiceSettings settings =
          AdParameterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdParameterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdServiceClient createAdServiceClient() {
      try {
        AdServiceSettings settings =
          AdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetGroupAssetServiceClient createAssetGroupAssetServiceClient() {
      try {
        AssetGroupAssetServiceSettings settings =
          AssetGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetGroupListingGroupFilterServiceClient createAssetGroupListingGroupFilterServiceClient(
        ) {
      try {
        AssetGroupListingGroupFilterServiceSettings settings =
          AssetGroupListingGroupFilterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetGroupListingGroupFilterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetGroupServiceClient createAssetGroupServiceClient() {
      try {
        AssetGroupServiceSettings settings =
          AssetGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetGroupSignalServiceClient createAssetGroupSignalServiceClient() {
      try {
        AssetGroupSignalServiceSettings settings =
          AssetGroupSignalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetGroupSignalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetServiceClient createAssetServiceClient() {
      try {
        AssetServiceSettings settings =
          AssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetSetAssetServiceClient createAssetSetAssetServiceClient() {
      try {
        AssetSetAssetServiceSettings settings =
          AssetSetAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetSetAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetSetServiceClient createAssetSetServiceClient() {
      try {
        AssetSetServiceSettings settings =
          AssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AudienceServiceClient createAudienceServiceClient() {
      try {
        AudienceServiceSettings settings =
          AudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BatchJobServiceClient createBatchJobServiceClient() {
      try {
        BatchJobServiceSettings settings =
          BatchJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BatchJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BiddingDataExclusionServiceClient createBiddingDataExclusionServiceClient() {
      try {
        BiddingDataExclusionServiceSettings settings =
          BiddingDataExclusionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BiddingDataExclusionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BiddingSeasonalityAdjustmentServiceClient createBiddingSeasonalityAdjustmentServiceClient(
        ) {
      try {
        BiddingSeasonalityAdjustmentServiceSettings settings =
          BiddingSeasonalityAdjustmentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BiddingSeasonalityAdjustmentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BiddingStrategyServiceClient createBiddingStrategyServiceClient() {
      try {
        BiddingStrategyServiceSettings settings =
          BiddingStrategyServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BiddingStrategyServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BillingSetupServiceClient createBillingSetupServiceClient() {
      try {
        BillingSetupServiceSettings settings =
          BillingSetupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BillingSetupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignAssetServiceClient createCampaignAssetServiceClient() {
      try {
        CampaignAssetServiceSettings settings =
          CampaignAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignAssetSetServiceClient createCampaignAssetSetServiceClient() {
      try {
        CampaignAssetSetServiceSettings settings =
          CampaignAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignBidModifierServiceClient createCampaignBidModifierServiceClient() {
      try {
        CampaignBidModifierServiceSettings settings =
          CampaignBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignBudgetServiceClient createCampaignBudgetServiceClient() {
      try {
        CampaignBudgetServiceSettings settings =
          CampaignBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignConversionGoalServiceClient createCampaignConversionGoalServiceClient() {
      try {
        CampaignConversionGoalServiceSettings settings =
          CampaignConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignCriterionServiceClient createCampaignCriterionServiceClient() {
      try {
        CampaignCriterionServiceSettings settings =
          CampaignCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignCustomizerServiceClient createCampaignCustomizerServiceClient() {
      try {
        CampaignCustomizerServiceSettings settings =
          CampaignCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignDraftServiceClient createCampaignDraftServiceClient() {
      try {
        CampaignDraftServiceSettings settings =
          CampaignDraftServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignDraftServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignExperimentServiceClient createCampaignExperimentServiceClient() {
      try {
        CampaignExperimentServiceSettings settings =
          CampaignExperimentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignExperimentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignExtensionSettingServiceClient createCampaignExtensionSettingServiceClient() {
      try {
        CampaignExtensionSettingServiceSettings settings =
          CampaignExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignFeedServiceClient createCampaignFeedServiceClient() {
      try {
        CampaignFeedServiceSettings settings =
          CampaignFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignGroupServiceClient createCampaignGroupServiceClient() {
      try {
        CampaignGroupServiceSettings settings =
          CampaignGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignLabelServiceClient createCampaignLabelServiceClient() {
      try {
        CampaignLabelServiceSettings settings =
          CampaignLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignServiceClient createCampaignServiceClient() {
      try {
        CampaignServiceSettings settings =
          CampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignSharedSetServiceClient createCampaignSharedSetServiceClient() {
      try {
        CampaignSharedSetServiceSettings settings =
          CampaignSharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignSharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionActionServiceClient createConversionActionServiceClient() {
      try {
        ConversionActionServiceSettings settings =
          ConversionActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionAdjustmentUploadServiceClient createConversionAdjustmentUploadServiceClient() {
      try {
        ConversionAdjustmentUploadServiceSettings settings =
          ConversionAdjustmentUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionAdjustmentUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionCustomVariableServiceClient createConversionCustomVariableServiceClient() {
      try {
        ConversionCustomVariableServiceSettings settings =
          ConversionCustomVariableServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionCustomVariableServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionGoalCampaignConfigServiceClient createConversionGoalCampaignConfigServiceClient(
        ) {
      try {
        ConversionGoalCampaignConfigServiceSettings settings =
          ConversionGoalCampaignConfigServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionGoalCampaignConfigServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionUploadServiceClient createConversionUploadServiceClient() {
      try {
        ConversionUploadServiceSettings settings =
          ConversionUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionValueRuleServiceClient createConversionValueRuleServiceClient() {
      try {
        ConversionValueRuleServiceSettings settings =
          ConversionValueRuleServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionValueRuleServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionValueRuleSetServiceClient createConversionValueRuleSetServiceClient() {
      try {
        ConversionValueRuleSetServiceSettings settings =
          ConversionValueRuleSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionValueRuleSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomAudienceServiceClient createCustomAudienceServiceClient() {
      try {
        CustomAudienceServiceSettings settings =
          CustomAudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomAudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomConversionGoalServiceClient createCustomConversionGoalServiceClient() {
      try {
        CustomConversionGoalServiceSettings settings =
          CustomConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomInterestServiceClient createCustomInterestServiceClient() {
      try {
        CustomInterestServiceSettings settings =
          CustomInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerAssetServiceClient createCustomerAssetServiceClient() {
      try {
        CustomerAssetServiceSettings settings =
          CustomerAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerClientLinkServiceClient createCustomerClientLinkServiceClient() {
      try {
        CustomerClientLinkServiceSettings settings =
          CustomerClientLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerClientLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerConversionGoalServiceClient createCustomerConversionGoalServiceClient() {
      try {
        CustomerConversionGoalServiceSettings settings =
          CustomerConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerCustomizerServiceClient createCustomerCustomizerServiceClient() {
      try {
        CustomerCustomizerServiceSettings settings =
          CustomerCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerExtensionSettingServiceClient createCustomerExtensionSettingServiceClient() {
      try {
        CustomerExtensionSettingServiceSettings settings =
          CustomerExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerFeedServiceClient createCustomerFeedServiceClient() {
      try {
        CustomerFeedServiceSettings settings =
          CustomerFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerLabelServiceClient createCustomerLabelServiceClient() {
      try {
        CustomerLabelServiceSettings settings =
          CustomerLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerManagerLinkServiceClient createCustomerManagerLinkServiceClient() {
      try {
        CustomerManagerLinkServiceSettings settings =
          CustomerManagerLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerManagerLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerNegativeCriterionServiceClient createCustomerNegativeCriterionServiceClient() {
      try {
        CustomerNegativeCriterionServiceSettings settings =
          CustomerNegativeCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerNegativeCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerServiceClient createCustomerServiceClient() {
      try {
        CustomerServiceSettings settings =
          CustomerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerUserAccessInvitationServiceClient createCustomerUserAccessInvitationServiceClient(
        ) {
      try {
        CustomerUserAccessInvitationServiceSettings settings =
          CustomerUserAccessInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerUserAccessInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerUserAccessServiceClient createCustomerUserAccessServiceClient() {
      try {
        CustomerUserAccessServiceSettings settings =
          CustomerUserAccessServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerUserAccessServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomizerAttributeServiceClient createCustomizerAttributeServiceClient() {
      try {
        CustomizerAttributeServiceSettings settings =
          CustomizerAttributeServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomizerAttributeServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ExperimentArmServiceClient createExperimentArmServiceClient() {
      try {
        ExperimentArmServiceSettings settings =
          ExperimentArmServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ExperimentArmServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ExperimentServiceClient createExperimentServiceClient() {
      try {
        ExperimentServiceSettings settings =
          ExperimentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ExperimentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ExtensionFeedItemServiceClient createExtensionFeedItemServiceClient() {
      try {
        ExtensionFeedItemServiceSettings settings =
          ExtensionFeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ExtensionFeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedItemServiceClient createFeedItemServiceClient() {
      try {
        FeedItemServiceSettings settings =
          FeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedItemSetLinkServiceClient createFeedItemSetLinkServiceClient() {
      try {
        FeedItemSetLinkServiceSettings settings =
          FeedItemSetLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedItemSetLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedItemSetServiceClient createFeedItemSetServiceClient() {
      try {
        FeedItemSetServiceSettings settings =
          FeedItemSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedItemSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedItemTargetServiceClient createFeedItemTargetServiceClient() {
      try {
        FeedItemTargetServiceSettings settings =
          FeedItemTargetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedItemTargetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedMappingServiceClient createFeedMappingServiceClient() {
      try {
        FeedMappingServiceSettings settings =
          FeedMappingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedMappingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedServiceClient createFeedServiceClient() {
      try {
        FeedServiceSettings settings =
          FeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GeoTargetConstantServiceClient createGeoTargetConstantServiceClient() {
      try {
        GeoTargetConstantServiceSettings settings =
          GeoTargetConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GeoTargetConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GoogleAdsFieldServiceClient createGoogleAdsFieldServiceClient() {
      try {
        GoogleAdsFieldServiceSettings settings =
          GoogleAdsFieldServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GoogleAdsFieldServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GoogleAdsServiceClient createGoogleAdsServiceClient() {
      try {
        GoogleAdsServiceSettings settings =
          GoogleAdsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GoogleAdsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public InvoiceServiceClient createInvoiceServiceClient() {
      try {
        InvoiceServiceSettings settings =
          InvoiceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return InvoiceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanAdGroupKeywordServiceClient createKeywordPlanAdGroupKeywordServiceClient() {
      try {
        KeywordPlanAdGroupKeywordServiceSettings settings =
          KeywordPlanAdGroupKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanAdGroupKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanAdGroupServiceClient createKeywordPlanAdGroupServiceClient() {
      try {
        KeywordPlanAdGroupServiceSettings settings =
          KeywordPlanAdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanAdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanCampaignKeywordServiceClient createKeywordPlanCampaignKeywordServiceClient() {
      try {
        KeywordPlanCampaignKeywordServiceSettings settings =
          KeywordPlanCampaignKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanCampaignKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanCampaignServiceClient createKeywordPlanCampaignServiceClient() {
      try {
        KeywordPlanCampaignServiceSettings settings =
          KeywordPlanCampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanCampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanIdeaServiceClient createKeywordPlanIdeaServiceClient() {
      try {
        KeywordPlanIdeaServiceSettings settings =
          KeywordPlanIdeaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanIdeaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanServiceClient createKeywordPlanServiceClient() {
      try {
        KeywordPlanServiceSettings settings =
          KeywordPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordThemeConstantServiceClient createKeywordThemeConstantServiceClient() {
      try {
        KeywordThemeConstantServiceSettings settings =
          KeywordThemeConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordThemeConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public LabelServiceClient createLabelServiceClient() {
      try {
        LabelServiceSettings settings =
          LabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return LabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public MediaFileServiceClient createMediaFileServiceClient() {
      try {
        MediaFileServiceSettings settings =
          MediaFileServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return MediaFileServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public MerchantCenterLinkServiceClient createMerchantCenterLinkServiceClient() {
      try {
        MerchantCenterLinkServiceSettings settings =
          MerchantCenterLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return MerchantCenterLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public OfflineUserDataJobServiceClient createOfflineUserDataJobServiceClient() {
      try {
        OfflineUserDataJobServiceSettings settings =
          OfflineUserDataJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return OfflineUserDataJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public PaymentsAccountServiceClient createPaymentsAccountServiceClient() {
      try {
        PaymentsAccountServiceSettings settings =
          PaymentsAccountServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return PaymentsAccountServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ReachPlanServiceClient createReachPlanServiceClient() {
      try {
        ReachPlanServiceSettings settings =
          ReachPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ReachPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public RecommendationServiceClient createRecommendationServiceClient() {
      try {
        RecommendationServiceSettings settings =
          RecommendationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return RecommendationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public RemarketingActionServiceClient createRemarketingActionServiceClient() {
      try {
        RemarketingActionServiceSettings settings =
          RemarketingActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return RemarketingActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SharedCriterionServiceClient createSharedCriterionServiceClient() {
      try {
        SharedCriterionServiceSettings settings =
          SharedCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SharedCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SharedSetServiceClient createSharedSetServiceClient() {
      try {
        SharedSetServiceSettings settings =
          SharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SmartCampaignSettingServiceClient createSmartCampaignSettingServiceClient() {
      try {
        SmartCampaignSettingServiceSettings settings =
          SmartCampaignSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SmartCampaignSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SmartCampaignSuggestServiceClient createSmartCampaignSuggestServiceClient() {
      try {
        SmartCampaignSuggestServiceSettings settings =
          SmartCampaignSuggestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SmartCampaignSuggestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ThirdPartyAppAnalyticsLinkServiceClient createThirdPartyAppAnalyticsLinkServiceClient() {
      try {
        ThirdPartyAppAnalyticsLinkServiceSettings settings =
          ThirdPartyAppAnalyticsLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ThirdPartyAppAnalyticsLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public UserDataServiceClient createUserDataServiceClient() {
      try {
        UserDataServiceSettings settings =
          UserDataServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return UserDataServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public UserListServiceClient createUserListServiceClient() {
      try {
        UserListServiceSettings settings =
          UserListServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return UserListServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }
  }

  private static class V11Client implements com.google.ads.googleads.v11.services.GoogleAdsVersion {
    private final TransportChannelProvider provider;

    private final Credentials credentials;

    public V11Client(TransportChannelProvider provider, Credentials credentials) {
      this.provider = provider;
      this.credentials = credentials;
    }

    @Override
    public com.google.ads.googleads.v11.services.AccountBudgetProposalServiceClient createAccountBudgetProposalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.AccountBudgetProposalServiceSettings settings =
          com.google.ads.googleads.v11.services.AccountBudgetProposalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AccountBudgetProposalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.AccountLinkServiceClient createAccountLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.AccountLinkServiceSettings settings =
          com.google.ads.googleads.v11.services.AccountLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AccountLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.AdGroupAdLabelServiceClient createAdGroupAdLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.AdGroupAdLabelServiceSettings settings =
          com.google.ads.googleads.v11.services.AdGroupAdLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AdGroupAdLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.AdGroupAdServiceClient createAdGroupAdServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.AdGroupAdServiceSettings settings =
          com.google.ads.googleads.v11.services.AdGroupAdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AdGroupAdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.AdGroupAssetServiceClient createAdGroupAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.AdGroupAssetServiceSettings settings =
          com.google.ads.googleads.v11.services.AdGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AdGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.AdGroupBidModifierServiceClient createAdGroupBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.AdGroupBidModifierServiceSettings settings =
          com.google.ads.googleads.v11.services.AdGroupBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AdGroupBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.AdGroupCriterionCustomizerServiceClient createAdGroupCriterionCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.AdGroupCriterionCustomizerServiceSettings settings =
          com.google.ads.googleads.v11.services.AdGroupCriterionCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AdGroupCriterionCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.AdGroupCriterionLabelServiceClient createAdGroupCriterionLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.AdGroupCriterionLabelServiceSettings settings =
          com.google.ads.googleads.v11.services.AdGroupCriterionLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AdGroupCriterionLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.AdGroupCriterionServiceClient createAdGroupCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.AdGroupCriterionServiceSettings settings =
          com.google.ads.googleads.v11.services.AdGroupCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AdGroupCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.AdGroupCustomizerServiceClient createAdGroupCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.AdGroupCustomizerServiceSettings settings =
          com.google.ads.googleads.v11.services.AdGroupCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AdGroupCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.AdGroupExtensionSettingServiceClient createAdGroupExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.AdGroupExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v11.services.AdGroupExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AdGroupExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.AdGroupFeedServiceClient createAdGroupFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.AdGroupFeedServiceSettings settings =
          com.google.ads.googleads.v11.services.AdGroupFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AdGroupFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.AdGroupLabelServiceClient createAdGroupLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.AdGroupLabelServiceSettings settings =
          com.google.ads.googleads.v11.services.AdGroupLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AdGroupLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.AdGroupServiceClient createAdGroupServiceClient() {
      try {
        com.google.ads.googleads.v11.services.AdGroupServiceSettings settings =
          com.google.ads.googleads.v11.services.AdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.AdParameterServiceClient createAdParameterServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.AdParameterServiceSettings settings =
          com.google.ads.googleads.v11.services.AdParameterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AdParameterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.AdServiceClient createAdServiceClient() {
      try {
        com.google.ads.googleads.v11.services.AdServiceSettings settings =
          com.google.ads.googleads.v11.services.AdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.AssetGroupAssetServiceClient createAssetGroupAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.AssetGroupAssetServiceSettings settings =
          com.google.ads.googleads.v11.services.AssetGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AssetGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.AssetGroupListingGroupFilterServiceClient createAssetGroupListingGroupFilterServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.AssetGroupListingGroupFilterServiceSettings settings =
          com.google.ads.googleads.v11.services.AssetGroupListingGroupFilterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AssetGroupListingGroupFilterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.AssetGroupServiceClient createAssetGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.AssetGroupServiceSettings settings =
          com.google.ads.googleads.v11.services.AssetGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AssetGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.AssetGroupSignalServiceClient createAssetGroupSignalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.AssetGroupSignalServiceSettings settings =
          com.google.ads.googleads.v11.services.AssetGroupSignalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AssetGroupSignalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.AssetServiceClient createAssetServiceClient() {
      try {
        com.google.ads.googleads.v11.services.AssetServiceSettings settings =
          com.google.ads.googleads.v11.services.AssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.AssetSetAssetServiceClient createAssetSetAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.AssetSetAssetServiceSettings settings =
          com.google.ads.googleads.v11.services.AssetSetAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AssetSetAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.AssetSetServiceClient createAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.AssetSetServiceSettings settings =
          com.google.ads.googleads.v11.services.AssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.AudienceServiceClient createAudienceServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.AudienceServiceSettings settings =
          com.google.ads.googleads.v11.services.AudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.AudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.BatchJobServiceClient createBatchJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.BatchJobServiceSettings settings =
          com.google.ads.googleads.v11.services.BatchJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.BatchJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.BiddingDataExclusionServiceClient createBiddingDataExclusionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.BiddingDataExclusionServiceSettings settings =
          com.google.ads.googleads.v11.services.BiddingDataExclusionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.BiddingDataExclusionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.BiddingSeasonalityAdjustmentServiceClient createBiddingSeasonalityAdjustmentServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.BiddingSeasonalityAdjustmentServiceSettings settings =
          com.google.ads.googleads.v11.services.BiddingSeasonalityAdjustmentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.BiddingSeasonalityAdjustmentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.BiddingStrategyServiceClient createBiddingStrategyServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.BiddingStrategyServiceSettings settings =
          com.google.ads.googleads.v11.services.BiddingStrategyServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.BiddingStrategyServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.BillingSetupServiceClient createBillingSetupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.BillingSetupServiceSettings settings =
          com.google.ads.googleads.v11.services.BillingSetupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.BillingSetupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CampaignAssetServiceClient createCampaignAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CampaignAssetServiceSettings settings =
          com.google.ads.googleads.v11.services.CampaignAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CampaignAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CampaignAssetSetServiceClient createCampaignAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CampaignAssetSetServiceSettings settings =
          com.google.ads.googleads.v11.services.CampaignAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CampaignAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CampaignBidModifierServiceClient createCampaignBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CampaignBidModifierServiceSettings settings =
          com.google.ads.googleads.v11.services.CampaignBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CampaignBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CampaignBudgetServiceClient createCampaignBudgetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CampaignBudgetServiceSettings settings =
          com.google.ads.googleads.v11.services.CampaignBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CampaignBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CampaignConversionGoalServiceClient createCampaignConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CampaignConversionGoalServiceSettings settings =
          com.google.ads.googleads.v11.services.CampaignConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CampaignConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CampaignCriterionServiceClient createCampaignCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CampaignCriterionServiceSettings settings =
          com.google.ads.googleads.v11.services.CampaignCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CampaignCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CampaignCustomizerServiceClient createCampaignCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CampaignCustomizerServiceSettings settings =
          com.google.ads.googleads.v11.services.CampaignCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CampaignCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CampaignDraftServiceClient createCampaignDraftServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CampaignDraftServiceSettings settings =
          com.google.ads.googleads.v11.services.CampaignDraftServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CampaignDraftServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CampaignExperimentServiceClient createCampaignExperimentServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CampaignExperimentServiceSettings settings =
          com.google.ads.googleads.v11.services.CampaignExperimentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CampaignExperimentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CampaignExtensionSettingServiceClient createCampaignExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CampaignExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v11.services.CampaignExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CampaignExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CampaignFeedServiceClient createCampaignFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CampaignFeedServiceSettings settings =
          com.google.ads.googleads.v11.services.CampaignFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CampaignFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CampaignGroupServiceClient createCampaignGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CampaignGroupServiceSettings settings =
          com.google.ads.googleads.v11.services.CampaignGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CampaignGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CampaignLabelServiceClient createCampaignLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CampaignLabelServiceSettings settings =
          com.google.ads.googleads.v11.services.CampaignLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CampaignLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CampaignServiceClient createCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CampaignServiceSettings settings =
          com.google.ads.googleads.v11.services.CampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CampaignSharedSetServiceClient createCampaignSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CampaignSharedSetServiceSettings settings =
          com.google.ads.googleads.v11.services.CampaignSharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CampaignSharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.ConversionActionServiceClient createConversionActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.ConversionActionServiceSettings settings =
          com.google.ads.googleads.v11.services.ConversionActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.ConversionActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.ConversionAdjustmentUploadServiceClient createConversionAdjustmentUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.ConversionAdjustmentUploadServiceSettings settings =
          com.google.ads.googleads.v11.services.ConversionAdjustmentUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.ConversionAdjustmentUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.ConversionCustomVariableServiceClient createConversionCustomVariableServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.ConversionCustomVariableServiceSettings settings =
          com.google.ads.googleads.v11.services.ConversionCustomVariableServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.ConversionCustomVariableServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.ConversionGoalCampaignConfigServiceClient createConversionGoalCampaignConfigServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.ConversionGoalCampaignConfigServiceSettings settings =
          com.google.ads.googleads.v11.services.ConversionGoalCampaignConfigServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.ConversionGoalCampaignConfigServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.ConversionUploadServiceClient createConversionUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.ConversionUploadServiceSettings settings =
          com.google.ads.googleads.v11.services.ConversionUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.ConversionUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.ConversionValueRuleServiceClient createConversionValueRuleServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.ConversionValueRuleServiceSettings settings =
          com.google.ads.googleads.v11.services.ConversionValueRuleServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.ConversionValueRuleServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.ConversionValueRuleSetServiceClient createConversionValueRuleSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.ConversionValueRuleSetServiceSettings settings =
          com.google.ads.googleads.v11.services.ConversionValueRuleSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.ConversionValueRuleSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CustomAudienceServiceClient createCustomAudienceServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CustomAudienceServiceSettings settings =
          com.google.ads.googleads.v11.services.CustomAudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CustomAudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CustomConversionGoalServiceClient createCustomConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CustomConversionGoalServiceSettings settings =
          com.google.ads.googleads.v11.services.CustomConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CustomConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CustomInterestServiceClient createCustomInterestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CustomInterestServiceSettings settings =
          com.google.ads.googleads.v11.services.CustomInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CustomInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CustomerAssetServiceClient createCustomerAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CustomerAssetServiceSettings settings =
          com.google.ads.googleads.v11.services.CustomerAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CustomerAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CustomerClientLinkServiceClient createCustomerClientLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CustomerClientLinkServiceSettings settings =
          com.google.ads.googleads.v11.services.CustomerClientLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CustomerClientLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CustomerConversionGoalServiceClient createCustomerConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CustomerConversionGoalServiceSettings settings =
          com.google.ads.googleads.v11.services.CustomerConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CustomerConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CustomerCustomizerServiceClient createCustomerCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CustomerCustomizerServiceSettings settings =
          com.google.ads.googleads.v11.services.CustomerCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CustomerCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CustomerExtensionSettingServiceClient createCustomerExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CustomerExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v11.services.CustomerExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CustomerExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CustomerFeedServiceClient createCustomerFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CustomerFeedServiceSettings settings =
          com.google.ads.googleads.v11.services.CustomerFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CustomerFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CustomerLabelServiceClient createCustomerLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CustomerLabelServiceSettings settings =
          com.google.ads.googleads.v11.services.CustomerLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CustomerLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CustomerManagerLinkServiceClient createCustomerManagerLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CustomerManagerLinkServiceSettings settings =
          com.google.ads.googleads.v11.services.CustomerManagerLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CustomerManagerLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CustomerNegativeCriterionServiceClient createCustomerNegativeCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CustomerNegativeCriterionServiceSettings settings =
          com.google.ads.googleads.v11.services.CustomerNegativeCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CustomerNegativeCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CustomerServiceClient createCustomerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CustomerServiceSettings settings =
          com.google.ads.googleads.v11.services.CustomerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CustomerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CustomerUserAccessInvitationServiceClient createCustomerUserAccessInvitationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CustomerUserAccessInvitationServiceSettings settings =
          com.google.ads.googleads.v11.services.CustomerUserAccessInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CustomerUserAccessInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CustomerUserAccessServiceClient createCustomerUserAccessServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CustomerUserAccessServiceSettings settings =
          com.google.ads.googleads.v11.services.CustomerUserAccessServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CustomerUserAccessServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.CustomizerAttributeServiceClient createCustomizerAttributeServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.CustomizerAttributeServiceSettings settings =
          com.google.ads.googleads.v11.services.CustomizerAttributeServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.CustomizerAttributeServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.ExperimentArmServiceClient createExperimentArmServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.ExperimentArmServiceSettings settings =
          com.google.ads.googleads.v11.services.ExperimentArmServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.ExperimentArmServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.ExperimentServiceClient createExperimentServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.ExperimentServiceSettings settings =
          com.google.ads.googleads.v11.services.ExperimentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.ExperimentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.ExtensionFeedItemServiceClient createExtensionFeedItemServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.ExtensionFeedItemServiceSettings settings =
          com.google.ads.googleads.v11.services.ExtensionFeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.ExtensionFeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.FeedItemServiceClient createFeedItemServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.FeedItemServiceSettings settings =
          com.google.ads.googleads.v11.services.FeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.FeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.FeedItemSetLinkServiceClient createFeedItemSetLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.FeedItemSetLinkServiceSettings settings =
          com.google.ads.googleads.v11.services.FeedItemSetLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.FeedItemSetLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.FeedItemSetServiceClient createFeedItemSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.FeedItemSetServiceSettings settings =
          com.google.ads.googleads.v11.services.FeedItemSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.FeedItemSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.FeedItemTargetServiceClient createFeedItemTargetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.FeedItemTargetServiceSettings settings =
          com.google.ads.googleads.v11.services.FeedItemTargetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.FeedItemTargetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.FeedMappingServiceClient createFeedMappingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.FeedMappingServiceSettings settings =
          com.google.ads.googleads.v11.services.FeedMappingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.FeedMappingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.FeedServiceClient createFeedServiceClient() {
      try {
        com.google.ads.googleads.v11.services.FeedServiceSettings settings =
          com.google.ads.googleads.v11.services.FeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.FeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.GeoTargetConstantServiceClient createGeoTargetConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.GeoTargetConstantServiceSettings settings =
          com.google.ads.googleads.v11.services.GeoTargetConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.GeoTargetConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.GoogleAdsFieldServiceClient createGoogleAdsFieldServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.GoogleAdsFieldServiceSettings settings =
          com.google.ads.googleads.v11.services.GoogleAdsFieldServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.GoogleAdsFieldServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.GoogleAdsServiceClient createGoogleAdsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.GoogleAdsServiceSettings settings =
          com.google.ads.googleads.v11.services.GoogleAdsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.GoogleAdsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.InvoiceServiceClient createInvoiceServiceClient() {
      try {
        com.google.ads.googleads.v11.services.InvoiceServiceSettings settings =
          com.google.ads.googleads.v11.services.InvoiceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.InvoiceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.KeywordPlanAdGroupKeywordServiceClient createKeywordPlanAdGroupKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.KeywordPlanAdGroupKeywordServiceSettings settings =
          com.google.ads.googleads.v11.services.KeywordPlanAdGroupKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.KeywordPlanAdGroupKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.KeywordPlanAdGroupServiceClient createKeywordPlanAdGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.KeywordPlanAdGroupServiceSettings settings =
          com.google.ads.googleads.v11.services.KeywordPlanAdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.KeywordPlanAdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.KeywordPlanCampaignKeywordServiceClient createKeywordPlanCampaignKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.KeywordPlanCampaignKeywordServiceSettings settings =
          com.google.ads.googleads.v11.services.KeywordPlanCampaignKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.KeywordPlanCampaignKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.KeywordPlanCampaignServiceClient createKeywordPlanCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.KeywordPlanCampaignServiceSettings settings =
          com.google.ads.googleads.v11.services.KeywordPlanCampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.KeywordPlanCampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.KeywordPlanIdeaServiceClient createKeywordPlanIdeaServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.KeywordPlanIdeaServiceSettings settings =
          com.google.ads.googleads.v11.services.KeywordPlanIdeaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.KeywordPlanIdeaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.KeywordPlanServiceClient createKeywordPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.KeywordPlanServiceSettings settings =
          com.google.ads.googleads.v11.services.KeywordPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.KeywordPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.KeywordThemeConstantServiceClient createKeywordThemeConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.KeywordThemeConstantServiceSettings settings =
          com.google.ads.googleads.v11.services.KeywordThemeConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.KeywordThemeConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.LabelServiceClient createLabelServiceClient() {
      try {
        com.google.ads.googleads.v11.services.LabelServiceSettings settings =
          com.google.ads.googleads.v11.services.LabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.LabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.MediaFileServiceClient createMediaFileServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.MediaFileServiceSettings settings =
          com.google.ads.googleads.v11.services.MediaFileServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.MediaFileServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.MerchantCenterLinkServiceClient createMerchantCenterLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.MerchantCenterLinkServiceSettings settings =
          com.google.ads.googleads.v11.services.MerchantCenterLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.MerchantCenterLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.OfflineUserDataJobServiceClient createOfflineUserDataJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.OfflineUserDataJobServiceSettings settings =
          com.google.ads.googleads.v11.services.OfflineUserDataJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.OfflineUserDataJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.PaymentsAccountServiceClient createPaymentsAccountServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.PaymentsAccountServiceSettings settings =
          com.google.ads.googleads.v11.services.PaymentsAccountServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.PaymentsAccountServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.ReachPlanServiceClient createReachPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.ReachPlanServiceSettings settings =
          com.google.ads.googleads.v11.services.ReachPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.ReachPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.RecommendationServiceClient createRecommendationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.RecommendationServiceSettings settings =
          com.google.ads.googleads.v11.services.RecommendationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.RecommendationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.RemarketingActionServiceClient createRemarketingActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.RemarketingActionServiceSettings settings =
          com.google.ads.googleads.v11.services.RemarketingActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.RemarketingActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.SharedCriterionServiceClient createSharedCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.SharedCriterionServiceSettings settings =
          com.google.ads.googleads.v11.services.SharedCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.SharedCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.SharedSetServiceClient createSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.SharedSetServiceSettings settings =
          com.google.ads.googleads.v11.services.SharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.SharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.SmartCampaignSettingServiceClient createSmartCampaignSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.SmartCampaignSettingServiceSettings settings =
          com.google.ads.googleads.v11.services.SmartCampaignSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.SmartCampaignSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.SmartCampaignSuggestServiceClient createSmartCampaignSuggestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.SmartCampaignSuggestServiceSettings settings =
          com.google.ads.googleads.v11.services.SmartCampaignSuggestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.SmartCampaignSuggestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.ThirdPartyAppAnalyticsLinkServiceClient createThirdPartyAppAnalyticsLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.ThirdPartyAppAnalyticsLinkServiceSettings settings =
          com.google.ads.googleads.v11.services.ThirdPartyAppAnalyticsLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.ThirdPartyAppAnalyticsLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.UserDataServiceClient createUserDataServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.UserDataServiceSettings settings =
          com.google.ads.googleads.v11.services.UserDataServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.UserDataServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v11.services.UserListServiceClient createUserListServiceClient(
        ) {
      try {
        com.google.ads.googleads.v11.services.UserListServiceSettings settings =
          com.google.ads.googleads.v11.services.UserListServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v11.services.UserListServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AudienceInsightsServiceClient createAudienceInsightsServiceClient() {
      try {
        AudienceInsightsServiceSettings settings =
          AudienceInsightsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AudienceInsightsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }
  }
}
