/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for FirewallPolicyAssociation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FirewallPolicyAssociation extends com.google.api.client.json.GenericJson {

  /**
   * The target that the firewall policy is attached to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String attachmentTarget;

  /**
   * [Output Only] Deprecated, please use short name instead. The display name of the firewall
   * policy of the association.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * [Output Only] The firewall policy ID of the association.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String firewallPolicyId;

  /**
   * The name for an association.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output Only] The short name of the firewall policy of the association.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String shortName;

  /**
   * The target that the firewall policy is attached to.
   * @return value or {@code null} for none
   */
  public java.lang.String getAttachmentTarget() {
    return attachmentTarget;
  }

  /**
   * The target that the firewall policy is attached to.
   * @param attachmentTarget attachmentTarget or {@code null} for none
   */
  public FirewallPolicyAssociation setAttachmentTarget(java.lang.String attachmentTarget) {
    this.attachmentTarget = attachmentTarget;
    return this;
  }

  /**
   * [Output Only] Deprecated, please use short name instead. The display name of the firewall
   * policy of the association.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * [Output Only] Deprecated, please use short name instead. The display name of the firewall
   * policy of the association.
   * @param displayName displayName or {@code null} for none
   */
  public FirewallPolicyAssociation setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * [Output Only] The firewall policy ID of the association.
   * @return value or {@code null} for none
   */
  public java.lang.String getFirewallPolicyId() {
    return firewallPolicyId;
  }

  /**
   * [Output Only] The firewall policy ID of the association.
   * @param firewallPolicyId firewallPolicyId or {@code null} for none
   */
  public FirewallPolicyAssociation setFirewallPolicyId(java.lang.String firewallPolicyId) {
    this.firewallPolicyId = firewallPolicyId;
    return this;
  }

  /**
   * The name for an association.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name for an association.
   * @param name name or {@code null} for none
   */
  public FirewallPolicyAssociation setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output Only] The short name of the firewall policy of the association.
   * @return value or {@code null} for none
   */
  public java.lang.String getShortName() {
    return shortName;
  }

  /**
   * [Output Only] The short name of the firewall policy of the association.
   * @param shortName shortName or {@code null} for none
   */
  public FirewallPolicyAssociation setShortName(java.lang.String shortName) {
    this.shortName = shortName;
    return this;
  }

  @Override
  public FirewallPolicyAssociation set(String fieldName, Object value) {
    return (FirewallPolicyAssociation) super.set(fieldName, value);
  }

  @Override
  public FirewallPolicyAssociation clone() {
    return (FirewallPolicyAssociation) super.clone();
  }

}
