/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.fcmdata.v1beta1.model;

/**
 * Data detailing messaging delivery
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Firebase Cloud Messaging Data API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleFirebaseFcmDataV1beta1Data extends com.google.api.client.json.GenericJson {

  /**
   * Count of messages accepted by FCM intended for Android devices. The targeted device must have
   * opted in to the collection of usage and diagnostic information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long countMessagesAccepted;

  /**
   * Count of notifications accepted by FCM intended for Android devices. The targeted device must
   * have opted in to the collection of usage and diagnostic information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long countNotificationsAccepted;

  /**
   * Additional information about delivery performance for messages that were successfully
   * delivered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleFirebaseFcmDataV1beta1DeliveryPerformancePercents deliveryPerformancePercents;

  /**
   * Additional general insights about message delivery.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleFirebaseFcmDataV1beta1MessageInsightPercents messageInsightPercents;

  /**
   * Mutually exclusive breakdown of message delivery outcomes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleFirebaseFcmDataV1beta1MessageOutcomePercents messageOutcomePercents;

  /**
   * Additional insights about proxy notification delivery.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleFirebaseFcmDataV1beta1ProxyNotificationInsightPercents proxyNotificationInsightPercents;

  /**
   * Count of messages accepted by FCM intended for Android devices. The targeted device must have
   * opted in to the collection of usage and diagnostic information.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCountMessagesAccepted() {
    return countMessagesAccepted;
  }

  /**
   * Count of messages accepted by FCM intended for Android devices. The targeted device must have
   * opted in to the collection of usage and diagnostic information.
   * @param countMessagesAccepted countMessagesAccepted or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1Data setCountMessagesAccepted(java.lang.Long countMessagesAccepted) {
    this.countMessagesAccepted = countMessagesAccepted;
    return this;
  }

  /**
   * Count of notifications accepted by FCM intended for Android devices. The targeted device must
   * have opted in to the collection of usage and diagnostic information.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCountNotificationsAccepted() {
    return countNotificationsAccepted;
  }

  /**
   * Count of notifications accepted by FCM intended for Android devices. The targeted device must
   * have opted in to the collection of usage and diagnostic information.
   * @param countNotificationsAccepted countNotificationsAccepted or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1Data setCountNotificationsAccepted(java.lang.Long countNotificationsAccepted) {
    this.countNotificationsAccepted = countNotificationsAccepted;
    return this;
  }

  /**
   * Additional information about delivery performance for messages that were successfully
   * delivered.
   * @return value or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1DeliveryPerformancePercents getDeliveryPerformancePercents() {
    return deliveryPerformancePercents;
  }

  /**
   * Additional information about delivery performance for messages that were successfully
   * delivered.
   * @param deliveryPerformancePercents deliveryPerformancePercents or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1Data setDeliveryPerformancePercents(GoogleFirebaseFcmDataV1beta1DeliveryPerformancePercents deliveryPerformancePercents) {
    this.deliveryPerformancePercents = deliveryPerformancePercents;
    return this;
  }

  /**
   * Additional general insights about message delivery.
   * @return value or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1MessageInsightPercents getMessageInsightPercents() {
    return messageInsightPercents;
  }

  /**
   * Additional general insights about message delivery.
   * @param messageInsightPercents messageInsightPercents or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1Data setMessageInsightPercents(GoogleFirebaseFcmDataV1beta1MessageInsightPercents messageInsightPercents) {
    this.messageInsightPercents = messageInsightPercents;
    return this;
  }

  /**
   * Mutually exclusive breakdown of message delivery outcomes.
   * @return value or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1MessageOutcomePercents getMessageOutcomePercents() {
    return messageOutcomePercents;
  }

  /**
   * Mutually exclusive breakdown of message delivery outcomes.
   * @param messageOutcomePercents messageOutcomePercents or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1Data setMessageOutcomePercents(GoogleFirebaseFcmDataV1beta1MessageOutcomePercents messageOutcomePercents) {
    this.messageOutcomePercents = messageOutcomePercents;
    return this;
  }

  /**
   * Additional insights about proxy notification delivery.
   * @return value or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1ProxyNotificationInsightPercents getProxyNotificationInsightPercents() {
    return proxyNotificationInsightPercents;
  }

  /**
   * Additional insights about proxy notification delivery.
   * @param proxyNotificationInsightPercents proxyNotificationInsightPercents or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1Data setProxyNotificationInsightPercents(GoogleFirebaseFcmDataV1beta1ProxyNotificationInsightPercents proxyNotificationInsightPercents) {
    this.proxyNotificationInsightPercents = proxyNotificationInsightPercents;
    return this;
  }

  @Override
  public GoogleFirebaseFcmDataV1beta1Data set(String fieldName, Object value) {
    return (GoogleFirebaseFcmDataV1beta1Data) super.set(fieldName, value);
  }

  @Override
  public GoogleFirebaseFcmDataV1beta1Data clone() {
    return (GoogleFirebaseFcmDataV1beta1Data) super.clone();
  }

}
