/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.fcmdata.v1beta1.model;

/**
 * Overview of delivery performance for messages that were successfully delivered. All percentages
 * are calculated with countMessagesAccepted as the denominator. These categories are not mutually
 * exclusive; a message can be delayed for multiple reasons.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Firebase Cloud Messaging Data API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleFirebaseFcmDataV1beta1DeliveryPerformancePercents extends com.google.api.client.json.GenericJson {

  /**
   * The percentage of accepted messages that were delayed because the device was in doze mode. Only
   * [normal priority messages](https://firebase.google.com/docs/cloud-messaging/concept-
   * options#setting-the-priority-of-a-message) should be delayed due to doze mode.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float delayedDeviceDoze;

  /**
   * The percentage of accepted messages that were delayed because the target device was not
   * connected at the time of sending. These messages were eventually delivered when the device
   * reconnected.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float delayedDeviceOffline;

  /**
   * The percentage of accepted messages that were delayed due to message throttling, such as
   * [collapsible message throttling](https://firebase.google.com/docs/cloud-messaging/concept-
   * options#collapsible_throttling) or [maximum message rate
   * throttling](https://firebase.google.com/docs/cloud-messaging/concept-
   * options#device_throttling).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float delayedMessageThrottled;

  /**
   * The percentage of accepted messages that were delayed because the intended device user-profile
   * was [stopped](https://firebase.google.com/docs/cloud-
   * messaging/android/receive#handling_messages) on the target device at the time of the send. The
   * messages were eventually delivered when the user-profile was started again.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float delayedUserStopped;

  /**
   * The percentage of accepted messages that were delivered to the device without delay from the
   * FCM system.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float deliveredNoDelay;

  /**
   * The percentage of accepted messages that were delayed because the device was in doze mode. Only
   * [normal priority messages](https://firebase.google.com/docs/cloud-messaging/concept-
   * options#setting-the-priority-of-a-message) should be delayed due to doze mode.
   * @return value or {@code null} for none
   */
  public java.lang.Float getDelayedDeviceDoze() {
    return delayedDeviceDoze;
  }

  /**
   * The percentage of accepted messages that were delayed because the device was in doze mode. Only
   * [normal priority messages](https://firebase.google.com/docs/cloud-messaging/concept-
   * options#setting-the-priority-of-a-message) should be delayed due to doze mode.
   * @param delayedDeviceDoze delayedDeviceDoze or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1DeliveryPerformancePercents setDelayedDeviceDoze(java.lang.Float delayedDeviceDoze) {
    this.delayedDeviceDoze = delayedDeviceDoze;
    return this;
  }

  /**
   * The percentage of accepted messages that were delayed because the target device was not
   * connected at the time of sending. These messages were eventually delivered when the device
   * reconnected.
   * @return value or {@code null} for none
   */
  public java.lang.Float getDelayedDeviceOffline() {
    return delayedDeviceOffline;
  }

  /**
   * The percentage of accepted messages that were delayed because the target device was not
   * connected at the time of sending. These messages were eventually delivered when the device
   * reconnected.
   * @param delayedDeviceOffline delayedDeviceOffline or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1DeliveryPerformancePercents setDelayedDeviceOffline(java.lang.Float delayedDeviceOffline) {
    this.delayedDeviceOffline = delayedDeviceOffline;
    return this;
  }

  /**
   * The percentage of accepted messages that were delayed due to message throttling, such as
   * [collapsible message throttling](https://firebase.google.com/docs/cloud-messaging/concept-
   * options#collapsible_throttling) or [maximum message rate
   * throttling](https://firebase.google.com/docs/cloud-messaging/concept-
   * options#device_throttling).
   * @return value or {@code null} for none
   */
  public java.lang.Float getDelayedMessageThrottled() {
    return delayedMessageThrottled;
  }

  /**
   * The percentage of accepted messages that were delayed due to message throttling, such as
   * [collapsible message throttling](https://firebase.google.com/docs/cloud-messaging/concept-
   * options#collapsible_throttling) or [maximum message rate
   * throttling](https://firebase.google.com/docs/cloud-messaging/concept-
   * options#device_throttling).
   * @param delayedMessageThrottled delayedMessageThrottled or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1DeliveryPerformancePercents setDelayedMessageThrottled(java.lang.Float delayedMessageThrottled) {
    this.delayedMessageThrottled = delayedMessageThrottled;
    return this;
  }

  /**
   * The percentage of accepted messages that were delayed because the intended device user-profile
   * was [stopped](https://firebase.google.com/docs/cloud-
   * messaging/android/receive#handling_messages) on the target device at the time of the send. The
   * messages were eventually delivered when the user-profile was started again.
   * @return value or {@code null} for none
   */
  public java.lang.Float getDelayedUserStopped() {
    return delayedUserStopped;
  }

  /**
   * The percentage of accepted messages that were delayed because the intended device user-profile
   * was [stopped](https://firebase.google.com/docs/cloud-
   * messaging/android/receive#handling_messages) on the target device at the time of the send. The
   * messages were eventually delivered when the user-profile was started again.
   * @param delayedUserStopped delayedUserStopped or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1DeliveryPerformancePercents setDelayedUserStopped(java.lang.Float delayedUserStopped) {
    this.delayedUserStopped = delayedUserStopped;
    return this;
  }

  /**
   * The percentage of accepted messages that were delivered to the device without delay from the
   * FCM system.
   * @return value or {@code null} for none
   */
  public java.lang.Float getDeliveredNoDelay() {
    return deliveredNoDelay;
  }

  /**
   * The percentage of accepted messages that were delivered to the device without delay from the
   * FCM system.
   * @param deliveredNoDelay deliveredNoDelay or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1DeliveryPerformancePercents setDeliveredNoDelay(java.lang.Float deliveredNoDelay) {
    this.deliveredNoDelay = deliveredNoDelay;
    return this;
  }

  @Override
  public GoogleFirebaseFcmDataV1beta1DeliveryPerformancePercents set(String fieldName, Object value) {
    return (GoogleFirebaseFcmDataV1beta1DeliveryPerformancePercents) super.set(fieldName, value);
  }

  @Override
  public GoogleFirebaseFcmDataV1beta1DeliveryPerformancePercents clone() {
    return (GoogleFirebaseFcmDataV1beta1DeliveryPerformancePercents) super.clone();
  }

}
