/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.fcmdata.v1beta1.model;

/**
 * Percentage breakdown of message delivery outcomes. These categories are mutually exclusive. All
 * percentages are calculated with countMessagesAccepted as the denominator. These categories may
 * not account for all message outcomes.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Firebase Cloud Messaging Data API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleFirebaseFcmDataV1beta1MessageOutcomePercents extends com.google.api.client.json.GenericJson {

  /**
   * The percentage of accepted messages that were
   * [collapsed](https://firebase.google.com/docs/cloud-messaging/concept-
   * options#collapsible_and_non-collapsible_messages) by another message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float collapsed;

  /**
   * The percentage of all accepted messages that were successfully delivered to the device.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float delivered;

  /**
   * The percentage of accepted messages that were dropped because the application was force stopped
   * on the device at the time of delivery and retries were unsuccessful.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float droppedAppForceStopped;

  /**
   * The percentage of accepted messages that were dropped because the target device is inactive.
   * FCM will drop messages if the target device is deemed inactive by our servers. If a device does
   * reconnect, we call [OnDeletedMessages()](https://firebase.google.com/docs/cloud-
   * messaging/android/receive#override-ondeletedmessages) in our SDK instead of delivering the
   * messages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float droppedDeviceInactive;

  /**
   * The percentage of accepted messages that were dropped due to [too many undelivered non-
   * collapsible messages](https://firebase.google.com/docs/cloud-messaging/concept-
   * options#collapsible_and_non-collapsible_messages). Specifically, each app instance can only
   * have 100 pending messages stored on our servers for a device which is disconnected. When that
   * device reconnects, those messages are delivered. When there are more than the maximum pending
   * messages, we call [OnDeletedMessages()](https://firebase.google.com/docs/cloud-
   * messaging/android/receive#override-ondeletedmessages) in our SDK instead of delivering the
   * messages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float droppedTooManyPendingMessages;

  /**
   * The percentage of accepted messages that expired because [Time To Live
   * (TTL)](https://firebase.google.com/docs/cloud-messaging/concept-options#ttl) elapsed before the
   * target device reconnected.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float droppedTtlExpired;

  /**
   * The percentage of messages accepted on this day that were not dropped and not delivered, due to
   * the device being disconnected (as of the end of the America/Los_Angeles day when the message
   * was sent to FCM). A portion of these messages will be delivered the next day when the device
   * connects but others may be destined to devices that ultimately never reconnect.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float pending;

  /**
   * The percentage of accepted messages that were
   * [collapsed](https://firebase.google.com/docs/cloud-messaging/concept-
   * options#collapsible_and_non-collapsible_messages) by another message.
   * @return value or {@code null} for none
   */
  public java.lang.Float getCollapsed() {
    return collapsed;
  }

  /**
   * The percentage of accepted messages that were
   * [collapsed](https://firebase.google.com/docs/cloud-messaging/concept-
   * options#collapsible_and_non-collapsible_messages) by another message.
   * @param collapsed collapsed or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1MessageOutcomePercents setCollapsed(java.lang.Float collapsed) {
    this.collapsed = collapsed;
    return this;
  }

  /**
   * The percentage of all accepted messages that were successfully delivered to the device.
   * @return value or {@code null} for none
   */
  public java.lang.Float getDelivered() {
    return delivered;
  }

  /**
   * The percentage of all accepted messages that were successfully delivered to the device.
   * @param delivered delivered or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1MessageOutcomePercents setDelivered(java.lang.Float delivered) {
    this.delivered = delivered;
    return this;
  }

  /**
   * The percentage of accepted messages that were dropped because the application was force stopped
   * on the device at the time of delivery and retries were unsuccessful.
   * @return value or {@code null} for none
   */
  public java.lang.Float getDroppedAppForceStopped() {
    return droppedAppForceStopped;
  }

  /**
   * The percentage of accepted messages that were dropped because the application was force stopped
   * on the device at the time of delivery and retries were unsuccessful.
   * @param droppedAppForceStopped droppedAppForceStopped or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1MessageOutcomePercents setDroppedAppForceStopped(java.lang.Float droppedAppForceStopped) {
    this.droppedAppForceStopped = droppedAppForceStopped;
    return this;
  }

  /**
   * The percentage of accepted messages that were dropped because the target device is inactive.
   * FCM will drop messages if the target device is deemed inactive by our servers. If a device does
   * reconnect, we call [OnDeletedMessages()](https://firebase.google.com/docs/cloud-
   * messaging/android/receive#override-ondeletedmessages) in our SDK instead of delivering the
   * messages.
   * @return value or {@code null} for none
   */
  public java.lang.Float getDroppedDeviceInactive() {
    return droppedDeviceInactive;
  }

  /**
   * The percentage of accepted messages that were dropped because the target device is inactive.
   * FCM will drop messages if the target device is deemed inactive by our servers. If a device does
   * reconnect, we call [OnDeletedMessages()](https://firebase.google.com/docs/cloud-
   * messaging/android/receive#override-ondeletedmessages) in our SDK instead of delivering the
   * messages.
   * @param droppedDeviceInactive droppedDeviceInactive or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1MessageOutcomePercents setDroppedDeviceInactive(java.lang.Float droppedDeviceInactive) {
    this.droppedDeviceInactive = droppedDeviceInactive;
    return this;
  }

  /**
   * The percentage of accepted messages that were dropped due to [too many undelivered non-
   * collapsible messages](https://firebase.google.com/docs/cloud-messaging/concept-
   * options#collapsible_and_non-collapsible_messages). Specifically, each app instance can only
   * have 100 pending messages stored on our servers for a device which is disconnected. When that
   * device reconnects, those messages are delivered. When there are more than the maximum pending
   * messages, we call [OnDeletedMessages()](https://firebase.google.com/docs/cloud-
   * messaging/android/receive#override-ondeletedmessages) in our SDK instead of delivering the
   * messages.
   * @return value or {@code null} for none
   */
  public java.lang.Float getDroppedTooManyPendingMessages() {
    return droppedTooManyPendingMessages;
  }

  /**
   * The percentage of accepted messages that were dropped due to [too many undelivered non-
   * collapsible messages](https://firebase.google.com/docs/cloud-messaging/concept-
   * options#collapsible_and_non-collapsible_messages). Specifically, each app instance can only
   * have 100 pending messages stored on our servers for a device which is disconnected. When that
   * device reconnects, those messages are delivered. When there are more than the maximum pending
   * messages, we call [OnDeletedMessages()](https://firebase.google.com/docs/cloud-
   * messaging/android/receive#override-ondeletedmessages) in our SDK instead of delivering the
   * messages.
   * @param droppedTooManyPendingMessages droppedTooManyPendingMessages or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1MessageOutcomePercents setDroppedTooManyPendingMessages(java.lang.Float droppedTooManyPendingMessages) {
    this.droppedTooManyPendingMessages = droppedTooManyPendingMessages;
    return this;
  }

  /**
   * The percentage of accepted messages that expired because [Time To Live
   * (TTL)](https://firebase.google.com/docs/cloud-messaging/concept-options#ttl) elapsed before the
   * target device reconnected.
   * @return value or {@code null} for none
   */
  public java.lang.Float getDroppedTtlExpired() {
    return droppedTtlExpired;
  }

  /**
   * The percentage of accepted messages that expired because [Time To Live
   * (TTL)](https://firebase.google.com/docs/cloud-messaging/concept-options#ttl) elapsed before the
   * target device reconnected.
   * @param droppedTtlExpired droppedTtlExpired or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1MessageOutcomePercents setDroppedTtlExpired(java.lang.Float droppedTtlExpired) {
    this.droppedTtlExpired = droppedTtlExpired;
    return this;
  }

  /**
   * The percentage of messages accepted on this day that were not dropped and not delivered, due to
   * the device being disconnected (as of the end of the America/Los_Angeles day when the message
   * was sent to FCM). A portion of these messages will be delivered the next day when the device
   * connects but others may be destined to devices that ultimately never reconnect.
   * @return value or {@code null} for none
   */
  public java.lang.Float getPending() {
    return pending;
  }

  /**
   * The percentage of messages accepted on this day that were not dropped and not delivered, due to
   * the device being disconnected (as of the end of the America/Los_Angeles day when the message
   * was sent to FCM). A portion of these messages will be delivered the next day when the device
   * connects but others may be destined to devices that ultimately never reconnect.
   * @param pending pending or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1MessageOutcomePercents setPending(java.lang.Float pending) {
    this.pending = pending;
    return this;
  }

  @Override
  public GoogleFirebaseFcmDataV1beta1MessageOutcomePercents set(String fieldName, Object value) {
    return (GoogleFirebaseFcmDataV1beta1MessageOutcomePercents) super.set(fieldName, value);
  }

  @Override
  public GoogleFirebaseFcmDataV1beta1MessageOutcomePercents clone() {
    return (GoogleFirebaseFcmDataV1beta1MessageOutcomePercents) super.clone();
  }

}
