/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.fcmdata.v1beta1.model;

/**
 * Additional information about [proxy notification](https://firebase.google.com/docs/cloud-
 * messaging/android/message-priority#proxy) delivery. All percentages are calculated with
 * countNotificationsAccepted as the denominator.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Firebase Cloud Messaging Data API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleFirebaseFcmDataV1beta1ProxyNotificationInsightPercents extends com.google.api.client.json.GenericJson {

  /**
   * The percentage of accepted notifications that failed to be proxied. This is usually caused by
   * exceptions that occurred while calling [notifyAsPackage](https://developer.android.com/referenc
   * e/android/app/NotificationManager#notifyAsPackage%28java.lang.String,%20java.lang.String,%20int
   * ,%20android.app.Notification%29).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float failed;

  /**
   * The percentage of accepted notifications that were successfully proxied by [Google Play
   * services](https://developers.google.com/android/guides/overview).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float proxied;

  /**
   * The percentage of accepted notifications that were skipped because the messages were not
   * throttled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float skippedNotThrottled;

  /**
   * The percentage of accepted notifications that were skipped because the app disallowed these
   * messages to be proxied.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float skippedOptedOut;

  /**
   * The percentage of accepted notifications that were skipped because configurations required for
   * notifications to be proxied were missing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float skippedUnconfigured;

  /**
   * The percentage of accepted notifications that were skipped because proxy notification is
   * unsupported for the recipient.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float skippedUnsupported;

  /**
   * The percentage of accepted notifications that failed to be proxied. This is usually caused by
   * exceptions that occurred while calling [notifyAsPackage](https://developer.android.com/referenc
   * e/android/app/NotificationManager#notifyAsPackage%28java.lang.String,%20java.lang.String,%20int
   * ,%20android.app.Notification%29).
   * @return value or {@code null} for none
   */
  public java.lang.Float getFailed() {
    return failed;
  }

  /**
   * The percentage of accepted notifications that failed to be proxied. This is usually caused by
   * exceptions that occurred while calling [notifyAsPackage](https://developer.android.com/referenc
   * e/android/app/NotificationManager#notifyAsPackage%28java.lang.String,%20java.lang.String,%20int
   * ,%20android.app.Notification%29).
   * @param failed failed or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1ProxyNotificationInsightPercents setFailed(java.lang.Float failed) {
    this.failed = failed;
    return this;
  }

  /**
   * The percentage of accepted notifications that were successfully proxied by [Google Play
   * services](https://developers.google.com/android/guides/overview).
   * @return value or {@code null} for none
   */
  public java.lang.Float getProxied() {
    return proxied;
  }

  /**
   * The percentage of accepted notifications that were successfully proxied by [Google Play
   * services](https://developers.google.com/android/guides/overview).
   * @param proxied proxied or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1ProxyNotificationInsightPercents setProxied(java.lang.Float proxied) {
    this.proxied = proxied;
    return this;
  }

  /**
   * The percentage of accepted notifications that were skipped because the messages were not
   * throttled.
   * @return value or {@code null} for none
   */
  public java.lang.Float getSkippedNotThrottled() {
    return skippedNotThrottled;
  }

  /**
   * The percentage of accepted notifications that were skipped because the messages were not
   * throttled.
   * @param skippedNotThrottled skippedNotThrottled or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1ProxyNotificationInsightPercents setSkippedNotThrottled(java.lang.Float skippedNotThrottled) {
    this.skippedNotThrottled = skippedNotThrottled;
    return this;
  }

  /**
   * The percentage of accepted notifications that were skipped because the app disallowed these
   * messages to be proxied.
   * @return value or {@code null} for none
   */
  public java.lang.Float getSkippedOptedOut() {
    return skippedOptedOut;
  }

  /**
   * The percentage of accepted notifications that were skipped because the app disallowed these
   * messages to be proxied.
   * @param skippedOptedOut skippedOptedOut or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1ProxyNotificationInsightPercents setSkippedOptedOut(java.lang.Float skippedOptedOut) {
    this.skippedOptedOut = skippedOptedOut;
    return this;
  }

  /**
   * The percentage of accepted notifications that were skipped because configurations required for
   * notifications to be proxied were missing.
   * @return value or {@code null} for none
   */
  public java.lang.Float getSkippedUnconfigured() {
    return skippedUnconfigured;
  }

  /**
   * The percentage of accepted notifications that were skipped because configurations required for
   * notifications to be proxied were missing.
   * @param skippedUnconfigured skippedUnconfigured or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1ProxyNotificationInsightPercents setSkippedUnconfigured(java.lang.Float skippedUnconfigured) {
    this.skippedUnconfigured = skippedUnconfigured;
    return this;
  }

  /**
   * The percentage of accepted notifications that were skipped because proxy notification is
   * unsupported for the recipient.
   * @return value or {@code null} for none
   */
  public java.lang.Float getSkippedUnsupported() {
    return skippedUnsupported;
  }

  /**
   * The percentage of accepted notifications that were skipped because proxy notification is
   * unsupported for the recipient.
   * @param skippedUnsupported skippedUnsupported or {@code null} for none
   */
  public GoogleFirebaseFcmDataV1beta1ProxyNotificationInsightPercents setSkippedUnsupported(java.lang.Float skippedUnsupported) {
    this.skippedUnsupported = skippedUnsupported;
    return this;
  }

  @Override
  public GoogleFirebaseFcmDataV1beta1ProxyNotificationInsightPercents set(String fieldName, Object value) {
    return (GoogleFirebaseFcmDataV1beta1ProxyNotificationInsightPercents) super.set(fieldName, value);
  }

  @Override
  public GoogleFirebaseFcmDataV1beta1ProxyNotificationInsightPercents clone() {
    return (GoogleFirebaseFcmDataV1beta1ProxyNotificationInsightPercents) super.clone();
  }

}
