/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.sqladmin;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.sqladmin.SQLAdminRequest;
import com.google.api.services.sqladmin.SQLAdminRequestInitializer;
import com.google.api.services.sqladmin.model.BackupRun;
import com.google.api.services.sqladmin.model.BackupRunsListResponse;
import com.google.api.services.sqladmin.model.ConnectSettings;
import com.google.api.services.sqladmin.model.Database;
import com.google.api.services.sqladmin.model.DatabaseInstance;
import com.google.api.services.sqladmin.model.DatabasesListResponse;
import com.google.api.services.sqladmin.model.FlagsListResponse;
import com.google.api.services.sqladmin.model.GenerateEphemeralCertRequest;
import com.google.api.services.sqladmin.model.GenerateEphemeralCertResponse;
import com.google.api.services.sqladmin.model.InstancesCloneRequest;
import com.google.api.services.sqladmin.model.InstancesDemoteMasterRequest;
import com.google.api.services.sqladmin.model.InstancesExportRequest;
import com.google.api.services.sqladmin.model.InstancesFailoverRequest;
import com.google.api.services.sqladmin.model.InstancesImportRequest;
import com.google.api.services.sqladmin.model.InstancesListResponse;
import com.google.api.services.sqladmin.model.InstancesListServerCasResponse;
import com.google.api.services.sqladmin.model.InstancesRestoreBackupRequest;
import com.google.api.services.sqladmin.model.InstancesRotateServerCaRequest;
import com.google.api.services.sqladmin.model.InstancesTruncateLogRequest;
import com.google.api.services.sqladmin.model.Operation;
import com.google.api.services.sqladmin.model.OperationsListResponse;
import com.google.api.services.sqladmin.model.SqlInstancesRescheduleMaintenanceRequestBody;
import com.google.api.services.sqladmin.model.SqlInstancesStartExternalSyncRequest;
import com.google.api.services.sqladmin.model.SqlInstancesVerifyExternalSyncSettingsRequest;
import com.google.api.services.sqladmin.model.SqlInstancesVerifyExternalSyncSettingsResponse;
import com.google.api.services.sqladmin.model.SslCert;
import com.google.api.services.sqladmin.model.SslCertsCreateEphemeralRequest;
import com.google.api.services.sqladmin.model.SslCertsInsertRequest;
import com.google.api.services.sqladmin.model.SslCertsInsertResponse;
import com.google.api.services.sqladmin.model.SslCertsListResponse;
import com.google.api.services.sqladmin.model.TiersListResponse;
import com.google.api.services.sqladmin.model.User;
import com.google.api.services.sqladmin.model.UsersListResponse;
import java.io.IOException;

public class SQLAdmin
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://sqladmin.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://sqladmin.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://sqladmin.googleapis.com/";

    public SQLAdmin(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    SQLAdmin(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public BackupRuns backupRuns() {
        return new BackupRuns();
    }

    public Connect connect() {
        return new Connect();
    }

    public Databases databases() {
        return new Databases();
    }

    public Flags flags() {
        return new Flags();
    }

    public Instances instances() {
        return new Instances();
    }

    public Operations operations() {
        return new Operations();
    }

    public Projects projects() {
        return new Projects();
    }

    public SslCerts sslCerts() {
        return new SslCerts();
    }

    public Tiers tiers() {
        return new Tiers();
    }

    public Users users() {
        return new Users();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Cloud SQL Admin API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return SQLAdmin.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://sqladmin.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), SQLAdmin.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(SQLAdmin.DEFAULT_BATCH_PATH);
        }

        public SQLAdmin build() {
            return new SQLAdmin(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setSQLAdminRequestInitializer(SQLAdminRequestInitializer sqladminRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)sqladminRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Users {
        public Delete delete(String project, String instance) throws IOException {
            Delete result = new Delete(project, instance);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String instance, String name) throws IOException {
            Get result = new Get(project, instance, name);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, String instance, User content) throws IOException {
            Insert result = new Insert(project, instance, content);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project, String instance) throws IOException {
            List result = new List(project, instance);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String project, String instance, User content) throws IOException {
            Update result = new Update(project, instance, content);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/users";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private String host;
            @Key
            private String name;

            protected Update(String project, String instance, User content) {
                super(SQLAdmin.this, "PUT", REST_PATH, (Object)content, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Update setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            public String getHost() {
                return this.host;
            }

            public Update setHost(String host) {
                this.host = host;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public Update setName(String name) {
                this.name = name;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends SQLAdminRequest<UsersListResponse> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/users";
            @Key
            private String project;
            @Key
            private String instance;

            protected List(String project, String instance) {
                super(SQLAdmin.this, "GET", REST_PATH, null, UsersListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public List setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/users";
            @Key
            private String project;
            @Key
            private String instance;

            protected Insert(String project, String instance, User content) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Insert setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends SQLAdminRequest<User> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/users/{name}";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private String name;
            @Key
            private String host;

            protected Get(String project, String instance, String name) {
                super(SQLAdmin.this, "GET", REST_PATH, null, User.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Get setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                this.name = name;
                return this;
            }

            public String getHost() {
                return this.host;
            }

            public Get setHost(String host) {
                this.host = host;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/users";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private String host;
            @Key
            private String name;

            protected Delete(String project, String instance) {
                super(SQLAdmin.this, "DELETE", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Delete setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            public String getHost() {
                return this.host;
            }

            public Delete setHost(String host) {
                this.host = host;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String name) {
                this.name = name;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Tiers {
        public List list(String project) throws IOException {
            List result = new List(project);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends SQLAdminRequest<TiersListResponse> {
            private static final String REST_PATH = "v1/projects/{project}/tiers";
            @Key
            private String project;

            protected List(String project) {
                super(SQLAdmin.this, "GET", REST_PATH, null, TiersListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                this.project = project;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class SslCerts {
        public CreateEphemeral createEphemeral(String project, String instance, SslCertsCreateEphemeralRequest content) throws IOException {
            CreateEphemeral result = new CreateEphemeral(project, instance, content);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String project, String instance, String sha1Fingerprint) throws IOException {
            Delete result = new Delete(project, instance, sha1Fingerprint);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String instance, String sha1Fingerprint) throws IOException {
            Get result = new Get(project, instance, sha1Fingerprint);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, String instance, SslCertsInsertRequest content) throws IOException {
            Insert result = new Insert(project, instance, content);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project, String instance) throws IOException {
            List result = new List(project, instance);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends SQLAdminRequest<SslCertsListResponse> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/sslCerts";
            @Key
            private String project;
            @Key
            private String instance;

            protected List(String project, String instance) {
                super(SQLAdmin.this, "GET", REST_PATH, null, SslCertsListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public List setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends SQLAdminRequest<SslCertsInsertResponse> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/sslCerts";
            @Key
            private String project;
            @Key
            private String instance;

            protected Insert(String project, String instance, SslCertsInsertRequest content) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)content, SslCertsInsertResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Insert setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends SQLAdminRequest<SslCert> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/sslCerts/{sha1Fingerprint}";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private String sha1Fingerprint;

            protected Get(String project, String instance, String sha1Fingerprint) {
                super(SQLAdmin.this, "GET", REST_PATH, null, SslCert.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
                this.sha1Fingerprint = (String)Preconditions.checkNotNull((Object)sha1Fingerprint, (Object)"Required parameter sha1Fingerprint must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Get setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            public String getSha1Fingerprint() {
                return this.sha1Fingerprint;
            }

            public Get setSha1Fingerprint(String sha1Fingerprint) {
                this.sha1Fingerprint = sha1Fingerprint;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/sslCerts/{sha1Fingerprint}";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private String sha1Fingerprint;

            protected Delete(String project, String instance, String sha1Fingerprint) {
                super(SQLAdmin.this, "DELETE", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
                this.sha1Fingerprint = (String)Preconditions.checkNotNull((Object)sha1Fingerprint, (Object)"Required parameter sha1Fingerprint must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Delete setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            public String getSha1Fingerprint() {
                return this.sha1Fingerprint;
            }

            public Delete setSha1Fingerprint(String sha1Fingerprint) {
                this.sha1Fingerprint = sha1Fingerprint;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class CreateEphemeral
        extends SQLAdminRequest<SslCert> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/createEphemeral";
            @Key
            private String project;
            @Key
            private String instance;

            protected CreateEphemeral(String project, String instance, SslCertsCreateEphemeralRequest content) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)content, SslCert.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public CreateEphemeral set$Xgafv(String $Xgafv) {
                return (CreateEphemeral)super.set$Xgafv($Xgafv);
            }

            public CreateEphemeral setAccessToken(String accessToken) {
                return (CreateEphemeral)super.setAccessToken(accessToken);
            }

            public CreateEphemeral setAlt(String alt) {
                return (CreateEphemeral)super.setAlt(alt);
            }

            public CreateEphemeral setCallback(String callback) {
                return (CreateEphemeral)super.setCallback(callback);
            }

            public CreateEphemeral setFields(String fields) {
                return (CreateEphemeral)super.setFields(fields);
            }

            public CreateEphemeral setKey(String key) {
                return (CreateEphemeral)super.setKey(key);
            }

            public CreateEphemeral setOauthToken(String oauthToken) {
                return (CreateEphemeral)super.setOauthToken(oauthToken);
            }

            public CreateEphemeral setPrettyPrint(Boolean prettyPrint) {
                return (CreateEphemeral)super.setPrettyPrint(prettyPrint);
            }

            public CreateEphemeral setQuotaUser(String quotaUser) {
                return (CreateEphemeral)super.setQuotaUser(quotaUser);
            }

            public CreateEphemeral setUploadType(String uploadType) {
                return (CreateEphemeral)super.setUploadType(uploadType);
            }

            public CreateEphemeral setUploadProtocol(String uploadProtocol) {
                return (CreateEphemeral)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public CreateEphemeral setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public CreateEphemeral setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public CreateEphemeral set(String parameterName, Object value) {
                return (CreateEphemeral)super.set(parameterName, value);
            }
        }
    }

    public class Projects {
        public Instances instances() {
            return new Instances();
        }

        public class Instances {
            public RescheduleMaintenance rescheduleMaintenance(String project, String instance, SqlInstancesRescheduleMaintenanceRequestBody content) throws IOException {
                RescheduleMaintenance result = new RescheduleMaintenance(project, instance, content);
                SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public StartExternalSync startExternalSync(String project, String instance, SqlInstancesStartExternalSyncRequest content) throws IOException {
                StartExternalSync result = new StartExternalSync(project, instance, content);
                SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public VerifyExternalSyncSettings verifyExternalSyncSettings(String project, String instance, SqlInstancesVerifyExternalSyncSettingsRequest content) throws IOException {
                VerifyExternalSyncSettings result = new VerifyExternalSyncSettings(project, instance, content);
                SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class VerifyExternalSyncSettings
            extends SQLAdminRequest<SqlInstancesVerifyExternalSyncSettingsResponse> {
                private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/verifyExternalSyncSettings";
                @Key
                private String project;
                @Key
                private String instance;

                protected VerifyExternalSyncSettings(String project, String instance, SqlInstancesVerifyExternalSyncSettingsRequest content) {
                    super(SQLAdmin.this, "POST", REST_PATH, (Object)content, SqlInstancesVerifyExternalSyncSettingsResponse.class);
                    this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                    this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
                }

                public VerifyExternalSyncSettings set$Xgafv(String $Xgafv) {
                    return (VerifyExternalSyncSettings)super.set$Xgafv($Xgafv);
                }

                public VerifyExternalSyncSettings setAccessToken(String accessToken) {
                    return (VerifyExternalSyncSettings)super.setAccessToken(accessToken);
                }

                public VerifyExternalSyncSettings setAlt(String alt) {
                    return (VerifyExternalSyncSettings)super.setAlt(alt);
                }

                public VerifyExternalSyncSettings setCallback(String callback) {
                    return (VerifyExternalSyncSettings)super.setCallback(callback);
                }

                public VerifyExternalSyncSettings setFields(String fields) {
                    return (VerifyExternalSyncSettings)super.setFields(fields);
                }

                public VerifyExternalSyncSettings setKey(String key) {
                    return (VerifyExternalSyncSettings)super.setKey(key);
                }

                public VerifyExternalSyncSettings setOauthToken(String oauthToken) {
                    return (VerifyExternalSyncSettings)super.setOauthToken(oauthToken);
                }

                public VerifyExternalSyncSettings setPrettyPrint(Boolean prettyPrint) {
                    return (VerifyExternalSyncSettings)super.setPrettyPrint(prettyPrint);
                }

                public VerifyExternalSyncSettings setQuotaUser(String quotaUser) {
                    return (VerifyExternalSyncSettings)super.setQuotaUser(quotaUser);
                }

                public VerifyExternalSyncSettings setUploadType(String uploadType) {
                    return (VerifyExternalSyncSettings)super.setUploadType(uploadType);
                }

                public VerifyExternalSyncSettings setUploadProtocol(String uploadProtocol) {
                    return (VerifyExternalSyncSettings)super.setUploadProtocol(uploadProtocol);
                }

                public String getProject() {
                    return this.project;
                }

                public VerifyExternalSyncSettings setProject(String project) {
                    this.project = project;
                    return this;
                }

                public String getInstance() {
                    return this.instance;
                }

                public VerifyExternalSyncSettings setInstance(String instance) {
                    this.instance = instance;
                    return this;
                }

                @Override
                public VerifyExternalSyncSettings set(String parameterName, Object value) {
                    return (VerifyExternalSyncSettings)super.set(parameterName, value);
                }
            }

            public class StartExternalSync
            extends SQLAdminRequest<Operation> {
                private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/startExternalSync";
                @Key
                private String project;
                @Key
                private String instance;

                protected StartExternalSync(String project, String instance, SqlInstancesStartExternalSyncRequest content) {
                    super(SQLAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                    this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
                }

                public StartExternalSync set$Xgafv(String $Xgafv) {
                    return (StartExternalSync)super.set$Xgafv($Xgafv);
                }

                public StartExternalSync setAccessToken(String accessToken) {
                    return (StartExternalSync)super.setAccessToken(accessToken);
                }

                public StartExternalSync setAlt(String alt) {
                    return (StartExternalSync)super.setAlt(alt);
                }

                public StartExternalSync setCallback(String callback) {
                    return (StartExternalSync)super.setCallback(callback);
                }

                public StartExternalSync setFields(String fields) {
                    return (StartExternalSync)super.setFields(fields);
                }

                public StartExternalSync setKey(String key) {
                    return (StartExternalSync)super.setKey(key);
                }

                public StartExternalSync setOauthToken(String oauthToken) {
                    return (StartExternalSync)super.setOauthToken(oauthToken);
                }

                public StartExternalSync setPrettyPrint(Boolean prettyPrint) {
                    return (StartExternalSync)super.setPrettyPrint(prettyPrint);
                }

                public StartExternalSync setQuotaUser(String quotaUser) {
                    return (StartExternalSync)super.setQuotaUser(quotaUser);
                }

                public StartExternalSync setUploadType(String uploadType) {
                    return (StartExternalSync)super.setUploadType(uploadType);
                }

                public StartExternalSync setUploadProtocol(String uploadProtocol) {
                    return (StartExternalSync)super.setUploadProtocol(uploadProtocol);
                }

                public String getProject() {
                    return this.project;
                }

                public StartExternalSync setProject(String project) {
                    this.project = project;
                    return this;
                }

                public String getInstance() {
                    return this.instance;
                }

                public StartExternalSync setInstance(String instance) {
                    this.instance = instance;
                    return this;
                }

                @Override
                public StartExternalSync set(String parameterName, Object value) {
                    return (StartExternalSync)super.set(parameterName, value);
                }
            }

            public class RescheduleMaintenance
            extends SQLAdminRequest<Operation> {
                private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/rescheduleMaintenance";
                @Key
                private String project;
                @Key
                private String instance;

                protected RescheduleMaintenance(String project, String instance, SqlInstancesRescheduleMaintenanceRequestBody content) {
                    super(SQLAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                    this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
                }

                public RescheduleMaintenance set$Xgafv(String $Xgafv) {
                    return (RescheduleMaintenance)super.set$Xgafv($Xgafv);
                }

                public RescheduleMaintenance setAccessToken(String accessToken) {
                    return (RescheduleMaintenance)super.setAccessToken(accessToken);
                }

                public RescheduleMaintenance setAlt(String alt) {
                    return (RescheduleMaintenance)super.setAlt(alt);
                }

                public RescheduleMaintenance setCallback(String callback) {
                    return (RescheduleMaintenance)super.setCallback(callback);
                }

                public RescheduleMaintenance setFields(String fields) {
                    return (RescheduleMaintenance)super.setFields(fields);
                }

                public RescheduleMaintenance setKey(String key) {
                    return (RescheduleMaintenance)super.setKey(key);
                }

                public RescheduleMaintenance setOauthToken(String oauthToken) {
                    return (RescheduleMaintenance)super.setOauthToken(oauthToken);
                }

                public RescheduleMaintenance setPrettyPrint(Boolean prettyPrint) {
                    return (RescheduleMaintenance)super.setPrettyPrint(prettyPrint);
                }

                public RescheduleMaintenance setQuotaUser(String quotaUser) {
                    return (RescheduleMaintenance)super.setQuotaUser(quotaUser);
                }

                public RescheduleMaintenance setUploadType(String uploadType) {
                    return (RescheduleMaintenance)super.setUploadType(uploadType);
                }

                public RescheduleMaintenance setUploadProtocol(String uploadProtocol) {
                    return (RescheduleMaintenance)super.setUploadProtocol(uploadProtocol);
                }

                public String getProject() {
                    return this.project;
                }

                public RescheduleMaintenance setProject(String project) {
                    this.project = project;
                    return this;
                }

                public String getInstance() {
                    return this.instance;
                }

                public RescheduleMaintenance setInstance(String instance) {
                    this.instance = instance;
                    return this;
                }

                @Override
                public RescheduleMaintenance set(String parameterName, Object value) {
                    return (RescheduleMaintenance)super.set(parameterName, value);
                }
            }
        }
    }

    public class Operations {
        public Get get(String project, String operation) throws IOException {
            Get result = new Get(project, operation);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project) throws IOException {
            List result = new List(project);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends SQLAdminRequest<OperationsListResponse> {
            private static final String REST_PATH = "v1/projects/{project}/operations";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String project) {
                super(SQLAdmin.this, "GET", REST_PATH, null, OperationsListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public List setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/operations/{operation}";
            @Key
            private String project;
            @Key
            private String operation;

            protected Get(String project, String operation) {
                super(SQLAdmin.this, "GET", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.operation = (String)Preconditions.checkNotNull((Object)operation, (Object)"Required parameter operation must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                this.project = project;
                return this;
            }

            public String getOperation() {
                return this.operation;
            }

            public Get setOperation(String operation) {
                this.operation = operation;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Instances {
        public AddServerCa addServerCa(String project, String instance) throws IOException {
            AddServerCa result = new AddServerCa(project, instance);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Clone clone(String project, String instance, InstancesCloneRequest content) throws IOException {
            Clone result = new Clone(project, instance, content);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String project, String instance) throws IOException {
            Delete result = new Delete(project, instance);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public DemoteMaster demoteMaster(String project, String instance, InstancesDemoteMasterRequest content) throws IOException {
            DemoteMaster result = new DemoteMaster(project, instance, content);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Export export(String project, String instance, InstancesExportRequest content) throws IOException {
            Export result = new Export(project, instance, content);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Failover failover(String project, String instance, InstancesFailoverRequest content) throws IOException {
            Failover result = new Failover(project, instance, content);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String instance) throws IOException {
            Get result = new Get(project, instance);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SQLAdminImport sqladminImport(String project, String instance, InstancesImportRequest content) throws IOException {
            SQLAdminImport result = new SQLAdminImport(project, instance, content);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, DatabaseInstance content) throws IOException {
            Insert result = new Insert(project, content);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project) throws IOException {
            List result = new List(project);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListServerCas listServerCas(String project, String instance) throws IOException {
            ListServerCas result = new ListServerCas(project, instance);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String project, String instance, DatabaseInstance content) throws IOException {
            Patch result = new Patch(project, instance, content);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public PromoteReplica promoteReplica(String project, String instance) throws IOException {
            PromoteReplica result = new PromoteReplica(project, instance);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ResetSslConfig resetSslConfig(String project, String instance) throws IOException {
            ResetSslConfig result = new ResetSslConfig(project, instance);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Restart restart(String project, String instance) throws IOException {
            Restart result = new Restart(project, instance);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public RestoreBackup restoreBackup(String project, String instance, InstancesRestoreBackupRequest content) throws IOException {
            RestoreBackup result = new RestoreBackup(project, instance, content);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public RotateServerCa rotateServerCa(String project, String instance, InstancesRotateServerCaRequest content) throws IOException {
            RotateServerCa result = new RotateServerCa(project, instance, content);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public StartReplica startReplica(String project, String instance) throws IOException {
            StartReplica result = new StartReplica(project, instance);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public StopReplica stopReplica(String project, String instance) throws IOException {
            StopReplica result = new StopReplica(project, instance);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TruncateLog truncateLog(String project, String instance, InstancesTruncateLogRequest content) throws IOException {
            TruncateLog result = new TruncateLog(project, instance, content);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String project, String instance, DatabaseInstance content) throws IOException {
            Update result = new Update(project, instance, content);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}";
            @Key
            private String project;
            @Key
            private String instance;

            protected Update(String project, String instance, DatabaseInstance content) {
                super(SQLAdmin.this, "PUT", REST_PATH, (Object)content, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Update setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class TruncateLog
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/truncateLog";
            @Key
            private String project;
            @Key
            private String instance;

            protected TruncateLog(String project, String instance, InstancesTruncateLogRequest content) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public TruncateLog set$Xgafv(String $Xgafv) {
                return (TruncateLog)super.set$Xgafv($Xgafv);
            }

            public TruncateLog setAccessToken(String accessToken) {
                return (TruncateLog)super.setAccessToken(accessToken);
            }

            public TruncateLog setAlt(String alt) {
                return (TruncateLog)super.setAlt(alt);
            }

            public TruncateLog setCallback(String callback) {
                return (TruncateLog)super.setCallback(callback);
            }

            public TruncateLog setFields(String fields) {
                return (TruncateLog)super.setFields(fields);
            }

            public TruncateLog setKey(String key) {
                return (TruncateLog)super.setKey(key);
            }

            public TruncateLog setOauthToken(String oauthToken) {
                return (TruncateLog)super.setOauthToken(oauthToken);
            }

            public TruncateLog setPrettyPrint(Boolean prettyPrint) {
                return (TruncateLog)super.setPrettyPrint(prettyPrint);
            }

            public TruncateLog setQuotaUser(String quotaUser) {
                return (TruncateLog)super.setQuotaUser(quotaUser);
            }

            public TruncateLog setUploadType(String uploadType) {
                return (TruncateLog)super.setUploadType(uploadType);
            }

            public TruncateLog setUploadProtocol(String uploadProtocol) {
                return (TruncateLog)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public TruncateLog setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public TruncateLog setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public TruncateLog set(String parameterName, Object value) {
                return (TruncateLog)super.set(parameterName, value);
            }
        }

        public class StopReplica
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/stopReplica";
            @Key
            private String project;
            @Key
            private String instance;

            protected StopReplica(String project, String instance) {
                super(SQLAdmin.this, "POST", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public StopReplica set$Xgafv(String $Xgafv) {
                return (StopReplica)super.set$Xgafv($Xgafv);
            }

            public StopReplica setAccessToken(String accessToken) {
                return (StopReplica)super.setAccessToken(accessToken);
            }

            public StopReplica setAlt(String alt) {
                return (StopReplica)super.setAlt(alt);
            }

            public StopReplica setCallback(String callback) {
                return (StopReplica)super.setCallback(callback);
            }

            public StopReplica setFields(String fields) {
                return (StopReplica)super.setFields(fields);
            }

            public StopReplica setKey(String key) {
                return (StopReplica)super.setKey(key);
            }

            public StopReplica setOauthToken(String oauthToken) {
                return (StopReplica)super.setOauthToken(oauthToken);
            }

            public StopReplica setPrettyPrint(Boolean prettyPrint) {
                return (StopReplica)super.setPrettyPrint(prettyPrint);
            }

            public StopReplica setQuotaUser(String quotaUser) {
                return (StopReplica)super.setQuotaUser(quotaUser);
            }

            public StopReplica setUploadType(String uploadType) {
                return (StopReplica)super.setUploadType(uploadType);
            }

            public StopReplica setUploadProtocol(String uploadProtocol) {
                return (StopReplica)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public StopReplica setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public StopReplica setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public StopReplica set(String parameterName, Object value) {
                return (StopReplica)super.set(parameterName, value);
            }
        }

        public class StartReplica
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/startReplica";
            @Key
            private String project;
            @Key
            private String instance;

            protected StartReplica(String project, String instance) {
                super(SQLAdmin.this, "POST", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public StartReplica set$Xgafv(String $Xgafv) {
                return (StartReplica)super.set$Xgafv($Xgafv);
            }

            public StartReplica setAccessToken(String accessToken) {
                return (StartReplica)super.setAccessToken(accessToken);
            }

            public StartReplica setAlt(String alt) {
                return (StartReplica)super.setAlt(alt);
            }

            public StartReplica setCallback(String callback) {
                return (StartReplica)super.setCallback(callback);
            }

            public StartReplica setFields(String fields) {
                return (StartReplica)super.setFields(fields);
            }

            public StartReplica setKey(String key) {
                return (StartReplica)super.setKey(key);
            }

            public StartReplica setOauthToken(String oauthToken) {
                return (StartReplica)super.setOauthToken(oauthToken);
            }

            public StartReplica setPrettyPrint(Boolean prettyPrint) {
                return (StartReplica)super.setPrettyPrint(prettyPrint);
            }

            public StartReplica setQuotaUser(String quotaUser) {
                return (StartReplica)super.setQuotaUser(quotaUser);
            }

            public StartReplica setUploadType(String uploadType) {
                return (StartReplica)super.setUploadType(uploadType);
            }

            public StartReplica setUploadProtocol(String uploadProtocol) {
                return (StartReplica)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public StartReplica setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public StartReplica setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public StartReplica set(String parameterName, Object value) {
                return (StartReplica)super.set(parameterName, value);
            }
        }

        public class RotateServerCa
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/rotateServerCa";
            @Key
            private String project;
            @Key
            private String instance;

            protected RotateServerCa(String project, String instance, InstancesRotateServerCaRequest content) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public RotateServerCa set$Xgafv(String $Xgafv) {
                return (RotateServerCa)super.set$Xgafv($Xgafv);
            }

            public RotateServerCa setAccessToken(String accessToken) {
                return (RotateServerCa)super.setAccessToken(accessToken);
            }

            public RotateServerCa setAlt(String alt) {
                return (RotateServerCa)super.setAlt(alt);
            }

            public RotateServerCa setCallback(String callback) {
                return (RotateServerCa)super.setCallback(callback);
            }

            public RotateServerCa setFields(String fields) {
                return (RotateServerCa)super.setFields(fields);
            }

            public RotateServerCa setKey(String key) {
                return (RotateServerCa)super.setKey(key);
            }

            public RotateServerCa setOauthToken(String oauthToken) {
                return (RotateServerCa)super.setOauthToken(oauthToken);
            }

            public RotateServerCa setPrettyPrint(Boolean prettyPrint) {
                return (RotateServerCa)super.setPrettyPrint(prettyPrint);
            }

            public RotateServerCa setQuotaUser(String quotaUser) {
                return (RotateServerCa)super.setQuotaUser(quotaUser);
            }

            public RotateServerCa setUploadType(String uploadType) {
                return (RotateServerCa)super.setUploadType(uploadType);
            }

            public RotateServerCa setUploadProtocol(String uploadProtocol) {
                return (RotateServerCa)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public RotateServerCa setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public RotateServerCa setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public RotateServerCa set(String parameterName, Object value) {
                return (RotateServerCa)super.set(parameterName, value);
            }
        }

        public class RestoreBackup
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/restoreBackup";
            @Key
            private String project;
            @Key
            private String instance;

            protected RestoreBackup(String project, String instance, InstancesRestoreBackupRequest content) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public RestoreBackup set$Xgafv(String $Xgafv) {
                return (RestoreBackup)super.set$Xgafv($Xgafv);
            }

            public RestoreBackup setAccessToken(String accessToken) {
                return (RestoreBackup)super.setAccessToken(accessToken);
            }

            public RestoreBackup setAlt(String alt) {
                return (RestoreBackup)super.setAlt(alt);
            }

            public RestoreBackup setCallback(String callback) {
                return (RestoreBackup)super.setCallback(callback);
            }

            public RestoreBackup setFields(String fields) {
                return (RestoreBackup)super.setFields(fields);
            }

            public RestoreBackup setKey(String key) {
                return (RestoreBackup)super.setKey(key);
            }

            public RestoreBackup setOauthToken(String oauthToken) {
                return (RestoreBackup)super.setOauthToken(oauthToken);
            }

            public RestoreBackup setPrettyPrint(Boolean prettyPrint) {
                return (RestoreBackup)super.setPrettyPrint(prettyPrint);
            }

            public RestoreBackup setQuotaUser(String quotaUser) {
                return (RestoreBackup)super.setQuotaUser(quotaUser);
            }

            public RestoreBackup setUploadType(String uploadType) {
                return (RestoreBackup)super.setUploadType(uploadType);
            }

            public RestoreBackup setUploadProtocol(String uploadProtocol) {
                return (RestoreBackup)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public RestoreBackup setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public RestoreBackup setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public RestoreBackup set(String parameterName, Object value) {
                return (RestoreBackup)super.set(parameterName, value);
            }
        }

        public class Restart
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/restart";
            @Key
            private String project;
            @Key
            private String instance;

            protected Restart(String project, String instance) {
                super(SQLAdmin.this, "POST", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public Restart set$Xgafv(String $Xgafv) {
                return (Restart)super.set$Xgafv($Xgafv);
            }

            public Restart setAccessToken(String accessToken) {
                return (Restart)super.setAccessToken(accessToken);
            }

            public Restart setAlt(String alt) {
                return (Restart)super.setAlt(alt);
            }

            public Restart setCallback(String callback) {
                return (Restart)super.setCallback(callback);
            }

            public Restart setFields(String fields) {
                return (Restart)super.setFields(fields);
            }

            public Restart setKey(String key) {
                return (Restart)super.setKey(key);
            }

            public Restart setOauthToken(String oauthToken) {
                return (Restart)super.setOauthToken(oauthToken);
            }

            public Restart setPrettyPrint(Boolean prettyPrint) {
                return (Restart)super.setPrettyPrint(prettyPrint);
            }

            public Restart setQuotaUser(String quotaUser) {
                return (Restart)super.setQuotaUser(quotaUser);
            }

            public Restart setUploadType(String uploadType) {
                return (Restart)super.setUploadType(uploadType);
            }

            public Restart setUploadProtocol(String uploadProtocol) {
                return (Restart)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Restart setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Restart setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public Restart set(String parameterName, Object value) {
                return (Restart)super.set(parameterName, value);
            }
        }

        public class ResetSslConfig
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/resetSslConfig";
            @Key
            private String project;
            @Key
            private String instance;

            protected ResetSslConfig(String project, String instance) {
                super(SQLAdmin.this, "POST", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public ResetSslConfig set$Xgafv(String $Xgafv) {
                return (ResetSslConfig)super.set$Xgafv($Xgafv);
            }

            public ResetSslConfig setAccessToken(String accessToken) {
                return (ResetSslConfig)super.setAccessToken(accessToken);
            }

            public ResetSslConfig setAlt(String alt) {
                return (ResetSslConfig)super.setAlt(alt);
            }

            public ResetSslConfig setCallback(String callback) {
                return (ResetSslConfig)super.setCallback(callback);
            }

            public ResetSslConfig setFields(String fields) {
                return (ResetSslConfig)super.setFields(fields);
            }

            public ResetSslConfig setKey(String key) {
                return (ResetSslConfig)super.setKey(key);
            }

            public ResetSslConfig setOauthToken(String oauthToken) {
                return (ResetSslConfig)super.setOauthToken(oauthToken);
            }

            public ResetSslConfig setPrettyPrint(Boolean prettyPrint) {
                return (ResetSslConfig)super.setPrettyPrint(prettyPrint);
            }

            public ResetSslConfig setQuotaUser(String quotaUser) {
                return (ResetSslConfig)super.setQuotaUser(quotaUser);
            }

            public ResetSslConfig setUploadType(String uploadType) {
                return (ResetSslConfig)super.setUploadType(uploadType);
            }

            public ResetSslConfig setUploadProtocol(String uploadProtocol) {
                return (ResetSslConfig)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public ResetSslConfig setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public ResetSslConfig setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public ResetSslConfig set(String parameterName, Object value) {
                return (ResetSslConfig)super.set(parameterName, value);
            }
        }

        public class PromoteReplica
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/promoteReplica";
            @Key
            private String project;
            @Key
            private String instance;

            protected PromoteReplica(String project, String instance) {
                super(SQLAdmin.this, "POST", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public PromoteReplica set$Xgafv(String $Xgafv) {
                return (PromoteReplica)super.set$Xgafv($Xgafv);
            }

            public PromoteReplica setAccessToken(String accessToken) {
                return (PromoteReplica)super.setAccessToken(accessToken);
            }

            public PromoteReplica setAlt(String alt) {
                return (PromoteReplica)super.setAlt(alt);
            }

            public PromoteReplica setCallback(String callback) {
                return (PromoteReplica)super.setCallback(callback);
            }

            public PromoteReplica setFields(String fields) {
                return (PromoteReplica)super.setFields(fields);
            }

            public PromoteReplica setKey(String key) {
                return (PromoteReplica)super.setKey(key);
            }

            public PromoteReplica setOauthToken(String oauthToken) {
                return (PromoteReplica)super.setOauthToken(oauthToken);
            }

            public PromoteReplica setPrettyPrint(Boolean prettyPrint) {
                return (PromoteReplica)super.setPrettyPrint(prettyPrint);
            }

            public PromoteReplica setQuotaUser(String quotaUser) {
                return (PromoteReplica)super.setQuotaUser(quotaUser);
            }

            public PromoteReplica setUploadType(String uploadType) {
                return (PromoteReplica)super.setUploadType(uploadType);
            }

            public PromoteReplica setUploadProtocol(String uploadProtocol) {
                return (PromoteReplica)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public PromoteReplica setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public PromoteReplica setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public PromoteReplica set(String parameterName, Object value) {
                return (PromoteReplica)super.set(parameterName, value);
            }
        }

        public class Patch
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}";
            @Key
            private String project;
            @Key
            private String instance;

            protected Patch(String project, String instance, DatabaseInstance content) {
                super(SQLAdmin.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Patch setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class ListServerCas
        extends SQLAdminRequest<InstancesListServerCasResponse> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/listServerCas";
            @Key
            private String project;
            @Key
            private String instance;

            protected ListServerCas(String project, String instance) {
                super(SQLAdmin.this, "GET", REST_PATH, null, InstancesListServerCasResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListServerCas set$Xgafv(String $Xgafv) {
                return (ListServerCas)super.set$Xgafv($Xgafv);
            }

            public ListServerCas setAccessToken(String accessToken) {
                return (ListServerCas)super.setAccessToken(accessToken);
            }

            public ListServerCas setAlt(String alt) {
                return (ListServerCas)super.setAlt(alt);
            }

            public ListServerCas setCallback(String callback) {
                return (ListServerCas)super.setCallback(callback);
            }

            public ListServerCas setFields(String fields) {
                return (ListServerCas)super.setFields(fields);
            }

            public ListServerCas setKey(String key) {
                return (ListServerCas)super.setKey(key);
            }

            public ListServerCas setOauthToken(String oauthToken) {
                return (ListServerCas)super.setOauthToken(oauthToken);
            }

            public ListServerCas setPrettyPrint(Boolean prettyPrint) {
                return (ListServerCas)super.setPrettyPrint(prettyPrint);
            }

            public ListServerCas setQuotaUser(String quotaUser) {
                return (ListServerCas)super.setQuotaUser(quotaUser);
            }

            public ListServerCas setUploadType(String uploadType) {
                return (ListServerCas)super.setUploadType(uploadType);
            }

            public ListServerCas setUploadProtocol(String uploadProtocol) {
                return (ListServerCas)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public ListServerCas setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public ListServerCas setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public ListServerCas set(String parameterName, Object value) {
                return (ListServerCas)super.set(parameterName, value);
            }
        }

        public class List
        extends SQLAdminRequest<InstancesListResponse> {
            private static final String REST_PATH = "v1/projects/{project}/instances";
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String project) {
                super(SQLAdmin.this, "GET", REST_PATH, null, InstancesListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances";
            @Key
            private String project;

            protected Insert(String project, DatabaseInstance content) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                this.project = project;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class SQLAdminImport
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/import";
            @Key
            private String project;
            @Key
            private String instance;

            protected SQLAdminImport(String project, String instance, InstancesImportRequest content) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public SQLAdminImport set$Xgafv(String $Xgafv) {
                return (SQLAdminImport)super.set$Xgafv($Xgafv);
            }

            public SQLAdminImport setAccessToken(String accessToken) {
                return (SQLAdminImport)super.setAccessToken(accessToken);
            }

            public SQLAdminImport setAlt(String alt) {
                return (SQLAdminImport)super.setAlt(alt);
            }

            public SQLAdminImport setCallback(String callback) {
                return (SQLAdminImport)super.setCallback(callback);
            }

            public SQLAdminImport setFields(String fields) {
                return (SQLAdminImport)super.setFields(fields);
            }

            public SQLAdminImport setKey(String key) {
                return (SQLAdminImport)super.setKey(key);
            }

            public SQLAdminImport setOauthToken(String oauthToken) {
                return (SQLAdminImport)super.setOauthToken(oauthToken);
            }

            public SQLAdminImport setPrettyPrint(Boolean prettyPrint) {
                return (SQLAdminImport)super.setPrettyPrint(prettyPrint);
            }

            public SQLAdminImport setQuotaUser(String quotaUser) {
                return (SQLAdminImport)super.setQuotaUser(quotaUser);
            }

            public SQLAdminImport setUploadType(String uploadType) {
                return (SQLAdminImport)super.setUploadType(uploadType);
            }

            public SQLAdminImport setUploadProtocol(String uploadProtocol) {
                return (SQLAdminImport)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public SQLAdminImport setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public SQLAdminImport setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public SQLAdminImport set(String parameterName, Object value) {
                return (SQLAdminImport)super.set(parameterName, value);
            }
        }

        public class Get
        extends SQLAdminRequest<DatabaseInstance> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}";
            @Key
            private String project;
            @Key
            private String instance;

            protected Get(String project, String instance) {
                super(SQLAdmin.this, "GET", REST_PATH, null, DatabaseInstance.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Get setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Failover
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/failover";
            @Key
            private String project;
            @Key
            private String instance;

            protected Failover(String project, String instance, InstancesFailoverRequest content) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public Failover set$Xgafv(String $Xgafv) {
                return (Failover)super.set$Xgafv($Xgafv);
            }

            public Failover setAccessToken(String accessToken) {
                return (Failover)super.setAccessToken(accessToken);
            }

            public Failover setAlt(String alt) {
                return (Failover)super.setAlt(alt);
            }

            public Failover setCallback(String callback) {
                return (Failover)super.setCallback(callback);
            }

            public Failover setFields(String fields) {
                return (Failover)super.setFields(fields);
            }

            public Failover setKey(String key) {
                return (Failover)super.setKey(key);
            }

            public Failover setOauthToken(String oauthToken) {
                return (Failover)super.setOauthToken(oauthToken);
            }

            public Failover setPrettyPrint(Boolean prettyPrint) {
                return (Failover)super.setPrettyPrint(prettyPrint);
            }

            public Failover setQuotaUser(String quotaUser) {
                return (Failover)super.setQuotaUser(quotaUser);
            }

            public Failover setUploadType(String uploadType) {
                return (Failover)super.setUploadType(uploadType);
            }

            public Failover setUploadProtocol(String uploadProtocol) {
                return (Failover)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Failover setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Failover setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public Failover set(String parameterName, Object value) {
                return (Failover)super.set(parameterName, value);
            }
        }

        public class Export
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/export";
            @Key
            private String project;
            @Key
            private String instance;

            protected Export(String project, String instance, InstancesExportRequest content) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public Export set$Xgafv(String $Xgafv) {
                return (Export)super.set$Xgafv($Xgafv);
            }

            public Export setAccessToken(String accessToken) {
                return (Export)super.setAccessToken(accessToken);
            }

            public Export setAlt(String alt) {
                return (Export)super.setAlt(alt);
            }

            public Export setCallback(String callback) {
                return (Export)super.setCallback(callback);
            }

            public Export setFields(String fields) {
                return (Export)super.setFields(fields);
            }

            public Export setKey(String key) {
                return (Export)super.setKey(key);
            }

            public Export setOauthToken(String oauthToken) {
                return (Export)super.setOauthToken(oauthToken);
            }

            public Export setPrettyPrint(Boolean prettyPrint) {
                return (Export)super.setPrettyPrint(prettyPrint);
            }

            public Export setQuotaUser(String quotaUser) {
                return (Export)super.setQuotaUser(quotaUser);
            }

            public Export setUploadType(String uploadType) {
                return (Export)super.setUploadType(uploadType);
            }

            public Export setUploadProtocol(String uploadProtocol) {
                return (Export)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Export setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Export setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public Export set(String parameterName, Object value) {
                return (Export)super.set(parameterName, value);
            }
        }

        public class DemoteMaster
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/demoteMaster";
            @Key
            private String project;
            @Key
            private String instance;

            protected DemoteMaster(String project, String instance, InstancesDemoteMasterRequest content) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public DemoteMaster set$Xgafv(String $Xgafv) {
                return (DemoteMaster)super.set$Xgafv($Xgafv);
            }

            public DemoteMaster setAccessToken(String accessToken) {
                return (DemoteMaster)super.setAccessToken(accessToken);
            }

            public DemoteMaster setAlt(String alt) {
                return (DemoteMaster)super.setAlt(alt);
            }

            public DemoteMaster setCallback(String callback) {
                return (DemoteMaster)super.setCallback(callback);
            }

            public DemoteMaster setFields(String fields) {
                return (DemoteMaster)super.setFields(fields);
            }

            public DemoteMaster setKey(String key) {
                return (DemoteMaster)super.setKey(key);
            }

            public DemoteMaster setOauthToken(String oauthToken) {
                return (DemoteMaster)super.setOauthToken(oauthToken);
            }

            public DemoteMaster setPrettyPrint(Boolean prettyPrint) {
                return (DemoteMaster)super.setPrettyPrint(prettyPrint);
            }

            public DemoteMaster setQuotaUser(String quotaUser) {
                return (DemoteMaster)super.setQuotaUser(quotaUser);
            }

            public DemoteMaster setUploadType(String uploadType) {
                return (DemoteMaster)super.setUploadType(uploadType);
            }

            public DemoteMaster setUploadProtocol(String uploadProtocol) {
                return (DemoteMaster)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public DemoteMaster setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public DemoteMaster setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public DemoteMaster set(String parameterName, Object value) {
                return (DemoteMaster)super.set(parameterName, value);
            }
        }

        public class Delete
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}";
            @Key
            private String project;
            @Key
            private String instance;

            protected Delete(String project, String instance) {
                super(SQLAdmin.this, "DELETE", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Delete setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Clone
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/clone";
            @Key
            private String project;
            @Key
            private String instance;

            protected Clone(String project, String instance, InstancesCloneRequest content) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public Clone set$Xgafv(String $Xgafv) {
                return (Clone)super.set$Xgafv($Xgafv);
            }

            public Clone setAccessToken(String accessToken) {
                return (Clone)super.setAccessToken(accessToken);
            }

            public Clone setAlt(String alt) {
                return (Clone)super.setAlt(alt);
            }

            public Clone setCallback(String callback) {
                return (Clone)super.setCallback(callback);
            }

            public Clone setFields(String fields) {
                return (Clone)super.setFields(fields);
            }

            public Clone setKey(String key) {
                return (Clone)super.setKey(key);
            }

            public Clone setOauthToken(String oauthToken) {
                return (Clone)super.setOauthToken(oauthToken);
            }

            public Clone setPrettyPrint(Boolean prettyPrint) {
                return (Clone)super.setPrettyPrint(prettyPrint);
            }

            public Clone setQuotaUser(String quotaUser) {
                return (Clone)super.setQuotaUser(quotaUser);
            }

            public Clone setUploadType(String uploadType) {
                return (Clone)super.setUploadType(uploadType);
            }

            public Clone setUploadProtocol(String uploadProtocol) {
                return (Clone)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Clone setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Clone setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public Clone set(String parameterName, Object value) {
                return (Clone)super.set(parameterName, value);
            }
        }

        public class AddServerCa
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/addServerCa";
            @Key
            private String project;
            @Key
            private String instance;

            protected AddServerCa(String project, String instance) {
                super(SQLAdmin.this, "POST", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public AddServerCa set$Xgafv(String $Xgafv) {
                return (AddServerCa)super.set$Xgafv($Xgafv);
            }

            public AddServerCa setAccessToken(String accessToken) {
                return (AddServerCa)super.setAccessToken(accessToken);
            }

            public AddServerCa setAlt(String alt) {
                return (AddServerCa)super.setAlt(alt);
            }

            public AddServerCa setCallback(String callback) {
                return (AddServerCa)super.setCallback(callback);
            }

            public AddServerCa setFields(String fields) {
                return (AddServerCa)super.setFields(fields);
            }

            public AddServerCa setKey(String key) {
                return (AddServerCa)super.setKey(key);
            }

            public AddServerCa setOauthToken(String oauthToken) {
                return (AddServerCa)super.setOauthToken(oauthToken);
            }

            public AddServerCa setPrettyPrint(Boolean prettyPrint) {
                return (AddServerCa)super.setPrettyPrint(prettyPrint);
            }

            public AddServerCa setQuotaUser(String quotaUser) {
                return (AddServerCa)super.setQuotaUser(quotaUser);
            }

            public AddServerCa setUploadType(String uploadType) {
                return (AddServerCa)super.setUploadType(uploadType);
            }

            public AddServerCa setUploadProtocol(String uploadProtocol) {
                return (AddServerCa)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public AddServerCa setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public AddServerCa setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public AddServerCa set(String parameterName, Object value) {
                return (AddServerCa)super.set(parameterName, value);
            }
        }
    }

    public class Flags {
        public List list() throws IOException {
            List result = new List();
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends SQLAdminRequest<FlagsListResponse> {
            private static final String REST_PATH = "v1/flags";
            @Key
            private String databaseVersion;

            protected List() {
                super(SQLAdmin.this, "GET", REST_PATH, null, FlagsListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getDatabaseVersion() {
                return this.databaseVersion;
            }

            public List setDatabaseVersion(String databaseVersion) {
                this.databaseVersion = databaseVersion;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class Databases {
        public Delete delete(String project, String instance, String database) throws IOException {
            Delete result = new Delete(project, instance, database);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String instance, String database) throws IOException {
            Get result = new Get(project, instance, database);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, String instance, Database content) throws IOException {
            Insert result = new Insert(project, instance, content);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project, String instance) throws IOException {
            List result = new List(project, instance);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String project, String instance, String database, Database content) throws IOException {
            Patch result = new Patch(project, instance, database, content);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String project, String instance, String database, Database content) throws IOException {
            Update result = new Update(project, instance, database, content);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/databases/{database}";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private String database;

            protected Update(String project, String instance, String database, Database content) {
                super(SQLAdmin.this, "PUT", REST_PATH, (Object)content, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
                this.database = (String)Preconditions.checkNotNull((Object)database, (Object)"Required parameter database must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Update setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            public String getDatabase() {
                return this.database;
            }

            public Update setDatabase(String database) {
                this.database = database;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/databases/{database}";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private String database;

            protected Patch(String project, String instance, String database, Database content) {
                super(SQLAdmin.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
                this.database = (String)Preconditions.checkNotNull((Object)database, (Object)"Required parameter database must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Patch setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            public String getDatabase() {
                return this.database;
            }

            public Patch setDatabase(String database) {
                this.database = database;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends SQLAdminRequest<DatabasesListResponse> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/databases";
            @Key
            private String project;
            @Key
            private String instance;

            protected List(String project, String instance) {
                super(SQLAdmin.this, "GET", REST_PATH, null, DatabasesListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public List setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/databases";
            @Key
            private String project;
            @Key
            private String instance;

            protected Insert(String project, String instance, Database content) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Insert setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends SQLAdminRequest<Database> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/databases/{database}";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private String database;

            protected Get(String project, String instance, String database) {
                super(SQLAdmin.this, "GET", REST_PATH, null, Database.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
                this.database = (String)Preconditions.checkNotNull((Object)database, (Object)"Required parameter database must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Get setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            public String getDatabase() {
                return this.database;
            }

            public Get setDatabase(String database) {
                this.database = database;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/databases/{database}";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private String database;

            protected Delete(String project, String instance, String database) {
                super(SQLAdmin.this, "DELETE", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
                this.database = (String)Preconditions.checkNotNull((Object)database, (Object)"Required parameter database must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Delete setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            public String getDatabase() {
                return this.database;
            }

            public Delete setDatabase(String database) {
                this.database = database;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Connect {
        public GenerateEphemeralCert generateEphemeralCert(String project, String instance, GenerateEphemeralCertRequest content) throws IOException {
            GenerateEphemeralCert result = new GenerateEphemeralCert(project, instance, content);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String instance) throws IOException {
            Get result = new Get(project, instance);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends SQLAdminRequest<ConnectSettings> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/connectSettings";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private String readTime;

            protected Get(String project, String instance) {
                super(SQLAdmin.this, "GET", REST_PATH, null, ConnectSettings.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Get setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            public String getReadTime() {
                return this.readTime;
            }

            public Get setReadTime(String readTime) {
                this.readTime = readTime;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class GenerateEphemeralCert
        extends SQLAdminRequest<GenerateEphemeralCertResponse> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}:generateEphemeralCert";
            @Key
            private String project;
            @Key
            private String instance;

            protected GenerateEphemeralCert(String project, String instance, GenerateEphemeralCertRequest content) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)content, GenerateEphemeralCertResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public GenerateEphemeralCert set$Xgafv(String $Xgafv) {
                return (GenerateEphemeralCert)super.set$Xgafv($Xgafv);
            }

            public GenerateEphemeralCert setAccessToken(String accessToken) {
                return (GenerateEphemeralCert)super.setAccessToken(accessToken);
            }

            public GenerateEphemeralCert setAlt(String alt) {
                return (GenerateEphemeralCert)super.setAlt(alt);
            }

            public GenerateEphemeralCert setCallback(String callback) {
                return (GenerateEphemeralCert)super.setCallback(callback);
            }

            public GenerateEphemeralCert setFields(String fields) {
                return (GenerateEphemeralCert)super.setFields(fields);
            }

            public GenerateEphemeralCert setKey(String key) {
                return (GenerateEphemeralCert)super.setKey(key);
            }

            public GenerateEphemeralCert setOauthToken(String oauthToken) {
                return (GenerateEphemeralCert)super.setOauthToken(oauthToken);
            }

            public GenerateEphemeralCert setPrettyPrint(Boolean prettyPrint) {
                return (GenerateEphemeralCert)super.setPrettyPrint(prettyPrint);
            }

            public GenerateEphemeralCert setQuotaUser(String quotaUser) {
                return (GenerateEphemeralCert)super.setQuotaUser(quotaUser);
            }

            public GenerateEphemeralCert setUploadType(String uploadType) {
                return (GenerateEphemeralCert)super.setUploadType(uploadType);
            }

            public GenerateEphemeralCert setUploadProtocol(String uploadProtocol) {
                return (GenerateEphemeralCert)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public GenerateEphemeralCert setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public GenerateEphemeralCert setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public GenerateEphemeralCert set(String parameterName, Object value) {
                return (GenerateEphemeralCert)super.set(parameterName, value);
            }
        }
    }

    public class BackupRuns {
        public Delete delete(String project, String instance, Long id) throws IOException {
            Delete result = new Delete(project, instance, id);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String instance, Long id) throws IOException {
            Get result = new Get(project, instance, id);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, String instance, BackupRun content) throws IOException {
            Insert result = new Insert(project, instance, content);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project, String instance) throws IOException {
            List result = new List(project, instance);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends SQLAdminRequest<BackupRunsListResponse> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/backupRuns";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected List(String project, String instance) {
                super(SQLAdmin.this, "GET", REST_PATH, null, BackupRunsListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public List setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/backupRuns";
            @Key
            private String project;
            @Key
            private String instance;

            protected Insert(String project, String instance, BackupRun content) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Insert setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends SQLAdminRequest<BackupRun> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/backupRuns/{id}";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private Long id;

            protected Get(String project, String instance, Long id) {
                super(SQLAdmin.this, "GET", REST_PATH, null, BackupRun.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
                this.id = (Long)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Get setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            public Long getId() {
                return this.id;
            }

            public Get setId(Long id) {
                this.id = id;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "v1/projects/{project}/instances/{instance}/backupRuns/{id}";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private Long id;

            protected Delete(String project, String instance, Long id) {
                super(SQLAdmin.this, "DELETE", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)instance, (Object)"Required parameter instance must be specified.");
                this.id = (Long)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                this.project = project;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Delete setInstance(String instance) {
                this.instance = instance;
                return this;
            }

            public Long getId() {
                return this.id;
            }

            public Delete setId(Long id) {
                this.id = id;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }
}

