/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.androidentrypoint;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.hilt.android.processor.internal.AndroidClassNames;
import dagger.hilt.android.processor.internal.androidentrypoint.AndroidEntryPointMetadata;
import dagger.hilt.android.processor.internal.androidentrypoint.Generators;
import dagger.hilt.processor.internal.Processors;
import java.io.IOException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;

public final class ActivityGenerator {
    private final ProcessingEnvironment env;
    private final AndroidEntryPointMetadata metadata;
    private final ClassName generatedClassName;

    public ActivityGenerator(ProcessingEnvironment env, AndroidEntryPointMetadata metadata) {
        this.env = env;
        this.metadata = metadata;
        this.generatedClassName = metadata.generatedClassName();
    }

    public void generate() throws IOException {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.generatedClassName.simpleName()).addOriginatingElement((Element)this.metadata.element()).superclass(this.metadata.baseClassName()).addModifiers(this.metadata.generatedClassModifiers()).addMethod(this.onCreate());
        Generators.addGeneratedBaseClassJavadoc(builder, AndroidClassNames.ANDROID_ENTRY_POINT);
        Processors.addGeneratedAnnotation(builder, this.env, this.getClass());
        Generators.copyConstructors(this.metadata.baseElement(), builder);
        this.metadata.baseElement().getTypeParameters().stream().map(TypeVariableName::get).forEachOrdered(arg_0 -> ((TypeSpec.Builder)builder).addTypeVariable(arg_0));
        Generators.addComponentOverride(this.metadata, builder);
        Generators.copyLintAnnotations(this.metadata.element(), builder);
        Generators.addInjectionMethods(this.metadata, builder);
        if (Processors.isAssignableFrom(this.metadata.baseElement(), AndroidClassNames.COMPONENT_ACTIVITY) && !this.metadata.overridesAndroidEntryPointClass()) {
            builder.addMethod(this.getDefaultViewModelProviderFactory());
        }
        JavaFile.builder((String)this.generatedClassName.packageName(), (TypeSpec)builder.build()).build().writeTo(this.env.getFiler());
    }

    private MethodSpec onCreate() {
        return MethodSpec.methodBuilder((String)"onCreate").addAnnotation(AndroidClassNames.CALL_SUPER).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(ParameterSpec.builder((TypeName)AndroidClassNames.BUNDLE, (String)"savedInstanceState", (Modifier[])new Modifier[0]).addAnnotation(AndroidClassNames.NULLABLE).build()).addStatement("inject()", new Object[0]).addStatement("super.onCreate(savedInstanceState)", new Object[0]).build();
    }

    private MethodSpec getDefaultViewModelProviderFactory() {
        return MethodSpec.methodBuilder((String)"getDefaultViewModelProviderFactory").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)AndroidClassNames.VIEW_MODEL_PROVIDER_FACTORY).addStatement("$T factory = $T.getActivityFactory(this)", new Object[]{AndroidClassNames.VIEW_MODEL_PROVIDER_FACTORY, AndroidClassNames.DEFAULT_VIEW_MODEL_FACTORIES}).beginControlFlow("if (factory != null)", new Object[0]).addStatement("return factory", new Object[0]).endControlFlow().addStatement("return super.getDefaultViewModelProviderFactory()", new Object[0]).build();
    }
}

