/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.androidentrypoint;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.hilt.android.processor.internal.AndroidClassNames;
import dagger.hilt.android.processor.internal.androidentrypoint.AndroidEntryPointMetadata;
import dagger.hilt.android.processor.internal.androidentrypoint.Generators;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ComponentNames;
import dagger.hilt.processor.internal.Processors;
import java.io.IOException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;

public final class ApplicationGenerator {
    private final ProcessingEnvironment env;
    private final AndroidEntryPointMetadata metadata;
    private final ClassName wrapperClassName;

    public ApplicationGenerator(ProcessingEnvironment env, AndroidEntryPointMetadata metadata) {
        this.env = env;
        this.metadata = metadata;
        this.wrapperClassName = metadata.generatedClassName();
    }

    public void generate() throws IOException {
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder((String)this.wrapperClassName.simpleName()).addOriginatingElement((Element)this.metadata.element()).superclass(this.metadata.baseClassName()).addModifiers(this.metadata.generatedClassModifiers()).addField(this.componentManagerField()).addMethod(this.componentManagerMethod());
        Generators.addGeneratedBaseClassJavadoc(typeSpecBuilder, AndroidClassNames.HILT_ANDROID_APP);
        Processors.addGeneratedAnnotation(typeSpecBuilder, this.env, this.getClass());
        this.metadata.baseElement().getTypeParameters().stream().map(TypeVariableName::get).forEachOrdered(arg_0 -> ((TypeSpec.Builder)typeSpecBuilder).addTypeVariable(arg_0));
        Generators.copyLintAnnotations(this.metadata.element(), typeSpecBuilder);
        Generators.addComponentOverride(this.metadata, typeSpecBuilder);
        typeSpecBuilder.addMethod(this.onCreateMethod());
        JavaFile.builder((String)this.metadata.elementClassName().packageName(), (TypeSpec)typeSpecBuilder.build()).build().writeTo(this.env.getFiler());
    }

    private FieldSpec componentManagerField() {
        ParameterSpec managerParam = this.metadata.componentManagerParam();
        return FieldSpec.builder((TypeName)managerParam.type, (String)managerParam.name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T($L)", new Object[]{AndroidClassNames.APPLICATION_COMPONENT_MANAGER, this.creatorType()}).build();
    }

    private MethodSpec componentManagerMethod() {
        return MethodSpec.methodBuilder((String)"componentManager").addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(this.metadata.componentManagerParam().type).addStatement("return $N", new Object[]{this.metadata.componentManagerParam()}).build();
    }

    private TypeSpec creatorType() {
        ClassName component = ComponentNames.generatedComponent(this.metadata.elementClassName(), AndroidClassNames.APPLICATION_COMPONENT);
        return TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)AndroidClassNames.COMPONENT_SUPPLIER).addMethod(MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeName.OBJECT).addStatement("return $T.builder()\n.applicationContextModule(new $T($T.this))\n.build()", new Object[]{Processors.prepend(Processors.getEnclosedClassName(component), "Dagger"), AndroidClassNames.APPLICATION_CONTEXT_MODULE, this.wrapperClassName}).build()).build();
    }

    private MethodSpec onCreateMethod() {
        return MethodSpec.methodBuilder((String)"onCreate").addAnnotation(AndroidClassNames.CALL_SUPER).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode(this.injectCodeBlock()).addStatement("super.onCreate()", new Object[0]).build();
    }

    private CodeBlock injectCodeBlock() {
        return CodeBlock.builder().add("// This is a known unsafe cast, but is safe in the only correct use case:\n", new Object[0]).add("// $T extends $T\n", new Object[]{this.metadata.elementClassName(), this.metadata.generatedClassName()}).addStatement("(($T) generatedComponent()).$L($T.<$T>unsafeCast(this))", new Object[]{this.metadata.injectorClassName(), this.metadata.injectMethodName(), ClassNames.UNSAFE_CASTS, this.metadata.elementClassName()}).build();
    }
}

