/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.ComponentDescriptor;
import dagger.internal.codegen.extension.DaggerStreams;
import java.util.Collection;
import java.util.HashMap;

public final class ComponentTree {
    private final ImmutableGraph<ComponentDescriptor> graph;

    private ComponentTree(ImmutableGraph<ComponentDescriptor> graph) {
        this.graph = (ImmutableGraph)Preconditions.checkNotNull(graph);
        Preconditions.checkState((!Graphs.hasCycle(graph) ? 1 : 0) != 0, (String)"Component graph has cycles: %s", (Object)graph.nodes());
        HashMap<ClassName, ComponentDescriptor> descriptors = new HashMap<ClassName, ComponentDescriptor>();
        for (ComponentDescriptor descriptor : graph.nodes()) {
            if (descriptors.containsKey(descriptor.component())) {
                ComponentDescriptor prevDescriptor = (ComponentDescriptor)descriptors.get(descriptor.component());
                Preconditions.checkState((boolean)descriptor.equals(prevDescriptor), (String)"%s has mismatching descriptors:\n    %s\n\n    %s\n\n", (Object)prevDescriptor.component(), (Object)prevDescriptor, (Object)descriptor);
            }
            descriptors.put(descriptor.component(), descriptor);
        }
        ImmutableList roots = (ImmutableList)graph.nodes().stream().filter(node -> graph.inDegree(node) == 0).map(node -> node.component()).collect(DaggerStreams.toImmutableList());
        Preconditions.checkState((roots.size() == 1 ? 1 : 0) != 0, (String)"Component graph must have exactly 1 root. Found: %s", (Object)roots);
    }

    public ImmutableSet<ComponentDescriptor> getComponentDescriptors() {
        return ImmutableSet.copyOf((Collection)this.graph.nodes());
    }

    public ImmutableSet<ComponentDescriptor> childrenOf(ComponentDescriptor componentDescriptor) {
        return ImmutableSet.copyOf((Collection)this.graph.successors((Object)componentDescriptor));
    }

    public static ComponentTree from(Collection<ComponentDescriptor> componentDescriptors) {
        MutableGraph graph = GraphBuilder.directed().allowsSelfLoops(false).build();
        componentDescriptors.forEach(descriptor -> {
            graph.addNode(descriptor);
            descriptor.parent().ifPresent(parent -> graph.putEdge(parent, descriptor));
        });
        return new ComponentTree((ImmutableGraph<ComponentDescriptor>)ImmutableGraph.copyOf((Graph)graph));
    }
}

