/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import dagger.hilt.processor.internal.AnnotationValues;
import dagger.shaded.auto.common.MoreElements;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import kotlin.Metadata;
import kotlinx.metadata.Flag;
import kotlinx.metadata.KmClassVisitor;
import kotlinx.metadata.jvm.KotlinClassHeader;
import kotlinx.metadata.jvm.KotlinClassMetadata;

public final class KotlinMetadata {
    private final TypeElement typeElement;
    private final int flags;

    private KotlinMetadata(TypeElement typeElement, int flags) {
        this.typeElement = typeElement;
        this.flags = flags;
    }

    public boolean isObjectClass() {
        return Flag.Class.IS_OBJECT.invoke(this.flags);
    }

    public boolean isCompanionObjectClass() {
        return Flag.Class.IS_COMPANION_OBJECT.invoke(this.flags);
    }

    public static Optional<KotlinMetadata> of(TypeElement typeElement) {
        if (!MoreElements.isAnnotationPresent(typeElement, Metadata.class)) {
            return Optional.empty();
        }
        MetadataVisitor visitor = new MetadataVisitor();
        KotlinMetadata.metadataOf(typeElement).accept((KmClassVisitor)visitor);
        return Optional.of(new KotlinMetadata(typeElement, visitor.classFlags));
    }

    private static KotlinClassMetadata.Class metadataOf(TypeElement typeElement) {
        AnnotationMirror metadataAnnotation = (AnnotationMirror)MoreElements.getAnnotationMirror(typeElement, Metadata.class).get();
        KotlinClassHeader header = new KotlinClassHeader(Integer.valueOf(AnnotationValues.getIntValue(metadataAnnotation, "k")), AnnotationValues.getIntArrayValue(metadataAnnotation, "mv"), AnnotationValues.getIntArrayValue(metadataAnnotation, "bv"), AnnotationValues.getStringArrayValue(metadataAnnotation, "d1"), AnnotationValues.getStringArrayValue(metadataAnnotation, "d2"), AnnotationValues.getStringValue(metadataAnnotation, "xs"), (String)AnnotationValues.getOptionalStringValue(metadataAnnotation, "pn").orElse(null), (Integer)AnnotationValues.getOptionalIntValue(metadataAnnotation, "xi").orElse(null));
        KotlinClassMetadata metadata = KotlinClassMetadata.read((KotlinClassHeader)header);
        if (metadata == null) {
            throw new IllegalStateException("Unsupported metadata version. Check that your Kotlin version is >= 1.0");
        }
        if (metadata instanceof KotlinClassMetadata.Class) {
            return (KotlinClassMetadata.Class)metadata;
        }
        throw new IllegalStateException("Unsupported metadata type: " + metadata);
    }

    private static final class MetadataVisitor
    extends KmClassVisitor {
        int classFlags;

        private MetadataVisitor() {
        }

        public void visit(int flags, String s) {
            this.classFlags = flags;
        }
    }
}

