/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.aggregateddeps;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Processors;
import dagger.shaded.auto.common.MoreElements;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

final class AggregatedDepsGenerator {
    static final String AGGREGATING_PACKAGE = "hilt_aggregated_deps";
    private static final ClassName AGGREGATED_DEPS = ClassName.get((String)"dagger.hilt.processor.internal.aggregateddeps", (String)"AggregatedDeps", (String[])new String[0]);
    private final String dependencyType;
    private final TypeElement dependency;
    private final ImmutableSet<ClassName> components;
    private final ProcessingEnvironment processingEnv;

    AggregatedDepsGenerator(String dependencyType, TypeElement dependency, ImmutableSet<ClassName> components, ProcessingEnvironment processingEnv) {
        this.dependencyType = dependencyType;
        this.dependency = dependency;
        this.components = components;
        this.processingEnv = processingEnv;
    }

    void generate() throws IOException {
        ClassName name = ClassName.get((String)AGGREGATING_PACKAGE, (String)(Processors.getFullEnclosedName(this.dependency) + "ModuleDeps"), (String[])new String[0]);
        TypeSpec.Builder generator = TypeSpec.classBuilder((String)name.simpleName()).addOriginatingElement((Element)this.dependency).addAnnotation(this.aggregatedDepsAnnotation()).addJavadoc("Generated class to pass information through multiple javac runs.\n", new Object[0]);
        Processors.addGeneratedAnnotation(generator, this.processingEnv, this.getClass());
        JavaFile.builder((String)name.packageName(), (TypeSpec)generator.build()).build().writeTo(this.processingEnv.getFiler());
    }

    private AnnotationSpec aggregatedDepsAnnotation() {
        AnnotationSpec.Builder annotationBuilder = AnnotationSpec.builder((ClassName)AGGREGATED_DEPS);
        this.components.forEach(component -> annotationBuilder.addMember("components", "$S", new Object[]{component}));
        this.getEnclosingTestName(this.dependency).ifPresent(test -> annotationBuilder.addMember("test", "$S", new Object[]{test}));
        annotationBuilder.addMember(this.dependencyType, "$S", new Object[]{this.dependency.getQualifiedName()});
        return annotationBuilder.build();
    }

    private Optional<ClassName> getEnclosingTestName(Element element) {
        TypeElement topLevelType = this.getOriginatingTopLevelType(element);
        return Processors.hasAnnotation((Element)topLevelType, ClassNames.HILT_ANDROID_TEST) ? Optional.of(ClassName.get((TypeElement)MoreElements.asType(topLevelType))) : Optional.empty();
    }

    private TypeElement getOriginatingTopLevelType(Element element) {
        TypeElement topLevelType = Processors.getTopLevelType(element);
        if (Processors.hasAnnotation((Element)topLevelType, ClassNames.ORIGINATING_ELEMENT)) {
            return this.getOriginatingTopLevelType(Processors.getAnnotationClassValue(this.processingEnv.getElementUtils(), Processors.getAnnotationMirror((Element)topLevelType, ClassNames.ORIGINATING_ELEMENT), "topLevelClass"));
        }
        return topLevelType;
    }
}

