/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.aggregateddeps;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import dagger.hilt.android.processor.internal.androidentrypoint.HiltCompilerOptions;
import dagger.hilt.processor.internal.BaseProcessor;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ComponentDescriptor;
import dagger.hilt.processor.internal.Components;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.aggregateddeps.AggregatedDepsGenerator;
import dagger.hilt.processor.internal.aggregateddeps.PkgPrivateEntryPointGenerator;
import dagger.hilt.processor.internal.aggregateddeps.PkgPrivateMetadata;
import dagger.hilt.processor.internal.aggregateddeps.PkgPrivateModuleGenerator;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

public final class AggregatedDepsProcessor
extends BaseProcessor {
    private static final ImmutableSet<ClassName> INSTALL_IN_ANNOTATIONS = ImmutableSet.builder().add((Object)ClassNames.INSTALL_IN).build();
    private static final ImmutableSet<ClassName> ENTRY_POINT_ANNOTATIONS = ImmutableSet.of((Object)ClassNames.ENTRY_POINT, (Object)ClassNames.GENERATED_ENTRY_POINT, (Object)ClassNames.COMPONENT_ENTRY_POINT);
    private final Set<Element> seen = new HashSet<Element>();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return (Set)ImmutableSet.builder().add((Object)ClassNames.MODULE).addAll(INSTALL_IN_ANNOTATIONS).addAll(ENTRY_POINT_ANNOTATIONS).build().stream().map(Object::toString).collect(DaggerStreams.toImmutableSet());
    }

    @Override
    public void processEach(TypeElement annotation, Element element) throws Exception {
        Optional<PkgPrivateMetadata> pkgPrivateMetadata;
        ImmutableSet<ClassName> components;
        if (!this.seen.add(element)) {
            return;
        }
        ImmutableSet installInAnnotations = (ImmutableSet)INSTALL_IN_ANNOTATIONS.stream().filter(installIn -> Processors.hasAnnotation(element, installIn)).collect(DaggerStreams.toImmutableSet());
        ImmutableSet entryPointAnnotations = (ImmutableSet)ENTRY_POINT_ANNOTATIONS.stream().filter(entryPoint -> Processors.hasAnnotation(element, entryPoint)).collect(DaggerStreams.toImmutableSet());
        ProcessorErrors.checkState(entryPointAnnotations.size() <= 1, element, "Found multiple @EntryPoint annotations on %s: %s", element, entryPointAnnotations);
        boolean hasInstallIn = !installInAnnotations.isEmpty();
        boolean isEntryPoint = !entryPointAnnotations.isEmpty();
        boolean isModule = Processors.hasAnnotation(element, ClassNames.MODULE);
        ProcessorErrors.checkState(!hasInstallIn || isEntryPoint || isModule, element, "@InstallIn can only be used on @Module or @EntryPoint classes: %s", element);
        ProcessorErrors.checkState(isModule != isEntryPoint, element, (Object)"@Module and @EntryPoint cannot be used on the same interface");
        ProcessorErrors.checkState(!isModule || hasInstallIn || AggregatedDepsProcessor.isDaggerGeneratedModule(element) || this.installInCheckDisabled(element), element, "%s must also be annotated with @InstallIn.", element);
        if (isModule && hasInstallIn) {
            ProcessorErrors.checkState(element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.INTERFACE, element, "Only classes and interfaces can be annotated with @Module: %s", element);
            TypeElement module = MoreElements.asType(element);
            List abstractMethodsWithMissingBinds = ElementFilter.methodsIn(module.getEnclosedElements()).stream().filter(method -> method.getModifiers().contains((Object)Modifier.ABSTRACT)).filter(method -> !Processors.hasDaggerAbstractMethodAnnotation(method)).collect(Collectors.toList());
            ProcessorErrors.checkState(abstractMethodsWithMissingBinds.isEmpty(), module, "Found unimplemented abstract methods, %s, in an abstract module, %s. Did you forget to add a Dagger binding annotation (e.g. @Binds)?", abstractMethodsWithMissingBinds, module);
            components = this.installInComponents(module);
            if (AggregatedDepsProcessor.isValidKind(module)) {
                pkgPrivateMetadata = PkgPrivateMetadata.of(this.getElementUtils(), module, ClassNames.MODULE);
                if (pkgPrivateMetadata.isPresent()) {
                    new PkgPrivateModuleGenerator(this.getProcessingEnv(), pkgPrivateMetadata.get()).generate();
                } else {
                    new AggregatedDepsGenerator("modules", module, components, this.getProcessingEnv()).generate();
                }
            }
        }
        if (isEntryPoint) {
            ClassName entryPointAnnotation = (ClassName)Iterables.getOnlyElement((Iterable)entryPointAnnotations);
            ProcessorErrors.checkState(hasInstallIn, element, "@%s %s must also be annotated with @InstallIn", entryPointAnnotation.simpleName(), element);
            ProcessorErrors.checkState(element.getKind() == ElementKind.INTERFACE, element, "Only interfaces can be annotated with @%s: %s", entryPointAnnotation.simpleName(), element);
            TypeElement entryPoint2 = MoreElements.asType(element);
            components = this.installInComponents(entryPoint2);
            if (AggregatedDepsProcessor.isValidKind(element)) {
                if (entryPointAnnotation.equals((Object)ClassNames.COMPONENT_ENTRY_POINT)) {
                    new AggregatedDepsGenerator("componentEntryPoints", entryPoint2, components, this.getProcessingEnv()).generate();
                } else {
                    pkgPrivateMetadata = PkgPrivateMetadata.of(this.getElementUtils(), entryPoint2, entryPointAnnotation);
                    if (pkgPrivateMetadata.isPresent()) {
                        new PkgPrivateEntryPointGenerator(this.getProcessingEnv(), pkgPrivateMetadata.get()).generate();
                    } else {
                        new AggregatedDepsGenerator("entryPoints", entryPoint2, components, this.getProcessingEnv()).generate();
                    }
                }
            }
        }
    }

    private ImmutableSet<ClassName> installInComponents(Element element) {
        return (ImmutableSet)Components.getComponentDescriptors(this.getElementUtils(), element).stream().map(ComponentDescriptor::component).collect(DaggerStreams.toImmutableSet());
    }

    private static boolean isValidKind(Element element) {
        return element.asType().getKind() != TypeKind.ERROR;
    }

    private boolean installInCheckDisabled(Element element) {
        return HiltCompilerOptions.BooleanOption.DISABLE_MODULES_HAVE_INSTALL_IN_CHECK.get(this.getProcessingEnv()) || Processors.hasAnnotation(element, ClassNames.DISABLE_INSTALL_IN_CHECK);
    }

    private static boolean isDaggerGeneratedModule(Element element) {
        if (!Processors.hasAnnotation(element, ClassNames.MODULE)) {
            return false;
        }
        return element.getAnnotationMirrors().stream().filter(mirror -> AggregatedDepsProcessor.isGenerated(mirror)).map(mirror -> AggregatedDepsProcessor.asString((AnnotationValue)Iterables.getOnlyElement(AggregatedDepsProcessor.asList(AnnotationMirrors.getAnnotationValue(mirror, "value"))))).anyMatch(value -> value.startsWith("dagger"));
    }

    private static List<? extends AnnotationValue> asList(AnnotationValue value) {
        return value.accept(new SimpleAnnotationValueVisitor8<List<? extends AnnotationValue>, Void>(){

            @Override
            public List<? extends AnnotationValue> visitArray(List<? extends AnnotationValue> value, Void unused) {
                return value;
            }
        }, null);
    }

    private static String asString(AnnotationValue value) {
        return value.accept(new SimpleAnnotationValueVisitor8<String, Void>(){

            @Override
            public String visitString(String value, Void unused) {
                return value;
            }
        }, null);
    }

    private static boolean isGenerated(AnnotationMirror annotationMirror) {
        Name name = MoreElements.asType(annotationMirror.getAnnotationType().asElement()).getQualifiedName();
        return name.contentEquals("javax.annotation.Generated") || name.contentEquals("javax.annotation.processing.Generated");
    }
}

