/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.aggregateddeps;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.BadInputException;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ComponentDescriptor;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.aggregateddeps.AggregatedDeps;
import dagger.hilt.processor.internal.aggregateddeps.AutoValue_ComponentDependencies_TestDepKey;
import dagger.hilt.processor.internal.aggregateddeps.PkgPrivateMetadata;
import dagger.internal.codegen.extension.DaggerStreams;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public final class ComponentDependencies {
    private final Dependencies modules;
    private final Dependencies entryPoints;
    private final Dependencies componentEntryPoints;

    private ComponentDependencies(Dependencies modules, Dependencies entryPoints, Dependencies componentEntryPoints) {
        this.modules = modules;
        this.entryPoints = entryPoints;
        this.componentEntryPoints = componentEntryPoints;
    }

    public ImmutableSet<TypeElement> getModules(ClassName componentName, ClassName rootName) {
        return this.modules.get(componentName, rootName);
    }

    public ImmutableSet<TypeElement> getEntryPoints(ClassName componentName, ClassName rootName) {
        return this.entryPoints.get(componentName, rootName);
    }

    public ImmutableSet<TypeElement> getComponentEntryPoints(ClassName componentName, ClassName rootName) {
        return this.componentEntryPoints.get(componentName, rootName);
    }

    public static ComponentDependencies from(ImmutableList<ComponentDescriptor> descriptors, Elements elements) {
        Dependencies.Builder moduleDeps = new Dependencies.Builder();
        Dependencies.Builder entryPointDeps = new Dependencies.Builder();
        Dependencies.Builder componentEntryPointDeps = new Dependencies.Builder();
        HashMap<String, TypeElement> testElements = new HashMap<String, TypeElement>();
        ImmutableMap descriptorLookup = (ImmutableMap)descriptors.stream().collect(DaggerStreams.toImmutableMap(descriptor -> descriptor.component().toString(), descriptor -> descriptor));
        for (AggregatedDeps deps : ComponentDependencies.getAggregatedDeps(elements)) {
            Optional<ClassName> test = Optional.empty();
            if (!deps.test().isEmpty()) {
                testElements.computeIfAbsent(deps.test(), testName -> elements.getTypeElement((CharSequence)testName));
                test = Optional.of(ClassName.get((TypeElement)((TypeElement)testElements.get(deps.test()))));
            }
            for (String component : deps.components()) {
                Preconditions.checkState((boolean)descriptorLookup.containsKey((Object)component), (String)"%s is not a valid Component. Did you add or remove code in package %s?", (Object)component, (Object)"hilt_aggregated_deps", (Object)component);
                ComponentDescriptor desc = (ComponentDescriptor)descriptorLookup.get((Object)component);
                for (String dep : deps.modules()) {
                    moduleDeps.addDep(desc.component(), test, elements.getTypeElement(dep));
                }
                for (String dep : deps.entryPoints()) {
                    entryPointDeps.addDep(desc.component(), test, elements.getTypeElement(dep));
                }
                for (String dep : deps.componentEntryPoints()) {
                    componentEntryPointDeps.addDep(desc.component(), test, elements.getTypeElement(dep));
                }
            }
        }
        for (TypeElement testElement : testElements.values()) {
            if (!Processors.hasAnnotation((Element)testElement, ClassNames.IGNORE_MODULES)) continue;
            moduleDeps.ignoreDeps(ClassName.get((TypeElement)testElement), ComponentDependencies.getIgnoredModules(testElement, elements));
        }
        return new ComponentDependencies(ComponentDependencies.validateModules(moduleDeps.build(), elements), entryPointDeps.build(), componentEntryPointDeps.build());
    }

    private static Dependencies validateModules(Dependencies moduleDeps, Elements elements) {
        HashMultimap invalidTestModules = HashMultimap.create();
        moduleDeps.testDeps.entries().stream().filter(e -> moduleDeps.ignoreDeps.containsEntry((Object)((TestDepKey)e.getKey()).test(), e.getValue())).forEach(arg_0 -> ComponentDependencies.lambda$validateModules$4((SetMultimap)invalidTestModules, arg_0));
        Optional invalidTest = invalidTestModules.keySet().stream().min((test1, test2) -> test1.toString().compareTo(test2.toString()));
        if (invalidTest.isPresent()) {
            throw new BadInputException(String.format("@UninstallModules on test, %s, should not containing test modules, but found: %s", invalidTest.get(), invalidTestModules.get((Object)((ClassName)invalidTest.get())).stream().sorted((test1, test2) -> test1.toString().compareTo(test2.toString())).collect(DaggerStreams.toImmutableList())), elements.getTypeElement(((ClassName)invalidTest.get()).toString()));
        }
        return moduleDeps;
    }

    private static ImmutableSet<TypeElement> getIgnoredModules(TypeElement testElement, Elements elements) {
        ImmutableList<TypeElement> userUninstallModules = Processors.getAnnotationClassValues(elements, Processors.getAnnotationMirror((Element)testElement, ClassNames.IGNORE_MODULES), "value");
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (TypeElement ignoreModule : userUninstallModules) {
            Optional<PkgPrivateMetadata> pkgPrivateMetadata = PkgPrivateMetadata.of(elements, ignoreModule, ClassNames.MODULE);
            builder.add((Object)(pkgPrivateMetadata.isPresent() ? elements.getTypeElement(pkgPrivateMetadata.get().generatedClassName().toString()) : ignoreModule));
        }
        return builder.build();
    }

    private static ImmutableList<AggregatedDeps> getAggregatedDeps(Elements elements) {
        PackageElement packageElement = elements.getPackageElement("hilt_aggregated_deps");
        Preconditions.checkState((packageElement != null ? 1 : 0) != 0, (String)"Couldn't find package %s. Did you mark your @Module classes with @InstallIn annotations?", (Object)"hilt_aggregated_deps");
        List<? extends Element> aggregatedDepsElements = packageElement.getEnclosedElements();
        Preconditions.checkState((!aggregatedDepsElements.isEmpty() ? 1 : 0) != 0, (Object)"No dependencies found. Did you mark your @Module classes with @InstallIn annotations?");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Element element : aggregatedDepsElements) {
            ProcessorErrors.checkState(element.getKind() == ElementKind.CLASS, element, "Only classes may be in package %s. Did you add custom code in the package?", "hilt_aggregated_deps");
            AggregatedDeps aggregatedDeps = element.getAnnotation(AggregatedDeps.class);
            ProcessorErrors.checkState(aggregatedDeps != null, element, "Classes in package %s must be annotated with @AggregatedDeps: %s. Found: %s.", "hilt_aggregated_deps", element.getSimpleName(), element.getAnnotationMirrors());
            builder.add((Object)aggregatedDeps);
        }
        return builder.build();
    }

    private static /* synthetic */ void lambda$validateModules$4(SetMultimap invalidTestModules, Map.Entry e) {
        invalidTestModules.put((Object)((TestDepKey)e.getKey()).test(), (Object)((TypeElement)e.getValue()));
    }

    private static final class Dependencies {
        private final ImmutableSetMultimap<ClassName, TypeElement> globalDeps;
        private final ImmutableSetMultimap<TestDepKey, TypeElement> testDeps;
        private final ImmutableSetMultimap<ClassName, TypeElement> ignoreDeps;

        Dependencies(ImmutableSetMultimap<ClassName, TypeElement> globalDeps, ImmutableSetMultimap<TestDepKey, TypeElement> testDeps, ImmutableSetMultimap<ClassName, TypeElement> ignoreDeps) {
            this.globalDeps = globalDeps;
            this.testDeps = testDeps;
            this.ignoreDeps = ignoreDeps;
        }

        ImmutableSet<TypeElement> get(ClassName component, ClassName test) {
            ImmutableSet ignoreTestDeps = this.ignoreDeps.get((Object)test);
            return ImmutableSet.builder().addAll((Iterable)this.globalDeps.get((Object)component).stream().filter(dep -> !ignoreTestDeps.contains(dep)).collect(DaggerStreams.toImmutableSet())).addAll((Iterable)this.testDeps.get((Object)TestDepKey.of(component, test))).build();
        }

        private static final class Builder {
            private final ImmutableSetMultimap.Builder<ClassName, TypeElement> globalDeps = ImmutableSetMultimap.builder();
            private final ImmutableSetMultimap.Builder<TestDepKey, TypeElement> testDeps = ImmutableSetMultimap.builder();
            private final ImmutableSetMultimap.Builder<ClassName, TypeElement> ignoreDeps = ImmutableSetMultimap.builder();

            private Builder() {
            }

            Builder addDep(ClassName component, Optional<ClassName> test, TypeElement dep) {
                if (test.isPresent()) {
                    this.testDeps.put((Object)TestDepKey.of(component, test.get()), (Object)dep);
                } else {
                    this.globalDeps.put((Object)component, (Object)dep);
                }
                return this;
            }

            Builder ignoreDeps(ClassName test, ImmutableSet<TypeElement> deps) {
                this.ignoreDeps.putAll((Object)test, deps);
                return this;
            }

            Dependencies build() {
                return new Dependencies((ImmutableSetMultimap<ClassName, TypeElement>)this.globalDeps.build(), (ImmutableSetMultimap<TestDepKey, TypeElement>)this.testDeps.build(), (ImmutableSetMultimap<ClassName, TypeElement>)this.ignoreDeps.build());
            }
        }
    }

    @AutoValue
    static abstract class TestDepKey {
        TestDepKey() {
        }

        static TestDepKey of(ClassName component, ClassName test) {
            return new AutoValue_ComponentDependencies_TestDepKey(component, test);
        }

        abstract ClassName component();

        abstract ClassName test();
    }
}

