/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.aggregateddeps;

import com.google.auto.value.AutoValue;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.aggregateddeps.AutoValue_PkgPrivateMetadata;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.Visibility;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

@AutoValue
abstract class PkgPrivateMetadata {
    private static final String PREFIX = "HiltWrapper_";

    PkgPrivateMetadata() {
    }

    TypeName baseClassName() {
        return TypeName.get((TypeMirror)this.getTypeElement().asType());
    }

    abstract TypeElement getTypeElement();

    abstract Optional<AnnotationMirror> getOptionalInstallInAnnotationMirror();

    abstract ClassName getAnnotation();

    final ClassName generatedClassName() {
        return Processors.prepend(Processors.getEnclosedClassName(ClassName.get((TypeElement)this.getTypeElement())), PREFIX);
    }

    static Optional<PkgPrivateMetadata> of(Elements elements, Element element, ClassName annotation) {
        if (Visibility.effectiveVisibilityOfElement(element) == Visibility.PUBLIC) {
            return Optional.empty();
        }
        if (!Processors.hasAnnotation(element, ClassNames.INSTALL_IN)) {
            throw new IllegalStateException("Expected element to be annotated with @InstallIn: " + element);
        }
        Optional<AnnotationMirror> installIn = Optional.of(Processors.getAnnotationMirror(element, ClassNames.INSTALL_IN));
        if (annotation.equals((Object)ClassNames.MODULE) && Processors.requiresModuleInstance(elements, MoreElements.asType(element))) {
            return Optional.empty();
        }
        return Optional.of(new AutoValue_PkgPrivateMetadata(MoreElements.asType(element), installIn, annotation));
    }
}

