/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.BaseProcessor;
import dagger.hilt.processor.internal.ComponentDescriptor;
import dagger.hilt.processor.internal.ComponentTree;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.aggregateddeps.ComponentDependencies;
import dagger.hilt.processor.internal.definecomponent.DefineComponents;
import dagger.hilt.processor.internal.generatesrootinput.GeneratesRootInputs;
import dagger.hilt.processor.internal.root.Root;
import dagger.hilt.processor.internal.root.RootGenerator;
import dagger.hilt.processor.internal.root.RootMetadata;
import dagger.hilt.processor.internal.root.RootType;
import dagger.hilt.processor.internal.root.TestComponentDataGenerator;
import dagger.hilt.processor.internal.root.TestComponentDataSupplierGenerator;
import dagger.hilt.processor.internal.root.TestInjectorGenerator;
import dagger.hilt.processor.internal.root.TestRootMetadata;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.shaded.auto.common.MoreElements;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public final class RootProcessor
extends BaseProcessor {
    private final List<ClassName> rootNames = new ArrayList<ClassName>();
    private final Set<ClassName> processed = new HashSet<ClassName>();
    private boolean isTestEnv;
    private GeneratesRootInputs generatesRootInputs;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.generatesRootInputs = new GeneratesRootInputs(processingEnvironment);
    }

    public ImmutableSet<String> getSupportedAnnotationTypes() {
        return ImmutableSet.builder().addAll((Iterable)Arrays.stream(RootType.values()).map(rootType -> rootType.className().toString()).collect(DaggerStreams.toImmutableSet())).build();
    }

    @Override
    public void processEach(TypeElement annotation, Element element) throws Exception {
        TypeElement rootElement = MoreElements.asType(element);
        boolean isTestRoot = RootType.of(this.getProcessingEnv(), rootElement).isTestRoot();
        Preconditions.checkState((this.rootNames.isEmpty() || this.isTestEnv == isTestRoot ? 1 : 0) != 0, (String)"Cannot mix test roots with non-test roots:\n\tNon-Test Roots: %s\n\tTest Roots: %s", (Object)(isTestRoot ? this.rootNames : rootElement), (Object)(isTestRoot ? rootElement : this.rootNames));
        this.isTestEnv = isTestRoot;
        this.rootNames.add(ClassName.get((TypeElement)rootElement));
        if (this.isTestEnv) {
            new TestInjectorGenerator(this.getProcessingEnv(), TestRootMetadata.of(this.getProcessingEnv(), rootElement)).generate();
        } else {
            ProcessorErrors.checkState(this.rootNames.size() <= 1, element, "More than one root found: %s", this.rootNames);
        }
    }

    @Override
    public void postRoundProcess(RoundEnvironment roundEnv) throws Exception {
        ImmutableSet<Element> newElements = this.generatesRootInputs.getElementsToWaitFor(roundEnv);
        if (!this.processed.isEmpty()) {
            Preconditions.checkState((boolean)newElements.isEmpty(), (String)"Found extra modules after compilation: %s\n(If you are adding an annotation processor that generates root input for hilt, the annotation must be annotated with @dagger.hilt.GeneratesRootInput.\n)", newElements);
        }
        if (!newElements.isEmpty()) {
            return;
        }
        ImmutableList rootsToProcess = (ImmutableList)this.rootNames.stream().filter(rootName -> !this.processed.contains(rootName)).map(rootName -> this.getElementUtils().getTypeElement(rootName.toString())).map(rootElement -> Root.create(rootElement, this.getProcessingEnv())).collect(DaggerStreams.toImmutableList());
        if (rootsToProcess.isEmpty()) {
            return;
        }
        try {
            ImmutableList<ComponentDescriptor> descriptors = DefineComponents.componentDescriptors(this.getElementUtils());
            ComponentTree tree = ComponentTree.from(descriptors);
            ComponentDependencies deps = ComponentDependencies.from(descriptors, this.getElementUtils());
            ImmutableList rootMetadatas = (ImmutableList)rootsToProcess.stream().map(root -> RootMetadata.create(root, tree, deps, this.getProcessingEnv())).collect(DaggerStreams.toImmutableList());
            for (RootMetadata rootMetadata : rootMetadatas) {
                this.setProcessingState(rootMetadata.root());
                this.generateComponents(rootMetadata);
            }
            if (this.isTestEnv) {
                this.generateTestComponentData((ImmutableList<RootMetadata>)rootMetadatas);
            }
        }
        catch (Exception e) {
            for (Root root2 : rootsToProcess) {
                this.processed.add(root2.classname());
            }
            throw e;
        }
    }

    private void setProcessingState(Root root) {
        this.processed.add(root.classname());
    }

    private void generateComponents(RootMetadata rootMetadata) throws IOException {
        RootGenerator.generate(rootMetadata, this.getProcessingEnv());
    }

    private void generateTestComponentData(ImmutableList<RootMetadata> rootMetadatas) throws IOException {
        for (RootMetadata rootMetadata : rootMetadatas) {
            TypeElement testElement = rootMetadata.testRootMetadata().testElement();
            ProcessorErrors.checkState(testElement.getModifiers().contains((Object)Modifier.PUBLIC), testElement, "Hilt tests must be public, but found: %s", testElement);
            new TestComponentDataGenerator(this.getProcessingEnv(), rootMetadata).generate();
        }
        new TestComponentDataSupplierGenerator(this.getProcessingEnv(), rootMetadatas).generate();
    }
}

