/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.common.base.Preconditions;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

final class DateUtils {
    static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    static final String PATTERN_RFC1036 = "EEE, dd-MMM-yy HH:mm:ss zzz";
    static final String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
    private static final SimpleDateFormat[] DEFAULT_PATTERNS = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz"), new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss zzz"), new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy")};
    static final TimeZone GMT = TimeZone.getTimeZone("GMT");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDate(String dateValue) {
        String v = (String)Preconditions.checkNotNull((Object)dateValue);
        if (v.length() > 1 && v.startsWith("'") && v.endsWith("'")) {
            v = v.substring(1, v.length() - 1);
        }
        for (SimpleDateFormat datePattern : DEFAULT_PATTERNS) {
            ParsePosition pos = new ParsePosition(0);
            SimpleDateFormat simpleDateFormat = datePattern;
            synchronized (simpleDateFormat) {
                Date result = datePattern.parse(v, pos);
                if (pos.getIndex() != 0) {
                    return result;
                }
            }
        }
        return null;
    }

    private DateUtils() {
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(GMT);
        calendar.set(2000, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        Date defaultTwoDigitYearStart = calendar.getTime();
        for (SimpleDateFormat datePattern : DEFAULT_PATTERNS) {
            datePattern.set2DigitYearStart(defaultTwoDigitYearStart);
        }
    }
}

