/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.snapshot;

import com.google.firebase.database.core.Path;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.KeyIndex;
import com.google.firebase.database.snapshot.NamedNode;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.snapshot.PathIndex;
import com.google.firebase.database.snapshot.ValueIndex;
import java.util.Comparator;

public abstract class Index
implements Comparator<NamedNode> {
    public static Index fromQueryDefinition(String str) {
        if (str.equals(".value")) {
            return ValueIndex.getInstance();
        }
        if (str.equals(".key")) {
            return KeyIndex.getInstance();
        }
        if (str.equals(".priority")) {
            throw new IllegalStateException("queryDefinition shouldn't ever be .priority since it's the default");
        }
        return new PathIndex(new Path(str));
    }

    public abstract boolean isDefinedOn(Node var1);

    public boolean indexedValueChanged(Node oldNode, Node newNode) {
        NamedNode newWrapped;
        NamedNode oldWrapped = new NamedNode(ChildKey.getMinName(), oldNode);
        return this.compare(oldWrapped, newWrapped = new NamedNode(ChildKey.getMinName(), newNode)) != 0;
    }

    public abstract NamedNode makePost(ChildKey var1, Node var2);

    public NamedNode minPost() {
        return NamedNode.getMinNode();
    }

    public abstract NamedNode maxPost();

    public abstract String getQueryDefinition();

    public int compare(NamedNode one, NamedNode two, boolean reverse) {
        if (reverse) {
            return this.compare(two, one);
        }
        return this.compare(one, two);
    }
}

