/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom;

import com.tve.custom.command.BuildApkMonitor;
import com.tve.custom.factory.CompatGeneratorFactory;
import com.tve.custom.factory.CompatGeneratorInterface;
import com.tve.custom.generator.APKGenerator;
import com.tve.custom.generator.AppPropertiesGenerator;
import com.tve.custom.generator.ColorClassGenerator;
import com.tve.custom.generator.ColorGenerator;
import com.tve.custom.generator.ConfigsGenerator;
import com.tve.custom.generator.DefaultLangGenerator;
import com.tve.custom.generator.DimensGenerator;
import com.tve.custom.generator.DrawableGenerator;
import com.tve.custom.generator.IntegerGenerator;
import com.tve.custom.generator.LayoutGenerator;
import com.tve.custom.generator.ResGenerator;
import com.tve.custom.generator.SLoadingStyleGenerator;
import com.tve.custom.generator.StringGenerator;
import com.tve.custom.generator.ThemeGenerator;
import com.tve.custom.generator.model.AppConfig;
import com.tve.custom.generator.model.CustomAttribute;
import com.tve.custom.generator.model.CustomBitmapDrawable;
import com.tve.custom.generator.model.CustomStrings;
import com.tve.custom.generator.model.ResConfig;
import com.tve.custom.generator.model.SLoadingStyle;
import com.tve.custom.generator.model.SignConfig;
import com.tve.custom.utils.CustomFilePathUtil;
import com.tve.custom.utils.FileUtil;
import com.tve.custom.utils.LogUtil;
import com.tve.custom.utils.TextUtil;
import com.tve.custom.utils.VideoUtil;
import com.tve.custom.utils.ZipUtil;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class CustomManager {
    protected int mTerminalType = 0;
    private String mProjectDir;
    private CustomCallback mCallback;
    protected AppConfig mAppConfig;
    private boolean isLauncherIconReady = false;
    private SignConfig mSignFile;
    private ConcurrentMap<String, CustomBitmapDrawable> mBitmapDrawableToDownloadMap;
    private ExecutorService mDownloadExecutor;
    protected String mTemplateLayout = "";
    private String mAppTheme = "";
    private String mColorClass = "";
    private String mAdvanced = "";
    private String mResDir = "";
    private String mRepositoryDir;
    private String mLayoutRepositoryDir;
    private String mThemeRepositoryDir;
    private String mColorRepositoryDir;
    private String mAdvancedRepositoryDir;
    private String mStartingVideoUrl = "";
    private String mStartingVideoCurtainUrl = "";
    private LinkedHashMap<String, CustomStrings> mStringsMap;
    private Map<String, Map<String, String>> mDrawableMap;
    private Map<String, SLoadingStyle> mSloadingStyleMap;
    private Map<String, CustomAttribute> mCustomAttributeMap;
    private LinkedHashMap<String, String> mColorMap;
    private LinkedHashMap<String, String> mDimensMap;
    private LinkedHashMap<String, String> mAppPropertiesMap;
    private LinkedHashMap<String, String> mIntegersMap;
    private APKGenerator mAPKGenerator;
    private BuildResult mBuildResult;
    private Progress mProgress;
    private String mBuildOs = "linux";
    private int mEnv = 0;
    private String mIjmApi = "http://34.237.162.164:9999/api";
    private DownLoadMonitor mDownloadMonitor;
    private BuildApkMonitor mBuildApkMonitor;
    protected CustomFilePathUtil mCustomFilePathUtil;
    private ConcurrentHashMap<String, CustomBitmapDrawable> mBitmapDrawableToDownloadBkMap;
    private LinkedHashMap<String, String> mColorBkMap;
    private LinkedHashMap<String, String> mDimensBkMap;
    private LinkedHashMap<String, String> mAppPropertiesBkMap;
    private LinkedHashMap<String, CustomStrings> mStringsBkMap;
    private Map<String, SLoadingStyle> mSloadingStyleBkMap;
    private Map<String, CustomAttribute> mCustomAttributeBkMap;
    private Map<String, Map<String, String>> mDrawableBkMap;
    private Map<String, String> mDisplayLayoutStyleBkMap;
    private Map<String, String> mBasicAppBkConfig;
    private boolean mEnableIjm = true;
    private final Object mBuildingLock = new Object();
    private boolean mIsBuilding = false;
    private int mRetry = 0;

    public CustomManager(int type, String taskId, String targetDir, String projectDir, String repositoryDir, String toolsDir, Map<String, String> paras) throws Exception {
        File projectDirFile;
        LogUtil.d("CustomManager Version v3.0.4beta2");
        if (TextUtil.isEmpty(targetDir) || TextUtil.isEmpty(projectDir)) {
            this.throwException("Project dir is empty");
        }
        if (!(projectDirFile = new File(projectDir)).exists() || !projectDirFile.isDirectory()) {
            this.throwException("Project dir is not valid");
        }
        this.mTerminalType = type;
        if (this.mAppConfig == null) {
            this.mAppConfig = new AppConfig(this.mTerminalType);
        }
        this.mAppConfig.setBuildParas(type, paras);
        this.init(type, taskId, targetDir, projectDir, repositoryDir, toolsDir);
    }

    private void init(int type, String taskId, String targetDir, String projectDir, String repositoryDir, String toolsDir) {
        this.mProjectDir = projectDir;
        this.mCustomFilePathUtil = new CustomFilePathUtil(type, targetDir, this.mProjectDir, toolsDir, this.mAppConfig);
        this.mRepositoryDir = repositoryDir;
        this.mLayoutRepositoryDir = this.mRepositoryDir + File.separator + "layout";
        this.mThemeRepositoryDir = this.mRepositoryDir + File.separator + "theme";
        this.mColorRepositoryDir = this.mRepositoryDir + File.separator + "color";
        this.mAdvancedRepositoryDir = this.mRepositoryDir + File.separator + "advanced";
        this.mBitmapDrawableToDownloadMap = new ConcurrentHashMap<String, CustomBitmapDrawable>();
        this.mStringsMap = new LinkedHashMap();
        this.mDrawableMap = new HashMap<String, Map<String, String>>();
        this.mSloadingStyleMap = new HashMap<String, SLoadingStyle>();
        this.mCustomAttributeMap = new HashMap<String, CustomAttribute>();
        this.mColorMap = new LinkedHashMap();
        this.mAppPropertiesMap = new LinkedHashMap();
        this.mDimensMap = new LinkedHashMap();
        this.mIntegersMap = new LinkedHashMap();
        this.mBuildResult = new BuildResult();
        this.mBuildResult.taskId = taskId;
        this.mProgress = new Progress();
        this.mProgress.taskId = taskId;
        this.mAPKGenerator = new APKGenerator(taskId, this.mCallback, this.mAppConfig);
        this.mBitmapDrawableToDownloadBkMap = new ConcurrentHashMap();
        this.mColorBkMap = new LinkedHashMap();
        this.mDimensBkMap = new LinkedHashMap();
        this.mAppPropertiesBkMap = new LinkedHashMap();
        this.mStringsBkMap = new LinkedHashMap();
        this.mSloadingStyleBkMap = new HashMap<String, SLoadingStyle>();
        this.mCustomAttributeBkMap = new HashMap<String, CustomAttribute>();
        this.mDrawableBkMap = new HashMap<String, Map<String, String>>();
        this.mDisplayLayoutStyleBkMap = new HashMap<String, String>();
        this.mBasicAppBkConfig = new HashMap<String, String>();
        this.mBuildApkMonitor = new BuildApkMonitor();
    }

    public void setBasicAPPConfigs(String key, String value) {
        if (this.mAppConfig == null) {
            this.mAppConfig = new AppConfig(this.mTerminalType);
        }
        this.mAppConfig.addBasicAppConfig(key, value);
    }

    public void setPkgProperties(String key, String value) {
        if (this.mAppConfig == null) {
            this.mAppConfig = new AppConfig(this.mTerminalType);
        }
        this.mAppConfig.addPkgConfig(key, value);
    }

    public void addFunctionConfigs(String key, String value) {
        if (this.mAppConfig == null) {
            this.mAppConfig = new AppConfig(this.mTerminalType);
        }
        this.mAppConfig.addFunction(key, value);
    }

    public void setLauncherIconUrl(String url, String freeTrialUrl) {
        if (!TextUtil.isEmpty(url)) {
            CustomBitmapDrawable icon = this.processBitmapUrl("ic_launcher", url);
            this.mBitmapDrawableToDownloadMap.put(icon.id, icon);
        }
        if (TextUtil.isEmpty(freeTrialUrl)) {
            if (TextUtil.isEmpty(url)) {
                return;
            }
            freeTrialUrl = url;
        }
        CustomBitmapDrawable iconTrial = this.processBitmapUrl("ic_launcher_freetrial", freeTrialUrl);
        this.mBitmapDrawableToDownloadMap.put(iconTrial.id, iconTrial);
    }

    public void setBitmapUrl(String key, String url) {
        if (TextUtil.isEmpty(key) || TextUtil.isEmpty(url)) {
            return;
        }
        CustomBitmapDrawable bitmap = this.processBitmapUrl(key, url);
        this.mBitmapDrawableToDownloadMap.put(key, bitmap);
    }

    private void processResource(String key, String value) {
        switch (key) {
            case "ic_launcher": {
                this.setLauncherIconUrl(value, null);
                break;
            }
            case "ic_launcher_freetrial": {
                this.setLauncherIconUrl(null, value);
                break;
            }
            case "bootvideo_curtain": {
                this.mStartingVideoCurtainUrl = value;
                if (TextUtil.isEmpty(value)) {
                    return;
                }
                CustomBitmapDrawable curtain = this.processBitmapUrl("bootvideo_curtain", this.mStartingVideoCurtainUrl);
                this.mBitmapDrawableToDownloadMap.put(curtain.id, curtain);
            }
        }
        this.setBitmapUrl(key, value);
    }

    private CustomBitmapDrawable processBitmapUrl(String name, String url) {
        CustomBitmapDrawable bitmapDrawable = new CustomBitmapDrawable();
        bitmapDrawable.downloadUrl = url;
        bitmapDrawable.id = name;
        bitmapDrawable.format = FileUtil.getDrawableUrlFormat(url);
        return bitmapDrawable;
    }

    private void processSloadingStyle(String name, String value) {
        String[] values = value.split(",");
        if (value.length() != 3) {
            LogUtil.e("process sloading style error : id " + name + " ; value : " + value);
            return;
        }
        SLoadingStyle sLoadingStyle = new SLoadingStyle();
        sLoadingStyle.style = values[0];
        sLoadingStyle.color = values[1];
        sLoadingStyle.extraColor = values[2];
        this.mSloadingStyleMap.put(name, sLoadingStyle);
    }

    public void setServerAddress(LinkedHashMap<String, String> serverMap) {
        this.mAppConfig.setServerMap(serverMap);
    }

    public void addServerAddress(String key, String adress) {
        this.mAppConfig.addServerAddress(key, adress);
    }

    public String getServerAddress(String key) {
        return this.mAppConfig.getServerAddress(key);
    }

    public void setRepositoryDir(String dir) {
        this.mRepositoryDir = dir;
    }

    public void setAppTheme(String name) {
        this.mAppTheme = name;
    }

    public String getAppTheme() {
        return this.mAppTheme;
    }

    public void setAppTemplate(String name) {
        if (TextUtil.isEmpty(name)) {
            LogUtil.e("Template name is null , default value will work.");
        }
        this.mTemplateLayout = name;
    }

    public String getTemplateLayout() {
        return this.mTemplateLayout;
    }

    public void setAppColorClass(String name) {
        if (TextUtil.isEmpty(name)) {
            LogUtil.e("ColorClass name is null , default value will work.");
        }
        this.mColorClass = name;
    }

    public String getColorClass() {
        return this.mColorClass;
    }

    public void setColor(String id, String colorValue) {
        if (TextUtil.isEmpty(id) || TextUtil.isEmpty(colorValue)) {
            LogUtil.e("id or colorValue is empty");
        }
        this.mColorMap.put(id, colorValue);
    }

    public void setDimens(String id, String dimenValue) {
        if (TextUtil.isEmpty(id) || TextUtil.isEmpty(dimenValue)) {
            LogUtil.e("id or dimenValue is empty");
        }
        this.mDimensMap.put(id, dimenValue);
    }

    public void setIntegers(String id, String integerValue) {
        if (TextUtil.isEmpty(id) || TextUtil.isEmpty(integerValue)) {
            LogUtil.e("id or integerValue is empty");
        }
        this.mIntegersMap.put(id, integerValue);
    }

    public void setAppProperties(String id, String propertiesValue) {
        if (TextUtil.isEmpty(id) || TextUtil.isEmpty(propertiesValue)) {
            LogUtil.e("id or propertiesValue is empty");
        }
        this.mAppPropertiesMap.put(id, propertiesValue);
    }

    public void setRes(String dir) {
        if (TextUtil.isEmpty(dir)) {
            LogUtil.e("dir is empty");
        }
        this.mResDir = dir;
    }

    public void setAdavancedConfig(String name) {
        this.mAdvanced = name;
    }

    public void addLayoutDisplayStyle(String key, String value) {
        if (TextUtil.isEmpty(value)) {
            LogUtil.e("Layout is invalid!");
            return;
        }
        if (this.mAppConfig == null) {
            this.mAppConfig = new AppConfig(this.mTerminalType);
        }
        this.mAppConfig.addLayoutDisplayStyle(key, value);
    }

    public void setLoadingVideoUrl(String videoUrl, String curtainUrl) {
        if (TextUtil.isEmpty(videoUrl)) {
            return;
        }
        this.mStartingVideoUrl = videoUrl;
        this.mStartingVideoCurtainUrl = curtainUrl;
        this.mAppConfig.addBasicAppConfig("CUSTOM_BOOT_LOAD_TYPE", "1");
        if (TextUtil.isEmpty(curtainUrl)) {
            return;
        }
        CustomBitmapDrawable curtain = this.processBitmapUrl("bootvideo_curtain", this.mStartingVideoCurtainUrl);
        this.mBitmapDrawableToDownloadMap.put(curtain.id, curtain);
    }

    public void setLoadingBackgroundUrl(String url) {
        CustomBitmapDrawable mainBg = this.processBitmapUrl("main_bg", url);
        this.mBitmapDrawableToDownloadMap.put(mainBg.id, mainBg);
    }

    public void setDrawables(String dir, HashMap<String, String> drawables) {
        if (drawables == null || drawables.size() == 0) {
            LogUtil.d("drawables map is empty, do not need to setDrawables");
            return;
        }
        Map<String, String> customDrawables = this.mDrawableMap.get(dir);
        if (customDrawables == null) {
            customDrawables = new HashMap<String, String>();
        }
        customDrawables.putAll(drawables);
        this.mDrawableMap.put(dir, customDrawables);
    }

    public void setStrings(String lan, LinkedHashMap<String, String> strings) {
        this.addString(lan, strings);
    }

    private void addString(String lan, LinkedHashMap<String, String> strings) {
        if (!CustomStrings.isValidLanuage(this.mTerminalType, lan)) {
            LogUtil.d("Langurage '" + lan + "' is invalid!");
            return;
        }
        CustomStrings customStrings = this.mStringsMap.get(lan);
        if (customStrings == null) {
            customStrings = new CustomStrings();
            customStrings.language = lan;
        }
        LinkedHashMap<String, String> lanStringMap = customStrings.stringMap;
        for (String stringName : strings.keySet()) {
            String stringValue = strings.get(stringName);
            if (stringValue.startsWith("?") || stringValue.startsWith("@")) {
                stringValue = "\\" + stringValue;
            }
            LogUtil.d("[addString] lang = " + lan + "; stringName = " + stringName + "; stringValue = " + stringValue);
            if (!stringValue.startsWith("<![CDATA")) {
                if ("app_name".equals(stringName)) {
                    lanStringMap.put("app_name_prod", "<![CDATA" + stringValue + "]]>");
                    lanStringMap.put("app_name_uat", "<![CDATA" + stringValue + "(TEST)" + "]]>");
                    lanStringMap.put("app_name", "<![CDATA" + stringValue + "]]>");
                    continue;
                }
                lanStringMap.put(stringName, "<![CDATA" + stringValue + "]]>");
                continue;
            }
            if ("app_name".equals(stringName)) {
                lanStringMap.put("app_name_prod", stringValue);
                lanStringMap.put("app_name_uat", stringValue + "(TEST)");
                lanStringMap.put("app_name", stringValue);
                continue;
            }
            lanStringMap.put(stringName, stringValue);
        }
        this.mStringsMap.put(lan, customStrings);
    }

    private void addString(String lan, String key, String value) {
        if (!CustomStrings.isValidLanuage(this.mTerminalType, lan)) {
            LogUtil.d("Langurage '" + lan + "' is invalid!");
            return;
        }
        CustomStrings customStrings = this.mStringsMap.get(lan);
        if (customStrings == null) {
            customStrings = new CustomStrings();
            customStrings.language = lan;
            this.mStringsMap.put(lan, customStrings);
        }
        LinkedHashMap<String, String> lanStringMap = customStrings.stringMap;
        lanStringMap.put(key, value);
    }

    public void setSLoadingStyle(String name, String style, String color, String extraColor) {
        SLoadingStyle sLoadingStyle = new SLoadingStyle();
        sLoadingStyle.style = style;
        sLoadingStyle.color = color;
        sLoadingStyle.extraColor = extraColor;
        this.mSloadingStyleMap.put(name, sLoadingStyle);
    }

    public void setSLoadingStyle(String key, String value) {
        String[] values = value.split(",");
        if (values.length != 3) {
            return;
        }
        String style = values[0];
        String color = values[1];
        String extraColor = values[2];
        this.setSLoadingStyle(key, style, color, extraColor);
    }

    public void setCustomLayoutAttribute(String layout, String widgetId, String attributeName, String attributeValue) {
        if (TextUtil.isEmpty(layout) || TextUtil.isEmpty(widgetId) || TextUtil.isEmpty(attributeName) || TextUtil.isEmpty(attributeValue)) {
            LogUtil.e("error custom attribute : " + layout + " , " + widgetId + " ," + attributeName + " , " + attributeValue);
            return;
        }
        CustomAttribute customAttribute = this.mCustomAttributeMap.containsKey(layout) ? this.mCustomAttributeMap.get(layout) : CustomAttribute.newCustomAttribute(layout, widgetId);
        customAttribute.layoutFile = layout;
        customAttribute.id = widgetId;
        customAttribute.addCustomAttributes(attributeName, attributeValue);
        this.mCustomAttributeMap.put(layout, customAttribute);
    }

    public void setCustomLayoutAttribute(String key, String value) {
        if (TextUtil.isEmpty(key) || TextUtil.isEmpty(value)) {
            LogUtil.e("error custom attribute : " + key + " , " + value);
            return;
        }
        String[] layoutAndId = key.split(",");
        String[] attributePair = value.split(",");
        String layout = layoutAndId[0];
        String widgetId = layoutAndId[1];
        String attributeName = attributePair[0];
        String attributeValue = attributePair[1];
        this.setCustomLayoutAttribute(layout, widgetId, attributeName, attributeValue);
    }

    public void generateApkCode() {
        this.onProgress(1, 0, 0, "prepare resource start", 0, 0);
        if (this.mDownloadMonitor == null) {
            this.mDownloadMonitor = new DownLoadMonitor();
        } else {
            this.mDownloadMonitor.reset();
        }
        Map<String, Object> ret = this.checkEnvironment();
        Boolean result = (Boolean)ret.get("result");
        if (!result.booleanValue()) {
            this.onProgress(1, 0, 1, "prepare resource failed", 1, 0);
            this.sendFailed(1, (String)ret.get("errMsg"));
            return;
        }
        this.backupCustomParas();
        CompatGeneratorInterface CompatGenerator = CompatGeneratorFactory.getCompatGenerator(this.mTerminalType);
        CompatGenerator.generateConfig(this.mAppConfig.getBrandID(), this.mAppConfig.getAppID(), this.mAppConfig);
        if (!TextUtil.isEmpty(this.mAppConfig.getSignFilePath())) {
            this.mSignFile = new SignConfig();
            this.mSignFile.setKeyAlias(this.mAppConfig.getKeyAlias());
            this.mSignFile.setKeyPwd(this.mAppConfig.getKeyPassword());
            this.mSignFile.setStorePwd(this.mAppConfig.getStorePassword());
            this.mSignFile.setPath(this.mAppConfig.getSignFilePath());
            this.mSignFile.setName(this.mAppConfig.getSignFilePath());
        } else {
            this.mSignFile = CompatGenerator.getSignFile(this.mProjectDir, this.mAppConfig.getBrandID(), this.mAppConfig.getAppID(), this.mAppConfig);
        }
        this.mAppConfig.setSignInfo(this.mSignFile);
        this.mAdvanced = CompatGenerator.getAdvancedConfig(this.mAppConfig.getBrandID(), this.mAppConfig.getAppID());
        this.generateResInternal();
        this.generateResExternal();
        this.restoreCustomParas();
        if (this.mDownloadExecutor == null) {
            this.mDownloadExecutor = Executors.newFixedThreadPool(2);
        }
        String targetBitmapBaseDir = this.mCustomFilePathUtil.getCustomResDir() + File.separator;
        this.mDownloadMonitor.registerDownloadingDrawables(this.mBitmapDrawableToDownloadMap.keySet());
        if (this.mBitmapDrawableToDownloadMap == null || this.mBitmapDrawableToDownloadMap.isEmpty()) {
            this.mDownloadMonitor.downloadDrawableResultNotify(true);
        } else {
            for (String drawableId : this.mBitmapDrawableToDownloadMap.keySet()) {
                final CustomBitmapDrawable bmpDrawable = (CustomBitmapDrawable)this.mBitmapDrawableToDownloadMap.get(drawableId);
                FileUtil.DownloadCallback downloadCallback = new FileUtil.DownloadCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onFnished(boolean success, String format) {
                        boolean isStandardFormat = true;
                        if (success) {
                            bmpDrawable.downloaded = true;
                            if (CustomManager.this.isAppIcon(bmpDrawable.id)) {
                                if (CustomManager.this.checkAppIcon(bmpDrawable.id, format)) {
                                    CustomManager.this.transformAppIcon(bmpDrawable.id, format);
                                } else {
                                    isStandardFormat = false;
                                }
                            }
                            CustomManager.this.onProgress(1, CustomManager.this.convert2SubEventId(bmpDrawable.id), 0, " download success " + bmpDrawable.id, 1, 0);
                        } else {
                            LogUtil.e("Bitmap download failed , url : " + bmpDrawable.downloadUrl);
                            CustomManager.this.onProgress(1, CustomManager.this.convert2SubEventId(bmpDrawable.id), 8, " download failed " + bmpDrawable.id, 1, 0);
                        }
                        DownLoadMonitor downLoadMonitor = CustomManager.this.mDownloadMonitor;
                        synchronized (downLoadMonitor) {
                            CustomManager.this.mDownloadMonitor.downloadDrawableResultNotify(bmpDrawable, success, isStandardFormat);
                        }
                    }
                };
                this.onProgress(1, this.convert2SubEventId(bmpDrawable.id), 0, "start to download " + bmpDrawable.id, 0, 0);
                String targetBitmapDir = targetBitmapBaseDir + (this.isAppIcon(bmpDrawable.id) ? this.getIconDefaultDpi() : this.getDefaultDpi());
                FileUtil.downloadDrawable(this.mDownloadExecutor, bmpDrawable.downloadUrl, targetBitmapDir, bmpDrawable.id, bmpDrawable.format, downloadCallback);
            }
        }
        if (!TextUtil.isEmpty(this.mStartingVideoUrl)) {
            final String videoFormat = FileUtil.getVideoUrlFormat(this.mStartingVideoUrl);
            FileUtil.DownloadCallback downloadCallback = new FileUtil.DownloadCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFnished(boolean success, String format) {
                    if (success) {
                        LogUtil.d("Starting video download sucess");
                        CustomManager.this.onProgress(1, 108, 0, " download video success", 1, 0);
                        CustomManager.this.handleBootupVideo(TextUtil.isEmpty(format) ? videoFormat : format);
                    } else {
                        LogUtil.e("Bitmap download failed , url : " + CustomManager.this.mStartingVideoUrl);
                        CustomManager.this.onProgress(1, 108, 0, " download video failed", 1, 0);
                    }
                    DownLoadMonitor downLoadMonitor = CustomManager.this.mDownloadMonitor;
                    synchronized (downLoadMonitor) {
                        CustomManager.this.mDownloadMonitor.downloadVideoResultNotify(success);
                    }
                }
            };
            this.onProgress(1, 108, 0, " start to download video ", 0, 0);
            FileUtil.downloadStartingVideo(this.mDownloadExecutor, this.mStartingVideoUrl, this.mCustomFilePathUtil, downloadCallback);
        } else {
            this.mDownloadMonitor.downloadVideoResultNotify(true);
        }
        DefaultLangGenerator.generate(this.mCustomFilePathUtil, this.mRepositoryDir, this.mAppConfig.getDefaultLang(this.mTerminalType));
        StringGenerator.copyStringRes(this.mTerminalType, this.mCustomFilePathUtil, this.mAppConfig.getStringExtPath(), this.mAppConfig.getDefaultLang(this.mTerminalType));
        StringGenerator.generate(this.mTerminalType, this.mCustomFilePathUtil, this.mStringsMap, this.mAppConfig.getDefaultLang(this.mTerminalType));
        DimensGenerator.generate(this.mCustomFilePathUtil, this.mDimensMap);
        IntegerGenerator.generate(this.mCustomFilePathUtil, this.mIntegersMap);
        AppPropertiesGenerator.generate(this.mCustomFilePathUtil, this.mAppPropertiesMap);
        ColorGenerator.generate(this.mCustomFilePathUtil, this.mColorMap);
        DrawableGenerator.copyHDpiDrawableFile(this.mCustomFilePathUtil, this.mDrawableMap);
        SLoadingStyleGenerator.generateSloadingStyleXml(this.mCustomFilePathUtil, this.mSloadingStyleMap);
        LayoutGenerator.generateCustomLayout(this.mCustomFilePathUtil, this.mCustomAttributeMap);
        this.generateGradleProperty(this.mTerminalType);
        this.mDownloadMonitor.isMainProcedureFinished = true;
        this.mDownloadMonitor.generateApkIfReady();
    }

    public void setCallback(CustomCallback callback) {
        if (callback != null) {
            this.mCallback = callback;
            if (this.mAPKGenerator != null) {
                this.mAPKGenerator.setCallback(callback);
            }
        }
    }

    public void setOs(String os) {
        this.mBuildOs = os;
    }

    public void setEnv(int env) {
        this.mEnv = env;
    }

    public void setIjmApi(String ijmApi) {
        this.mIjmApi = ijmApi;
    }

    public void buildApk() {
        this.mDownloadMonitor.generateApkIfReady();
    }

    public void buildApk(CustomCallback callback) {
        if (callback != null) {
            this.mCallback = callback;
        }
        this.mDownloadMonitor.generateApkIfReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateApkNow(final String os, final int env, final String ijmApi, final CustomCallback callback) {
        Object object = this.mBuildingLock;
        synchronized (object) {
            if (this.mIsBuilding) {
                LogUtil.d("apk is building...");
                return;
            }
            this.mIsBuilding = true;
        }
        this.onProgress(1, 0, 0, "prepare resource success", 1, 0);
        BuildApkMonitor.ResultUpdateListener buildResultUpdateListener = new BuildApkMonitor.ResultUpdateListener(){

            @Override
            public void onResultSuccess() {
                LogUtil.d("Build APK finish : starting resign procedure : ");
                CustomManager.this.onProgress(2, 0, 0, "compile success", 1, 0);
                File file = new File(CustomManager.this.mCustomFilePathUtil.getJiaguApkDir());
                if (!file.exists()) {
                    file.mkdirs();
                }
                CustomManager.this.mAPKGenerator.reSignApk(os, CustomManager.this.mCustomFilePathUtil, CustomManager.this.mSignFile, CustomManager.this.mBuildApkMonitor, CustomManager.this.mEnableIjm);
            }

            @Override
            public void onResultFailed(String errMsg) {
                LogUtil.e("APK build build apk failed!");
                CustomManager.this.onProgress(2, 0, 2, "compile failed", 1, 0);
                CustomManager.this.sendFailed(2, errMsg);
            }
        };
        BuildApkMonitor.ResultUpdateListener resignResultUpdateListener = new BuildApkMonitor.ResultUpdateListener(){

            @Override
            public void onResultSuccess() {
                LogUtil.d("Build APK finish : starting jiagu procedure : ");
                CustomManager.this.onProgress(3, 0, 0, "resign success", 1, 0);
                if (CustomManager.this.mEnableIjm) {
                    CustomManager.this.mAPKGenerator.jiaguApk(os, env, ijmApi, CustomManager.this.mCustomFilePathUtil, CustomManager.this.mBuildApkMonitor);
                } else {
                    CustomManager.this.mAPKGenerator.alignApk(os, CustomManager.this.mCustomFilePathUtil, CustomManager.this.mSignFile, CustomManager.this.mBuildApkMonitor, CustomManager.this.mEnableIjm);
                }
            }

            @Override
            public void onResultFailed(String errMsg) {
                LogUtil.e("APK build build apk failed!");
                CustomManager.this.onProgress(3, 0, 2, "resign failed", 1, 0);
                CustomManager.this.sendFailed(3, errMsg);
            }
        };
        BuildApkMonitor.ResultUpdateListener jiaguResultUpdateListener = new BuildApkMonitor.ResultUpdateListener(){

            @Override
            public void onResultSuccess() {
                CustomManager.this.onProgress(4, 0, 0, "ijm success", 1, 0);
                CustomManager.this.mAPKGenerator.alignApk(os, CustomManager.this.mCustomFilePathUtil, CustomManager.this.mSignFile, CustomManager.this.mBuildApkMonitor, CustomManager.this.mEnableIjm);
            }

            @Override
            public void onResultFailed(String errMsg) {
                if (CustomManager.this.mRetry > 0) {
                    LogUtil.d("jiaguResultUpdateListener retry jiagu, mRetry = " + CustomManager.this.mRetry);
                    --CustomManager.this.mRetry;
                    CustomManager.this.mBuildApkMonitor.retry(1);
                    CustomManager.this.mAPKGenerator.jiaguApk(os, env, ijmApi, CustomManager.this.mCustomFilePathUtil, CustomManager.this.mBuildApkMonitor);
                } else {
                    LogUtil.e("APK build jiagu apk failed!");
                    CustomManager.this.onProgress(4, 0, 4, "ijm failed", 1, 0);
                    CustomManager.this.sendFailed(4, "ijm failed");
                }
            }
        };
        BuildApkMonitor.ResultUpdateListener alignResultUpdateListener = new BuildApkMonitor.ResultUpdateListener(){

            @Override
            public void onResultSuccess() {
                CustomManager.this.onProgress(5, 0, 0, "align success", 1, 0);
                CustomManager.this.mAPKGenerator.signApk(os, CustomManager.this.mCustomFilePathUtil, CustomManager.this.mSignFile, CustomManager.this.mBuildApkMonitor, CustomManager.this.mEnableIjm);
            }

            @Override
            public void onResultFailed(String errMsg) {
                LogUtil.e("APK build align apk failed!");
                CustomManager.this.onProgress(5, 0, 5, "align failed", 1, 0);
                CustomManager.this.sendFailed(5, "align failed");
            }
        };
        BuildApkMonitor.ResultUpdateListener signResultUpdateListener = new BuildApkMonitor.ResultUpdateListener(){

            @Override
            public void onResultSuccess() {
                CustomManager.this.onProgress(6, 0, 0, "sign success", 1, 0);
                ((CustomManager)CustomManager.this).mBuildResult.errCode = 0;
                ((CustomManager)CustomManager.this).mBuildResult.appId = CustomManager.this.mAppConfig.getAppID();
                ((CustomManager)CustomManager.this).mBuildResult.versionName = CustomManager.this.mAppConfig.getVersionName();
                ((CustomManager)CustomManager.this).mBuildResult.versionCode = CustomManager.this.mAppConfig.getVersionCode();
                ((CustomManager)CustomManager.this).mBuildResult.isSucess = true;
                ((CustomManager)CustomManager.this).mBuildResult.prodAppPath = CustomManager.this.mCustomFilePathUtil.getSignOutputPath();
                ((CustomManager)CustomManager.this).mBuildResult.uatAppPath = "";
                ((CustomManager)CustomManager.this).mBuildResult.debugInfoPath = CustomManager.this.mCustomFilePathUtil.getDebugZipPath();
                CustomManager.this.backupDebugInfo();
                LogUtil.d("APK sign finished, prod path : " + ((CustomManager)CustomManager.this).mBuildResult.prodAppPath);
                LogUtil.d("APK sign finished, uat path : " + ((CustomManager)CustomManager.this).mBuildResult.uatAppPath);
                LogUtil.d("debugInfo path : " + ((CustomManager)CustomManager.this).mBuildResult.debugInfoPath);
                if (callback != null) {
                    if (TextUtil.isEmpty(((CustomManager)CustomManager.this).mBuildResult.prodAppPath)) {
                        ((CustomManager)CustomManager.this).mBuildResult.isSucess = false;
                    }
                    callback.onBuildFinished(CustomManager.this.mBuildResult);
                }
            }

            @Override
            public void onResultFailed(String errMsg) {
                if (CustomManager.this.mRetry > 0) {
                    LogUtil.d("signResultUpdateListener retry jiagu again");
                    CustomManager.this.onProgress(6, 0, 6, "sign failed", 1, 0);
                    --CustomManager.this.mRetry;
                    if (CustomManager.this.mEnableIjm) {
                        CustomManager.this.mBuildApkMonitor.retry(1);
                        CustomManager.this.mAPKGenerator.jiaguApk(os, env, ijmApi, CustomManager.this.mCustomFilePathUtil, CustomManager.this.mBuildApkMonitor);
                    } else {
                        File file = new File(CustomManager.this.mCustomFilePathUtil.getJiaguApkDir());
                        if (!file.exists()) {
                            file.mkdirs();
                        }
                        CustomManager.this.mBuildApkMonitor.retry(2);
                        CustomManager.this.mAPKGenerator.signApk(os, CustomManager.this.mCustomFilePathUtil, CustomManager.this.mSignFile, CustomManager.this.mBuildApkMonitor, CustomManager.this.mEnableIjm);
                    }
                } else {
                    LogUtil.e("APK build sign apk failed!");
                    CustomManager.this.onProgress(6, 0, 6, "sign failed", 1, 0);
                    CustomManager.this.sendFailed(6, "sign failed");
                }
            }
        };
        this.mBuildApkMonitor.registerResultUpdateListener("build", buildResultUpdateListener);
        this.mBuildApkMonitor.registerResultUpdateListener("resign", resignResultUpdateListener);
        this.mBuildApkMonitor.registerResultUpdateListener("jiagu", jiaguResultUpdateListener);
        this.mBuildApkMonitor.registerResultUpdateListener("align", alignResultUpdateListener);
        this.mBuildApkMonitor.registerResultUpdateListener("sign", signResultUpdateListener);
        this.mAPKGenerator.generateApk(os, this.mCustomFilePathUtil, this.mAppConfig, this.mBuildApkMonitor);
    }

    public void setCustomData(int type, String key, String value) {
        LogUtil.d("[setCustomData]type = " + type + "; key = " + key + "; value = " + value);
        switch (type) {
            case 1: {
                this.processResource(key, value);
                break;
            }
            case 2: {
                this.addFunctionConfigs(key, value);
                break;
            }
            case 3: {
                if ("CUSTOM_RELEASE_API_AESKEY_CIPHER".equals(key)) {
                    this.setBasicAPPConfigs("AAK", value);
                }
                if ("CUSTOM_RELEASE_API_AESIV_CIPHER".equals(key)) {
                    this.setBasicAPPConfigs("AAI", value);
                }
                if ("CUSTOM_PACKAGE_NAME".equals(key)) {
                    this.setBasicAPPConfigs("applicationId", value);
                }
                this.setBasicAPPConfigs(key, value);
                break;
            }
            case 4: {
                this.addLayoutDisplayStyle(key, value);
                break;
            }
            case 15: {
                this.setAppTemplate(value);
                break;
            }
            case 5: {
                this.setAppColorClass(value);
                break;
            }
            case 12: {
                this.setColor(key, value);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                if ("CUSTOM_PROD_AUTH_SERVERS".equals(key)) {
                    this.addServerAddress("AUTH_SERVERS", value);
                }
                this.addServerAddress(key, value);
                break;
            }
            case 8: {
                this.setAppTheme(value);
                break;
            }
            case 9: {
                this.setLoadingVideoUrl(value, null);
                break;
            }
            case 10: {
                this.processSloadingStyle(key, value);
                break;
            }
            case 11: {
                this.setAdavancedConfig(value);
                break;
            }
            case 13: {
                this.setDimens(key, value);
                break;
            }
            case 14: {
                this.setAppProperties(key, value);
                break;
            }
            case 16: {
                this.setPkgProperties(key, value);
            }
        }
    }

    public void setCustomDataMap(List<ResConfig> resList) {
        HashMap map;
        LinkedHashMap<String, LinkedHashMap> stringMap = new LinkedHashMap<String, LinkedHashMap>();
        HashMap<String, HashMap> drawableMap = new HashMap<String, HashMap>();
        for (ResConfig config : resList) {
            String[] tag;
            Map map2;
            String type = config.getType();
            String id = config.getId();
            String value = config.getValue();
            if (TextUtil.isEmpty(type) || TextUtil.isEmpty(id) || TextUtil.isEmpty(value)) continue;
            if ("color".equals(type)) {
                this.setCustomData(12, id, value);
                continue;
            }
            if ("dimens".equals(type)) {
                this.setDimens(id, value);
                continue;
            }
            if ("integer".equals(type)) {
                this.setIntegers(id, value);
                continue;
            }
            if (type.contains("string")) {
                map2 = stringMap.computeIfAbsent(type, k -> new LinkedHashMap());
                map2.put(id, value);
                continue;
            }
            if (type.startsWith("drawable")) {
                if (!value.startsWith("http")) {
                    map2 = drawableMap.computeIfAbsent(type, k -> new HashMap());
                    map2.put(id, value);
                    continue;
                }
                this.setCustomData(1, id, value);
                continue;
            }
            if ("properties".equals(type)) {
                this.setAppProperties(id, value);
                continue;
            }
            if ("resource".equals(type)) {
                this.setRes(value);
                continue;
            }
            if ("config".equals(type)) {
                this.setCustomData(3, id, value);
                continue;
            }
            if ("layout".equals(type)) {
                this.setCustomData(4, id, value);
                continue;
            }
            if (!"attribute".equals(type) || TextUtil.isEmpty((tag = id.split("_"))[0]) || TextUtil.isEmpty(tag[1]) || TextUtil.isEmpty(tag[2])) continue;
            this.setCustomLayoutAttribute(tag[0], tag[1], tag[2], value);
        }
        for (String key : stringMap.keySet()) {
            map = (LinkedHashMap)stringMap.get(key);
            if (map == null) continue;
            String lan = key.substring(0, 2);
            this.setStrings(lan, (LinkedHashMap<String, String>)map);
        }
        for (String key : drawableMap.keySet()) {
            map = (HashMap)drawableMap.get(key);
            if (map == null) continue;
            this.setDrawables(key, map);
        }
    }

    private void throwException(String message) throws Exception {
        Exception e = new Exception(message);
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseResConfig(String sourceDir, String name) {
        if (TextUtil.isEmpty(sourceDir)) {
            LogUtil.d("expert file name is empty");
            return;
        }
        String configFilePath = TextUtil.isEmpty(name) ? sourceDir + File.separator + "config.txt" : sourceDir + File.separator + name + File.separator + "config.txt";
        File configFile = new File(configFilePath);
        if (!configFile.exists()) {
            LogUtil.d("templete file not exists, skip");
            return;
        }
        ArrayList<ResConfig> resList = new ArrayList<ResConfig>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(configFile), "UTF-8"));
            String lineTxt = "";
            while ((lineTxt = br.readLine()) != null) {
                String[] attrs = lineTxt.split("\\[##split##\\]");
                if (attrs == null || attrs.length != 3) continue;
                String type = attrs[0];
                String id = attrs[1];
                String value = attrs[2];
                if (TextUtil.isEmpty(type) || TextUtil.isEmpty(id) || TextUtil.isEmpty(value)) continue;
                ResConfig resConfig = new ResConfig();
                resConfig.setType(type);
                resConfig.setId(id);
                resConfig.setValue(value);
                resList.add(resConfig);
            }
            if (resList.size() > 0) {
                this.setCustomDataMap(resList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void backupDebugInfo() {
        File debugZip;
        LogUtil.d("backup files for debug");
        String gradlePropertiesFilePath = this.mProjectDir + File.separator + this.mAppConfig.getGradleProperties(this.mTerminalType) + ".properties";
        String flavorGradlePropertiesFilePath = this.mProjectDir + File.separator + this.mAppConfig.getFlavorGradleProperties(this.mTerminalType) + ".properties";
        String propertiesFilePath = this.mProjectDir + File.separator + this.mAppConfig.getFlavor().toLowerCase() + ".properties";
        File debugDir = new File(this.mCustomFilePathUtil.getDebugDir());
        if (debugDir.exists()) {
            debugDir.delete();
        }
        if ((debugZip = new File(this.mBuildResult.debugInfoPath)).exists()) {
            debugZip.delete();
        }
        FileUtil.copyFolder(this.mCustomFilePathUtil.getCustomDir(), this.mCustomFilePathUtil.getDebugDir());
        FileUtil.copyFolder(this.mCustomFilePathUtil.getMappingDir(), this.mCustomFilePathUtil.getDebugDir());
        FileUtil.copyFile(gradlePropertiesFilePath, this.mCustomFilePathUtil.getDebugDir());
        FileUtil.copyFile(flavorGradlePropertiesFilePath, this.mCustomFilePathUtil.getDebugDir());
        FileUtil.copyFile(propertiesFilePath, this.mCustomFilePathUtil.getDebugDir());
        ZipUtil.zipDir(this.mCustomFilePathUtil.getDebugDir(), this.mBuildResult.debugInfoPath);
    }

    private Map<String, Object> checkEnvironment() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (TextUtil.isEmpty(this.mAppConfig.getBrandID()) || TextUtil.isEmpty(this.mAppConfig.getAppID()) || TextUtil.isEmpty(this.mAppConfig.getPackageName()) || TextUtil.isEmpty(this.mAppConfig.getVnoID()) || TextUtil.isEmpty(this.mAppConfig.getAppName()) || TextUtil.isEmpty(this.mAppConfig.getVersionName()) || TextUtil.isEmpty(this.mAppConfig.getVersionCode()) || TextUtil.isEmpty(this.mAppConfig.getBaseVersionCode())) {
            LogUtil.e("invalid app info!");
            ret.put("result", false);
            ret.put("errMsg", "invalid app info!");
            return ret;
        }
        if (TextUtil.isEmpty(this.getTemplateLayout()) || TextUtil.isEmpty(this.getColorClass()) || TextUtil.isEmpty(this.getAppTheme())) {
            LogUtil.e("invalid template info!");
            ret.put("result", false);
            ret.put("errMsg", "invalid template info!");
            return ret;
        }
        if (TextUtil.isEmpty(this.getServerAddress("CUSTOM_UAT_AUTH_SERVERS")) || TextUtil.isEmpty(this.getServerAddress("CUSTOM_PROD_AUTH_SERVERS"))) {
            LogUtil.e("invalid server info!");
            ret.put("result", false);
            ret.put("errMsg", "invalid server info!");
            return ret;
        }
        if (!TextUtil.isEmpty(this.mAppConfig.getSignFilePath()) && (TextUtil.isEmpty(this.mAppConfig.getStorePassword()) || TextUtil.isEmpty(this.mAppConfig.getKeyPassword()) || TextUtil.isEmpty(this.mAppConfig.getKeyAlias()))) {
            LogUtil.e("invalid sign info!");
            ret.put("result", false);
            ret.put("errMsg", "invalid sign info!");
            return ret;
        }
        String sdkDir = System.getenv("ANDROID_HOME");
        if (TextUtil.isEmpty(sdkDir)) {
            LogUtil.e("ANDROID_HOME is not set!");
            ret.put("result", false);
            ret.put("errMsg", "ANDROID_HOME is not set!");
            return ret;
        }
        ret.put("result", true);
        ret.put("errMsg", "");
        return ret;
    }

    private void sendFailed(int errCode, String errMsg) {
        if (this.mCallback == null) {
            return;
        }
        this.mBuildResult.errCode = errCode;
        this.mBuildResult.errMsg = errMsg;
        this.mBuildResult.appId = this.mAppConfig.getAppID();
        this.mBuildResult.versionName = this.mAppConfig.getVersionName();
        this.mBuildResult.versionCode = this.mAppConfig.getVersionCode();
        this.mBuildResult.prodAppPath = "";
        this.mBuildResult.uatAppPath = "";
        this.mBuildResult.isSucess = false;
        this.mBuildResult.debugInfoPath = this.mCustomFilePathUtil.getDebugZipPath();
        this.backupDebugInfo();
        this.mCallback.onBuildFinished(this.mBuildResult);
    }

    private void onProgress(int eventId, int subEventId, int errCode, String message, int status, int progress) {
        if (this.mCallback == null) {
            return;
        }
        this.mProgress.eventId = eventId;
        this.mProgress.subEventId = subEventId;
        this.mProgress.errCode = errCode;
        this.mProgress.message = message;
        this.mProgress.timestamp = System.currentTimeMillis();
        this.mProgress.status = status;
        this.mProgress.progress = progress;
        this.mCallback.onProgress(this.mProgress);
    }

    private void backupCustomParas() {
        this.mBitmapDrawableToDownloadBkMap.clear();
        this.mColorBkMap.clear();
        this.mDimensBkMap.clear();
        this.mDisplayLayoutStyleBkMap.clear();
        this.mBasicAppBkConfig.clear();
        this.mStringsBkMap.clear();
        this.mAppPropertiesBkMap.clear();
        this.mSloadingStyleBkMap.clear();
        this.mCustomAttributeBkMap.clear();
        this.mDrawableBkMap.clear();
        if (this.mBitmapDrawableToDownloadMap != null && !this.mBitmapDrawableToDownloadMap.isEmpty()) {
            this.mBitmapDrawableToDownloadBkMap.putAll(this.mBitmapDrawableToDownloadMap);
        } else if (this.mColorMap != null && !this.mColorMap.isEmpty()) {
            this.mColorBkMap.putAll(this.mColorMap);
        } else if (this.mDimensMap != null && !this.mDimensMap.isEmpty()) {
            this.mDimensBkMap.putAll(this.mDimensMap);
        } else if (this.mAppConfig != null && this.mAppConfig.getDisplayLayoutStyleMap() != null && !this.mAppConfig.getDisplayLayoutStyleMap().isEmpty()) {
            this.mDisplayLayoutStyleBkMap.putAll(this.mAppConfig.getDisplayLayoutStyleMap());
        } else if (this.mAppConfig != null && this.mAppConfig.getBasicAppConfig() != null && !this.mAppConfig.getBasicAppConfig().isEmpty()) {
            this.mBasicAppBkConfig.putAll(this.mAppConfig.getBasicAppConfig());
        } else if (this.mStringsMap != null && !this.mStringsMap.isEmpty()) {
            this.mStringsBkMap.putAll(this.mStringsMap);
        } else if (this.mAppPropertiesMap != null && !this.mAppPropertiesMap.isEmpty()) {
            this.mAppPropertiesBkMap.putAll(this.mAppPropertiesMap);
        } else if (this.mSloadingStyleMap != null && !this.mSloadingStyleMap.isEmpty()) {
            this.mSloadingStyleBkMap.putAll(this.mSloadingStyleMap);
        } else if (this.mCustomAttributeMap != null && !this.mCustomAttributeMap.isEmpty()) {
            this.mCustomAttributeBkMap.putAll(this.mCustomAttributeMap);
        } else if (this.mDrawableMap != null && !this.mDrawableMap.isEmpty()) {
            this.mDrawableBkMap.putAll(this.mDrawableMap);
        }
    }

    public void restoreCustomParas() {
        if (this.mBitmapDrawableToDownloadBkMap != null && !this.mBitmapDrawableToDownloadBkMap.isEmpty()) {
            this.mBitmapDrawableToDownloadMap.putAll(this.mBitmapDrawableToDownloadBkMap);
            this.mBitmapDrawableToDownloadBkMap.clear();
        } else if (this.mColorBkMap != null && !this.mColorBkMap.isEmpty()) {
            this.mColorMap.putAll(this.mColorBkMap);
            this.mColorBkMap.clear();
        } else if (this.mDimensBkMap != null && !this.mDimensBkMap.isEmpty()) {
            this.mDimensMap.putAll(this.mDimensBkMap);
            this.mDimensBkMap.clear();
        } else if (this.mDisplayLayoutStyleBkMap != null && !this.mDisplayLayoutStyleBkMap.isEmpty()) {
            this.mAppConfig.getDisplayLayoutStyleMap().putAll(this.mDisplayLayoutStyleBkMap);
            this.mDisplayLayoutStyleBkMap.clear();
        } else if (this.mBasicAppBkConfig != null && !this.mBasicAppBkConfig.isEmpty()) {
            this.mAppConfig.getBasicAppConfig().putAll(this.mBasicAppBkConfig);
            this.mBasicAppBkConfig.clear();
        } else if (this.mStringsBkMap != null && !this.mStringsBkMap.isEmpty()) {
            this.mStringsMap.putAll(this.mStringsBkMap);
            this.mStringsBkMap.clear();
        } else if (this.mAppPropertiesBkMap != null && !this.mAppPropertiesBkMap.isEmpty()) {
            this.mAppPropertiesMap.putAll(this.mAppPropertiesBkMap);
            this.mAppPropertiesBkMap.clear();
        } else if (this.mSloadingStyleBkMap != null && !this.mSloadingStyleBkMap.isEmpty()) {
            this.mSloadingStyleMap.putAll(this.mSloadingStyleBkMap);
            this.mSloadingStyleBkMap.clear();
        } else if (this.mCustomAttributeBkMap != null && !this.mCustomAttributeBkMap.isEmpty()) {
            this.mCustomAttributeMap.putAll(this.mCustomAttributeBkMap);
            this.mCustomAttributeBkMap.clear();
        } else if (this.mDrawableBkMap != null && !this.mDrawableBkMap.isEmpty()) {
            this.mDrawableMap.putAll(this.mDrawableBkMap);
            this.mDrawableBkMap.clear();
        }
    }

    private void handleBootupVideo(String format) {
        String customVideoFileDir = this.mCustomFilePathUtil.getCustomVideoDir();
        String customVideoPath = customVideoFileDir + File.separator + "bootvideo" + "." + format;
        String curtainDir = this.mCustomFilePathUtil.getCustomResDir();
        String curtainPath = curtainDir + File.separator + this.getDefaultDpi() + File.separator + "bootvideo_curtain" + ".jpg";
        String videoFinish = curtainDir + File.separator + this.getDefaultDpi() + File.separator + "video_finish_bg" + ".jpg";
        try {
            VideoUtil.fetchFrame(customVideoPath, curtainPath, 1920, 1080, 0);
            VideoUtil.fetchFrame(customVideoPath, videoFinish, 1920, 1080, -1);
        }
        catch (Exception e) {
            LogUtil.e("fetchFrame error", e);
            this.copyVideoCurtain();
        }
    }

    public void copyVideoCurtain() {
        String customDirPath = this.mCustomFilePathUtil.getCustomResDir() + File.separator + this.getIconDefaultDpi();
        File customDir = new File(customDirPath);
        if (!customDir.exists()) {
            return;
        }
        File[] files = customDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            int dotIndex;
            String fileName;
            if (file == null || TextUtil.isEmpty(fileName = file.getName()) || !fileName.contains(".") || !fileName.substring(0, dotIndex = fileName.indexOf(".")).equals("main_bg")) continue;
            String curtainPath = customDirPath + File.separator + "bootvideo_curtain" + fileName.substring(dotIndex, fileName.length());
            String videoFinish = customDirPath + File.separator + "video_finish_bg" + fileName.substring(dotIndex, fileName.length());
            FileUtil.copyFile(file, curtainPath);
            FileUtil.copyFile(file, videoFinish);
            return;
        }
    }

    private boolean checkAppIcon(String id, String format) {
        if (TextUtil.isEmpty(id) || TextUtil.isEmpty(format)) {
            return false;
        }
        String iconPath = this.mCustomFilePathUtil.getCustomResDir() + File.separator + this.getIconDefaultDpi() + File.separator + id + "." + format;
        File iconFile = new File(iconPath);
        if (!iconFile.exists()) {
            return false;
        }
        if (format.equals("png")) {
            try {
                DataInputStream dis = new DataInputStream(new FileInputStream(iconFile));
                byte[] b = new byte[8];
                dis.read(b);
                if ((b[0] & 0xFF) != 137 || (b[1] & 0xFF) != 80 || (b[2] & 0xFF) != 78 || (b[3] & 0xFF) != 71 || (b[4] & 0xFF) != 13 || (b[5] & 0xFF) != 10 || (b[6] & 0xFF) != 26 || (b[7] & 0xFF) != 10) {
                    return false;
                }
            }
            catch (Exception e) {
                LogUtil.e("checkAppIcon failed: " + e.toString());
                return true;
            }
        }
        return true;
    }

    private int convert2SubEventId(String drawableId) {
        if ("ic_launcher".equals(drawableId)) {
            return 106;
        }
        if ("ic_launcher_freetrial".equals(drawableId)) {
            return 107;
        }
        if ("load_bg".equals(drawableId)) {
            return 104;
        }
        if ("main_bg".equals(drawableId)) {
            return 102;
        }
        if ("stopplay".equals(drawableId)) {
            return 101;
        }
        if ("bg_playback_finished".equals(drawableId)) {
            return 105;
        }
        if ("welcome_bg".equals(drawableId)) {
            return 103;
        }
        if ("bootvideo".equals(drawableId)) {
            return 108;
        }
        return 109;
    }

    private void generateGradleProperty(int terminalType) {
        String gradlePropertiesPath = "";
        gradlePropertiesPath = terminalType == 0 || terminalType == 1 ? this.mProjectDir + File.separator + this.mAppConfig.getGradleProperties(this.mTerminalType) + ".properties" : this.mProjectDir + File.separator + this.mAppConfig.getFlavorGradleProperties(this.mTerminalType) + ".properties";
        int configResult = ConfigsGenerator.generateGradleConfig(gradlePropertiesPath, this.mAppConfig);
        if (configResult == 0) {
            this.sendFailed(7, "generate gradle property failed: " + gradlePropertiesPath);
            return;
        }
        if (terminalType != 0 && terminalType != 1) {
            String flavorPropertiesPath = this.mProjectDir + File.separator + this.mAppConfig.getFlavor().toLowerCase() + ".properties";
            ConfigsGenerator.generateFlavorConfig(flavorPropertiesPath, this.mAppConfig);
        }
    }

    private void generateResInternal() {
        this.parseResConfig(this.mLayoutRepositoryDir, this.mTemplateLayout);
        this.mAppTheme = TextUtil.isEmpty(this.mAppTheme) ? "base" : this.mAppTheme;
        String themeName = this.mTemplateLayout + "_" + this.mAppTheme;
        ThemeGenerator.copyFlavorSourceRes(this.mCustomFilePathUtil, this.mThemeRepositoryDir, themeName);
        this.parseResConfig(this.mThemeRepositoryDir, themeName);
        String androidManifestSource = this.mThemeRepositoryDir + File.separator + "base" + File.separator;
        String androidManifestDest = this.mCustomFilePathUtil.getCustomDir();
        androidManifestSource = "vtv".equals(this.mAppConfig.getAppID()) ? androidManifestSource + "freetrial" + File.separator + "AndroidManifest.xml" : (this.mAppConfig.isUserPay() ? androidManifestSource + "freetrial" + File.separator + "AndroidManifest.xml" : androidManifestSource + "nofreetrial" + File.separator + "AndroidManifest.xml");
        FileUtil.copyFile(androidManifestSource, androidManifestDest);
        String colorName = this.mColorClass;
        File colorDir = new File(this.mColorRepositoryDir + File.separator + colorName);
        if (!colorDir.exists()) {
            colorName = this.mTemplateLayout + "_" + this.mAppTheme + "_" + this.mColorClass;
        }
        ColorClassGenerator.generateColorClass(this.mCustomFilePathUtil, this.mColorRepositoryDir, colorName);
        ResGenerator.generate(this.mCustomFilePathUtil, this.mColorRepositoryDir + File.separator + colorName + File.separator + "res");
        this.parseResConfig(this.mAdvancedRepositoryDir, this.mAdvanced);
    }

    private void generateResExternal() {
        String resExtPath = this.mAppConfig.getResExtPath();
        if (TextUtil.isEmpty(resExtPath)) {
            return;
        }
        LogUtil.d("get res external path: " + resExtPath);
        this.parseResConfig(resExtPath, "");
        ResGenerator.generate(this.mCustomFilePathUtil, resExtPath + File.separator + "res");
    }

    public void enableIJM(boolean enable) {
        this.mEnableIjm = enable;
    }

    public void setRetryCount(int count) {
        this.mRetry = count;
    }

    protected abstract String getDefaultDpi();

    protected abstract String getIconDefaultDpi();

    protected abstract boolean isAppIcon(String var1);

    protected abstract void transformAppIcon(String var1, String var2);

    private class DownLoadMonitor {
        public boolean isDrawableDownloadFinished = false;
        public boolean isVideoDownloadFinished = false;
        public boolean isMainProcedureFinished = false;
        public boolean isStartBuildWhenReady = false;
        public boolean isAllDrawableReady = true;
        public boolean isAllStandardFormat = true;
        public boolean isAllVideoReady = true;
        private Set<String> mDownloadingDrawableList;

        private DownLoadMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            DownLoadMonitor downLoadMonitor = this;
            synchronized (downLoadMonitor) {
                this.isDrawableDownloadFinished = false;
                this.isVideoDownloadFinished = false;
                this.isMainProcedureFinished = false;
                this.isStartBuildWhenReady = false;
                this.isAllDrawableReady = true;
                this.isAllVideoReady = true;
            }
        }

        public void registerDownloadingDrawables(Set<String> list) {
            this.mDownloadingDrawableList = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void downloadDrawableResultNotify(CustomBitmapDrawable drawable, boolean success, boolean isStandard) {
            DownLoadMonitor downLoadMonitor = this;
            synchronized (downLoadMonitor) {
                this.mDownloadingDrawableList.remove(drawable.id);
                if (this.mDownloadingDrawableList.isEmpty()) {
                    this.isDrawableDownloadFinished = true;
                }
                if (!success) {
                    this.isAllDrawableReady = success;
                }
                if (!isStandard) {
                    this.isAllStandardFormat = isStandard;
                }
            }
            if (this.isReadyToBuild()) {
                CustomManager.this.generateApkNow(CustomManager.this.mBuildOs, CustomManager.this.mEnv, CustomManager.this.mIjmApi, CustomManager.this.mCallback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void downloadDrawableResultNotify(boolean result) {
            DownLoadMonitor downLoadMonitor = this;
            synchronized (downLoadMonitor) {
                this.mDownloadingDrawableList.clear();
                this.isDrawableDownloadFinished = true;
            }
            if (this.isReadyToBuild()) {
                CustomManager.this.generateApkNow(CustomManager.this.mBuildOs, CustomManager.this.mEnv, CustomManager.this.mIjmApi, CustomManager.this.mCallback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void downloadVideoResultNotify(boolean result) {
            DownLoadMonitor downLoadMonitor = this;
            synchronized (downLoadMonitor) {
                this.isVideoDownloadFinished = true;
                if (!result) {
                    this.isAllVideoReady = result;
                }
            }
            if (this.isReadyToBuild()) {
                CustomManager.this.generateApkNow(CustomManager.this.mBuildOs, CustomManager.this.mEnv, CustomManager.this.mIjmApi, CustomManager.this.mCallback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isReadyToBuild() {
            DownLoadMonitor downLoadMonitor = this;
            synchronized (downLoadMonitor) {
                if (this.isDrawableDownloadFinished && this.isVideoDownloadFinished && this.isMainProcedureFinished) {
                    if (this.isAllDrawableReady && this.isAllVideoReady && this.isAllStandardFormat) {
                        return true;
                    }
                    int errCode = 0;
                    String errMsg = "";
                    if (!this.isAllStandardFormat) {
                        errCode = 10;
                        errMsg = "Wrong format!";
                    } else {
                        errCode = !this.isAllDrawableReady ? 8 : 9;
                        errMsg = !this.isAllDrawableReady ? "download drawable fail" : "download video fail";
                    }
                    CustomManager.this.onProgress(1, 0, 8, "prepare resource failed", 1, 0);
                    CustomManager.this.sendFailed(errCode, errMsg);
                    return false;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void generateApkIfReady() {
            DownLoadMonitor downLoadMonitor = this;
            synchronized (downLoadMonitor) {
                if (!this.isReadyToBuild()) {
                    this.isStartBuildWhenReady = true;
                } else {
                    CustomManager.this.generateApkNow(CustomManager.this.mBuildOs, CustomManager.this.mEnv, CustomManager.this.mIjmApi, CustomManager.this.mCallback);
                }
            }
        }
    }

    public class Status {
        public static final int start = 0;
        public static final int finish = 1;
    }

    public class ErrorCode {
        public static final int SUCCESS = 0;
        public static final int INVALID_PARAS = 1;
        public static final int BUILD_FAIL = 2;
        public static final int RESIGN_FAIL = 3;
        public static final int IJM_FAIL = 4;
        public static final int ALIGN_FAIL = 5;
        public static final int SIGN_FAIL = 6;
        public static final int GENERATE_GRADLE_PROPERTY_FAIL = 7;
        public static final int DOWNLOAD_DRAWABLE_FAIL = 8;
        public static final int DOWNLOAD_VIDEO_FAIL = 9;
        public static final int RESOURCE_FORMAT_FAIL = 10;
    }

    public static class Progress {
        public String taskId;
        public int eventId;
        public int subEventId;
        public int errCode;
        public String message;
        public long timestamp;
        public int status;
        public int progress;

        public String toString() {
            return "Progress{taskId='" + this.taskId + '\'' + ", eventId=" + this.eventId + ", subEventId=" + this.subEventId + ", errCode=" + this.errCode + ", message='" + this.message + '\'' + ", timestamp=" + this.timestamp + ", status=" + this.status + ", progress=" + this.progress + '}';
        }
    }

    public class BuildResult {
        public String taskId;
        public String appId;
        public String prodAppPath;
        public String uatAppPath;
        public String debugInfoPath;
        public String versionCode;
        public String versionName;
        public boolean isSucess;
        public int errCode;
        public String errMsg;
    }

    public class CustomData {
        public static final int TYPE_RESOURCE = 1;
        public static final int TYPE_FUNCTION = 2;
        public static final int TYPE_INFO = 3;
        public static final int TYPE_LAYOUT = 4;
        public static final int TYPE_COLORS = 5;
        public static final int TYPE_STRING = 6;
        public static final int TYPE_SERVE_ADDRESS = 7;
        public static final int TYPE_THEME = 8;
        public static final int TYPE_VIDEO = 9;
        public static final int TYPE_SLOADING = 10;
        public static final int TYPE_ADVANCED = 11;
        public static final int TYPE_COLOR = 12;
        public static final int TYPE_DIMENS = 13;
        public static final int TYPE_APPPROPERTIES = 14;
        public static final int TYPE_TEMPLATE = 15;
        public static final int TYPE_PKG = 16;
    }

    public static interface CustomCallback {
        public void onProgress(Progress var1);

        public void onBuildFinished(BuildResult var1);
    }
}

