/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.generator;

import com.tve.custom.generator.model.CustomXMLDrawable;
import com.tve.custom.utils.CustomFilePathUtil;
import com.tve.custom.utils.LogUtil;
import com.tve.custom.utils.TextUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class DrawableGenerator {
    private static final String TAG = "DrawableGenerator";

    public static void copyHDpiDrawableFile(CustomFilePathUtil pathUtil, Map<String, Map<String, String>> drawableMap) {
        ArrayList mDrawableDirList = new ArrayList();
        if (drawableMap == null || drawableMap.size() == 0) {
            return;
        }
        String targetDir = pathUtil.getCustomResDir();
        for (String drawableDir : drawableMap.keySet()) {
            File drawableDirFile = new File(targetDir, drawableDir);
            if (drawableDirFile.exists()) {
                for (File oldFile : drawableDirFile.listFiles()) {
                    oldFile.delete();
                }
                continue;
            }
            drawableDirFile.mkdir();
        }
        for (String drawableDir : drawableMap.keySet()) {
            Map<String, String> sourceDrawableMap = drawableMap.get(drawableDir);
            for (String sourceDrawable : sourceDrawableMap.keySet()) {
                File srcDrawableFile = new File(sourceDrawableMap.get(sourceDrawable));
                File destDrawableFile = new File(targetDir + File.separator + drawableDir + File.separator + srcDrawableFile.getName());
                try {
                    int c;
                    if (!srcDrawableFile.exists()) {
                        LogUtil.d("DrawableGenerator try to process a drawable file - " + sourceDrawable + " but it's not exist.");
                        continue;
                    }
                    FileInputStream in = new FileInputStream(srcDrawableFile);
                    destDrawableFile.createNewFile();
                    FileOutputStream out = new FileOutputStream(destDrawableFile);
                    byte[] buffer = new byte[1024];
                    while ((c = in.read(buffer)) != -1) {
                        out.write(buffer, 0, c);
                    }
                    in.close();
                    out.close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    LogUtil.d("DrawableGenerator try to process a drawable file - " + sourceDrawable + " but failed.");
                    e.printStackTrace();
                }
            }
        }
    }

    public static void copyBitmapDrawable(String destPath, Map<String, CustomXMLDrawable> drawableMap) {
        if (TextUtil.isEmpty(destPath) || drawableMap == null || drawableMap.size() == 0) {
            return;
        }
        File drawableDir = new File(destPath, "drawable-hdpi");
        if (drawableDir.exists()) {
            for (File oldFile : drawableDir.listFiles()) {
                oldFile.delete();
            }
        } else {
            drawableDir.mkdirs();
        }
        for (String sourceDrawable : drawableMap.keySet()) {
            File srcDrawableFile = new File(drawableMap.get((Object)sourceDrawable).filePath);
            File destDrawableFile = new File(drawableDir, srcDrawableFile.getName());
            try {
                int c;
                if (!srcDrawableFile.exists()) {
                    LogUtil.d("DrawableGenerator try to process a drawable file - " + sourceDrawable + " but it's not exist.");
                    continue;
                }
                FileInputStream in = new FileInputStream(srcDrawableFile);
                destDrawableFile.createNewFile();
                FileOutputStream out = new FileOutputStream(destDrawableFile);
                byte[] buffer = new byte[1024];
                while ((c = in.read(buffer)) != -1) {
                    out.write(buffer, 0, c);
                }
                in.close();
                out.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                LogUtil.d("DrawableGenerator try to process a drawable file - " + sourceDrawable + " but failed.");
                e.printStackTrace();
            }
        }
    }

    public static void generateRectangleDrawableFile(String destPath, String id, CustomXMLDrawable recDrawable) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        buffer.append("<shape xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    android:shape=\"rectangle\">");
        buffer.append("<corners android:radius=\"" + recDrawable.radius + "\"/>\n");
        buffer.append("<solid android:color=\"" + recDrawable.solid + "\"/>\n");
        buffer.append("</shape>");
        File targetFile = new File(destPath, id + ".xml");
        if (targetFile.exists()) {
            targetFile.delete();
        }
        try {
            targetFile.createNewFile();
        }
        catch (IOException e) {
            LogUtil.d("DrawableGenerator tries to make strings.xml, but failed");
            e.printStackTrace();
            return;
        }
        try {
            FileOutputStream os = new FileOutputStream(targetFile, true);
            os.write(buffer.toString().getBytes("utf-8"));
            os.close();
        }
        catch (Exception e) {
            LogUtil.d("DrawableGenerator tries to write colors.xml, but failed");
            e.printStackTrace();
        }
    }
}

