/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.generator;

import com.tve.custom.generator.model.CustomAttribute;
import com.tve.custom.utils.CustomFilePathUtil;
import com.tve.custom.utils.LogUtil;
import com.tve.custom.utils.XmlFileUtil;
import java.io.File;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LayoutGenerator {
    public static void generateCustomLayout(CustomFilePathUtil pathUtil, Map<String, CustomAttribute> customAttributeMap) {
        File mainLayoutFile;
        String mainLayoutDir = pathUtil.getMainResDir() + File.separator + "layout";
        String customLayoutDir = pathUtil.getCustomResDir() + File.separator + "layout";
        File customLayoutFile = new File(customLayoutDir);
        if (!customLayoutFile.exists()) {
            customLayoutFile.mkdirs();
        }
        if (!(mainLayoutFile = new File(mainLayoutDir)).exists()) {
            LogUtil.d("Main res layout file is not exist.");
            return;
        }
        for (String id : customAttributeMap.keySet()) {
            CustomAttribute customAttribute = customAttributeMap.get(id);
            String layoutName = customAttribute.layoutFile;
            if (!layoutName.endsWith(".xml")) {
                layoutName = layoutName + ".xml";
            }
            String layoutFilePath = mainLayoutDir + File.separator + layoutName;
            Document layoutDocument = XmlFileUtil.loadXmlFile(layoutFilePath);
            NodeList nodesList = layoutDocument.getElementsByTagName("*");
            for (int i = 0; i < nodesList.getLength(); ++i) {
                Node widget = nodesList.item(i);
                NamedNodeMap attributesMap = widget.getAttributes();
                for (int j = 0; j < attributesMap.getLength(); ++j) {
                    Node widgetAttribute = attributesMap.item(j);
                    if (!widgetAttribute.getNodeName().equals("android:id") || !widgetAttribute.getNodeValue().equals("@+id/" + customAttribute.id)) continue;
                    for (String attributeName : customAttribute.cunstomAttributes.keySet()) {
                        Element nodeElement = (Element)widget;
                        nodeElement.setAttribute(attributeName, customAttribute.cunstomAttributes.get(attributeName));
                    }
                }
            }
            String newLayoutFilePath = customLayoutDir + File.separator + layoutName;
            XmlFileUtil.saveLayoutXml(newLayoutFilePath, layoutDocument);
        }
    }
}

