/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.command;

import com.tve.custom.CustomManager;
import com.tve.custom.generator.model.CommandResult;
import java.util.HashMap;

public class BuildApkMonitor {
    private HashMap<String, CommandResult> resultMap;
    private CommandResult buildResult = new CommandResult("build");
    private CommandResult jiaguProdResult = new CommandResult("jiaguProd");
    private CommandResult jiaguUatResult = new CommandResult("jiaguUat");
    private CommandResult SignResult = new CommandResult("sign");
    private CommandResult alignResult;
    private CommandResult reSignResult = new CommandResult("resign");
    private HashMap<String, ResultUpdateListener> resultListenerMap;
    public static final int RETRY_TYPE_BUILD = 0;
    public static final int RETRY_TYPE_IJM = 1;
    public static final int RETRY_TYPE_SIGN = 2;
    CustomManager.CustomCallback customCallback;

    public BuildApkMonitor() {
        this.alignResult = new CommandResult("align");
        this.resultMap = new HashMap();
        this.resultMap.put("build", this.buildResult);
        this.resultMap.put("jiaguProd", this.jiaguProdResult);
        this.resultMap.put("jiaguUat", this.jiaguUatResult);
        this.resultMap.put("sign", this.SignResult);
        this.resultMap.put("align", this.alignResult);
        this.resultMap.put("resign", this.reSignResult);
        this.resultListenerMap = new HashMap();
    }

    public CustomManager.CustomCallback getCustomCallback() {
        return this.customCallback;
    }

    public void retry(int type) {
        if (type == 0) {
            this.buildResult = new CommandResult("build");
            this.jiaguProdResult = new CommandResult("jiaguProd");
            this.jiaguUatResult = new CommandResult("jiaguUat");
            this.SignResult = new CommandResult("sign");
            this.resultMap.put("build", this.buildResult);
            this.resultMap.put("jiaguProd", this.jiaguProdResult);
            this.resultMap.put("jiaguUat", this.jiaguUatResult);
            this.resultMap.put("sign", this.SignResult);
            this.resultMap.put("resign", this.reSignResult);
            this.resultMap.put("align", this.alignResult);
        } else if (type == 1) {
            this.jiaguProdResult = new CommandResult("jiaguProd");
            this.jiaguUatResult = new CommandResult("jiaguUat");
            this.SignResult = new CommandResult("sign");
            this.resultMap.put("jiaguProd", this.jiaguProdResult);
            this.resultMap.put("jiaguUat", this.jiaguUatResult);
            this.resultMap.put("sign", this.SignResult);
            this.resultMap.put("align", this.alignResult);
        } else if (type == 2) {
            this.SignResult = new CommandResult("sign");
            this.resultMap.put("sign", this.SignResult);
        }
    }

    public void setCustomCallback(CustomManager.CustomCallback customCallback) {
        this.customCallback = customCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCommandSuccess(String name) {
        BuildApkMonitor buildApkMonitor = this;
        synchronized (buildApkMonitor) {
            CommandResult result = this.resultMap.get(name);
            if (result == null) {
                return false;
            }
            return result.isSucess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCommandResult(String name, int type, int result, String errMsg) {
        BuildApkMonitor buildApkMonitor = this;
        synchronized (buildApkMonitor) {
            CommandResult commandResult = this.resultMap.get(name);
            if (commandResult == null) {
                return;
            }
            commandResult.updateResult(type, result, errMsg);
            if (commandResult.isResultReady()) {
                this.onResutlNotify(commandResult);
            }
        }
    }

    private void onResutlNotify(CommandResult result) {
        ResultUpdateListener listener;
        String name = result.commandName;
        if (name.startsWith("jiagu")) {
            name = "jiagu";
        }
        if ((listener = this.resultListenerMap.get(name)) != null) {
            if (name.startsWith("jiagu")) {
                CommandResult jiaguProdResult = this.resultMap.get("jiaguProd");
                CommandResult jiaguUatResult = this.resultMap.get("jiaguUat");
                if (jiaguProdResult.isResultReady()) {
                    boolean isSuccess = jiaguProdResult.isSucess();
                    if (isSuccess) {
                        listener.onResultSuccess();
                    } else {
                        listener.onResultFailed(result.getErrMsg());
                    }
                }
            } else {
                boolean isSuccess = result.isSucess();
                if (isSuccess) {
                    listener.onResultSuccess();
                } else {
                    listener.onResultFailed(result.getErrMsg());
                }
            }
        }
    }

    public void registerResultUpdateListener(String name, ResultUpdateListener listener) {
        this.resultListenerMap.put(name, listener);
    }

    public static interface ResultUpdateListener {
        public void onResultSuccess();

        public void onResultFailed(String var1);
    }
}

