/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.generator;

import com.tve.custom.generator.model.AppConfig;
import com.tve.custom.generator.model.SignConfig;
import com.tve.custom.utils.EncryptedStringUtil;
import com.tve.custom.utils.LogUtil;
import com.tve.custom.utils.TextUtil;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Properties;

public class ConfigsGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int generateGradleConfig(String gradlePropertiesFilePath, AppConfig config) {
        if (TextUtil.isEmpty(gradlePropertiesFilePath)) {
            return 0;
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            Properties properties = new Properties();
            HashMap<String, String> propertiesMap = new HashMap<String, String>();
            in = new FileInputStream(gradlePropertiesFilePath);
            properties.load(in);
            for (Object key : properties.keySet()) {
                propertiesMap.put((String)key, properties.getProperty((String)key));
            }
            propertiesMap.putAll(config.getBasicAppConfig());
            propertiesMap.putAll(config.getServerMap());
            propertiesMap.putAll(config.getFunctionMap());
            propertiesMap.putAll(config.getDisplayLayoutStyleMap());
            out = new FileOutputStream(gradlePropertiesFilePath, false);
            for (Object key : propertiesMap.keySet()) {
                String value = (String)propertiesMap.get(key);
                value = EncryptedStringUtil.handleEncryptedStringToProperties(value);
                String s = (String)key + "=" + value + "\n";
                out.write(s.getBytes());
            }
            out.flush();
        }
        catch (Exception e) {
            LogUtil.e("can not read flavor.properties");
            int n = 0;
            return n;
        }
        finally {
            try {
                in.close();
                out.close();
            }
            catch (Exception e) {
                LogUtil.e("bufferedReader can not close");
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateFlavorConfig(String gradlePropertiesFilePath, AppConfig config) {
        if (TextUtil.isEmpty(gradlePropertiesFilePath)) {
            return;
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            Properties properties = new Properties();
            HashMap<String, String> propertiesMap = new HashMap<String, String>();
            in = new FileInputStream(gradlePropertiesFilePath);
            properties.load(in);
            for (Object key : properties.keySet()) {
                propertiesMap.put((String)key, properties.getProperty((String)key));
            }
            SignConfig signInfo = config.getSignInfo();
            propertiesMap.put("applicationId", config.getPackageName());
            propertiesMap.put("versionCode", config.getVersionCode());
            propertiesMap.put("versionName", config.getVersionName());
            if (TextUtil.isEmpty(config.getSignFilePath())) {
                propertiesMap.put("signFilePath", signInfo.getPath());
                propertiesMap.put("keyAlias", signInfo.getKeyAlias());
                propertiesMap.put("keyPassword", signInfo.getKeyPwd());
                propertiesMap.put("storePassword", signInfo.getStorePwd());
            } else {
                propertiesMap.put("signFilePath", "./keystore/goose.jks");
                propertiesMap.put("keyAlias", "goose");
                propertiesMap.put("keyPassword", "SdijD78niop2d43jhk");
                propertiesMap.put("storePassword", "SdijD78niop2d43jhk");
            }
            propertiesMap.put("channels", config.getFlavor());
            for (String key : propertiesMap.keySet()) {
                properties.setProperty(key, (String)propertiesMap.get(key));
            }
            out = new FileOutputStream(gradlePropertiesFilePath, false);
            properties.store(out, "");
        }
        catch (Exception e) {
            LogUtil.e("can not read flavor.properties");
        }
        finally {
            try {
                in.close();
                out.close();
            }
            catch (Exception e) {
                LogUtil.e("bufferedReader can not close");
            }
        }
    }
}

