/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.generator;

import com.tve.custom.generator.model.CustomStrings;
import com.tve.custom.utils.CustomFilePathUtil;
import com.tve.custom.utils.FileUtil;
import com.tve.custom.utils.LogUtil;
import com.tve.custom.utils.TextUtil;
import com.tve.custom.utils.XmlFileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StringGenerator {
    private static final String LOG_TAG = "StringGenerator";
    private static final String FILE_NAME = "strings.xml";
    public static final String ELEMENT_NAME = "string";
    private static final Map<String, CustomStrings> mStringsMap = new LinkedHashMap<String, CustomStrings>();
    private static final Map<String, List<String>> mStringAaaryMap = new LinkedHashMap<String, List<String>>();

    public static void generate(int type, CustomFilePathUtil pathUtil, Map<String, CustomStrings> map, String defLang) {
        if (map == null || map.size() == 0 || TextUtil.isEmpty(defLang)) {
            LogUtil.d("StringGenerator map is empty, no need to generate");
            return;
        }
        boolean isCopyToDefault = false;
        for (String language : map.keySet()) {
            Object value;
            Element newElement;
            Document document;
            File targetFile;
            if (!CustomStrings.isValidLanuage(type, language)) continue;
            String dir = language.equals(defLang) ? "values" : "values-" + language;
            String targetXmlDirectory = pathUtil.getCustomResDir() + File.separator + dir;
            String targetXmlPath = targetXmlDirectory + File.separator + FILE_NAME;
            LinkedHashMap<String, String> newMap = map.get((Object)language).stringMap;
            LinkedHashMap<String, List<String>> newArrayMap = map.get((Object)language).stringArrayMap;
            if (!(newMap != null && newMap.size() != 0 || newArrayMap != null && newArrayMap.size() != 0)) {
                LogUtil.d("StringGenerator map is empty, no need to generate");
                continue;
            }
            if (language.equals(defLang) && !defLang.equals("en")) {
                isCopyToDefault = true;
            }
            if (!(targetFile = new File(targetXmlPath)).exists()) {
                boolean ret;
                File dirFile = new File(targetXmlDirectory);
                if (!dirFile.exists() && !(ret = dirFile.mkdirs())) {
                    LogUtil.e("StringGeneratorgenerate failed: can not make target dir");
                    continue;
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n").append("<resources>\n").append("</resources>");
                try {
                    FileOutputStream os = new FileOutputStream(targetFile, true);
                    os.write(buffer.toString().getBytes(StandardCharsets.UTF_8));
                    os.close();
                }
                catch (Exception e) {
                    LogUtil.e("StringGenerator tries to write colors.xml, but failed");
                    e.printStackTrace();
                    continue;
                }
            }
            if ((document = XmlFileUtil.loadXmlFile(targetXmlPath)) == null) {
                LogUtil.e("StringGeneratorGenerate failed ,target file maybe empty,please check it! ");
                continue;
            }
            Element root = document.getDocumentElement();
            NodeList nodesList = root.getElementsByTagName("*");
            for (int i = 0; i < nodesList.getLength(); ++i) {
                Node node = nodesList.item(i);
                if (node == null || node.getChildNodes() == null) continue;
                try {
                    String targetItemName;
                    if (ELEMENT_NAME.equals(node.getNodeName())) {
                        String stringValue;
                        if (node.getAttributes() == null || node.getAttributes().item(0) == null) continue;
                        targetItemName = node.getAttributes().item(0).getNodeValue();
                        LogUtil.i("[ExtraStringXML] targetItemName = " + targetItemName + "; type = " + node.getNodeName() + "; lang = " + language);
                        if (newMap == null || !newMap.containsKey(targetItemName) || (stringValue = (String)newMap.get(targetItemName)) == null) continue;
                        CDATASection newText = stringValue.startsWith("<![CDATA") && stringValue.endsWith("]]>") ? document.createCDATASection(stringValue.substring("<![CDATA".length(), stringValue.length() - "]]>".length())) : document.createCDATASection(stringValue);
                        Node oldNode = node.getChildNodes().item(0);
                        if (oldNode != null) {
                            node.replaceChild(newText, oldNode);
                        } else {
                            node.appendChild(newText);
                        }
                        newMap.remove(targetItemName);
                        continue;
                    }
                    if (!"string-array".equals(node.getNodeName())) continue;
                    targetItemName = node.getAttributes().item(0).getNodeValue();
                    if (newArrayMap.containsKey(targetItemName)) {
                        newElement = XmlFileUtil.createArrayElement(document, "string-array", targetItemName, (List)newArrayMap.get(targetItemName));
                        if (node != null) {
                            node.getParentNode().replaceChild(newElement, node);
                        } else {
                            node.getParentNode().appendChild(newElement);
                        }
                    }
                    newArrayMap.remove(targetItemName);
                    continue;
                }
                catch (Exception e) {
                    LogUtil.e("generate string failed" + e.toString());
                }
            }
            root.appendChild(document.createTextNode("    "));
            if (newMap != null) {
                for (String extra : newMap.keySet()) {
                    value = (String)newMap.get(extra);
                    if (value == null) continue;
                    newElement = XmlFileUtil.createElement(document, ELEMENT_NAME, extra, (String)value);
                    root.appendChild(newElement);
                }
            }
            if (newArrayMap != null) {
                for (String extra : newArrayMap.keySet()) {
                    value = (List)newArrayMap.get(extra);
                    if (value == null) continue;
                    newElement = XmlFileUtil.createArrayElement(document, "string-array", extra, (List<String>)value);
                    root.appendChild(newElement);
                }
            }
            XmlFileUtil.saveLayoutXml(targetXmlPath, document);
        }
        if (isCopyToDefault) {
            String sourceFile = pathUtil.getCustomResDir() + File.separator + "values" + File.separator + FILE_NAME;
            String targetDir = pathUtil.getCustomResDir() + File.separator + "values-" + defLang;
            FileUtil.copyFile(sourceFile, targetDir);
        }
    }

    public static void copyStringRes(int type, CustomFilePathUtil pathUtil, String repositoryPath, String defLang) {
        LogUtil.i("string path = " + repositoryPath);
        if (TextUtil.isEmpty(repositoryPath)) {
            return;
        }
        File themeDirFile = new File(repositoryPath);
        if (!themeDirFile.exists() || !themeDirFile.isDirectory()) {
            return;
        }
        StringGenerator.generateStringMap(repositoryPath);
        StringGenerator.generate(type, pathUtil, mStringsMap, defLang);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateStringMap(String repositoryPath) {
        try {
            File file = new File(repositoryPath);
            if (!file.exists()) {
                return;
            }
            String[] files = file.list();
            if (files == null) {
                return;
            }
            File subFile = null;
            String subFileName = "";
            for (int i = 0; i < files.length; ++i) {
                subFileName = repositoryPath.endsWith(File.separator) ? repositoryPath + files[i] : repositoryPath + File.separator + files[i];
                subFile = new File(repositoryPath + File.separator + files[i]);
                if (subFile.isFile()) {
                    Document document = XmlFileUtil.loadXmlFile(subFileName);
                    if (document == null) continue;
                    CustomStrings customStrings = new CustomStrings();
                    LinkedHashMap<String, String> stringMap = new LinkedHashMap<String, String>();
                    LinkedHashMap stringArrayMap = new LinkedHashMap();
                    Element root = document.getDocumentElement();
                    NodeList nodesList = root.getElementsByTagName("*");
                    for (int j = 0; j < nodesList.getLength(); ++j) {
                        int nodeSize;
                        Node node = nodesList.item(j);
                        int n = nodeSize = node == null || node.getChildNodes() == null ? 0 : node.getChildNodes().getLength();
                        if (nodeSize == 0) continue;
                        if (ELEMENT_NAME.equals(node.getNodeName())) {
                            if (node.getAttributes().item(0) == null) continue;
                            String targetItemKey = node.getAttributes().item(0).getNodeValue();
                            String targetItemValue = node.getChildNodes().item(0).getNodeValue();
                            stringMap.put(targetItemKey, targetItemValue);
                            continue;
                        }
                        if (!"string-array".equals(node.getNodeName())) continue;
                        LinkedList<String> arrayValue = new LinkedList<String>();
                        for (int k = 0; k < nodeSize; ++k) {
                            String subItemValue;
                            Node subNode = node.getChildNodes().item(k);
                            if (subNode == null || subNode.getChildNodes() == null || subNode.getChildNodes().item(0) == null || TextUtil.isEmpty(subItemValue = subNode.getChildNodes().item(0).getNodeValue())) continue;
                            arrayValue.add(subItemValue);
                        }
                        String targetItemKey = node.getAttributes().item(0).getNodeValue();
                        stringArrayMap.put(targetItemKey, arrayValue);
                    }
                    String lan = repositoryPath.substring(repositoryPath.indexOf("values-") + "values-".length());
                    customStrings.stringMap = stringMap;
                    customStrings.stringArrayMap = stringArrayMap;
                    mStringsMap.put(lan, customStrings);
                }
                if (!subFile.isDirectory()) continue;
                StringGenerator.generateStringMap(subFileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

