/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.utils;

import com.tve.custom.generator.model.AppConfig;
import com.tve.custom.utils.LogUtil;
import java.io.File;

public class CustomFilePathUtil {
    private int mType;
    private String mTargetDir;
    private String mProjectDir;
    private String mBuildDir;
    private String mOutputDir;
    private String mMappingDir;
    private String mCustomDir;
    private String mCustomResDir;
    private String mCustomValuesDir;
    private String mColorClassFilePath;
    private String mCustomVideoDir;
    private String mMainResDir;
    private String mCustomProdApkDir;
    private String mCustomUatApkDir;
    private String mJiaguProdLibPath;
    private String mJiaguUatLibPath;
    private String mJiaguApkDir;
    private String mApkSignerLibPath;
    private String mApkAlignLibPath;
    private String mDebugDir;
    private String mDebugZipPath;
    private String mToolsDir;

    public CustomFilePathUtil(int type, String targetDir, String projectDir, String toolsDir, AppConfig appConfig) {
        this.mType = type;
        this.mTargetDir = targetDir;
        this.mProjectDir = projectDir;
        this.mToolsDir = toolsDir;
        this.init(appConfig);
    }

    private void init(AppConfig appConfig) {
        String mainEntry = "tvapp";
        if (this.mType == 3 || this.mType == 2) {
            mainEntry = "app";
        }
        this.mCustomDir = this.mProjectDir + File.separator + mainEntry + File.separator + "src" + File.separator + appConfig.getFlavor().toLowerCase();
        this.mCustomResDir = this.mCustomDir + File.separator + "res";
        this.mCustomValuesDir = this.mCustomResDir + File.separator + "values";
        this.mColorClassFilePath = this.mCustomValuesDir + File.separator + "colors.xml";
        this.mCustomVideoDir = this.mCustomResDir + File.separator + "raw";
        this.mMainResDir = this.mProjectDir + File.separator + mainEntry + File.separator + "src" + File.separator + "main" + File.separator + "res";
        this.mBuildDir = this.mProjectDir + File.separator + mainEntry + File.separator + "build";
        this.mOutputDir = this.mBuildDir + File.separator + "outputs";
        this.mMappingDir = this.mOutputDir + File.separator + "mapping";
        this.mCustomProdApkDir = this.mProjectDir + File.separator + mainEntry + File.separator + "build" + File.separator + "outputs" + File.separator + "apk" + File.separator + appConfig.getBuildTask() + File.separator + "release";
        this.mCustomUatApkDir = "";
        this.mJiaguApkDir = this.mProjectDir + File.separator + mainEntry + File.separator + "build" + File.separator + "outputs" + File.separator + "apk" + File.separator + "jiagu";
        if (this.mType == 1 || this.mType == 0) {
            this.mJiaguProdLibPath = this.mProjectDir + File.separator + mainEntry + File.separator + "tve3-build-tools" + File.separator + "encryptionTool-private-v4.2.6.jar";
            this.mJiaguUatLibPath = this.mProjectDir + File.separator + mainEntry + File.separator + "tve3-build-tools" + File.separator + "encryptiontool-public.jar";
            this.mApkSignerLibPath = this.mProjectDir + File.separator + mainEntry + File.separator + "tve3-build-tools" + File.separator + "apksigner.jar";
        } else {
            this.mJiaguProdLibPath = this.mTargetDir + File.separator + "tve3-build-tools" + File.separator + "encryptionTool-private-v4.2.6.jar";
            this.mJiaguUatLibPath = this.mTargetDir + File.separator + "tve3-build-tools" + File.separator + "encryptiontool-public.jar";
            this.mApkSignerLibPath = this.mTargetDir + File.separator + "tve3-build-tools" + File.separator + "apksigner.jar";
        }
        this.mApkAlignLibPath = this.mToolsDir + "zipalign";
        this.mDebugDir = this.mProjectDir + File.separator + mainEntry + File.separator + "build" + File.separator + "outputs" + File.separator + "debuginfo";
        this.mDebugZipPath = this.mProjectDir + File.separator + mainEntry + File.separator + "build" + File.separator + "outputs" + File.separator + "apk" + File.separator + "debuginfo" + File.separator + "debug.zip";
    }

    public String getProjectDir() {
        return this.mProjectDir;
    }

    public String getBuildDir() {
        return this.mBuildDir;
    }

    public String getMappingDir() {
        return this.mMappingDir;
    }

    public String getTVAppDir() {
        return this.mProjectDir;
    }

    public String getCustomDir() {
        return this.mCustomDir;
    }

    public String getCustomResDir() {
        return this.mCustomResDir;
    }

    public String getCustomVideoDir() {
        return this.mCustomVideoDir;
    }

    public String getCustomValuesDir() {
        return this.mCustomValuesDir;
    }

    public String getMainResDir() {
        return this.mMainResDir;
    }

    public String getDebugDir() {
        return this.mDebugDir;
    }

    public String getDebugZipPath() {
        return this.mDebugZipPath;
    }

    public String getJiaguLibPath(int env) {
        return env == 0 ? this.mJiaguProdLibPath : this.mJiaguUatLibPath;
    }

    public String getApkSignerLibPath() {
        return this.mApkSignerLibPath;
    }

    public String getApkAlignLibPath() {
        return this.mApkAlignLibPath;
    }

    public String getJiaguApkDir() {
        return this.mJiaguApkDir;
    }

    public String getLocalPropertiesPath() {
        String filePath = this.getProjectDir() + File.separator + "local.properties";
        return filePath;
    }

    public String getCustomProdApkName() {
        String prodApkPath = this.getCustomProdApkPath();
        return new File(prodApkPath).getName();
    }

    public String getCustomProdApkPath() {
        File apkParent = new File(this.mCustomProdApkDir);
        File[] list = apkParent.listFiles();
        if (list == null) {
            LogUtil.d("Get custom prod apk path error , file list is null, apk may not successfully be built");
            return "";
        }
        for (File file : list) {
            if (!file.isFile() || !file.getName().endsWith(".apk")) continue;
            return this.mCustomProdApkDir + File.separator + file.getName();
        }
        return "";
    }

    public String getResignInputPath() {
        return this.getCustomProdApkPath();
    }

    public String getResignOutputPath() {
        String prodApkName = this.getCustomProdApkName();
        String signedProdApkName = prodApkName.substring(0, prodApkName.lastIndexOf(".apk")) + "_resigned.apk";
        return this.getJiaguApkDir() + File.separator + signedProdApkName;
    }

    public String getJiaguInputPath() {
        return this.getResignOutputPath();
    }

    public String getJiaguOutputPath() {
        String prodApkName = this.getCustomProdApkName();
        String signedProdApkName = prodApkName.substring(0, prodApkName.lastIndexOf(".apk")) + "_jiagu.apk";
        return this.getJiaguApkDir() + File.separator + signedProdApkName;
    }

    public String getJiaguApkName() {
        File file = new File(this.getJiaguOutputPath());
        return file.getName();
    }

    public String getAlignInputPath(boolean enableIjm) {
        if (enableIjm) {
            return this.getJiaguOutputPath();
        }
        return this.getResignOutputPath();
    }

    public String getAlignOutputPath() {
        String prodApkName = this.getCustomProdApkName();
        String signedProdApkName = prodApkName.substring(0, prodApkName.lastIndexOf(".apk")) + "_align.apk";
        return this.getJiaguApkDir() + File.separator + signedProdApkName;
    }

    public String getSignInputPath() {
        return this.getAlignOutputPath();
    }

    public String getSignOutputPath() {
        String prodApkName = this.getCustomProdApkName();
        String signedProdApkName = prodApkName.substring(0, prodApkName.lastIndexOf(".apk")) + "_sign.apk";
        return this.getJiaguApkDir() + File.separator + signedProdApkName;
    }
}

